Public Class BaseTax
    Const StateRate As Double = 0.053 ' %5.3 State tax
    Overridable Function CalculateTax(ByVal Amount As Double) As Double
        Return Amount * StateRate ' Calculate state tax.
    End Function
End Class

Public Class CityTax
    ' and modifies the returned value.
    Inherits BaseTax
    Private BaseAmount As Double
    Const CityRate As Double = 0.028  ' %2.8 City tax
    ' This method calls a method in the base class 
    Overrides Function CalculateTax(ByVal Amount As Double) As Double
        ' Some cities apply a tax to the total cost of purchases,
        ' including other taxes. 
        BaseAmount = MyBase.CalculateTax(Amount)
        Return (CityRate * (BaseAmount + Amount)) + BaseAmount
    End Function
End Class


