'The vehicle class is a base (or parent) class which provides a base
'implementation of the common properties and methods of a vehicle.  The
'MustInherit keyword in the class declaration means that this class can
'not be be created directly.
Namespace VehicleDemo

    Public MustInherit Class BaseVehicle
        'Property holders
        Private intMilesPerGallon As Integer
        Private intFuelCapacity As Integer

        'Property Accessors
        Public Property FuelCapacity() As Integer
            Set(ByVal Value As Integer)
                intFuelCapacity = Value
            End Set
            Get
                FuelCapacity = intFuelCapacity
            End Get
        End Property

        Public Property MilesPerGallon() As Integer
            Set(ByVal Value As Integer)
                intMilesPerGallon = Value
            End Set
            Get
                MilesPerGallon = intMilesPerGallon
            End Get
        End Property

        'The ComputeRange function is maked as Overridable which means that classes which 
        'inherit the Vehicle class can override the implementation of this function.
        Public Overridable Function ComputeRange() As Integer

            ComputeRange = intMilesPerGallon * intFuelCapacity

        End Function

    End Class
End Namespace