Namespace VehicleDemo

    'The Car class simply inherits the Vehicle class.  No need to extend it
    'or override anything
    Public Class Car
        Inherits BaseVehicle

    End Class

    'For boats we need to extent the Vehicle class with a new property (sailboat)
    'and override the implementation of the ComputeRange function
    Public Class Boat
        'Inherit the Vehicle Class
        Inherits BaseVehicle
        Private bolSailboat As Boolean

        Public Property SailBoat() As Boolean
            Set(ByVal Value As Boolean)
                bolSailboat = Value
            End Set
            Get
                SailBoat = bolSailboat
            End Get
        End Property

        'We need to override the ComputeRange function to add support for sailboats
        'For sailboats we want to double the couputed range.  We will call the
        'ComputeRange function on MyBase which is the Vehicle class
        Overrides Function ComputeRange() As Integer
            If Me.SailBoat Then
                'If this is a sailboat then we double the calculated range
                ComputeRange = MyBase.ComputeRange * 2
            Else
                'If it's not a sailboat, then we simply calculate the range
                ComputeRange = MyBase.ComputeRange
            End If
        End Function

    End Class

End Namespace