CREATE TABLE [dbo].[t_albums] (
	[album_id] [int] IDENTITY (1, 1) NOT NULL ,
	[album_title] [varchar] (255) NOT NULL ,
	[album_publish_date] [datetime] NOT NULL ,
	[band_id] [int] NOT NULL ,
	[album_price] [smallmoney] NOT NULL 
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[t_albums] WITH NOCHECK ADD 
	CONSTRAINT [DF_t_albums_album_publish_date] DEFAULT (getdate()) FOR [album_publish_date],
	CONSTRAINT [DF_t_albums_album_price] DEFAULT (0.00) FOR [album_price],
	CONSTRAINT [PK_t_albums] PRIMARY KEY  NONCLUSTERED 
	(
		[album_id]
	)  ON [PRIMARY] ,
	CONSTRAINT [IX_band_albums] UNIQUE  NONCLUSTERED 
	(
		[album_title],
		[band_id]
	)  ON [PRIMARY] 
GO
ALTER TABLE [dbo].[t_albums] ADD 
	CONSTRAINT [FK_t_albums_t_bands] FOREIGN KEY 
	(
		[band_id]
	) REFERENCES [dbo].[t_bands] (
		[band_id]
	)
GO
