<%@LANGUAGE="VBSCRIPT"%>
<%
   Option Explicit
   'On Error Resume Next

   ' this section is optional - it just denies anonymous access
   'If Request.ServerVariables("LOGON_USER")="" Then
   '   Response.Status = "401 Access Denied"
   'End If

   ' declare variables
   Dim objFSO, objFolder
   Dim objCollection, objItem

   Dim strPhysicalPath, strTitle, strServerName
   Dim strPath, strTemp
   Dim strName, strFile, strExt, strAttr
   Dim intSizeB, intSizeK, intAttr, dtmDate

   ' declare constants
   Const vbReadOnly = 1
   Const vbHidden = 2
   Const vbSystem = 4
   Const vbVolume = 8
   Const vbDirectory = 16
   Const vbArchive = 32
   Const vbAlias = 64
   Const vbCompressed = 128

   ' don't cache the page
   Response.AddHeader "Pragma", "No-Cache"
   Response.CacheControl = "Private"

   ' get the current folder URL path
   strTemp = Mid(Request.ServerVariables("URL"),2)
   strPath = ""

   Do While Instr(strTemp,"/")
      strPath = strPath & Left(strTemp,Instr(strTemp,"/"))
      strTemp = Mid(strTemp,Instr(strTemp,"/")+1)      
   Loop

   strPath = "/" & strPath

   ' build the page title
   strServerName = "Tony & Marie"
   strTitle = "Baby Pictures!"

   ' create the file system objects
   strPhysicalPath = Server.MapPath(strPath)
   Set objFSO = Server.CreateObject("Scripting.FileSystemObject")
   Set objFolder = objFSO.GetFolder(strPhysicalPath)
%>
<html>
<head>
<title><%=strServerName%> - <%=strTitle%></title>
<meta name="GENERATOR" content="Tony Caudill">
<style>
TABLE { BACKGROUND: #000000; COLOR: #ffffff; }
TH    { BACKGROUND: #0000ff; COLOR: #ffffff; }
TD    { BACKGROUND: #ffffff; COLOR: #000000; }
TT    { FONT-FAMILY: Courier; FONT-SIZE: 11pt; }
</style>
</head>
<body bgcolor="#9999cc" lang=EN-GB link=blue vlink="#660099" style='tab-interval:
.5in' alink="#0000FF" topmargin=30 leftmargin=5>

<h1 align="center"><%=strServerName%><br><%=strTitle%></h1>
<h4 align="center">Directory Listing</h4>

<div align="center"><center>
<table width="100%" border="0" cellspacing="1" cellpadding="2">
<tr>
   <th align="left">Name</th>
   <th align="left">KB</th>
   <th align="left">Ext</th>
   <th align="left">Type</th>
   <th align="left">Date</th>
</tr>
<tr>
   <td align="left"><a href="../default.asp">.. Up A Level</a></th>
   <td align="left">N/A</th>
   <td align="left">DIR</th>
   <td align="left">N/A</th>
   <td align="left">N/A</th>
</tr>

<%
   ''''''''''''''''''''''''''''''''''''''''
   ' output the folder list
   ''''''''''''''''''''''''''''''''''''''''

   Set objCollection = objFolder.SubFolders

   For Each objItem in objCollection
      strName = objItem.Name
      strAttr = MakeAttr(objItem.Attributes)      
      dtmDate = CDate(objItem.DateLastModified)
%>
<tr>
   <td align="left"><b><a href="<%=strName%>"><%=strName%></a></b></td>
   <td align="right">N/A</td>
   <td align="left"><b>&lt;DIR&gt;</b></td>
   <td align="left"><b>Directory</b></td>
   <td align="left"><%=FormatDateTime(dtmDate,vbShortDate)%></td>
</tr>
<% Next %>

<%
   ''''''''''''''''''''''''''''''''''''''''
   ' output the file list
   ''''''''''''''''''''''''''''''''''''''''

   Set objCollection = objFolder.Files

   For Each objItem in objCollection
      strName = objItem.Name
      strFile = Server.HTMLEncode(Lcase(strName))
      strURL = Server.URLEncode(Lcase(strName))
      intSizeB = objItem.Size
      intSizeK = Int((intSizeB/1024) + .5)
      If intSizeK = 0 Then intSizeK = 1

      strAttr = MakeAttr(objItem.Attributes)
      strName = Ucase(objItem.ShortName)
      If Instr(strName,".") Then strExt = Right(strName,Len(strName)-Instr(strName,".")) Else strExt = ""
      dtmDate = CDate(objItem.DateLastModified)
      Select Case UCASE(strExt)
	CASE "JPG"
		showImg()
	CASE "ASP"
	
	CASE ELSE
		showOther()
      End Select
%>

<% Next %>

</table>
</center></div>

</body>
</html>
<%
   Set objFSO = Nothing
   Set objFolder = Nothing

   ' this adds the IIf() function to VBScript
   Function IIf(i,j,k)
      If i Then IIf = j Else IIf = k
   End Function

   ' this function creates a string from the file atttributes
   Function MakeAttr(intAttr)
      MakeAttr = MakeAttr & IIf(intAttr And vbArchive,"A","-")
      MakeAttr = MakeAttr & IIf(intAttr And vbSystem,"S","-")
      MakeAttr = MakeAttr & IIf(intAttr And vbHidden,"H","-")
      MakeAttr = MakeAttr & IIf(intAttr And vbReadOnly,"R","-")
   End Function

   Sub showIMG()
	Response.Write"<tr>" & vbcrlf & vbTab
	Response.Write"<td align='left'><a href='pictureFrame.asp?imagePath=" & strFile & "&imageTitle=" & strFile & "&imageDate=" & FormatDateTime(dtmDate,vbShortDate) & "'>" & strFile & "</a></td>"& vbcrlf & vbTab
	Response.Write"<td align='right'>" & intSizeK & "K</td>" & vbcrlf & vbTab
	Response.Write"<td align='left'>" & strExt & "</td>"& vbcrlf & vbTab
	Response.Write"<td align='left'>" & objItem.Type &"</td>"& vbcrlf & vbTab
	Response.Write"<td align='left'>" & FormatDateTime(dtmDate,vbShortDate) & "</td>"& vbcrlf
	Response.Write"</tr>"& vbcrlf
   End Sub
   Sub showOther()
	Response.Write"<tr>"& vbcrlf
        Response.Write"<td align='left'><a href='" & strFile & "'>" & strFile & "</a></td>"& vbcrlf
	Response.Write"<td align='right'>" & intSizeK & "K</td>"& vbcrlf
	Response.Write"<td align='left'>" & strExt & "</td>"& vbcrlf
	Response.Write"<td align='left'>" & objItem.Type &"</td>"& vbcrlf
	Response.Write"<td align='left'>" & FormatDateTime(dtmDate,vbShortDate) & "</td>"& vbcrlf
	Response.Write"</tr>"& vbcrlf
   End Sub%>