<%@ Page Language="vb" debug="True" %>
<%@ Import Namespace="System.Drawing"%>
<HTML>
    <HEAD>
        <SCRIPT LANGUAGE="vb" RUNAT="server" ID="Script1">
		Public Sub ShowCache()
		    Dim oItem As Object
		    Dim sText As String
		    For Each oItem In Cache
		        If Left(oItem.key, 7) <> "System." Then
		            sText = sText & oItem.Key & "=" & Cache(oItem.Key) & "<br>"
		        End If
		    Next
			divDisplay.InnerHTML =sText
		    lblcompile.Text = datetime.Now.ToLongTimeString
		End Sub
		Public Sub btnRefreshClick(ByVal sender As Object, ByVal e As System.EventArgs)
			ShowCache()
		End Sub
		
		Public Sub BtnRemoveClick(ByVal sender As Object, ByVal e As System.EventArgs)
		    Cache.Remove(txtKey.Text.ToString)
		    showcache()
		End Sub
		
		Public Sub btnInsertClick(ByVal sender As Object, ByVal e As System.EventArgs)
			Dim bAbs as Boolean
			Dim bSlide as Boolean
			Dim bBoth as Boolean
			Dim sTemp as String
		    If CDbl(txtAbs.Text.ToString()) > 0 And CDbl(txtSlide.Text.ToString()) = 0 Then
		        Cache.Insert(txtKey.Text.tostring, txtvalue.Text.ToString, Nothing, datetime.Now.AddSeconds(CDbl(txtAbs.Text.ToString())), timespan.zero)
			bAbs=True 
			lblError.Text = "The key/value pair " & txtKey.Text & "/" & txtValue.text &" has an absolute expiration at " & datetime.Now.AddSeconds(CDbl(txtAbs.Text.ToString())).ToLongTimeString
			lblError.ForeColor= color.Blue
		    ElseIf Cdbl(txtAbs.Text.ToString()) = 0 And CDbl(txtSlide.Text.ToString()) > 0 Then
		        Cache.Insert(txtKey.Text.ToString, txtvalue.Text.ToString, Nothing, datetime.maxvalue, timespan.FromSeconds(CDbl(txtSlide.Text.ToString())))
			bSlide=True
			lblError.Text = "The key/value pair " & txtKey.Text & "/" & txtValue.text &" is on a sliding expiration target of " & datetime.Now.AddSeconds(CDbl(txtSlide.Text.ToString())).ToLongTimeString
			lblError.ForeColor= color.Blue
		    ElseIf Cdbl(txtAbs.Text.ToString()) > 0 And CDbl(txtSlide.Text.ToString()) > 0 Then
			lblError.Text = "You can only set Absolute Expiration or Sliding Expiration not both"
			lblError.ForeColor= color.red
		    End If
		    showcache() 
		End Sub
		
		Sub Page_Load(ByVal Sender As System.Object, ByVal e As System.EventArgs)
		    ShowCache()
		End Sub
		</SCRIPT>
        <META CONTENT="Microsoft Visual Studio.NET 7.0" NAME="GENERATOR">
        <META CONTENT="Visual Basic 7.0" NAME="CODE_LANGUAGE">
    </HEAD>
    <BODY>
        <FORM ID="WebForm1" METHOD="post" RUNAT="server">
            <H1>
                Examples of Data Caching
            </H1>
            <ASP:LABEL ID="lblError" RUNAT="server"></ASP:LABEL>
            <P>
                Example of Adding, Displaying and Removing an Item from the Data Cache
            </P>
            <P>
                Enter a Key
                <ASP:TEXTBOX ID="txtKey" RUNAT="server"></ASP:TEXTBOX>
                &nbsp;
                <ASP:REQUIREDFIELDVALIDATOR ID="RequiredFieldValidator1" RUNAT="server" ERRORMESSAGE="You must Enter a Key Value" CONTROLTOVALIDATE="txtKey"></ASP:REQUIREDFIELDVALIDATOR>
            </P>
            <P>
                Enter a Value
                <ASP:TEXTBOX ID="txtValue" RUNAT="server"></ASP:TEXTBOX>
            </P>
            <P>
                Absolute Expiration in&nbsp;
                <ASP:TEXTBOX ID="txtAbs" RUNAT="server" WIDTH="25" HEIGHT="24" TEXT="0"></ASP:TEXTBOX>
                &nbsp;seconds
            </P>
            <P>
                Sliding Expiration in
                <ASP:TEXTBOX ID="txtSlide" RUNAT="server" WIDTH="25" HEIGHT="24" TEXT="0"></ASP:TEXTBOX>
                &nbsp;seconds from last request
            </P>
            <P>
                <ASP:BUTTON ID="btnInsert" ONCLICK="btninsertclick" RUNAT="server" TEXT="Insert"></ASP:BUTTON>
                <ASP:BUTTON ID="BtnRemove" RUNAT="server" TEXT="Remove" ONCLICK="btnremoveclick"></ASP:BUTTON>
                <ASP:BUTTON ID="btnRefresh" RUNAT="server" TEXT="Refresh" ONCLICK="btnRefreshClick"></ASP:BUTTON>
            </P>
            <H2>
                Results
            </H2>
            </P>
        </FORM>
        <P>
            Page Last Compiled on
            <ASP:LABEL ID="lblCompile" RUNAT="server"></ASP:LABEL>
        </P>
        <P>
            List of All Values in Data Cache
        </P>
        <DIV ID="divDisplay" RUNAT="server">
        </DIV>
    </BODY>
</HTML>
