<%@ Import Namespace="System.Diagnostics"%>
<%@ Import Namespace="System.Exception" %>
<%@ Import Namespace="System.Data.OleDB" %>
<%@ Import Namespace="System.Data" %>
<%@ Page Language="VB" Debug="False" Trace="False" %>
<HTML>
    <SCRIPT LANGUAGE="VB" RUNAT="server">

        Sub ExecuteDBCodeBtn_Click(Sender As Object, E as EventArgs)
            Try
            	Dim MyDataset As DataSet = GetRecords()
            	grid1.DataSource = MyDataset.Tables(0).DefaultView
            	grid1.DataBind()
	        Catch ex as Exception
		        Dim oLabel as new Label()
		        Dim sMess as String
		        oLabel.Text=""
		        oLabel.Id="ExecuteDBCodeBtn_ErrorLabel"
		        Page.Controls.Add(oLabel)
		        sMess = sMess & "<b><p>Code Error Occurred</p></b>"
		        sMess = sMess & "<ul><li>" & ex.message & "</li></ul>"
		        oLabel.Text = oLabel.Text & sMess
	        End Try
        End Sub
        
        Function GetRecords() As DataSet
            Try	
	            Dim connection as New OleDBConnection(txtConnStr.Text)
                Dim command as New OleDBDataAdapter(txtSQLStr.Text, connection)
                Dim dataset As New DataSet()
            	command.Fill(dataset, "dataset")
		        Return dataset
	        Catch myException as OleDBException
		        OleDBErrorHandler(myException)
	        End Try        
        End Function
	
	    Function OleDBErrorHandler(ByVal myException as OleDBException)
		    Dim sMess as String
		    Dim oLabel as new Label()
		    Dim eItem as OleDBError
    		
		    'Add a label to the page dynamically to show errors
		    oLabel.Text = ""
		    oLabel.Id="OleDBLabel"
   		    Page.Controls.Add(new LiteralControl("<hr>"))
		    Page.Controls.Add(oLabel)
    		
		    'Loop throught the Errors in OleDBException
		    sMess=sMess & "<p><b>Database Error" & myException.ErrorCode.ToString() &" Occurred: " & myException.Message &"</b></p>"
		    sMess=sMess & "<p>StackTrace: " & myException.StackTrace.ToString() &"</p>"
		    sMess=sMess & "<p>TargetSite: " & myException.TargetSite.ToString() &"</p>"
		    For each eItem in myException.Errors
 			    sMess=sMess & "<ul>"
			    sMess = sMess &"<li>Error Message: " & eItem.Message & "</li>"
			    sMess = sMess &"<li>Source of Error: " & eItem.Source & "</li>"
			    sMess = sMess &"<li>Native Error Id: " & eItem.NativeError.ToString() & "</li>"
			    sMess = sMess &"<li>SQL State: " & eItem.SQLState & "</li>"
			    sMess=sMess & "</ul>"
			    oLabel.Text = oLabel.Text & sMess		
		    Next
		    WriteEvent(myException)
	    End Function
	
	    Function WriteEvent(ByVal myException as Exception)
 		    Dim sPage as String = Request.Path 
  		    Dim Message As String = "Url " & sPage
		    Dim sLogName As String = "myLogFile" 
 		    Dim oLog as New EventLog 

		    Message = Message  & " Error: " 
		    Message = Message  & myexception.message
		    If (Not EventLog.SourceExists(sLogName)) Then 
	       		    EventLog.CreateEventSource(sLogName,sLogName) 
		    End if 
		    oLog.Source = sLogName 
		    oLog.WriteEntry(Message, EventLogEntryType.Error)
	    End Function
    </SCRIPT>
    <BODY>
        <FORM RUNAT="server" ID="Form1">
            <H1>
                ASP.NET OleDB Exception Handling
            </H1>
            <P>
                This example is useful for testing some of the typical errors that may occur 
                while connecting to OleDB datasources. Try creating errors&nbsp;in the 
                connection string and sql statements to see how error handling is reported.
            </P>
            <P>
                <ASP:LABEL RUNAT="Server" ID="Label1">Connection String</ASP:LABEL>
                <ASP:TEXTBOX ID="txtConnStr" RUNAT="server" WRAP="False" WIDTH="800">provider=sqloledb;Data Source=127.0.0.1;Initial Catalog=pubs;User ID=sa;pwd=;</ASP:TEXTBOX>
            </P>
            <P>
                <ASP:LABEL RUNAT="Server" ID="Label2">SQL Statement</ASP:LABEL>
                <ASP:TEXTBOX ID="txtSQLStr" RUNAT="server" WRAP="False" WIDTH="800">SELECT * FROM 
GENERATE ERROR IN SQL</ASP:TEXTBOX>
            </P>
            <P>
                <ASP:BUTTON TEXT="Execute Database Code" ONCLICK="ExecuteDBCodeBtn_Click" RUNAT="server" ID="Button1" />
            </P>
            <P>
                <ASP:DATAGRID ID="grid1" RUNAT="server" />
            </P>
        </FORM>
    </BODY>
</HTML>
