/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class AudioDevice {
    private Vector streams;
    private byte[] ulaw;
    private int[] linear;
    private int dev;
    private static final int MSCLICK = 50;
    private static final int MSMARGIN = 16;
    private static final int BYTES_PER_SAMPLE = 1;
    private static final int SAMPLE_RATE = 8000;
    private static final int ULAW_BIAS = 132;
    private static final int ULAW_CLIP = 32635;
    private static final int[] ULAW_TAB = new int[]{-32124, -31100, -30076, -29052, -28028, -27004, -25980, -24956, -23932, -22908, -21884, -20860, -19836, -18812, -17788, -16764, -15996, -15484, -14972, -14460, -13948, -13436, -12924, -12412, -11900, -11388, -10876, -10364, -9852, -9340, -8828, -8316, -7932, -7676, -7420, -7164, -6908, -6652, -6396, -6140, -5884, -5628, -5372, -5116, -4860, -4604, -4348, -4092, -3900, -3772, -3644, -3516, -3388, -3260, -3132, -3004, -2876, -2748, -2620, -2492, -2364, -2236, -2108, -1980, -1884, -1820, -1756, -1692, -1628, -1564, -1500, -1436, -1372, -1308, -1244, -1180, -1116, -1052, -988, -924, -876, -844, -812, -780, -748, -716, -684, -652, -620, -588, -556, -524, -492, -460, -428, -396, -372, -356, -340, -324, -308, -292, -276, -260, -244, -228, -212, -196, -180, -164, -148, -132, -120, -112, -104, -96, -88, -80, -72, -64, -56, -48, -40, -32, -24, -16, -8, 0, 32124, 31100, 30076, 29052, 28028, 27004, 25980, 24956, 23932, 22908, 21884, 20860, 19836, 18812, 17788, 16764, 15996, 15484, 14972, 14460, 13948, 13436, 12924, 12412, 11900, 11388, 10876, 10364, 9852, 9340, 8828, 8316, 7932, 7676, 7420, 7164, 6908, 6652, 6396, 6140, 5884, 5628, 5372, 5116, 4860, 4604, 4348, 4092, 3900, 3772, 3644, 3516, 3388, 3260, 3132, 3004, 2876, 2748, 2620, 2492, 2364, 2236, 2108, 1980, 1884, 1820, 1756, 1692, 1628, 1564, 1500, 1436, 1372, 1308, 1244, 1180, 1116, 1052, 988, 924, 876, 844, 812, 780, 748, 716, 684, 652, 620, 588, 556, 524, 492, 460, 428, 396, 372, 356, 340, 324, 308, 292, 276, 260, 244, 228, 212, 196, 180, 164, 148, 132, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40, 32, 24, 16, 8, 0};
    private static final int[] ULAW_LUT = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    public static final AudioDevice device = new AudioDevice();

    private native int audioOpen();

    private native void audioClose();

    private synchronized native void audioWrite(byte[] var1, int var2);

    private AudioDevice() {
        try {
            System.loadLibrary("mmedia");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("could not find/load the mmedia library");
        }
        this.streams = new Vector();
        int n = 400;
        this.ulaw = new byte[n];
        this.linear = new int[n];
    }

    public synchronized void openChannel(InputStream inputStream) {
        this.streams.insertElementAt(inputStream, 0);
        this.notify();
    }

    public synchronized void closeChannel(InputStream inputStream) {
        if (this.streams.removeElement(inputStream)) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public synchronized void open() {
        int n = 1;
        int n2 = 5;
        while (this.dev == 0) {
            this.dev = this.audioOpen();
            if (this.dev < 0) {
                System.out.println("no audio device");
                return;
            }
            if (this.dev != 0) continue;
            System.out.println("audio device busy (attempt " + n + " out of " + n2 + ")");
            if (this.streams.size() == 0 || ++n > n2) {
                this.closeStreams();
                return;
            }
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                this.closeStreams();
                return;
            }
        }
    }

    public synchronized void close() {
        if (this.dev != 0) {
            this.audioClose();
            this.dev = 0;
        }
        this.closeStreams();
    }

    private synchronized void mix() {
        int n = this.ulaw.length;
        byte[] byArray = this.ulaw;
        switch (this.streams.size()) {
            case 0: {
                int n2 = n;
                while (n2-- > 0) {
                    byArray[n2] = 127;
                }
                return;
            }
            case 1: {
                InputStream inputStream = (InputStream)this.streams.elementAt(0);
                int n3 = 0;
                try {
                    n3 = inputStream.read(byArray, 0, n);
                }
                catch (IOException iOException) {
                    n3 = -1;
                }
                if (n3 <= 0) {
                    this.streams.removeElementAt(0);
                    n3 = 0;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                while (n3 < n) {
                    byArray[n3] = 127;
                    ++n3;
                }
                return;
            }
        }
        int[] nArray = ULAW_TAB;
        int[] nArray2 = this.linear;
        int n4 = this.streams.size() - 1;
        InputStream inputStream = (InputStream)this.streams.elementAt(n4);
        int n5 = 0;
        try {
            n5 = inputStream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            n5 = -1;
        }
        if (n5 <= 0) {
            this.streams.removeElementAt(n4);
            n5 = 0;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        int n6 = 0;
        while (n6 < n5) {
            nArray2[n6] = nArray[byArray[n6] & 0xFF];
            ++n6;
        }
        while (n5 < n) {
            nArray2[n5] = 0;
            ++n5;
        }
        while (n4-- > 0) {
            inputStream = (InputStream)this.streams.elementAt(n4);
            try {
                n5 = inputStream.read(byArray, 0, n);
            }
            catch (IOException iOException) {
                n5 = -1;
            }
            if (n5 <= 0) {
                this.streams.removeElementAt(n4);
                n5 = 0;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            while (n5-- > 0) {
                int n7 = n5;
                nArray2[n7] = nArray2[n7] + nArray[byArray[n5] & 0xFF];
            }
        }
        int[] nArray3 = ULAW_LUT;
        n5 = n;
        while (n5-- > 0) {
            int n8;
            int n9;
            int n10 = nArray2[n5];
            if (n10 >= 0) {
                if (n10 > 32635) {
                    n10 = 32635;
                }
                n9 = nArray3[(n10 += 132) >> 7];
                n8 = n10 >> n9 + 3 & 0xF;
                n10 = (n9 << 4 | n8) ^ 0xFF;
            } else {
                if ((n10 = -n10) > 32635) {
                    n10 = 32635;
                }
                n9 = nArray3[(n10 += 132) >> 7];
                n8 = n10 >> n9 + 3 & 0xF;
                n10 = (n9 << 4 | n8) ^ 0x7F;
            }
            byArray[n5] = (byte)n10;
        }
    }

    private synchronized boolean waitForData() throws InterruptedException {
        if (this.streams.size() == 0) {
            this.close();
            this.wait();
            this.open();
            return true;
        }
        return false;
    }

    public void play() {
        try {
            long l = System.currentTimeMillis() - 16L;
            while (this.dev > 0) {
                if (this.waitForData()) {
                    l = System.currentTimeMillis() - 16L;
                }
                this.mix();
                this.audioWrite(this.ulaw, this.ulaw.length);
                long l2 = (l += 50L) - System.currentTimeMillis();
                if (l2 > 0L) {
                    Thread.currentThread();
                    Thread.sleep(l2);
                    continue;
                }
                l = System.currentTimeMillis() - 16L;
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void closeStreams() {
        Enumeration enumeration = this.streams.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((InputStream)enumeration.nextElement()).close();
            }
            catch (IOException iOException) {}
        }
        this.streams = new Vector();
    }

    public int openChannels() {
        return this.streams.size();
    }
}

