/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.net.URL;
import java.util.Hashtable;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveKey;

public class KeepAliveCache
extends Hashtable {
    static int MAXCONNS = Integer.getInteger("http.maxConnections", 2);
    static final int LIFETIME = 5000;
    static final int PROXY_LIFETIME = 10000;

    public synchronized void put(URL uRL, HttpClient httpClient) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            clientVector = new ClientVector(this, keepAliveKey, httpClient.usingProxy ? 10000 : 5000);
            clientVector.put(httpClient);
            super.put(keepAliveKey, clientVector);
            Thread thread = new Thread(clientVector, "Keep-Alive-Timer:" + uRL.getHost());
            thread.setPriority(8);
            thread.start();
            return;
        }
        clientVector.put(httpClient);
    }

    synchronized void removeVector(KeepAliveKey keepAliveKey) {
        super.remove(keepAliveKey);
    }

    public Object get(URL uRL) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            return null;
        }
        return clientVector.get();
    }
}

