/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.net.URL;
import java.util.Hashtable;

public class AuthenticationInfo {
    static Hashtable preemptiveCache = new Hashtable();
    static Hashtable cache = new Hashtable();
    String host;
    int port;
    String realm;
    String auth;

    public AuthenticationInfo(URL uRL, String string, String string2) {
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        this.auth = string2;
        this.realm = string;
        AuthenticationInfo.cacheInfo(this, uRL);
    }

    public AuthenticationInfo(URL uRL, String string) {
        this.realm = "";
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        this.auth = string;
        AuthenticationInfo.cacheInfo(this, uRL);
    }

    public AuthenticationInfo(String string, int n, String string2) {
        this.host = string;
        this.port = n;
        this.realm = string2;
    }

    public AuthenticationInfo(String string, int n, String string2, String string3) {
        this(string, n, string2);
        this.auth = string3;
        AuthenticationInfo.cacheInfo(this);
    }

    public static void cacheInfo(AuthenticationInfo authenticationInfo) {
        cache.put(authenticationInfo, authenticationInfo);
    }

    public static void cacheInfo(AuthenticationInfo authenticationInfo, URL uRL) {
        AuthenticationInfo.cacheInfo(authenticationInfo);
        preemptiveCache.put(AuthenticationInfo.cacheKey(uRL), authenticationInfo);
    }

    public static void uncacheInfo(AuthenticationInfo authenticationInfo) {
        cache.remove(authenticationInfo);
    }

    public static void uncacheInfo(AuthenticationInfo authenticationInfo, URL uRL) {
        AuthenticationInfo.uncacheInfo(authenticationInfo);
        preemptiveCache.remove(AuthenticationInfo.cacheKey(uRL));
    }

    private void dumpCaches(String string) {
        System.err.println("\n" + string);
        System.err.println("\nCache:\n" + cache + "\n\nPreemptiveCache:\n" + preemptiveCache + "\n");
    }

    public static AuthenticationInfo getAuth(URL uRL) {
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)preemptiveCache.get(AuthenticationInfo.cacheKey(uRL));
        return authenticationInfo;
    }

    public static AuthenticationInfo getAuth(URL uRL, String string) {
        AuthenticationInfo authenticationInfo = null;
        if (string == null) {
            authenticationInfo = AuthenticationInfo.getAuth(uRL);
        } else {
            AuthenticationInfo authenticationInfo2 = new AuthenticationInfo(uRL.getHost(), uRL.getPort(), string);
            authenticationInfo = (AuthenticationInfo)cache.get(authenticationInfo2);
        }
        return authenticationInfo;
    }

    public String getAuthString() {
        return "Basic " + this.auth;
    }

    static String cacheKey(URL uRL) {
        return String.valueOf(uRL.getHost()) + ":" + uRL.getPort();
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port ^ this.realm.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AuthenticationInfo) {
            AuthenticationInfo authenticationInfo = (AuthenticationInfo)object;
            return authenticationInfo.host.equals(this.host) && authenticationInfo.port == this.port && authenticationInfo.realm.equals(this.realm);
        }
        return false;
    }

    public String toString() {
        return "AuthenticationInfo[" + this.realm + "@" + this.host + ":" + this.port + "]->" + this.auth;
    }
}

