/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.ServerRuntimeException;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.server.RemoteProxy;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.Channel;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.rmi.transport.tcp.TCPTransport;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    private transient Skeleton skel;

    public UnicastServerRef() {
    }

    public UnicastServerRef(LiveRef liveRef) {
        super(liveRef);
    }

    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        int n;
        int n2 = n = object != null ? (Integer)object : 0;
        if (this.ref == null) {
            this.ref = new LiveRef(n);
        }
        RemoteStub remoteStub = this.setSkeleton(remote);
        Target target = new Target(remote, this, remoteStub);
        this.ref.exportObject(target);
        return remoteStub;
    }

    public String getClientHost() throws ServerNotActiveException {
        Channel channel = TCPTransport.getCurrentChannel();
        if (channel instanceof TCPChannel) {
            TCPEndpoint tCPEndpoint = (TCPEndpoint)((TCPChannel)channel).getEndpoint();
            try {
                return tCPEndpoint.getHost();
            }
            catch (Exception exception) {}
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    public RemoteStub setSkeleton(Remote remote) throws RemoteException {
        this.skel = RemoteProxy.getSkeleton(remote);
        return RemoteProxy.getStub(remote, this.getClientRef());
    }

    public void dispatch(Remote remote, RemoteCall remoteCall) throws IOException {
        try {
            try {
                long l;
                int n;
                Object object;
                try {
                    object = remoteCall.getInputStream();
                    n = object.readInt();
                    l = object.readLong();
                }
                catch (Exception exception) {
                    throw new UnmarshalException("Error unmarshaling call header", exception);
                }
                object = RemoteServer.getLog();
                if (object != null) {
                    ((PrintStream)object).println("[" + this.getClientHost() + ": " + remote.getClass().getName() + this.ref.getObjID().toString() + ": " + this.skel.getOperations()[n] + "]");
                }
                this.skel.dispatch(remote, remoteCall, n, l);
            }
            catch (Throwable throwable) {
                RemoteException remoteException;
                Object object;
                PrintStream printStream = RemoteServer.getLog();
                if (printStream != null) {
                    object = printStream;
                    synchronized (object) {
                        try {
                            printStream.print("[" + this.getClientHost() + "] ");
                        }
                        catch (ServerNotActiveException serverNotActiveException) {}
                        printStream.print("exception: ");
                        throwable.printStackTrace(printStream);
                    }
                }
                object = remoteCall.getResultStream(false);
                if (throwable instanceof RuntimeException) {
                    remoteException = new ServerRuntimeException("Server RuntimeException", (Exception)throwable);
                } else if (throwable instanceof Error) {
                    remoteException = new ServerError("Server Error", (Error)throwable);
                } else if (throwable instanceof RemoteException) {
                    remoteException = new ServerException("Server RemoteException", (Exception)throwable);
                }
                object.writeObject(remoteException);
            }
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
            throw throwable;
        }
        remoteCall.releaseInputStream();
        remoteCall.releaseOutputStream();
    }

    public String getRefClass(ObjectOutput objectOutput) {
        if (objectOutput instanceof MarshalOutputStream) {
            return "UnicastRef";
        }
        return "UnicastServerRef";
    }

    private RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (objectOutput instanceof MarshalOutputStream) {
            throw new Error("UnicastServerRef.writeExternal: internal error");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }
}

