/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.text.Utility;
import java.util.Date;
import java.util.Locale;

public class MessageFormat
extends Format {
    private Locale locale = Locale.getDefault();
    private String pattern = "";
    private Format[] formats = new Format[10];
    private int[] offsets = new int[10];
    private int[] argumentNumbers = new int[10];
    private int maxOffset = -1;
    private static final String[] typeList = new String[]{"", "", "number", "", "date", "", "time", "", "choice"};
    private static final String[] modifierList = new String[]{"", "", "currency", "", "percent", "", "integer"};
    private static final String[] dateModifierList = new String[]{"", "", "short", "", "medium", "", "long", "", "full"};

    public MessageFormat(String string) {
        this.applyPattern(string);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void applyPattern(String string) {
        StringBuffer[] stringBufferArray = new StringBuffer[4];
        int n = 0;
        while (n < stringBufferArray.length) {
            stringBufferArray[n] = new StringBuffer();
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        while (n5 < string.length()) {
            block17: {
                char c;
                block18: {
                    block16: {
                        c = string.charAt(n5);
                        if (n2 != 0) break block16;
                        if (c == '\'') {
                            if (n5 + 1 < string.length() && string.charAt(n5 + 1) == '\'') {
                                stringBufferArray[n2].append(c);
                                ++n5;
                            } else {
                                bl = !bl;
                            }
                        } else if (c == '{' && !bl) {
                            n2 = 1;
                        } else {
                            stringBufferArray[n2].append(c);
                        }
                        break block17;
                    }
                    if (!bl) break block18;
                    stringBufferArray[n2].append(c);
                    if (c != '\'') break block17;
                    bl = false;
                    break block17;
                }
                switch (c) {
                    case ',': {
                        if (n2 < 3) {
                            ++n2;
                            break;
                        }
                        stringBufferArray[n2].append(c);
                        break;
                    }
                    case '{': {
                        ++n4;
                        stringBufferArray[n2].append(c);
                        break;
                    }
                    case '}': {
                        if (n4 == 0) {
                            n2 = 0;
                            this.makeFormat(n5, n3, stringBufferArray);
                            ++n3;
                            break;
                        }
                        --n4;
                        stringBufferArray[n2].append(c);
                        break;
                    }
                    case '\'': {
                        bl = true;
                    }
                    default: {
                        stringBufferArray[n2].append(c);
                        break;
                    }
                }
            }
            ++n5;
        }
        this.pattern = stringBufferArray[0].toString();
    }

    public String toPattern() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 <= this.maxOffset) {
            MessageFormat.copyAndFixQuotes(this.pattern, n, this.offsets[n2], stringBuffer);
            n = this.offsets[n2];
            stringBuffer.append('{');
            stringBuffer.append(this.argumentNumbers[n2]);
            if (this.formats[n2] != null) {
                if (this.formats[n2] instanceof DecimalFormat) {
                    if (this.formats[n2].equals(NumberFormat.getInstance(this.locale))) {
                        stringBuffer.append(",number");
                    } else if (this.formats[n2].equals(NumberFormat.getCurrencyInstance(this.locale))) {
                        stringBuffer.append(",number,currency");
                    } else if (this.formats[n2].equals(NumberFormat.getPercentInstance(this.locale))) {
                        stringBuffer.append(",number,percent");
                    } else if (this.formats[n2].equals(this.getIntegerFormat(this.locale))) {
                        stringBuffer.append(",number,integer");
                    } else {
                        stringBuffer.append(",number," + ((DecimalFormat)this.formats[n2]).toPattern());
                    }
                } else if (this.formats[n2] instanceof SimpleDateFormat) {
                    if (this.formats[n2].equals(DateFormat.getDateInstance(2, this.locale))) {
                        stringBuffer.append(",date");
                    } else if (this.formats[n2].equals(DateFormat.getDateInstance(3, this.locale))) {
                        stringBuffer.append(",date,short");
                    } else if (this.formats[n2].equals(DateFormat.getDateInstance(2, this.locale))) {
                        stringBuffer.append(",date,medium");
                    } else if (this.formats[n2].equals(DateFormat.getDateInstance(1, this.locale))) {
                        stringBuffer.append(",date,long");
                    } else if (this.formats[n2].equals(DateFormat.getDateInstance(0, this.locale))) {
                        stringBuffer.append(",date,full");
                    } else if (this.formats[n2].equals(DateFormat.getTimeInstance(2, this.locale))) {
                        stringBuffer.append(",time");
                    } else if (this.formats[n2].equals(DateFormat.getTimeInstance(3, this.locale))) {
                        stringBuffer.append(",time,short");
                    } else if (this.formats[n2].equals(DateFormat.getTimeInstance(2, this.locale))) {
                        stringBuffer.append(",time,medium");
                    } else if (this.formats[n2].equals(DateFormat.getTimeInstance(1, this.locale))) {
                        stringBuffer.append(",time,long");
                    } else if (this.formats[n2].equals(DateFormat.getTimeInstance(0, this.locale))) {
                        stringBuffer.append(",time,full");
                    } else {
                        stringBuffer.append(",date," + ((SimpleDateFormat)this.formats[n2]).toPattern());
                    }
                } else if (this.formats[n2] instanceof ChoiceFormat) {
                    stringBuffer.append(",choice," + ((ChoiceFormat)this.formats[n2]).toPattern());
                }
            }
            stringBuffer.append('}');
            ++n2;
        }
        MessageFormat.copyAndFixQuotes(this.pattern, n, this.pattern.length(), stringBuffer);
        return stringBuffer.toString();
    }

    public void setFormats(Format[] formatArray) {
        try {
            this.formats = (Format[])formatArray.clone();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setFormat(int n, Format format) {
        this.formats[n] = format;
    }

    public Format[] getFormats() {
        try {
            return (Format[])this.formats.clone();
        }
        catch (Exception exception) {
            return this.formats;
        }
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(objectArray, stringBuffer, fieldPosition, 0);
    }

    public static String format(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((Object[])object, stringBuffer, fieldPosition, 0);
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        int n;
        Object[] objectArray = new Object[10];
        int n2 = 0;
        int n3 = parsePosition.index;
        ParsePosition parsePosition2 = new ParsePosition(0);
        int n4 = 0;
        while (n4 <= this.maxOffset) {
            n = this.offsets[n4] - n2;
            if (n == 0 || this.pattern.regionMatches(n2, string, n3, n)) {
                n3 += n;
                n2 += n;
            } else {
                return null;
            }
            if (this.formats[n4] == null) {
                int n5 = n4 != this.maxOffset ? this.offsets[n4 + 1] : this.pattern.length();
                int n6 = string.indexOf(this.pattern.substring(n2, n5), n3);
                if (n6 < 0) {
                    return null;
                }
                objectArray[this.argumentNumbers[n4]] = string.substring(n3, n6);
                n3 = n6;
            } else {
                parsePosition2.index = n3;
                objectArray[this.argumentNumbers[n4]] = this.formats[n4].parseObject(string, parsePosition2);
                if (parsePosition2.index == n3) {
                    return null;
                }
                n3 = parsePosition2.index;
            }
            ++n4;
        }
        n = this.pattern.length() - n2;
        if (n != 0 && !this.pattern.regionMatches(n2, string, n3, n)) {
            return null;
        }
        parsePosition.index = n3 + n;
        return objectArray;
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("MessageFormat parse error!", 0);
        }
        return objectArray;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public Object clone() {
        MessageFormat messageFormat = (MessageFormat)super.clone();
        messageFormat.formats = (Format[])this.formats.clone();
        int n = 0;
        while (n < this.formats.length) {
            if (this.formats[n] != null) {
                messageFormat.formats[n] = (Format)this.formats[n].clone();
            }
            ++n;
        }
        messageFormat.offsets = (int[])this.offsets.clone();
        messageFormat.argumentNumbers = (int[])this.argumentNumbers.clone();
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MessageFormat messageFormat = (MessageFormat)object;
        return this.maxOffset == messageFormat.maxOffset && this.pattern.equals(messageFormat.pattern) && Utility.objectEquals(this.locale, messageFormat.locale) && Utility.arrayEquals(this.offsets, (Object)messageFormat.offsets) && Utility.arrayEquals(this.argumentNumbers, (Object)messageFormat.argumentNumbers) && Utility.arrayEquals(this.formats, (Object)messageFormat.formats);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 <= this.maxOffset) {
            String string;
            stringBuffer.append(this.pattern.substring(n2, this.offsets[n3]));
            n2 = this.offsets[n3];
            int n4 = this.argumentNumbers[n3];
            if (n4 >= objectArray.length) {
                throw new IllegalArgumentException("Argument # > Arg length");
            }
            Object object = objectArray[n4];
            boolean bl = false;
            if (this.formats[n3] != null) {
                string = this.formats[n3].format(object);
                bl = this.formats[n3] instanceof ChoiceFormat;
            } else if (object instanceof Number) {
                string = NumberFormat.getInstance(this.locale).format(object);
            } else if (object instanceof Date) {
                string = DateFormat.getDateTimeInstance(3, 3, this.locale).format(object);
            } else if (object instanceof String) {
                string = (String)object;
            } else {
                System.out.println("Unknown object of type:" + object.getClass().getName());
                throw new IllegalArgumentException("Unknown argument");
            }
            if (bl && string.indexOf(123) >= 0) {
                MessageFormat messageFormat = new MessageFormat(string);
                messageFormat.format(objectArray, stringBuffer, fieldPosition, n);
            } else {
                stringBuffer.append(string);
            }
            ++n3;
        }
        stringBuffer.append(this.pattern.substring(n2, this.pattern.length()));
        return stringBuffer;
    }

    private void makeFormat(int n, int n2, StringBuffer[] stringBufferArray) {
        try {
            int n3 = Integer.parseInt(stringBufferArray[1].toString());
            if (n3 < 0 || n3 > 9) {
                throw new NumberFormatException();
            }
            this.maxOffset = n2;
            this.offsets[n2] = stringBufferArray[0].length();
            this.argumentNumbers[n2] = n3;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("argument number too large at ");
        }
        Format format = null;
        block5 : switch (MessageFormat.findKeyword(stringBufferArray[2].toString(), typeList)) {
            case 1: 
            case 2: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), modifierList)) {
                    case 0: {
                        format = NumberFormat.getInstance(this.locale);
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        format = NumberFormat.getCurrencyInstance(this.locale);
                        break block5;
                    }
                    case 3: 
                    case 4: {
                        format = NumberFormat.getPercentInstance(this.locale);
                        break block5;
                    }
                    case 5: 
                    case 6: {
                        format = this.getIntegerFormat(this.locale);
                        break block5;
                    }
                }
                format = NumberFormat.getInstance(this.locale);
                try {
                    ((DecimalFormat)format).applyPattern(stringBufferArray[3].toString());
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Pattern incorrect or locale does not support formats, error at ");
                }
            }
            case 3: 
            case 4: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), dateModifierList)) {
                    case 0: {
                        format = DateFormat.getDateInstance(2, this.locale);
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        format = DateFormat.getDateInstance(3, this.locale);
                        break block5;
                    }
                    case 3: 
                    case 4: {
                        format = DateFormat.getDateInstance(2, this.locale);
                        break block5;
                    }
                    case 5: 
                    case 6: {
                        format = DateFormat.getDateInstance(1, this.locale);
                        break block5;
                    }
                    case 7: 
                    case 8: {
                        format = DateFormat.getDateInstance(0, this.locale);
                        break block5;
                    }
                }
                format = DateFormat.getDateInstance(2, this.locale);
                try {
                    ((SimpleDateFormat)format).applyPattern(stringBufferArray[3].toString());
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Pattern incorrect or locale does not support formats, error at ");
                }
            }
            case 5: 
            case 6: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), dateModifierList)) {
                    case 0: {
                        format = DateFormat.getTimeInstance(2, this.locale);
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        format = DateFormat.getTimeInstance(3, this.locale);
                        break block5;
                    }
                    case 3: 
                    case 4: {
                        format = DateFormat.getTimeInstance(2, this.locale);
                        break block5;
                    }
                    case 5: 
                    case 6: {
                        format = DateFormat.getTimeInstance(1, this.locale);
                        break block5;
                    }
                    case 7: 
                    case 8: {
                        format = DateFormat.getTimeInstance(0, this.locale);
                        break block5;
                    }
                }
                format = DateFormat.getTimeInstance(2, this.locale);
                try {
                    ((SimpleDateFormat)format).applyPattern(stringBufferArray[3].toString());
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Pattern incorrect or locale does not support formats, error at ");
                }
            }
            case 7: 
            case 8: {
                try {
                    format = new ChoiceFormat(stringBufferArray[3].toString());
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Choice Pattern incorrect, error at ");
                }
            }
            default: {
                throw new IllegalArgumentException("unknown format type at ");
            }
            case 0: 
        }
        this.formats[n2] = format;
        stringBufferArray[1].setLength(0);
        stringBufferArray[2].setLength(0);
        stringBufferArray[3].setLength(0);
    }

    private static final int findKeyword(String string, String[] stringArray) {
        string = string.trim().toLowerCase();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    NumberFormat getIntegerFormat(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            decimalFormat.setMaximumFractionDigits(0);
            decimalFormat.setDecimalSeparatorAlwaysShown(false);
            decimalFormat.setParseIntegerOnly(true);
        }
        return numberFormat;
    }

    private static final void copyAndFixQuotes(String string, int n, int n2, StringBuffer stringBuffer) {
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '{') {
                stringBuffer.append("'{'");
            } else if (c == '\'') {
                stringBuffer.append("''");
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
    }
}

