/*
 * Decompiled with CFR 0.152.
 */
package jhl.applets.launcher;

import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jhl.apps.search.SearchCompiler;

public final class JHLSearch
extends Applet
implements ActionListener,
Runnable {
    SearchCompiler sc;
    String data;
    Choice appsList;
    Button runButton;
    TextField argLine;
    List outList;
    Thread runApplet;
    Thread compiler;
    private static final String runMessage = "  Run  ";
    private static final String stopMessage = " Stop ";
    private Object syncTo = new Object();

    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.lightGray);
        int n = dimension.width - 2;
        int n2 = dimension.height - 2;
        graphics.drawLine(n, 0, n, n2);
        graphics.drawLine(0, n2, n, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(++n, 0, n, ++n2);
        graphics.drawLine(0, n2, n, n2);
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, --n, 0);
        graphics.drawLine(1, 1, --n, 1);
        graphics.drawLine(0, 0, 0, --n2);
        graphics.drawLine(1, 1, 1, --n2);
    }

    public void init() {
        URL uRL = null;
        try {
            uRL = this.buildUrl("./data/");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Error: Couldn't find the data directory");
            return;
        }
        String string = uRL.toString().substring(5);
        string = string.startsWith("//") ? string.substring(2) : string.substring(1);
        char c = File.separatorChar;
        if (c != '/') {
            string = string.replace('/', c);
        }
        this.data = string;
        Font font = new Font("Dialog", 0, 14);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        ((Component)this).setFont(font);
        this.setBackground(Color.lightGray);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        panel.setLayout(gridBagLayout2);
        Label label = new Label("Application: ", 1);
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagLayout2.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.appsList = new Choice();
        this.appsList.setBackground(Color.white);
        this.appsList.addItem("Compiler");
        this.appsList.addItem("Parser");
        this.appsList.addItem("URL tokenizer");
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 10;
        gridBagLayout2.setConstraints(this.appsList, gridBagConstraints);
        panel.add(this.appsList);
        this.runButton = new Button(runMessage);
        this.runButton.setFont(font);
        this.runButton.addActionListener(this);
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout2.setConstraints(this.runButton, gridBagConstraints);
        panel.add(this.runButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        label = new Label("Command line: ", 1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.argLine = new TextField(50);
        ((Component)this.argLine).setBackground(Color.white);
        this.argLine.setFont(font);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.argLine, gridBagConstraints);
        this.add(this.argLine);
        font = new Font("DialogInput", 0, 14);
        this.outList = new List(10, false);
        this.outList.setBackground(Color.white);
        this.outList.setFont(font);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.outList, gridBagConstraints);
        this.add(this.outList);
        this.sc = new SearchCompiler(this.outList, this.data);
        this.validate();
    }

    public void start() {
        if (this.compiler == null) {
            this.compiler = new Thread((Runnable)this.sc, "SearchCompiler");
            this.compiler.start();
        }
        if (this.runApplet == null) {
            this.runApplet = new Thread((Runnable)this, "JHLSearch");
            this.runApplet.start();
        }
    }

    public void stop() {
        if (this.compiler != null) {
            this.compiler.stop();
        }
        if (this.runApplet != null) {
            this.runApplet.stop();
        }
    }

    public void run() {
        while (true) {
            Object object = this.syncTo;
            synchronized (object) {
                if (!this.compiler.isAlive() && this.runButton.getLabel().equals(stopMessage)) {
                    this.compiler.stop();
                    this.runButton.setLabel(runMessage);
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.syncTo;
        synchronized (object) {
            if (this.compiler.isAlive()) {
                this.outList.addItem("Application stopped by user");
                this.compiler.stop();
                this.runButton.setLabel(runMessage);
                Object var3_3 = null;
                return;
            }
            this.runButton.setLabel(stopMessage);
            boolean bl = this.runApp();
            if (bl) {
                this.compiler = new Thread((Runnable)this.sc, "SearchCompiler");
                this.compiler.start();
            } else {
                this.runButton.setLabel(runMessage);
            }
            return;
        }
    }

    private boolean runApp() {
        String string;
        this.outList.removeAll();
        String string2 = this.argLine.getText().trim();
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = 0;
        block0: while (n4 < n3) {
            char c;
            if (" \t\n\r\"".indexOf(c = string2.charAt(n4++)) < 0) continue;
            if (n4 - n2 > 1) {
                ++n;
            }
            n2 = n4;
            if (c != '\"') continue;
            while (n4 < n3) {
                if ((c = string2.charAt(n4++)) != '\"') continue;
                ++n;
                n2 = n4;
                continue block0;
            }
        }
        if (n4 - n2 > 1) {
            ++n;
        }
        if (n == 0) {
            this.outList.addItem("Error: No arguments specified");
            return false;
        }
        String[] stringArray = new String[n];
        n = 0;
        n2 = 0;
        n4 = 0;
        block2: while (n4 < n3) {
            char c;
            if (" \t\n\r\"".indexOf(c = string2.charAt(n4++)) < 0) continue;
            if (n4 - n2 > 1) {
                stringArray[n++] = string2.substring(n2, n4 - 1);
            }
            n2 = n4;
            if (c != '\"') continue;
            while (n4 < n3) {
                if ((c = string2.charAt(n4++)) != '\"') continue;
                stringArray[n++] = string2.substring(n2, n4);
                n2 = n4;
                continue block2;
            }
        }
        if (n4 - n2 > 1) {
            stringArray[n++] = string2.substring(n2, n4);
        }
        boolean bl = (string = this.appsList.getSelectedItem()).equals("Compiler") ? this.sc.compilerArgs(stringArray) : (string.equals("URL tokenizer") ? this.sc.tokenizerArgs(stringArray) : this.sc.parserArgs(stringArray));
        return bl;
    }

    private URL buildUrl(String string) throws MalformedURLException {
        String string2;
        String string3;
        String string4;
        URL uRL;
        block5: {
            uRL = this.getDocumentBase();
            string4 = uRL.getProtocol();
            string3 = uRL.getHost();
            string2 = uRL.getFile();
            if (string4.equals("file")) {
                int n = string.indexOf(47, 1);
                if (n >= 0) {
                    String string5;
                    String string6 = string.substring(0, n + 1);
                    n = -1;
                    do {
                        ++n;
                        if ((n = string2.indexOf(47, n)) >= 0) continue;
                        string2 = string;
                        break block5;
                    } while (!(string5 = string2.substring(n)).startsWith(string6));
                    string2 = n > 0 ? String.valueOf(string2.substring(0, n)) + string : string;
                } else {
                    string2 = string;
                }
            } else {
                string2 = string;
            }
        }
        URL uRL2 = null;
        uRL2 = string2.startsWith("/") ? new URL(string4, string3, string2) : new URL(uRL, string2);
        return uRL2;
    }
}

