/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.html;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import jhl.apps.html.NameDataTable;
import jhl.apps.html.NameDataTableEntry;
import jhl.apps.html.URL;
import jhl.util.NameTable;
import jhl.www.html.Document;
import jhl.www.html.WordDocument;

public final class Data {
    static final long serialVersionUID = -3587903199396399860L;
    public long lastModified;
    public boolean plainText = false;
    public boolean frameset = false;
    public String docTitle = "";
    public NameTable hrefUrls;
    public NameTable nonHrefUrls;
    public NameDataTable wordTable;
    public URL url;
    public int count;
    public Vector links;
    int index;

    public void transfer(Document document) {
        this.plainText = document.plainText;
        this.frameset = document.frameset != null;
        this.docTitle = document.docTitle == null ? "" : document.docTitle;
        this.hrefUrls = document.hrefUrls.toNameTable(false);
        this.nonHrefUrls = document.imageUrls.toNameTable(false);
        this.nonHrefUrls.add(document.dataUrls.toNameTable(false));
    }

    public void transfer(WordDocument wordDocument, boolean bl) {
        this.plainText = wordDocument.plainText;
        this.frameset = wordDocument.frameset != null;
        this.docTitle = wordDocument.docTitle == null ? "" : wordDocument.docTitle;
        this.hrefUrls = wordDocument.hrefUrls.toNameTable(false);
        this.nonHrefUrls = wordDocument.imageUrls.toNameTable(false);
        this.nonHrefUrls.add(wordDocument.dataUrls.toNameTable(false));
        this.wordTable = new NameDataTable(wordDocument, bl);
    }

    void store(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(-3587903199396399860L);
        dataOutputStream.writeLong(this.lastModified);
        dataOutputStream.writeBoolean(this.plainText);
        dataOutputStream.writeBoolean(this.frameset);
        dataOutputStream.writeUTF(this.docTitle);
        this.hrefUrls.store(dataOutputStream);
        this.nonHrefUrls.store(dataOutputStream);
        this.wordTable.store(dataOutputStream);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.load(dataInputStream, false, false);
    }

    public void load(DataInputStream dataInputStream, boolean bl, boolean bl2) throws IOException {
        long l = dataInputStream.readLong();
        if (l != -3587903199396399860L) {
            throw new IOException("Not a .data file");
        }
        this.lastModified = dataInputStream.readLong();
        if (!bl) {
            this.plainText = dataInputStream.readBoolean();
            this.frameset = dataInputStream.readBoolean();
            this.docTitle = dataInputStream.readUTF();
            this.hrefUrls = new NameTable();
            this.nonHrefUrls = new NameTable();
            this.hrefUrls.load(dataInputStream);
            this.nonHrefUrls.load(dataInputStream);
            this.wordTable = new NameDataTable();
            if (!bl2) {
                this.wordTable.load(dataInputStream);
            }
        }
    }

    public void clearIndex() {
        this.index = 0;
    }

    public NameDataTableEntry wordIndex(String string) {
        int n;
        int n2 = n = this.wordTable == null ? 0 : this.wordTable.count;
        if (this.index >= n) {
            return null;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.wordTable.table;
        int n3 = 1;
        while (n3 > 0) {
            NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[this.index];
            n3 = string.compareTo(nameDataTableEntry.key);
            if (n3 == 0) {
                return nameDataTableEntry;
            }
            if (n3 <= 0 || ++this.index < n) continue;
            return null;
        }
        return null;
    }
}

