/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.html;

import java.awt.List;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Vector;
import jhl.apps.html.Data;
import jhl.apps.html.DependencyLister;
import jhl.apps.html.Hierarchy;
import jhl.apps.html.URL;
import jhl.apps.html.URLTokenizer;
import jhl.io.ResponseReader;
import jhl.util.NameTable;
import jhl.util.StringFilter;
import jhl.www.html.HtmlError;
import jhl.www.html.HtmlErrorMessage;
import jhl.www.html.HtmlException;
import jhl.www.html.Parser;
import jhl.www.html.WordDocument;
import jhl.www.html.WordParserObserver;

public final class DependencyCompiler
extends Observable {
    String argUrl;
    String argLocal;
    String argDataPath;
    String argUrlsFile;
    NameTable argUrlExclusions;
    boolean argSilent;
    boolean argCase;
    boolean argLoadWords;
    PrintStream appOutput;
    List appletOutput;
    WordParserObserver parser;
    URLTokenizer ut;
    URL siteUrl;
    URL rootUrl;
    public String siteAbsPath;
    public String rootAbsPath;
    char fsChar;
    Hierarchy todo;
    Hierarchy dep;
    Hierarchy docLinks;
    Hierarchy nonDocLinks;
    NameTable nonSiteLinks;
    Hierarchy missingLinks;
    StringFilter[] urlExclude;
    StringFilter[] urlPathExclude;
    long startTime;

    public DependencyCompiler(PrintStream printStream, List list, Parser parser) {
        this.appOutput = printStream;
        this.appletOutput = list;
        this.parser = new WordParserObserver(parser == null ? new Parser() : parser);
        this.ut = new URLTokenizer();
        this.fsChar = File.separatorChar;
    }

    public static void main(String[] stringArray) {
        try {
            DependencyCompiler dependencyCompiler = new DependencyCompiler(System.out, null, null);
            dependencyCompiler.clear();
            if (dependencyCompiler.parseArgs(stringArray)) {
                if (dependencyCompiler.checkArgs()) {
                    dependencyCompiler.run();
                    return;
                }
                dependencyCompiler.showUsage();
                return;
            }
            dependencyCompiler.showUsage();
            return;
        }
        catch (Throwable throwable) {
            System.out.println("Fatal Error: " + throwable.getMessage());
            throwable.printStackTrace(System.out);
            return;
        }
    }

    public synchronized void clear() {
        this.argUrlsFile = null;
        this.argDataPath = null;
        this.argLocal = null;
        this.argUrl = null;
        this.argUrlExclusions = new NameTable();
        this.argCase = false;
        this.argLoadWords = false;
        this.argSilent = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            block22: {
                if (!stringArray[n].startsWith("-")) {
                    this.println("Unknown argument '" + stringArray[n] + "'");
                    return false;
                }
                if (stringArray[n].equals("-c")) {
                    this.argCase = true;
                } else if (stringArray[n].equals("-f")) {
                    this.argLocal = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-l")) {
                    this.argLoadWords = true;
                } else if (stringArray[n].equals("-lu")) {
                    this.argUrlsFile = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-p")) {
                    this.argDataPath = this.trimQuotes(stringArray[++n]);
                } else {
                    if (stringArray[n].equals("-r")) {
                        String string = this.trimQuotes(stringArray[++n]);
                        try {
                            ResponseReader responseReader = new ResponseReader(string);
                            String[] stringArray2 = responseReader.readAll();
                            responseReader.close();
                            responseReader = null;
                            if (stringArray2 != null && !this.parseArgs(stringArray2)) {
                                return false;
                            }
                            break block22;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.println("Error: Couldn't find response file " + string);
                            return false;
                        }
                        catch (IOException iOException) {
                            this.println("Error: Couldn't read response file " + string);
                            return false;
                        }
                    }
                    if (stringArray[n].equals("-s")) {
                        this.argSilent = true;
                    } else if (stringArray[n].equals("-u")) {
                        this.argUrl = this.trimQuotes(stringArray[++n]);
                    } else {
                        if (!stringArray[n].equals("-xu")) {
                            this.println("Unknown argument '" + stringArray[n] + "'");
                            return false;
                        }
                        this.argUrlExclusions.add(this.trimQuotes(stringArray[++n]));
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public synchronized boolean checkArgs() {
        int n;
        int n2;
        int n3;
        String string;
        File file;
        if (this.argLocal == null) {
            this.println("Error: Missing -f filename");
            return false;
        }
        if (this.argDataPath == null) {
            this.argDataPath = "data" + this.fsChar;
        }
        String string2 = this.argDataPath;
        if (this.fsChar != '/') {
            this.argDataPath = this.argDataPath.replace('/', this.fsChar);
        }
        if (!this.argDataPath.endsWith(File.separator)) {
            this.argDataPath = String.valueOf(this.argDataPath) + this.fsChar;
        }
        try {
            file = new File(this.argDataPath);
            this.argDataPath = file.getCanonicalPath();
            if (!this.argDataPath.endsWith(File.separator)) {
                this.argDataPath = String.valueOf(this.argDataPath) + this.fsChar;
            }
        }
        catch (IOException iOException) {
            this.println("Error: couldn't create canonical filepath for " + string2);
            return false;
        }
        file = new File(this.argDataPath);
        if (!(!file.exists() || file.isDirectory() && file.canRead())) {
            this.println("Error: filepath " + this.argDataPath + " is not a readable directory");
            return false;
        }
        file = new File(this.argLocal);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            this.println("Error: Can't read " + this.argLocal);
            return false;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.println("Error: Can't get canonical version of " + this.argLocal);
            return false;
        }
        if (this.argUrl == null) {
            this.argUrl = "file://" + string;
            if (this.fsChar != '/') {
                this.argUrl = this.argUrl.replace(this.fsChar, '/');
            }
        }
        this.siteUrl = this.ut.parse(this.argUrl);
        if (this.fsChar != '/') {
            string = string.replace(this.fsChar, '/');
        }
        this.rootUrl = this.ut.parse("file://" + string);
        int n4 = n3 = this.argUrlExclusions == null ? 0 : this.argUrlExclusions.getSize();
        if (n3 > 0) {
            StringFilter[] stringFilterArray;
            this.urlExclude = new StringFilter[n3];
            this.urlPathExclude = new StringFilter[n3];
            int n5 = 0;
            int n6 = 0;
            n2 = 0;
            while (n2 < n3) {
                stringFilterArray = this.argUrlExclusions.getName(n2);
                StringFilter stringFilter = new StringFilter((String)stringFilterArray);
                String string3 = stringFilter.getComp();
                if (string3.endsWith("//")) {
                    n = stringFilter.getMode();
                    stringFilter.setComp(string3.substring(0, string3.length() - 1));
                    if (n == 1) {
                        n = 0;
                    }
                    stringFilter.setMode(n | 2);
                    this.urlPathExclude[n6++] = stringFilter;
                } else {
                    this.urlExclude[n5++] = stringFilter;
                }
                ++n2;
            }
            if (n6 == 0) {
                this.urlPathExclude = null;
            } else if (n6 < n3) {
                stringFilterArray = new StringFilter[n6];
                System.arraycopy(this.urlPathExclude, 0, stringFilterArray, 0, n6);
                this.urlPathExclude = stringFilterArray;
            }
            if (n5 == 0) {
                this.urlExclude = null;
            } else if (n5 < n3) {
                stringFilterArray = new StringFilter[n5];
                System.arraycopy(this.urlExclude, 0, stringFilterArray, 0, n5);
                this.urlExclude = stringFilterArray;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(this.siteUrl.path).reverse();
        StringBuffer stringBuffer2 = new StringBuffer(this.rootUrl.path).reverse();
        n2 = 0;
        int n7 = 0;
        int n8 = Math.min(stringBuffer.length(), stringBuffer2.length());
        while (n2 < n8) {
            char c = stringBuffer.charAt(n2);
            if (c != (n = (int)stringBuffer2.charAt(n2))) break;
            if (c == '/') {
                n7 = n2;
            }
            ++n2;
        }
        this.siteAbsPath = n7 < (n8 = stringBuffer.length()) ? this.siteUrl.path.substring(0, n8 - n7) : "/";
        n8 = stringBuffer2.length();
        this.rootAbsPath = n7 < n8 ? this.rootUrl.path.substring(0, n8 - n7) : "/";
        System.gc();
        return true;
    }

    public synchronized void showUsage() {
        this.println("Usage:   java jhl.apps.html.DependencyCompiler -f filename -p filepath [options]");
        this.println("         -f filename    the root HTML filename (required)");
        this.println("Options: -lu filename   list dependency URLs to filename");
        this.println("         -p filepath    intermediate data filepath");
        this.println("         -r filename    execute response file");
        this.println("         -s             suppress HTML syntax error reporting");
        this.println("         -u url         the WWW URL equivalent of the root HTML document");
        this.println("         -xu url        exclude URL from dependancy list");
    }

    public synchronized void run() {
        this.startTime = System.currentTimeMillis();
        this.todo = new Hierarchy();
        this.todo.schema = this.rootUrl.schema;
        this.todo.location = this.rootUrl.location;
        this.dep = new Hierarchy();
        this.dep.schema = this.rootUrl.schema;
        this.dep.location = this.rootUrl.location;
        this.docLinks = new Hierarchy();
        this.docLinks.schema = this.rootUrl.schema;
        this.docLinks.location = this.rootUrl.location;
        this.nonDocLinks = new Hierarchy();
        this.nonDocLinks.schema = this.rootUrl.schema;
        this.nonDocLinks.location = this.rootUrl.location;
        this.nonSiteLinks = new NameTable();
        this.missingLinks = new Hierarchy();
        this.missingLinks.schema = this.rootUrl.schema;
        this.missingLinks.location = this.rootUrl.location;
        this.todo.add(this.rootUrl);
        this.parseHierarchy();
        int n = this.dep.getSize();
        long l = System.currentTimeMillis() - this.startTime;
        this.println(String.valueOf(n) + " files checked in " + (double)l / 1000.0 + " s");
        this.parser = null;
        this.argUrlExclusions = null;
        this.urlExclude = null;
        this.urlPathExclude = null;
        System.gc();
        if (this.argUrlsFile != null) {
            DependencyLister dependencyLister = new DependencyLister(this.appOutput, this.appletOutput, this.rootUrl, this.docLinks, this.nonDocLinks, this.nonSiteLinks, this.missingLinks);
            dependencyLister.generate(this.argUrlsFile);
        }
        this.todo = null;
        this.dep = null;
        System.gc();
    }

    protected void println(String string) {
        if (this.appletOutput != null) {
            this.appletOutput.addItem(string);
            int n = this.appletOutput.getItemCount() - 1;
            this.appletOutput.makeVisible(n);
        }
        if (this.appOutput != null) {
            this.appOutput.println(string);
        }
    }

    private void parseHierarchy() {
        while (this.todo.getSize() > 0) {
            URL uRL = this.todo.get(0);
            this.todo.remove(0);
            if (this.dep.inList(uRL)) continue;
            this.println(uRL.stringize());
            Data data = this.checkHtml(uRL);
            if (data != null) {
                this.dep.add(uRL);
                this.checkLinks(uRL, data);
                data.url = uRL;
                this.setChanged();
                this.notifyObservers(data);
            }
            System.gc();
        }
    }

    private Data checkHtml(URL uRL) {
        String string = this.fileUrlToFile(uRL, false);
        String string2 = String.valueOf(this.fileUrlToFile(uRL, true)) + ".data";
        File file = new File(string);
        File file2 = new File(string2);
        if (file2.exists() && file2.isFile() && file2.canRead()) {
            FilterInputStream filterInputStream = null;
            try {
                Data data = new Data();
                filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
                data.load((DataInputStream)filterInputStream, true, false);
                filterInputStream.close();
                if (data.lastModified != file.lastModified()) {
                    return this.parseHtml(uRL, string2);
                }
                filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
                data.load((DataInputStream)filterInputStream, false, !this.argLoadWords);
                filterInputStream.close();
                uRL.lastModified = file.lastModified();
                return data;
            }
            catch (IOException iOException) {
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                }
                catch (IOException iOException2) {}
                return this.parseHtml(uRL, string2);
            }
        }
        return this.parseHtml(uRL, string2);
    }

    private Data parseHtml(URL uRL, String string) {
        Object object;
        int n = string.lastIndexOf(this.fsChar);
        String string2 = string.substring(0, n + 1);
        String string3 = this.fileUrlToFile(uRL, false);
        File file = new File(string3);
        File file2 = new File(string);
        File file3 = new File(string2);
        WordDocument wordDocument = new WordDocument();
        HtmlError htmlError = this.argSilent ? null : new HtmlError();
        try {
            this.parser.parse(file, wordDocument, htmlError);
            if (htmlError != null && (object = htmlError.getErrors()) != null) {
                int n2 = ((Vector)object).size();
                int n3 = 0;
                while (n3 < n2) {
                    HtmlErrorMessage htmlErrorMessage = (HtmlErrorMessage)((Vector)object).elementAt(n3);
                    this.println(htmlErrorMessage.getError());
                    ++n3;
                }
            }
        }
        catch (HtmlException htmlException) {
            this.println("Error: " + uRL.stringize() + ": " + htmlException.getMessage());
            return null;
        }
        object = new Data();
        FilterOutputStream filterOutputStream = null;
        try {
            ((Data)object).transfer(wordDocument, this.argCase);
            ((Data)object).lastModified = file.lastModified();
            uRL.lastModified = file.lastModified();
            if (((Data)object).docTitle.length() == 0) {
                ((Data)object).docTitle = uRL.filename;
            }
            file3.mkdirs();
            filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            ((Data)object).store((DataOutputStream)filterOutputStream);
            filterOutputStream.close();
            return object;
        }
        catch (IOException iOException) {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException2) {}
            this.println("Couldn't write " + string);
            return object;
        }
    }

    private void checkLinks(URL uRL, Data data) {
        Object object;
        Object object2;
        URL uRL2;
        Object object3;
        NameTable nameTable = data.hrefUrls;
        int n = nameTable.getSize();
        int n2 = 0;
        while (n2 < n) {
            String string = nameTable.getName(n2);
            object3 = this.ut.parse(string);
            uRL2 = this.convertLink(uRL, (URL)object3);
            if (uRL2 == null) {
                if (((URL)object3).location.length() != 0 || ((URL)object3).path.length() != 0 || ((URL)object3).filename.length() != 0) {
                    this.nonSiteLinks.add(((URL)object3).stringize());
                }
            } else if (!(this.dep.inList(uRL2) || this.todo.inList(uRL2) || this.isExcluded(String.valueOf(uRL2.path) + uRL2.filename))) {
                object2 = this.fileUrlToFile(uRL2, false);
                object = new File((String)object2);
                if (!(((File)object).exists() && ((File)object).isFile() && ((File)object).canRead())) {
                    this.missingLinks.add(uRL2);
                } else {
                    this.docLinks.add(uRL2);
                    this.setChanged();
                    this.notifyObservers(uRL2);
                    this.todo.add(uRL2);
                }
            } else if (!this.isExcluded(String.valueOf(uRL2.path) + uRL2.filename)) {
                object2 = this.fileUrlToFile(uRL2, false);
                object = new File((String)object2);
                if (!(((File)object).exists() && ((File)object).isFile() && ((File)object).canRead())) {
                    this.missingLinks.add(uRL2);
                } else {
                    this.docLinks.add(uRL2);
                    this.setChanged();
                    this.notifyObservers(uRL2);
                }
            }
            ++n2;
        }
        nameTable = data.nonHrefUrls;
        n = nameTable.getSize();
        int n3 = 0;
        while (n3 < n) {
            object3 = nameTable.getName(n3);
            uRL2 = this.ut.parse((String)object3);
            object2 = this.convertLink(uRL, uRL2);
            if (object2 == null) {
                if (uRL2.location.length() != 0 || uRL2.path.length() != 0 || uRL2.filename.length() != 0) {
                    this.nonSiteLinks.add(uRL2.stringize());
                }
            } else if (!this.nonDocLinks.inList((URL)object2)) {
                object = this.fileUrlToFile((URL)object2, false);
                File file = new File((String)object);
                if (!file.exists()) {
                    this.missingLinks.add((URL)object2);
                } else {
                    this.nonDocLinks.add((URL)object2);
                }
            }
            ++n3;
        }
    }

    private URL convertLink(URL uRL, URL uRL2) {
        int n;
        if (uRL2.filename.equals("")) {
            return null;
        }
        if (!uRL2.schema.equals("http") && !uRL2.schema.equals("")) {
            return null;
        }
        if (!uRL2.location.equals(this.siteUrl.location) && !uRL2.location.equals("")) {
            return null;
        }
        URL uRL3 = new URL();
        uRL3.schema = this.rootUrl.schema;
        uRL3.location = this.rootUrl.location;
        uRL3.path = uRL.path;
        uRL3.filename = uRL2.filename;
        boolean bl = false;
        String string = uRL2.path;
        if (!string.equals("")) {
            if (!string.startsWith("/")) {
                uRL3.path = String.valueOf(uRL3.path) + string;
                bl = true;
            } else {
                if (!string.startsWith(this.siteAbsPath)) {
                    return null;
                }
                n = this.siteAbsPath.length();
                uRL3.path = String.valueOf(this.rootAbsPath) + string.substring(n);
                bl = true;
            }
        }
        if (bl) {
            string = uRL3.path;
            n = string.length();
            int n2 = -1;
            while (true) {
                ++n2;
                if ((n2 = string.indexOf(47, n2)) < 0 || n2 >= n - 2) break;
                char c = string.charAt(n2 + 1);
                if (c != '.') continue;
                char c2 = string.charAt(n2 + 2);
                if (c2 == '/') {
                    string = n > ++n2 + 2 ? String.valueOf(string.substring(0, n2)) + string.substring(n2 + 2) : string.substring(0, n2);
                    n2 -= 2;
                    n = string.length();
                    continue;
                }
                if (c2 != '.' || (c2 = string.charAt(n2 + 3)) != '/') continue;
                int n3 = -1;
                int n4 = string.indexOf(47);
                while (n4 != n2) {
                    n3 = n4++;
                    n4 = string.indexOf(47, n4);
                }
                if (n3 < 0) {
                    string = n > ++n2 + 3 ? String.valueOf(string.substring(0, n2)) + string.substring(n2 + 3) : string.substring(0, n2);
                    n2 -= 2;
                    n = string.length();
                    continue;
                }
                string = n > ++n2 + 3 ? String.valueOf(string.substring(0, n3)) + string.substring(n2 + 3) : string.substring(0, ++n3);
                n = string.length();
                n2 = n3 - 2;
            }
            uRL3.path = string;
        }
        return uRL3;
    }

    private boolean isExcluded(String string) {
        int n;
        int n2;
        if (this.urlExclude != null) {
            n2 = this.urlExclude.length;
            n = 0;
            while (n < n2) {
                if (this.urlExclude[n].isValid(string)) {
                    return true;
                }
                ++n;
            }
        }
        if (this.urlPathExclude == null) {
            return false;
        }
        n2 = this.urlPathExclude.length;
        n = 0;
        while (n < n2) {
            StringFilter stringFilter = this.urlPathExclude[n];
            if (stringFilter.isValid(string)) {
                String string2 = stringFilter.getComp();
                int n3 = string2.length();
                int n4 = string.indexOf(string2);
                if (string.indexOf(47, n4 + n3) < 0) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private String fileUrlToFile(URL uRL, boolean bl) {
        String string = uRL.stringize().substring(7);
        if (bl) {
            int n;
            string = string.startsWith("/") ? String.valueOf(this.argDataPath) + string.substring(1) : ((n = string.indexOf(47)) > 0 ? String.valueOf(this.argDataPath) + string.substring(n + 1) : String.valueOf(this.argDataPath) + string);
        }
        if (this.fsChar != '/') {
            string = string.replace('/', this.fsChar);
        }
        return string;
    }

    private String trimQuotes(String string) {
        int n = string.length();
        if (n <= 0) {
            return string;
        }
        if (string.charAt(n - 1) == '\"') {
            string = string.substring(0, n - 1);
        }
        if (string.charAt(0) == '\"') {
            string = string.substring(1);
        }
        return string;
    }
}

