/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.html;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;

public final class HtmlOutputStream
extends FileOutputStream {
    private int col;
    private String delims = " \t";

    public HtmlOutputStream(String string) throws IOException {
        super(string);
        this.col = 0;
    }

    public HtmlOutputStream(String string, boolean bl) throws IOException {
        super(string, false);
    }

    public HtmlOutputStream(File file) throws IOException {
        super(file);
    }

    public HtmlOutputStream(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    public void printString(String string) throws IOException {
        int n = string.length();
        char[] cArray = string.toCharArray();
        this.printWithBreaks(cArray, 0, n);
    }

    public void println() throws IOException {
        this.write(13);
        this.write(10);
        this.col = 0;
    }

    public void write(int n) throws IOException {
        if (n >= 160) {
            this.printString("&#" + n + ";");
            return;
        }
        super.write(n);
    }

    private void printWithBreaks(char[] cArray, int n, int n2) throws IOException {
        while (n2-- > 0) {
            char c = cArray[n++];
            if (this.col >= 80) {
                int n3 = this.delims.indexOf(c);
                if (n3 >= 0) {
                    this.write(13);
                    this.write(10);
                    this.col = 0;
                    this.write(c);
                    ++this.col;
                    continue;
                }
                this.write(c);
                ++this.col;
                continue;
            }
            this.write(c);
            ++this.col;
        }
    }
}

