/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.html;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jhl.apps.html.NameDataTableEntry;
import jhl.util.CaseNameTable;
import jhl.util.NameTable;
import jhl.util.NameTableCompressor;
import jhl.util.StringFilter;
import jhl.www.html.WordDocument;

public final class NameDataTable {
    NameDataTableEntry[] table;
    int count;
    NameTableCompressor compressor;

    public NameDataTable() {
        this(50);
    }

    public NameDataTable(int n) {
        if (n < 50) {
            n = 50;
        }
        n += 49;
        n -= n % 50;
        this.table = new NameDataTableEntry[n];
    }

    public NameDataTable(WordDocument wordDocument, boolean bl) {
        int n = 0;
        n = Math.max(n, wordDocument.titleWords.getSize());
        n = Math.max(n, wordDocument.headingWords.getSize());
        n = Math.max(n, wordDocument.listWords.getSize());
        n = Math.max(n, wordDocument.htmlWords.getSize());
        n += 49;
        n -= n % 50;
        if (n == 0) {
            n = 50;
        }
        this.table = new NameDataTableEntry[n];
        if (!bl) {
            NameTable nameTable = wordDocument.titleWords.toNameTable(true);
            this.add(nameTable, 1);
            nameTable = wordDocument.headingWords.toNameTable(true);
            this.add(nameTable, 2);
            nameTable = wordDocument.listWords.toNameTable(true);
            this.add(nameTable, 4);
            nameTable = wordDocument.htmlWords.toNameTable(true);
            this.add(nameTable, 8);
            return;
        }
        CaseNameTable caseNameTable = wordDocument.titleWords.toCaseNameTable();
        this.add(caseNameTable, 1);
        caseNameTable = wordDocument.headingWords.toCaseNameTable();
        this.add(caseNameTable, 2);
        caseNameTable = wordDocument.listWords.toCaseNameTable();
        this.add(caseNameTable, 4);
        caseNameTable = wordDocument.htmlWords.toCaseNameTable();
        this.add(caseNameTable, 8);
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized int getSize() {
        return this.count;
    }

    public synchronized void clear() {
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n = 0;
        while (n < nameDataTableEntryArray.length) {
            nameDataTableEntryArray[n] = null;
            ++n;
        }
        this.count = 0;
    }

    public synchronized void setCompressor(NameTableCompressor nameTableCompressor) {
        this.compressor = nameTableCompressor;
    }

    public synchronized void add(NameDataTableEntry nameDataTableEntry) {
        int n;
        if (nameDataTableEntry == null || nameDataTableEntry.key.length() == 0) {
            return;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        if (this.count == 0) {
            NameDataTableEntry nameDataTableEntry2 = new NameDataTableEntry();
            nameDataTableEntry2.key = nameDataTableEntry.key;
            nameDataTableEntry2.original = nameDataTableEntry.original;
            nameDataTableEntry2.add(nameDataTableEntry);
            nameDataTableEntryArray[0] = nameDataTableEntry2;
            ++this.count;
            return;
        }
        int n2 = this.find(nameDataTableEntry.key);
        NameDataTableEntry nameDataTableEntry3 = nameDataTableEntryArray[n2];
        int n3 = nameDataTableEntry.key.compareTo(nameDataTableEntry3.key);
        if (n3 == 0) {
            nameDataTableEntry3.add(nameDataTableEntry);
            return;
        }
        if (n3 > 0) {
            ++n2;
        }
        if (this.ensureCapacity(this.count)) {
            nameDataTableEntryArray = this.table;
        }
        if ((n = this.count - n2) > 0) {
            System.arraycopy(nameDataTableEntryArray, n2, nameDataTableEntryArray, n2 + 1, n);
        }
        NameDataTableEntry nameDataTableEntry4 = new NameDataTableEntry();
        nameDataTableEntry4.key = nameDataTableEntry.key;
        nameDataTableEntry4.original = nameDataTableEntry.original;
        nameDataTableEntry4.add(nameDataTableEntry);
        nameDataTableEntryArray[n2] = nameDataTableEntry4;
        ++this.count;
    }

    public synchronized void add(NameTable nameTable, int n) {
        int n2;
        if (nameTable == null || nameTable.getSize() == 0) {
            return;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n3 = nameTable.getSize();
        if (this.count == 0) {
            if (this.ensureCapacity(n3)) {
                nameDataTableEntryArray = this.table;
            }
            int n4 = 0;
            while (n4 < n3) {
                NameDataTableEntry nameDataTableEntry = new NameDataTableEntry();
                nameDataTableEntry.key = nameDataTableEntry.original = nameTable.getName(n4);
                nameDataTableEntry.add(nameTable.getUsage(n4), n);
                nameDataTableEntryArray[n4] = nameDataTableEntry;
                ++n4;
            }
            this.count = n3;
            return;
        }
        String string = nameTable.getName(0);
        int n5 = this.find(string);
        NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n5];
        int n6 = string.compareTo(nameDataTableEntry.key);
        if (n6 == 0) {
            nameDataTableEntry.add(nameTable.getUsage(0), n);
            ++n5;
        } else {
            if (n6 > 0) {
                ++n5;
            }
            if (this.ensureCapacity(this.count)) {
                nameDataTableEntryArray = this.table;
            }
            if ((n2 = this.count - n5) > 0) {
                System.arraycopy(nameDataTableEntryArray, n5, nameDataTableEntryArray, n5 + 1, n2);
            }
            NameDataTableEntry nameDataTableEntry2 = new NameDataTableEntry();
            nameDataTableEntry2.key = nameDataTableEntry2.original = string;
            nameDataTableEntry2.add(nameTable.getUsage(0), n);
            nameDataTableEntryArray[n5] = nameDataTableEntry2;
            ++n5;
            ++this.count;
        }
        n2 = 1;
        while (n2 < n3) {
            NameDataTableEntry nameDataTableEntry3;
            string = nameTable.getName(n2);
            while (true) {
                if (n5 >= this.count) {
                    int n7 = n3 - n2;
                    if (this.ensureCapacity(this.count + n7)) {
                        nameDataTableEntryArray = this.table;
                    }
                    while (n2 < n3) {
                        nameDataTableEntry3 = new NameDataTableEntry();
                        nameDataTableEntry3.key = nameDataTableEntry3.original = nameTable.getName(n2);
                        nameDataTableEntry3.add(nameTable.getUsage(n2), n);
                        nameDataTableEntryArray[n5] = nameDataTableEntry3;
                        ++n5;
                        ++n2;
                    }
                    this.count += n7;
                    return;
                }
                nameDataTableEntry = nameDataTableEntryArray[n5];
                n6 = string.compareTo(nameDataTableEntry.key);
                if (n6 <= 0) break;
                ++n5;
            }
            if (n6 == 0) {
                nameDataTableEntry.add(nameTable.getUsage(n2), n);
                ++n5;
            } else {
                int n8;
                if (this.ensureCapacity(this.count)) {
                    nameDataTableEntryArray = this.table;
                }
                if ((n8 = this.count - n5) > 0) {
                    System.arraycopy(nameDataTableEntryArray, n5, nameDataTableEntryArray, n5 + 1, n8);
                }
                nameDataTableEntry3 = new NameDataTableEntry();
                nameDataTableEntry3.key = nameDataTableEntry3.original = string;
                nameDataTableEntry3.add(nameTable.getUsage(n2), n);
                nameDataTableEntryArray[n5] = nameDataTableEntry3;
                ++n5;
                ++this.count;
            }
            ++n2;
        }
    }

    public synchronized void add(CaseNameTable caseNameTable, int n) {
        int n2;
        if (caseNameTable == null || caseNameTable.getSize() == 0) {
            return;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n3 = caseNameTable.getSize();
        if (this.count == 0) {
            if (this.ensureCapacity(n3)) {
                nameDataTableEntryArray = this.table;
            }
            int n4 = 0;
            while (n4 < n3) {
                NameDataTableEntry nameDataTableEntry = new NameDataTableEntry();
                nameDataTableEntry.key = caseNameTable.getName(n4);
                nameDataTableEntry.original = caseNameTable.getOriginal(n4);
                nameDataTableEntry.add(caseNameTable.getUsage(n4), n);
                nameDataTableEntryArray[n4] = nameDataTableEntry;
                ++n4;
            }
            this.count = n3;
            return;
        }
        String string = caseNameTable.getName(0);
        int n5 = this.find(string);
        NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n5];
        int n6 = string.compareTo(nameDataTableEntry.key);
        if (n6 == 0) {
            nameDataTableEntry.add(caseNameTable.getUsage(0), n);
            ++n5;
        } else {
            if (n6 > 0) {
                ++n5;
            }
            if (this.ensureCapacity(this.count)) {
                nameDataTableEntryArray = this.table;
            }
            if ((n2 = this.count - n5) > 0) {
                System.arraycopy(nameDataTableEntryArray, n5, nameDataTableEntryArray, n5 + 1, n2);
            }
            NameDataTableEntry nameDataTableEntry2 = new NameDataTableEntry();
            nameDataTableEntry2.key = string;
            nameDataTableEntry2.original = caseNameTable.getOriginal(0);
            nameDataTableEntry2.add(caseNameTable.getUsage(0), n);
            nameDataTableEntryArray[n5] = nameDataTableEntry2;
            ++n5;
            ++this.count;
        }
        n2 = 1;
        while (n2 < n3) {
            NameDataTableEntry nameDataTableEntry3;
            string = caseNameTable.getName(n2);
            while (true) {
                if (n5 >= this.count) {
                    int n7 = n3 - n2;
                    if (this.ensureCapacity(this.count + n7)) {
                        nameDataTableEntryArray = this.table;
                    }
                    while (n2 < n3) {
                        nameDataTableEntry3 = new NameDataTableEntry();
                        nameDataTableEntry3.key = caseNameTable.getName(n2);
                        nameDataTableEntry3.original = caseNameTable.getOriginal(n2);
                        nameDataTableEntry3.add(caseNameTable.getUsage(n2), n);
                        nameDataTableEntryArray[n5] = nameDataTableEntry3;
                        ++n5;
                        ++n2;
                    }
                    this.count += n7;
                    return;
                }
                nameDataTableEntry = nameDataTableEntryArray[n5];
                n6 = string.compareTo(nameDataTableEntry.key);
                if (n6 <= 0) break;
                ++n5;
            }
            if (n6 == 0) {
                nameDataTableEntry.add(caseNameTable.getUsage(n2), n);
                ++n5;
            } else {
                int n8;
                if (this.ensureCapacity(this.count)) {
                    nameDataTableEntryArray = this.table;
                }
                if ((n8 = this.count - n5) > 0) {
                    System.arraycopy(nameDataTableEntryArray, n5, nameDataTableEntryArray, n5 + 1, n8);
                }
                nameDataTableEntry3 = new NameDataTableEntry();
                nameDataTableEntry3.key = string;
                nameDataTableEntry3.original = caseNameTable.getOriginal(n2);
                nameDataTableEntry3.add(caseNameTable.getUsage(n2), n);
                nameDataTableEntryArray[n5] = nameDataTableEntry3;
                ++n5;
                ++this.count;
            }
            ++n2;
        }
    }

    public synchronized void add(NameDataTable nameDataTable) {
        int n;
        if (nameDataTable == null || nameDataTable.count == 0) {
            return;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        NameDataTableEntry[] nameDataTableEntryArray2 = nameDataTable.table;
        int n2 = nameDataTable.count;
        if (this.count == 0) {
            if (this.ensureCapacity(n2)) {
                nameDataTableEntryArray = this.table;
            }
            int n3 = 0;
            while (n3 < n2) {
                NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray2[n3];
                NameDataTableEntry nameDataTableEntry2 = new NameDataTableEntry();
                nameDataTableEntry2.key = nameDataTableEntry.key;
                nameDataTableEntry2.original = nameDataTableEntry.original;
                nameDataTableEntry2.add(nameDataTableEntry);
                nameDataTableEntryArray[n3] = nameDataTableEntry2;
                ++n3;
            }
            this.count = n2;
            return;
        }
        NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray2[0];
        String string = nameDataTableEntry.key;
        int n4 = this.find(string);
        NameDataTableEntry nameDataTableEntry3 = nameDataTableEntryArray[n4];
        int n5 = string.compareTo(nameDataTableEntry3.key);
        if (n5 == 0) {
            nameDataTableEntry3.add(nameDataTableEntry);
            ++n4;
        } else {
            if (n5 > 0) {
                ++n4;
            }
            if (this.ensureCapacity(this.count)) {
                nameDataTableEntryArray = this.table;
            }
            if ((n = this.count - n4) > 0) {
                System.arraycopy(nameDataTableEntryArray, n4, nameDataTableEntryArray, n4 + 1, n);
            }
            NameDataTableEntry nameDataTableEntry4 = new NameDataTableEntry();
            nameDataTableEntry4.key = nameDataTableEntry.key;
            nameDataTableEntry4.original = nameDataTableEntry.original;
            nameDataTableEntry4.add(nameDataTableEntry);
            nameDataTableEntryArray[n4] = nameDataTableEntry4;
            ++n4;
            ++this.count;
        }
        n = 1;
        while (n < n2) {
            NameDataTableEntry nameDataTableEntry5;
            nameDataTableEntry = nameDataTableEntryArray2[n];
            string = nameDataTableEntry.key;
            while (true) {
                if (n4 >= this.count) {
                    int n6 = n2 - n;
                    if (this.ensureCapacity(this.count + n6)) {
                        nameDataTableEntryArray = this.table;
                    }
                    while (n < n2) {
                        nameDataTableEntry = nameDataTableEntryArray2[n];
                        nameDataTableEntry5 = new NameDataTableEntry();
                        nameDataTableEntry5.key = nameDataTableEntry.key;
                        nameDataTableEntry5.original = nameDataTableEntry.original;
                        nameDataTableEntry5.add(nameDataTableEntry);
                        nameDataTableEntryArray[n4] = nameDataTableEntry5;
                        ++n4;
                        ++n;
                    }
                    this.count += n6;
                    return;
                }
                nameDataTableEntry3 = nameDataTableEntryArray[n4];
                n5 = string.compareTo(nameDataTableEntry3.key);
                if (n5 <= 0) break;
                ++n4;
            }
            if (n5 == 0) {
                nameDataTableEntry3.add(nameDataTableEntry);
                ++n4;
            } else {
                int n7;
                if (this.ensureCapacity(this.count)) {
                    nameDataTableEntryArray = this.table;
                }
                if ((n7 = this.count - n4) > 0) {
                    System.arraycopy(nameDataTableEntryArray, n4, nameDataTableEntryArray, n4 + 1, n7);
                }
                nameDataTableEntry5 = new NameDataTableEntry();
                nameDataTableEntry5.key = nameDataTableEntry.key;
                nameDataTableEntry5.original = nameDataTableEntry.original;
                nameDataTableEntry5.add(nameDataTableEntry);
                nameDataTableEntryArray[n4] = nameDataTableEntry5;
                ++n4;
                ++this.count;
            }
            ++n;
        }
    }

    public synchronized void removeDigits() {
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n = 0;
        while (n < this.count) {
            NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n];
            if (Character.isDigit(nameDataTableEntry.key.charAt(0))) {
                int n2 = this.count - n - 1;
                if (n2 > 0) {
                    System.arraycopy(nameDataTableEntryArray, n + 1, nameDataTableEntryArray, n, n2);
                }
                --this.count;
                --n;
                nameDataTableEntryArray[this.count] = null;
            }
            ++n;
        }
    }

    public synchronized void removeGroup(int n) {
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n2 = 0;
        while (n2 < this.count) {
            NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n2];
            if ((nameDataTableEntry.getType() & n) == 0) {
                int n3 = this.count - n2 - 1;
                if (n3 > 0) {
                    System.arraycopy(nameDataTableEntryArray, n2 + 1, nameDataTableEntryArray, n2, n3);
                }
                --this.count;
                --n2;
                nameDataTableEntryArray[this.count] = null;
            } else {
                nameDataTableEntry.removeGroup(n);
            }
            ++n2;
        }
    }

    public synchronized void remove(StringFilter[] stringFilterArray) {
        if (this.count == 0 || stringFilterArray == null) {
            return;
        }
        NameDataTable nameDataTable = new NameDataTable();
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n = stringFilterArray.length;
        int n2 = 0;
        while (n2 < this.count) {
            NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n2];
            int n3 = 0;
            while (n3 < n) {
                StringFilter stringFilter = stringFilterArray[n3];
                if (stringFilter.isValid(nameDataTableEntry.key)) {
                    int n4 = this.count - n2 - 1;
                    if (n4 > 0) {
                        System.arraycopy(nameDataTableEntryArray, n2 + 1, nameDataTableEntryArray, n2, n4);
                    }
                    --this.count;
                    --n2;
                    nameDataTableEntryArray[this.count] = null;
                    String string = stringFilter.filter(nameDataTableEntry.key);
                    int n5 = nameDataTableEntry.key.indexOf(string);
                    int n6 = string.length();
                    if (n6 > 0) {
                        nameDataTableEntry.original = nameDataTableEntry.original.substring(n5, n5 + n6);
                    }
                    nameDataTableEntry.key = string;
                    if (n6 <= 0) break;
                    nameDataTable.add(nameDataTableEntry);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        this.add(nameDataTable);
    }

    public synchronized void remove(NameTable nameTable) {
        int n;
        if (this.count == 0 || nameTable == null || nameTable.getSize() == 0) {
            return;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n2 = nameTable.getSize();
        String string = nameTable.getName(0);
        int n3 = this.find(string);
        NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n3];
        int n4 = string.compareTo(nameDataTableEntry.key);
        if (n4 == 0) {
            n = this.count - n3 - 1;
            if (n > 0) {
                System.arraycopy(nameDataTableEntryArray, n3 + 1, nameDataTableEntryArray, n3, n);
            }
            --this.count;
            nameDataTableEntryArray[this.count] = null;
        } else if (n4 > 0) {
            ++n3;
        }
        n = 1;
        while (n < n2) {
            string = nameTable.getName(n);
            while (true) {
                if (n3 >= this.count) {
                    return;
                }
                nameDataTableEntry = nameDataTableEntryArray[n3];
                n4 = string.compareTo(nameDataTableEntry.key);
                if (n4 <= 0) break;
                ++n3;
            }
            if (n4 == 0) {
                int n5 = this.count - n3 - 1;
                if (n5 > 0) {
                    System.arraycopy(nameDataTableEntryArray, n3 + 1, nameDataTableEntryArray, n3, n5);
                }
                --this.count;
                nameDataTableEntryArray[this.count] = null;
            }
            ++n;
        }
    }

    public synchronized void remove(int n) {
        if (n < 0 || n >= this.count) {
            return;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n2 = this.count - n - 1;
        if (n2 > 0) {
            System.arraycopy(nameDataTableEntryArray, n + 1, nameDataTableEntryArray, n, n2);
        }
        --this.count;
        nameDataTableEntryArray[this.count] = null;
    }

    public synchronized boolean inTable(String string) {
        if (string == null || string.length() == 0 || this.count == 0) {
            return false;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n = this.find(string);
        NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n];
        return string.compareTo(nameDataTableEntry.key) == 0;
    }

    public synchronized int getIndex(String string) {
        if (string == null || string.length() == 0 || this.count == 0) {
            return -1;
        }
        return this.find(string);
    }

    public synchronized String getString(int n) {
        if (n < 0 || n >= this.count) {
            return "";
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        return nameDataTableEntryArray[n].key;
    }

    public synchronized int getUsage(int n, int n2) {
        if (n < 0 || n >= this.count) {
            return -1;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n];
        return nameDataTableEntry.getUsage(n2);
    }

    public synchronized int getType(int n) {
        if (n < 0 || n >= this.count) {
            return 0;
        }
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        NameDataTableEntry nameDataTableEntry = nameDataTableEntryArray[n];
        return nameDataTableEntry.getType();
    }

    private boolean ensureCapacity(int n) {
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        if (n >= nameDataTableEntryArray.length) {
            n += 49;
            n -= n % 50;
            NameDataTableEntry[] nameDataTableEntryArray2 = new NameDataTableEntry[n + 50];
            System.arraycopy(nameDataTableEntryArray, 0, nameDataTableEntryArray2, 0, this.count);
            this.table = nameDataTableEntryArray2;
            return true;
        }
        return false;
    }

    private int find(String string) {
        NameDataTableEntry[] nameDataTableEntryArray = this.table;
        int n = 0;
        int n2 = 0;
        int n3 = this.count;
        int n4 = -1;
        do {
            n2 = n3 + n4 >> 1;
            n = string.compareTo(nameDataTableEntryArray[n2].key);
            if (n == 0) {
                return n2;
            }
            if (n < 0) {
                n3 = n2;
                continue;
            }
            n4 = n2;
        } while (n4 < n3 - 1);
        return n2;
    }

    public synchronized void store(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.count);
        if (this.count > 0) {
            NameDataTableEntry nameDataTableEntry;
            int n;
            NameDataTableEntry[] nameDataTableEntryArray = this.table;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.count) {
                NameDataTableEntry nameDataTableEntry2 = nameDataTableEntryArray[n6];
                n2 = Math.max(n2, nameDataTableEntry2.titleCount);
                n3 = Math.max(n3, nameDataTableEntry2.headingCount);
                n4 = Math.max(n4, nameDataTableEntry2.listCount);
                n5 = Math.max(n5, nameDataTableEntry2.htmlCount);
                ++n6;
            }
            int n7 = 0;
            while (n2 > 0) {
                ++n7;
                n2 >>>= 1;
            }
            int n8 = 0;
            while (n3 > 0) {
                ++n8;
                n3 >>>= 1;
            }
            int n9 = 0;
            while (n4 > 0) {
                ++n9;
                n4 >>>= 1;
            }
            int n10 = 0;
            while (n5 > 0) {
                ++n10;
                n5 >>>= 1;
            }
            int n11 = n7 + n8 + n9 + n10;
            int n12 = n7;
            int n13 = n12 + n8;
            int n14 = n13 + n9;
            dataOutputStream.writeShort((short)n7);
            dataOutputStream.writeShort((short)n8);
            dataOutputStream.writeShort((short)n9);
            dataOutputStream.writeShort((short)n10);
            if (this.compressor != null) {
                this.compressor.init();
                n = 0;
                while (n < this.count) {
                    nameDataTableEntry = nameDataTableEntryArray[n];
                    this.compressor.store(dataOutputStream, nameDataTableEntry.original);
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.count) {
                    nameDataTableEntry = nameDataTableEntryArray[n];
                    dataOutputStream.writeUTF(nameDataTableEntry.original);
                    ++n;
                }
            }
            n = 0;
            while (n < this.count) {
                nameDataTableEntry = nameDataTableEntryArray[n];
                long l = nameDataTableEntry.titleCount;
                l += (long)nameDataTableEntry.headingCount << n12;
                l += (long)nameDataTableEntry.listCount << n13;
                l += (long)nameDataTableEntry.htmlCount << n14;
                if (n11 < 8) {
                    dataOutputStream.writeByte((byte)l);
                } else if (n11 < 16) {
                    dataOutputStream.writeShort((short)l);
                } else if (n11 < 32) {
                    dataOutputStream.writeInt((int)l);
                } else {
                    dataOutputStream.writeLong(l);
                }
                ++n;
            }
        }
    }

    public synchronized void load(DataInputStream dataInputStream) throws IOException {
        this.count = dataInputStream.readInt();
        if (this.count > 0) {
            NameDataTableEntry nameDataTableEntry;
            int n;
            int n2 = this.count + 49;
            n2 -= n2 % 50;
            NameDataTableEntry[] nameDataTableEntryArray = this.table = new NameDataTableEntry[n2];
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            short s3 = dataInputStream.readShort();
            short s4 = dataInputStream.readShort();
            int n3 = s + s2 + s3 + s4;
            long l = (1 << s) - 1;
            long l2 = (1 << s2) - 1;
            long l3 = (1 << s3) - 1;
            long l4 = (1 << s4) - 1;
            if (this.compressor != null) {
                this.compressor.init();
                n = 0;
                while (n < this.count) {
                    nameDataTableEntryArray[n] = nameDataTableEntry = new NameDataTableEntry();
                    nameDataTableEntry.original = this.compressor.load(dataInputStream);
                    nameDataTableEntry.key = nameDataTableEntry.original.toLowerCase();
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.count) {
                    nameDataTableEntryArray[n] = nameDataTableEntry = new NameDataTableEntry();
                    nameDataTableEntry.original = dataInputStream.readUTF();
                    nameDataTableEntry.key = nameDataTableEntry.original.toLowerCase();
                    ++n;
                }
            }
            n = 0;
            while (n < this.count) {
                nameDataTableEntry = nameDataTableEntryArray[n];
                long l5 = n3 < 8 ? (long)dataInputStream.readByte() : (n3 < 16 ? (long)dataInputStream.readShort() : (n3 < 32 ? (long)dataInputStream.readInt() : dataInputStream.readLong()));
                nameDataTableEntry.titleCount = (int)(l5 & l);
                nameDataTableEntry.headingCount = (int)((l5 >>>= s) & l2);
                nameDataTableEntry.listCount = (int)((l5 >>>= s2) & l3);
                nameDataTableEntry.htmlCount = (int)((l5 >>>= s3) & l4);
                ++n;
            }
        }
    }
}

