/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.search;

import java.awt.List;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import jhl.apps.html.Data;
import jhl.apps.html.HtmlOutputStream;
import jhl.apps.html.NameDataTable;
import jhl.apps.html.NameDataTableEntry;
import jhl.apps.html.URL;
import jhl.io.LZWOutputStream;
import jhl.util.NameTable;

public final class AppletCompiler {
    PrintStream appOutput;
    List appletOutput;
    Data[] infoFiles;
    NameDataTable filteredWordList;
    int readFiles;
    int wordFiles;
    Data TOC;
    int webDatabaseSize;
    int cdDatabaseSize;
    String siteAbsPath;
    static final long serialVersionUID = 7819821248086837908L;

    public AppletCompiler(PrintStream printStream, List list, int n, int n2, NameDataTable nameDataTable, Data[] dataArray, Data data, String string) {
        this.appOutput = printStream;
        this.appletOutput = list;
        this.readFiles = n;
        this.wordFiles = n2;
        this.filteredWordList = nameDataTable;
        this.infoFiles = dataArray;
        this.TOC = data;
        this.siteAbsPath = string;
    }

    public void generate(String string, String string2) {
        this.println("Generating applet files");
        this.sizeSearchDatabase();
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        RandomAccessFile randomAccessFile = null;
        try {
            if (string != null) {
                fileOutputStream = new HtmlOutputStream(new File(String.valueOf(string) + ".html"));
                this.outputWebApplet((HtmlOutputStream)fileOutputStream, string);
                fileOutputStream.close();
            }
            if (string2 != null) {
                fileOutputStream2 = new HtmlOutputStream(new File(String.valueOf(string2) + ".htm"));
                this.outputCdApplet((HtmlOutputStream)fileOutputStream2, string2);
                fileOutputStream2.close();
            }
            if (string != null) {
                outputStream = new BufferedOutputStream(new FileOutputStream(new File(String.valueOf(string) + ".ws")));
            }
            if (string2 != null) {
                outputStream2 = new BufferedOutputStream(new FileOutputStream(new File(String.valueOf(string2) + ".s")));
                randomAccessFile = new RandomAccessFile(String.valueOf(string2) + ".wid", "rw");
            }
            this.outputSearchDatabase(outputStream, outputStream2, randomAccessFile);
            if (outputStream != null) {
                outputStream.close();
            }
            if (outputStream2 != null) {
                outputStream2.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
                return;
            }
        }
        catch (IOException iOException) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException2) {}
            try {
                if (fileOutputStream2 != null) {
                    fileOutputStream2.close();
                }
            }
            catch (IOException iOException3) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException4) {}
            try {
                if (outputStream2 != null) {
                    outputStream2.close();
                }
            }
            catch (IOException iOException5) {}
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException6) {}
            this.println("Error: Couldn't write the applet files");
        }
    }

    private void println(String string) {
        if (this.appletOutput != null) {
            this.appletOutput.addItem(string);
            int n = this.appletOutput.getItemCount() - 1;
            this.appletOutput.makeVisible(n);
        }
        if (this.appOutput != null) {
            this.appOutput.println(string);
        }
    }

    private void sizeSearchDatabase() {
        int n;
        int n2;
        int n3 = 14;
        int n4 = this.filteredWordList.getSize();
        NameTable nameTable = new NameTable(10);
        NameTable nameTable2 = new NameTable(100);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(this.readFiles, 1.0f);
        int n5 = 0;
        while (n5 < this.readFiles) {
            n3 += this.utfLength(this.infoFiles[n5].docTitle);
            URL uRL = this.infoFiles[n5].url;
            uRL.add(nameTable, nameTable2);
            this.infoFiles[n5].url = uRL;
            hashtable.put(String.valueOf(uRL.path) + uRL.filename, new Integer(n5));
            this.infoFiles[n5].clearIndex();
            ++n5;
        }
        n4 = nameTable.getSize();
        n3 += 2;
        int n6 = 0;
        while (n6 < n4) {
            n3 += this.utfLength(nameTable.getName(n6));
            ++n6;
        }
        int n7 = 0;
        ++n4;
        while (n4 > 0) {
            ++n7;
            n4 >>>= 1;
        }
        n4 = nameTable2.getSize();
        n3 += 2;
        int n8 = 0;
        while (n8 < n4) {
            n3 += this.utfLength(nameTable2.getName(n8));
            ++n8;
        }
        int n9 = 0;
        while (n4 > 0) {
            ++n9;
            n4 >>>= 1;
        }
        int n10 = n9 + n7;
        n3 = n10 <= 8 ? (n3 += this.readFiles) : (n10 <= 16 ? (n3 += this.readFiles * 2) : (n3 += this.readFiles * 4));
        n4 = this.readFiles;
        int n11 = 0;
        while (n4 > 0) {
            ++n11;
            n4 >>>= 1;
        }
        n3 = n11 <= 8 ? ++n3 : (n3 += 2);
        n3 += (this.readFiles + 15) / 16 * 2;
        int n12 = 0;
        while (n12 < this.readFiles) {
            Vector vector = this.infoFiles[n12].links;
            n2 = vector == null ? 0 : vector.size();
            n = 0;
            int n13 = 0;
            while (n13 < n2) {
                String string = (String)vector.elementAt(n13);
                Integer n14 = (Integer)hashtable.get(string);
                if (n14 != null) {
                    ++n;
                }
                ++n13;
            }
            n3 = n11 <= 8 ? (n3 += n + 1) : (n3 += n * 2 + 2);
            ++n12;
        }
        n4 = this.filteredWordList.getSize();
        int n15 = 0;
        while (n15 < n4) {
            n3 += this.utfLength(this.filteredWordList.getString(n15));
            ++n15;
        }
        n3 += 8;
        this.cdDatabaseSize = n3 += (n4 + 15) / 16 * 8;
        n4 = this.wordFiles;
        n2 = 0;
        while (n4 > 0) {
            ++n2;
            n4 >>>= 1;
        }
        n2 += 4;
        n4 = this.filteredWordList.getSize();
        n = 0;
        while (n < n4) {
            String string = this.filteredWordList.getString(n);
            int n16 = 0;
            int n17 = 0;
            while (n17 < this.wordFiles) {
                NameDataTableEntry nameDataTableEntry = this.infoFiles[n17].wordIndex(string);
                if (nameDataTableEntry != null) {
                    ++n16;
                }
                ++n17;
            }
            n3 = n2 <= 8 ? (n3 += n16 + 1) : (n3 += n16 * 2 + 2);
            ++n;
        }
        this.webDatabaseSize = n3;
    }

    private void outputWebApplet(HtmlOutputStream htmlOutputStream, String string) throws IOException {
        Date date = new Date();
        htmlOutputStream.printString("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- Generated by the JHLSearch Compiler " + date);
        htmlOutputStream.println();
        htmlOutputStream.printString("     Web applet version -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<title>JHLSearch Web applet</title>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<div align=center>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<applet codebase=\"" + this.siteAbsPath + "classes\" archive=\"JHLSearch.zip\" code=\"jhl/applets/search/JHLSearch.class\" width=600 height=200>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<param name=cabbase value=\"JHLSearch.cab\">");
        htmlOutputStream.println();
        htmlOutputStream.printString("<param name=database value=\"" + string + "\">");
        htmlOutputStream.println();
        this.outputAppletParams(htmlOutputStream);
    }

    private void outputCdApplet(HtmlOutputStream htmlOutputStream, String string) throws IOException {
        Date date = new Date();
        htmlOutputStream.printString("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- Generated by the JHLSearch Compiler " + date);
        htmlOutputStream.println();
        htmlOutputStream.printString("     CD-ROM applet version -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<title>JHLSearch CD-ROM applet</title>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<div align=center>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<applet codebase=\"" + this.siteAbsPath + "classes\" archive=\"JHLCDS.zip\" code=\"jhl/applets/search/JHLCDSearch.class\" width=600 height=200>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<param name=cabbase value=\"JHLCDS.cab\">");
        htmlOutputStream.println();
        htmlOutputStream.printString("<param name=database value=\"" + string + "\">");
        htmlOutputStream.println();
        this.outputAppletParams(htmlOutputStream);
    }

    private void outputAppletParams(HtmlOutputStream htmlOutputStream) throws IOException {
        htmlOutputStream.printString("<!-- param name=path value=\"" + this.siteAbsPath + "\" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=query value=\"Enter query: \" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=results value=\"Results: (double click to view the document) \" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=search value=\" Search \" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=empty value=\"No matching documents found\" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=select value=\"Search by: \" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=title value=\" title \" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=headings value=\" headings \" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=lists value=\" lists \" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=body value=\" body \" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- param name=target value=\"add target frame/window here\" -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("</applet>");
        htmlOutputStream.println();
        htmlOutputStream.printString("</div>");
        htmlOutputStream.println();
    }

    private void outputSearchDatabase(OutputStream outputStream, OutputStream outputStream2, RandomAccessFile randomAccessFile) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        int n6 = 1;
        int n7 = 1;
        int n8 = this.webDatabaseSize;
        int n9 = this.cdDatabaseSize;
        while (n8 > 512) {
            ++n8;
            n8 >>>= 1;
            n6 <<= 1;
        }
        while (n9 > 512) {
            ++n9;
            n9 >>>= 1;
            n7 <<= 1;
        }
        int n10 = n8 * n6 - this.webDatabaseSize;
        int n11 = n9 * n7 - this.cdDatabaseSize;
        if (outputStream != null) {
            this.outputHeader(outputStream, n8, n6);
        }
        if (outputStream2 != null) {
            this.outputHeader(outputStream2, n9, n7);
        }
        DataOutputStream dataOutputStream = null;
        DataOutputStream dataOutputStream2 = null;
        if (outputStream != null) {
            dataOutputStream = new DataOutputStream(new LZWOutputStream(outputStream));
        }
        if (outputStream2 != null) {
            dataOutputStream2 = new DataOutputStream(new LZWOutputStream(outputStream2));
        }
        int n12 = this.filteredWordList.getSize();
        if (dataOutputStream != null) {
            dataOutputStream.writeLong(7819821248086837908L);
            dataOutputStream.writeShort(this.readFiles);
            dataOutputStream.writeShort(this.wordFiles);
            dataOutputStream.writeShort(n12);
        }
        if (dataOutputStream2 != null) {
            dataOutputStream2.writeLong(7819821248086837908L);
            randomAccessFile.writeLong(7819821248086837908L);
            dataOutputStream2.writeShort(this.readFiles);
            dataOutputStream2.writeShort(this.wordFiles);
            dataOutputStream2.writeShort(n12);
        }
        NameTable nameTable = new NameTable(10);
        NameTable nameTable2 = new NameTable(100);
        int n13 = 0;
        while (n13 < this.readFiles) {
            String string = this.infoFiles[n13].docTitle;
            if (dataOutputStream != null) {
                dataOutputStream.writeUTF(string);
            }
            if (dataOutputStream2 != null) {
                dataOutputStream2.writeUTF(string);
            }
            object = this.infoFiles[n13].url;
            ((URL)object).add(nameTable, nameTable2);
            ++n13;
        }
        n12 = nameTable.getSize();
        if (dataOutputStream != null) {
            dataOutputStream.writeShort(n12);
        }
        if (dataOutputStream2 != null) {
            dataOutputStream2.writeShort(n12);
        }
        int n14 = 0;
        while (n14 < n12) {
            object = nameTable.getName(n14);
            if (dataOutputStream != null) {
                dataOutputStream.writeUTF((String)object);
            }
            if (dataOutputStream2 != null) {
                dataOutputStream2.writeUTF((String)object);
            }
            ++n14;
        }
        int n15 = 0;
        ++n12;
        while (n12 > 0) {
            ++n15;
            n12 >>>= 1;
        }
        n12 = nameTable2.getSize();
        if (dataOutputStream != null) {
            dataOutputStream.writeShort(n12);
        }
        if (dataOutputStream2 != null) {
            dataOutputStream2.writeShort(n12);
        }
        n14 = 0;
        while (n14 < n12) {
            object = nameTable2.getName(n14);
            if (dataOutputStream != null) {
                dataOutputStream.writeUTF((String)object);
            }
            if (dataOutputStream2 != null) {
                dataOutputStream2.writeUTF((String)object);
            }
            ++n14;
        }
        int n16 = 0;
        while (n12 > 0) {
            ++n16;
            n12 >>>= 1;
        }
        int n17 = n16 + n15;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(this.readFiles, 1.0f);
        int n18 = 0;
        while (n18 < this.readFiles) {
            URL uRL = this.infoFiles[n18].url;
            hashtable.put(String.valueOf(uRL.path) + uRL.filename, new Integer(n18));
            int n19 = uRL.path.length() == 0 ? 0 : nameTable.getIndex(uRL.path) + 1;
            n19 += nameTable2.getIndex(uRL.filename) << n15;
            if (n17 <= 8) {
                if (dataOutputStream != null) {
                    dataOutputStream.writeByte((byte)n19);
                }
                if (dataOutputStream2 != null) {
                    dataOutputStream2.writeByte((byte)n19);
                }
            } else if (n17 <= 16) {
                if (dataOutputStream != null) {
                    dataOutputStream.writeChar((char)n19);
                }
                if (dataOutputStream2 != null) {
                    dataOutputStream2.writeChar((char)n19);
                }
            } else {
                if (dataOutputStream != null) {
                    dataOutputStream.writeInt(n19);
                }
                if (dataOutputStream2 != null) {
                    dataOutputStream2.writeInt(n19);
                }
            }
            this.infoFiles[n18].clearIndex();
            ++n18;
        }
        n12 = this.readFiles;
        int n20 = 0;
        while (n12 > 0) {
            ++n20;
            n12 >>>= 1;
        }
        URL uRL = this.TOC.url;
        Integer n21 = (Integer)hashtable.get(String.valueOf(uRL.path) + uRL.filename);
        int n22 = n21;
        if (n20 <= 8) {
            if (dataOutputStream != null) {
                dataOutputStream.writeByte((byte)n22);
            }
            if (dataOutputStream2 != null) {
                dataOutputStream2.writeByte((byte)n22);
            }
        } else {
            if (dataOutputStream != null) {
                dataOutputStream.writeChar((char)n22);
            }
            if (dataOutputStream2 != null) {
                dataOutputStream2.writeChar((char)n22);
            }
        }
        int n23 = 0;
        int n24 = 0;
        n14 = 0;
        while (n14 < this.readFiles) {
            n24 = (char)(n24 | (char)((this.infoFiles[n14].frameset ? 1 : 0) << n23));
            if (++n23 >= 16) {
                if (dataOutputStream != null) {
                    dataOutputStream.writeChar(n24);
                }
                if (dataOutputStream2 != null) {
                    dataOutputStream2.writeChar(n24);
                }
                n24 = 0;
                n23 = 0;
            }
            ++n14;
        }
        if (n23 > 0) {
            if (dataOutputStream != null) {
                dataOutputStream.writeChar(n24);
            }
            if (dataOutputStream2 != null) {
                dataOutputStream2.writeChar(n24);
            }
        }
        int[] nArray = new int[this.readFiles];
        int[] nArray2 = new int[this.readFiles];
        int n25 = 0;
        while (n25 < this.readFiles) {
            int n26;
            Vector vector = this.infoFiles[n25].links;
            n5 = vector == null ? 0 : vector.size();
            n4 = 0;
            n3 = 0;
            while (n3 < n5) {
                String string = (String)vector.elementAt(n3);
                n21 = (Integer)hashtable.get(string);
                if (n21 != null) {
                    nArray[n4++] = n21;
                }
                ++n3;
            }
            nArray2[0] = nArray[0];
            n2 = 1;
            while (n2 < n4) {
                int n27;
                block114: {
                    int n28 = 0;
                    n27 = 0;
                    n26 = n2;
                    int n29 = -1;
                    String string = this.infoFiles[nArray[n2]].docTitle;
                    do {
                        n27 = n26 + n29 >> 1;
                        String string2 = this.infoFiles[nArray2[n27]].docTitle;
                        n28 = string.compareTo(string2);
                        if (n28 == 0) break block114;
                        if (n28 < 0) {
                            n26 = n27;
                            continue;
                        }
                        n29 = n27;
                    } while (n29 < n26 - 1);
                    if (n28 > 0) {
                        ++n27;
                    }
                }
                if ((n = n2 - n27) > 0) {
                    System.arraycopy(nArray2, n27, nArray2, n27 + 1, n);
                }
                nArray2[n27] = nArray[n2];
                ++n2;
            }
            if (n20 <= 8) {
                if (dataOutputStream != null) {
                    dataOutputStream.writeByte((byte)n4);
                }
                if (dataOutputStream2 != null) {
                    dataOutputStream2.writeByte((byte)n4);
                }
            } else {
                if (dataOutputStream != null) {
                    dataOutputStream.writeChar((char)n4);
                }
                if (dataOutputStream2 != null) {
                    dataOutputStream2.writeChar((char)n4);
                }
            }
            n26 = 0;
            while (n26 < n4) {
                if (n20 <= 8) {
                    if (dataOutputStream != null) {
                        dataOutputStream.writeByte((byte)nArray2[n26]);
                    }
                    if (dataOutputStream2 != null) {
                        dataOutputStream2.writeByte((byte)nArray2[n26]);
                    }
                } else {
                    if (dataOutputStream != null) {
                        dataOutputStream.writeChar((char)nArray2[n26]);
                    }
                    if (dataOutputStream2 != null) {
                        dataOutputStream2.writeChar((char)nArray2[n26]);
                    }
                }
                ++n26;
            }
            ++n25;
        }
        int n30 = 0;
        n5 = 0;
        n4 = 0;
        n3 = 0;
        n12 = this.filteredWordList.getSize();
        n14 = 0;
        while (n14 < n12) {
            object = this.filteredWordList.getString(n14);
            if (dataOutputStream != null) {
                dataOutputStream.writeUTF((String)object);
            }
            if (dataOutputStream2 != null) {
                dataOutputStream2.writeUTF((String)object);
            }
            if (((n2 = this.filteredWordList.getType(n14)) & 1) != 0) {
                ++n30;
            }
            if ((n2 & 2) != 0) {
                ++n5;
            }
            if ((n2 & 4) != 0) {
                ++n4;
            }
            if ((n2 & 8) != 0) {
                ++n3;
            }
            ++n14;
        }
        if (dataOutputStream != null) {
            dataOutputStream.writeShort(n30);
            dataOutputStream.writeShort(n5);
            dataOutputStream.writeShort(n4);
            dataOutputStream.writeShort(n3);
        }
        if (dataOutputStream2 != null) {
            dataOutputStream2.writeShort(n30);
            dataOutputStream2.writeShort(n5);
            dataOutputStream2.writeShort(n4);
            dataOutputStream2.writeShort(n3);
        }
        int[] nArray3 = new int[16];
        n23 = 15;
        n14 = 0;
        while (n14 < n12) {
            n23 = n14 % 16;
            nArray3[n23] = this.filteredWordList.getType(n14);
            if (n23 >= 15) {
                long l = (long)nArray3[15] << 60;
                l += (long)nArray3[14] << 56;
                l += (long)nArray3[13] << 52;
                l += (long)nArray3[12] << 48;
                l += (long)nArray3[11] << 44;
                l += (long)nArray3[10] << 40;
                l += (long)nArray3[9] << 36;
                l += (long)nArray3[8] << 32;
                l += (long)nArray3[7] << 28;
                l += (long)nArray3[6] << 24;
                l += (long)nArray3[5] << 20;
                l += (long)nArray3[4] << 16;
                l += (long)nArray3[3] << 12;
                l += (long)nArray3[2] << 8;
                l += (long)nArray3[1] << 4;
                l += (long)nArray3[0];
                if (dataOutputStream != null) {
                    dataOutputStream.writeLong(l);
                }
                if (dataOutputStream2 != null) {
                    dataOutputStream2.writeLong(l);
                }
            }
            ++n14;
        }
        if (n23 < 15) {
            long l = 0L;
            while (n23 >= 0) {
                l <<= 4;
                l += (long)nArray3[n23--];
            }
            if (dataOutputStream != null) {
                dataOutputStream.writeLong(l);
            }
            if (dataOutputStream2 != null) {
                dataOutputStream2.writeLong(l);
            }
        }
        n12 = this.wordFiles;
        int n31 = 0;
        while (n12 > 0) {
            ++n31;
            n12 >>>= 1;
        }
        n31 += 4;
        int[] nArray4 = new int[this.wordFiles];
        int[] nArray5 = new int[this.wordFiles];
        n12 = this.filteredWordList.getSize();
        int[] nArray6 = new int[n12];
        int n32 = 0;
        if (randomAccessFile != null) {
            randomAccessFile.seek((long)n12 * 4L + 8L);
        }
        n14 = 0;
        while (n14 < n12) {
            object = this.filteredWordList.getString(n14);
            int n33 = 0;
            nArray6[n14] = n32;
            n = 0;
            while (n < this.wordFiles) {
                NameDataTableEntry nameDataTableEntry = this.infoFiles[n].wordIndex((String)object);
                if (nameDataTableEntry != null) {
                    int n34 = nameDataTableEntry.getTotal();
                    int n35 = nameDataTableEntry.getType();
                    if (n33 == 0) {
                        nArray5[0] = (n << 4) + n35;
                        nArray4[0] = n34;
                        ++n33;
                    } else {
                        int n36;
                        int n37;
                        int n38 = 0;
                        int n39 = 0;
                        int n40 = n33;
                        int n41 = -1;
                        while ((n38 = (n37 = nArray4[n39 = n40 + n41 >> 1]) - n34) != 0) {
                            if (n38 < 0) {
                                n40 = n39;
                            } else {
                                n41 = n39;
                            }
                            if (n41 < n40 - 1) continue;
                            if (n38 <= 0) break;
                            ++n39;
                            break;
                        }
                        if ((n36 = n33 - n39) > 0) {
                            System.arraycopy(nArray4, n39, nArray4, n39 + 1, n36);
                            System.arraycopy(nArray5, n39, nArray5, n39 + 1, n36);
                        }
                        nArray5[n39] = (n << 4) + n35;
                        nArray4[n39] = n34;
                        ++n33;
                    }
                }
                ++n;
            }
            if (n31 <= 8) {
                if (dataOutputStream != null) {
                    dataOutputStream.writeByte((byte)n33);
                }
            } else if (dataOutputStream != null) {
                dataOutputStream.writeChar((char)n33);
            }
            if (randomAccessFile != null) {
                randomAccessFile.writeChar((char)n33);
                n32 += 2;
            }
            n = 0;
            while (n < n33) {
                if (n31 <= 8) {
                    if (dataOutputStream != null) {
                        dataOutputStream.writeByte((byte)nArray5[n]);
                    }
                } else if (dataOutputStream != null) {
                    dataOutputStream.writeChar((char)nArray5[n]);
                }
                if (randomAccessFile != null) {
                    randomAccessFile.writeChar((char)nArray5[n]);
                    n32 += 2;
                }
                ++n;
            }
            ++n14;
        }
        if (randomAccessFile != null && dataOutputStream2 != null) {
            randomAccessFile.seek(8L);
            n14 = 0;
            while (n14 < n12) {
                randomAccessFile.writeInt(nArray6[n14]);
                ++n14;
            }
        }
        if (dataOutputStream != null) {
            while (n10-- > 0) {
                dataOutputStream.writeByte(0);
            }
            dataOutputStream.flush();
        }
        if (dataOutputStream2 != null) {
            while (n11-- > 0) {
                dataOutputStream2.writeByte(0);
            }
            dataOutputStream2.flush();
        }
    }

    private void outputHeader(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(71);
        outputStream.write(73);
        outputStream.write(70);
        outputStream.write(56);
        outputStream.write(57);
        outputStream.write(97);
        outputStream.write((byte)(n & 0xFF));
        outputStream.write((byte)(n >>> 8 & 0xFF));
        outputStream.write((byte)(n2 & 0xFF));
        outputStream.write((byte)(n2 >>> 8 & 0xFF));
        outputStream.write(-9);
        outputStream.write(0);
        outputStream.write(0);
        int n3 = 0;
        while (n3 < 256) {
            outputStream.write((byte)n3);
            outputStream.write((byte)n3);
            outputStream.write((byte)n3);
            ++n3;
        }
        outputStream.write(44);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write((byte)(n & 0xFF));
        outputStream.write((byte)(n >>> 8 & 0xFF));
        outputStream.write((byte)(n2 & 0xFF));
        outputStream.write((byte)(n2 >>> 8 & 0xFF));
        outputStream.write(7);
        outputStream.write(8);
    }

    private int utfLength(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2 + 2;
    }
}

