/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.search;

import java.awt.List;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import jhl.apps.html.Data;
import jhl.apps.html.HtmlOutputStream;
import jhl.apps.html.NameDataTable;
import jhl.apps.html.NameDataTableEntry;
import jhl.util.NameTable;

public final class IndexCompiler {
    PrintStream appOutput;
    List appletOutput;
    Data[] infoFiles;
    NameDataTable filteredWordList;
    int readFiles;
    int wordFiles;
    String relPath;
    int maxLinks;

    public IndexCompiler(PrintStream printStream, List list, int n, int n2, NameDataTable nameDataTable, Data[] dataArray, String string, int n3) {
        this.appOutput = printStream;
        this.appletOutput = list;
        this.readFiles = n;
        this.wordFiles = n2;
        this.filteredWordList = nameDataTable;
        this.infoFiles = dataArray;
        this.relPath = string;
        this.maxLinks = n3;
    }

    public void generate(String string) {
        this.println("Generating word index file");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new HtmlOutputStream(new File(string));
            this.outputIndex((HtmlOutputStream)fileOutputStream);
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException2) {}
            this.println("Error: Couldn't write the index file");
            return;
        }
    }

    private void println(String string) {
        if (this.appletOutput != null) {
            this.appletOutput.addItem(string);
            int n = this.appletOutput.getItemCount() - 1;
            this.appletOutput.makeVisible(n);
        }
        if (this.appOutput != null) {
            this.appOutput.println(string);
        }
    }

    private void outputIndex(HtmlOutputStream htmlOutputStream) throws IOException {
        char c;
        Object object;
        String[] stringArray = new String[this.wordFiles];
        boolean bl = this.relPath.endsWith("/");
        int n = this.relPath.length() - 1;
        int n2 = 0;
        while (n2 < this.wordFiles) {
            object = this.infoFiles[n2];
            String string = String.valueOf(((Data)object).url.path) + ((Data)object).url.filename;
            if (!this.relPath.equals("")) {
                string = string.startsWith("/") && bl ? String.valueOf(this.relPath.substring(0, n)) + string : (string.startsWith("/") || bl ? String.valueOf(this.relPath) + string : String.valueOf(this.relPath) + "/" + string);
            }
            stringArray[n2] = "<a href=\"" + string + "\">" + ((Data)object).docTitle + "</a>";
            ++n2;
        }
        object = new Date();
        htmlOutputStream.printString("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
        htmlOutputStream.println();
        htmlOutputStream.printString("<html>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<!-- Generated by the JHLSearch Compiler " + object + " -->");
        htmlOutputStream.println();
        htmlOutputStream.printString("<head>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<title>Word Index</title>");
        htmlOutputStream.println();
        htmlOutputStream.printString("</head>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<body>");
        htmlOutputStream.println();
        int n3 = this.filteredWordList.getSize();
        char[] cArray = new char[n3];
        char c2 = '\u0000';
        int n4 = 0;
        while (n4 < n3) {
            String string = this.filteredWordList.getString(n4);
            c = string.charAt(0);
            if (Character.isLetter(c) && (c = Character.toUpperCase(c)) != c2) {
                c2 = cArray[n4] = c;
            }
            ++n4;
        }
        htmlOutputStream.printString("<a name=\"top\"></a>");
        htmlOutputStream.println();
        htmlOutputStream.printString("<hr><div align=center>");
        htmlOutputStream.println();
        int n5 = 0;
        while (n5 < n3) {
            if (cArray[n5] != '\u0000') {
                htmlOutputStream.printString("<a href=\"#letter" + n5 + "\"><b>" + cArray[n5] + "</b></a>");
                htmlOutputStream.println();
            }
            ++n5;
        }
        htmlOutputStream.printString("</div>");
        if (cArray[0] != '\u0000') {
            htmlOutputStream.printString("<p>");
        } else {
            htmlOutputStream.printString("<hr><p>");
        }
        htmlOutputStream.println();
        c = '\u0000';
        if (cArray[0] == '\u0000') {
            htmlOutputStream.printString("<dl><dd><dl>");
            htmlOutputStream.println();
            c = '\u0001';
        }
        int[] nArray = new int[this.wordFiles];
        int[] nArray2 = new int[this.wordFiles];
        NameTable nameTable = new NameTable(this.wordFiles);
        int n6 = 0;
        while (n6 < n3) {
            int n7;
            int n8;
            int n9 = 0;
            String string = this.filteredWordList.getString(n6);
            nameTable.clear();
            int n10 = 0;
            while (n10 < this.wordFiles) {
                NameDataTableEntry nameDataTableEntry = this.infoFiles[n10].wordIndex(string);
                if (nameDataTableEntry != null) {
                    nameTable.add(nameDataTableEntry.original);
                    n8 = nameDataTableEntry.getTotal();
                    if (n9 == 0) {
                        nArray2[0] = n10;
                        nArray[0] = n8;
                        ++n9;
                    } else {
                        int n11;
                        int n12;
                        int n13 = 0;
                        int n14 = 0;
                        n7 = n9;
                        int n15 = -1;
                        while ((n13 = (n12 = nArray[n14 = n7 + n15 >> 1]) - n8) != 0) {
                            if (n13 < 0) {
                                n7 = n14;
                            } else {
                                n15 = n14;
                            }
                            if (n15 < n7 - 1) continue;
                            if (n13 <= 0) break;
                            ++n14;
                            break;
                        }
                        if ((n11 = n9 - n14) > 0) {
                            System.arraycopy(nArray, n14, nArray, n14 + 1, n11);
                            System.arraycopy(nArray2, n14, nArray2, n14 + 1, n11);
                        }
                        nArray2[n14] = n10;
                        nArray[n14] = n8;
                        ++n9;
                    }
                }
                ++n10;
            }
            int n16 = nameTable.getSize();
            if (cArray[n6] != '\u0000') {
                if (c != '\u0000') {
                    htmlOutputStream.printString("</dl></dl>");
                }
                htmlOutputStream.printString("<p><a name=\"letter" + n6 + "\"></a>");
                htmlOutputStream.printString("<hr><dl><dd><dl>");
                htmlOutputStream.println();
                c = '\u0001';
                htmlOutputStream.printString("<dt><b>" + cArray[n6] + "</b> <a href=\"#top\">index</a>");
                htmlOutputStream.println();
                htmlOutputStream.printString("</dl></dl><hr><p><dl><dd><dl>");
                htmlOutputStream.println();
            }
            htmlOutputStream.printString("<dt>");
            n8 = 0;
            while (n8 < n16 - 1) {
                htmlOutputStream.printString("<b>" + nameTable.getName(n8) + "</b>, ");
                ++n8;
            }
            htmlOutputStream.printString("<b>" + nameTable.getName(n16 - 1) + "</b>");
            htmlOutputStream.println();
            htmlOutputStream.printString("<dd>");
            n9 = Math.min(n9, this.maxLinks);
            n7 = 0;
            while (n7 < n9) {
                htmlOutputStream.printString("<dd>" + stringArray[nArray2[n7]]);
                htmlOutputStream.println();
                ++n7;
            }
            htmlOutputStream.printString("<p>");
            htmlOutputStream.println();
            ++n6;
        }
        htmlOutputStream.printString("</dl></dl>");
        htmlOutputStream.println();
    }
}

