/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.search;

import java.awt.List;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import jhl.apps.html.DependencyCompiler;
import jhl.apps.html.URL;
import jhl.apps.html.URLTokenizer;
import jhl.apps.search.WordCompiler;
import jhl.www.html.Document;
import jhl.www.html.HtmlError;
import jhl.www.html.HtmlErrorMessage;
import jhl.www.html.HtmlException;
import jhl.www.html.Parser;

public final class SearchCompiler
implements Runnable {
    public final int EXEC_COMPILER = 0;
    public final int EXEC_HTML_PARSER = 1;
    public final int EXEC_URL_PARSER = 2;
    List output;
    URLTokenizer ut;
    Parser parser;
    DependencyCompiler dc;
    WordCompiler wc;
    String dataPath;
    private String[] appArgs;
    private int app;

    public SearchCompiler(List list, String string) {
        this.output = list;
        this.dataPath = string;
        this.ut = new URLTokenizer();
        this.parser = new Parser();
        Parser parser = new Parser();
        this.dc = new DependencyCompiler(null, list, parser);
        this.wc = new WordCompiler(null, list, this.dc, parser);
        this.app = -1;
    }

    public synchronized boolean parserArgs(String[] stringArray) {
        this.app = -1;
        if (stringArray.length <= 0) {
            this.addItem("Error: No filename specified");
            return false;
        }
        if (stringArray.length > 1) {
            this.addItem("Error: Only one filename can be specified");
            return false;
        }
        stringArray[0] = this.trimQuotes(stringArray[0]);
        File file = new File(stringArray[0]);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            this.addItem("Error: Can't read " + stringArray[0]);
            return false;
        }
        this.appArgs = stringArray;
        this.app = 1;
        return true;
    }

    public synchronized boolean tokenizerArgs(String[] stringArray) {
        this.app = -1;
        if (stringArray.length <= 0) {
            this.addItem("Error: No URL specified");
            return false;
        }
        if (stringArray.length > 1) {
            this.addItem("Error: Only one URL can be specified");
            return false;
        }
        stringArray[0] = this.trimQuotes(stringArray[0]);
        this.appArgs = stringArray;
        this.app = 2;
        return true;
    }

    public synchronized boolean compilerArgs(String[] stringArray) {
        this.app = -1;
        int n = stringArray.length;
        if (n <= 0) {
            this.addItem("Error: Missing -f filename");
            return false;
        }
        String[] stringArray2 = new String[n + 2];
        stringArray2[0] = "-p";
        stringArray2[1] = this.dataPath;
        System.arraycopy(stringArray, 0, stringArray2, 2, n);
        try {
            this.wc.clear();
            if (!this.wc.parseArgs(stringArray2)) {
                return false;
            }
            if (!this.wc.checkArgs()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            this.addItem("Fatal Error: " + throwable.getMessage());
        }
        this.app = 0;
        return true;
    }

    public synchronized void run() {
        try {
            switch (this.app) {
                case 0: {
                    this.wc.run();
                    this.addItem("Done");
                    return;
                }
                case 1: {
                    this.parse(this.appArgs[0]);
                    this.addItem("Done");
                    return;
                }
                case 2: {
                    this.tokenize(this.appArgs[0]);
                    this.addItem("Done");
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                this.addItem("Fatal Error: Out of memory");
                return;
            }
            String string = throwable.getMessage();
            if (string != null) {
                this.addItem("Fatal Error: " + string);
            }
            return;
        }
    }

    private void parse(String string) {
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            char c = File.separatorChar;
            if (c != '/') {
                string2 = string2.replace(c, '/');
            }
            URL uRL = this.ut.parse("file://" + string2);
            Document document = new Document();
            HtmlError htmlError = new HtmlError();
            try {
                this.parser.parse(file, document, htmlError);
                Vector vector = htmlError.getErrors();
                if (vector != null) {
                    int n = vector.size();
                    int n2 = 0;
                    while (n2 < n) {
                        HtmlErrorMessage htmlErrorMessage = (HtmlErrorMessage)vector.elementAt(n2);
                        this.addItem(htmlErrorMessage.getError());
                        ++n2;
                    }
                    return;
                }
            }
            catch (HtmlException htmlException) {
                this.addItem("Error: " + uRL.stringize() + ": " + htmlException.getMessage());
                return;
            }
        }
        catch (IOException iOException) {
            this.addItem("Error: Can't get canonical version of " + string);
            return;
        }
    }

    public void tokenize(String string) {
        URL uRL = this.ut.parse(string);
        this.addItem("    schema: '" + uRL.schema + "'");
        this.addItem("  location: '" + uRL.location + "'");
        this.addItem("      path: '" + uRL.path + "'");
        this.addItem("  filename: '" + uRL.filename + "'");
        this.addItem("parameters: '" + uRL.params + "'");
        this.addItem("     query: '" + uRL.query + "'");
        this.addItem("  fragment: '" + uRL.fragment + "'");
    }

    private void addItem(String string) {
        this.output.addItem(string);
        int n = this.output.getItemCount() - 1;
        this.output.makeVisible(n);
    }

    private String trimQuotes(String string) {
        int n = string.length();
        if (n <= 0) {
            return string;
        }
        if (string.charAt(n - 1) == '\"') {
            string = string.substring(0, n - 1);
        }
        if (string.charAt(0) == '\"') {
            string = string.substring(1);
        }
        return string;
    }
}

