/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.search;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;

public final class SearchDatabase
implements ImageObserver,
ImageConsumer {
    public int docs;
    public int wordDocs;
    public int words;
    public int rootDoc;
    public String[] titles;
    public String[] wordTable;
    public String[] urlPaths;
    public String[] urlFilenames;
    public int[] urlIndices;
    public byte[] subTable;
    public char[] framesetFlags;
    public char[][] docLinks;
    public char[][] wordInDoc;
    static final long serialVersionUID = 7819821248086837908L;
    String dbPath;
    String dbName;
    int status = 0;
    String error;
    int pathBits;
    int width;
    byte[] pixelBuffer;
    Image dbImage;
    ImageProducer dbProducer;
    boolean widsLoaded;

    public SearchDatabase(String string) {
        char c = File.separatorChar;
        if (c != '/') {
            string = string.replace('/', c);
        }
        this.dbPath = string;
        File file = new File(String.valueOf(string) + ".ws");
        if (file.exists() && file.isFile() && file.canRead()) {
            this.widsLoaded = true;
            this.dbName = String.valueOf(string) + ".ws";
            this.dbImage = Toolkit.getDefaultToolkit().getImage(this.dbName);
            this.dbImage.getWidth(this);
            return;
        }
        file = new File(String.valueOf(string) + ".s");
        if (file.exists() && file.isFile() && file.canRead()) {
            file = new File(String.valueOf(string) + ".wid");
            if (file.exists() && file.isFile() && file.canRead()) {
                this.widsLoaded = false;
                this.dbName = String.valueOf(string) + ".s";
                this.dbImage = Toolkit.getDefaultToolkit().getImage(this.dbName);
                this.dbImage.getWidth(this);
                return;
            }
            this.status = -1;
            this.error = String.valueOf(string) + " database not found";
            return;
        }
        this.status = -1;
        this.error = String.valueOf(string) + " database not found";
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image != this.dbImage) {
            return false;
        }
        boolean bl = true;
        if ((n & 0x40) != 0) {
            this.status = -1;
            this.error = "Database " + this.dbName + " is corrupt";
            bl = false;
        }
        if ((n & 0x30) != 0) {
            this.dbProducer = this.dbImage.getSource();
            this.dbProducer.startProduction(this);
            bl = false;
        }
        return bl;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.pixelBuffer = new byte[n * n2];
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n5;
        int n8 = n2 * this.width + n;
        while (n4-- > 0) {
            System.arraycopy(byArray, n7, this.pixelBuffer, n8, n3);
            n7 += n6;
            n8 += n3;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n5;
        int n8 = n2 * this.width + n;
        while (n4-- > 0) {
            int n9 = n7;
            int n10 = n9 + n3;
            int n11 = n8;
            while (n9 < n10) {
                this.pixelBuffer[n11++] = (byte)nArray[n9++];
            }
            n7 += n6;
            n8 += this.width;
        }
    }

    public synchronized void imageComplete(int n) {
        if (n != 2 && n != 3) {
            this.status = -1;
            this.error = "Database " + this.dbName + " is corrupt";
            return;
        }
        if (n == 3) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pixelBuffer);
            try {
                this.loadExternal(byteArrayInputStream);
            }
            catch (Throwable throwable) {
                this.status = -1;
                this.error = "Couldn't unpack database " + this.dbName;
                return;
            }
            this.dbProducer.removeConsumer(this);
            this.dbProducer = null;
            this.dbImage = null;
            this.pixelBuffer = null;
            if (!this.widsLoaded) {
                try {
                    this.loadWids();
                }
                catch (Throwable throwable) {
                    this.status = -1;
                    this.error = throwable.getMessage();
                    return;
                }
            }
            this.status = 1;
            System.gc();
        }
    }

    private void loadExternal(InputStream inputStream) throws IOException {
        int n;
        int n2;
        long l;
        int n3;
        int n4;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        long l2 = dataInputStream.readLong();
        if (l2 != 7819821248086837908L) {
            this.status = -1;
            this.error = String.valueOf(this.dbName) + " is not a search file";
            return;
        }
        this.docs = dataInputStream.readShort();
        this.wordDocs = dataInputStream.readShort();
        this.words = dataInputStream.readShort();
        this.titles = new String[this.docs];
        int n5 = 0;
        while (n5 < this.docs) {
            this.titles[n5] = dataInputStream.readUTF();
            ++n5;
        }
        int n6 = dataInputStream.readShort();
        if (n6 > 0) {
            this.urlPaths = new String[n6];
            n4 = 0;
            while (n4 < n6) {
                this.urlPaths[n4] = dataInputStream.readUTF();
                ++n4;
            }
        }
        ++n6;
        this.pathBits = 0;
        while (n6 > 0) {
            ++this.pathBits;
            n6 >>>= 1;
        }
        n4 = dataInputStream.readShort();
        this.urlFilenames = new String[n4];
        int n7 = 0;
        while (n7 < n4) {
            this.urlFilenames[n7] = dataInputStream.readUTF();
            ++n7;
        }
        int n8 = 0;
        while (n4 > 0) {
            ++n8;
            n4 >>>= 1;
        }
        this.urlIndices = new int[this.docs];
        int n9 = this.pathBits + n8;
        if (n9 <= 8) {
            n3 = 0;
            while (n3 < this.docs) {
                this.urlIndices[n3] = dataInputStream.readByte() & 0xFF;
                ++n3;
            }
        } else if (n9 <= 16) {
            n3 = 0;
            while (n3 < this.docs) {
                this.urlIndices[n3] = dataInputStream.readChar();
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.docs) {
                this.urlIndices[n3] = dataInputStream.readInt();
                ++n3;
            }
        }
        n3 = 0;
        int n10 = this.docs;
        while (n10 > 0) {
            ++n3;
            n10 >>>= 1;
        }
        this.rootDoc = n3 <= 8 ? dataInputStream.readByte() & 0xFF : (int)dataInputStream.readChar();
        int n11 = (this.docs + 15) / 16;
        this.framesetFlags = new char[n11];
        int n12 = 0;
        while (n12 < n11) {
            this.framesetFlags[n12] = dataInputStream.readChar();
            ++n12;
        }
        this.docLinks = new char[this.docs][];
        this.unpack(this.docLinks, this.docs, n3, dataInputStream);
        this.wordTable = new String[this.words];
        int n13 = 0;
        while (n13 < this.words) {
            this.wordTable[n13] = dataInputStream.readUTF();
            ++n13;
        }
        this.subTable = new byte[this.words];
        int n14 = this.words - this.words % 16;
        int n15 = 0;
        while (n15 < n14) {
            l = dataInputStream.readLong();
            n2 = n15;
            while (n2 < n15 + 16) {
                n = (int)l & 0xF;
                l >>>= 4;
                this.subTable[n2] = (byte)n;
                ++n2;
            }
            n15 += 16;
        }
        if (n15 < this.words) {
            l = dataInputStream.readLong();
            n2 = n15;
            while (n2 < this.words) {
                n = (int)l & 0xF;
                l >>>= 4;
                this.subTable[n2] = (byte)n;
                ++n2;
            }
        }
        this.wordInDoc = new char[this.words][];
        if (this.widsLoaded) {
            int n16 = this.wordDocs;
            int n17 = 0;
            while (n16 > 0) {
                ++n17;
                n16 >>>= 1;
            }
            this.wordInDoc = new char[this.words][];
            this.unpack(this.wordInDoc, this.words, n17 += 4, dataInputStream);
        }
        this.status = 1;
    }

    private void unpack(char[][] cArray, int n, int n2, DataInputStream dataInputStream) throws IOException {
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 <= 8 ? dataInputStream.readByte() & 0xFF : dataInputStream.readChar();
            if (n4 > 0) {
                char[] cArray2 = new char[n4];
                cArray[n3] = cArray2;
                int n5 = 0;
                while (n5 < n4) {
                    cArray2[n5] = n2 <= 8 ? (char)(dataInputStream.readByte() & 0xFF) : dataInputStream.readChar();
                    ++n5;
                }
            }
            ++n3;
        }
    }

    private void loadWids() throws IOException {
        String string = String.valueOf(this.dbPath) + ".wid";
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        long l = randomAccessFile.readLong();
        if (l != 7819821248086837908L) {
            randomAccessFile.close();
            throw new IOException(String.valueOf(string) + " is not a search file");
        }
        int n = 0;
        while (n < this.words) {
            randomAccessFile.seek((long)n * 4L + 8L);
            long l2 = (long)randomAccessFile.readInt() + (long)this.words * 4L + 8L;
            randomAccessFile.seek(l2);
            int n2 = randomAccessFile.readChar();
            char[] cArray = new char[n2];
            int n3 = 0;
            while (n3 < n2) {
                cArray[n3] = randomAccessFile.readChar();
                ++n3;
            }
            this.wordInDoc[n] = cArray;
            ++n;
        }
    }
}

