/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.search;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class SearchEngine
implements ImageConsumer {
    public int docs;
    public int wordDocs;
    public int words;
    public int rootDoc;
    public String[] titles;
    public String[] wordTable;
    public String[] titleWordTable;
    public String[] headingWordTable;
    public String[] listWordTable;
    public String[] bodyWordTable;
    static final long serialVersionUID = 7819821248086837908L;
    int status = 0;
    String basePath;
    String widFilename;
    String[] urlPaths;
    String[] urlFilenames;
    int[] urlIndices;
    byte[] subTable;
    char[] framesetFlags;
    char[][] docLinks;
    char[][] wordInDoc;
    char[] widTable;
    static final int OR = 0;
    static final int AND = 1;
    static final int NOT = 2;
    String[] resultWords;
    int[] result;
    int validResults = 0;
    int validWords = 0;
    int pathBits;
    String dbFilename;
    int width;
    byte[] pixelBuffer;
    Image dbImage;
    ImageProducer dbProducer;
    boolean loadWids;
    String error;

    public SearchEngine(String string, String string2) throws IOException {
        Object object;
        String string3;
        this.basePath = string;
        if (this.basePath == null) {
            this.basePath = "/";
        }
        if ((string3 = string2) == null) {
            this.status = -1;
            throw new IOException("No database filepath specified");
        }
        char c = File.separatorChar;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        string3 = string3.replace('/', c);
        this.widFilename = String.valueOf(string3) + ".wid";
        try {
            object = new RandomAccessFile(this.widFilename, "r");
            long l = ((RandomAccessFile)object).readLong();
            if (l != 7819821248086837908L) {
                throw new IOException("Not a search file");
            }
            ((RandomAccessFile)object).close();
        }
        catch (Throwable throwable) {
            this.dbFilename = String.valueOf(string3) + ".ws";
            try {
                this.loadWids = true;
                this.dbImage = toolkit.getImage(this.dbFilename);
                MediaTracker mediaTracker = new MediaTracker(null);
                mediaTracker.addImage(this.dbImage, 0);
                mediaTracker.waitForID(0);
                this.dbProducer = this.dbImage.getSource();
                this.dbProducer.startProduction(this);
                return;
            }
            catch (Throwable throwable2) {
                this.status = -1;
                throw new IOException("Couldn't read database " + this.dbFilename);
            }
        }
        this.dbFilename = String.valueOf(string3) + ".s";
        try {
            this.loadWids = false;
            this.dbImage = toolkit.getImage(this.dbFilename);
            object = new MediaTracker(null);
            ((MediaTracker)object).addImage(this.dbImage, 0);
            ((MediaTracker)object).waitForID(0);
            this.dbProducer = this.dbImage.getSource();
            this.dbProducer.startProduction(this);
            return;
        }
        catch (Throwable throwable) {
            this.status = -1;
            throw new IOException("Couldn't read database " + this.dbFilename);
        }
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized String getError() {
        return this.error;
    }

    public String getWord(int n) throws ArrayIndexOutOfBoundsException {
        if (this.status <= 0 || n < 0 || n >= this.validWords) {
            throw new ArrayIndexOutOfBoundsException("Invalid index " + n);
        }
        return this.resultWords[n];
    }

    public String getResultUrl(int n) throws MalformedURLException {
        if (this.status <= 0 || n < 0 || n >= this.validResults) {
            throw new MalformedURLException("Invalid index " + n);
        }
        return this.getUrl(this.result[n]);
    }

    public String getUrl(int n) throws MalformedURLException {
        if (this.status <= 0 || n < 0 || n >= this.docs) {
            throw new MalformedURLException("Invalid index " + n);
        }
        int n2 = this.urlIndices[n];
        int n3 = n2 >>> this.pathBits;
        int n4 = n2 & (1 << this.pathBits) - 1;
        String string = n4 == 0 ? "" : this.urlPaths[--n4];
        return String.valueOf(this.basePath) + string + this.urlFilenames[n3];
    }

    public char[] getLinks(int n) {
        if (this.status <= 0 || n < 0 || n >= this.docs) {
            return null;
        }
        return this.docLinks[n];
    }

    public boolean isFrameset(int n) {
        if (this.status <= 0 || n < 0 || n >= this.docs) {
            return false;
        }
        int n2 = n / 16;
        char c = this.framesetFlags[n2];
        return (c & (n2 = 1 << n % 16)) == 1;
    }

    public String[] search(String string, int n) throws IOException {
        Object object;
        this.validWords = 0;
        this.validResults = 0;
        int n2 = 0;
        while (n2 < this.wordDocs) {
            this.result[n2] = 0;
            ++n2;
        }
        if (this.status <= 0 || string == null || string.length() == 0 || (n & 0xF) == 0) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            int n5 = "*+-|&! \t\f\n\r".indexOf(string.charAt(n4));
            if (n5 >= 0) {
                if (n4 - n3 > 0) {
                    object = string.substring(n3, n4);
                    bl = true;
                    if (n5 == 0) {
                        object = String.valueOf(object) + "*";
                        n5 = -1;
                    }
                    vector.addElement(object);
                }
                switch (n5) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        vector.addElement(new Integer(0));
                        break;
                    }
                    case 5: {
                        vector.addElement(new Integer(2));
                    }
                }
                n3 = ++n4;
                continue;
            }
            ++n4;
        }
        if (n4 - n3 > 0) {
            String string2 = string.substring(n3, n4);
            vector.addElement(string2);
            bl = true;
        }
        if (bl && vector.size() > 0) {
            String[] stringArray;
            try {
                if (!this.loadWids) {
                    object = new RandomAccessFile(this.widFilename, "r");
                    stringArray = this.doSearch((RandomAccessFile)object, vector, n);
                    ((RandomAccessFile)object).close();
                } else {
                    stringArray = this.doSearch(null, vector, n);
                }
            }
            catch (IOException iOException) {
                System.out.println("Couldn't read WID database " + this.widFilename);
                stringArray = null;
            }
            return stringArray;
        }
        return null;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.pixelBuffer = new byte[n * n2];
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n5;
        int n8 = n2 * this.width + n;
        while (n4-- > 0) {
            System.arraycopy(byArray, n7, this.pixelBuffer, n8, n3);
            n7 += n6;
            n8 += n3;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n5;
        int n8 = n2 * this.width + n;
        while (n4-- > 0) {
            int n9 = n7;
            int n10 = n9 + n3;
            int n11 = n8;
            while (n9 < n10) {
                this.pixelBuffer[n11++] = (byte)nArray[n9++];
            }
            n7 += n6;
            n8 += this.width;
        }
    }

    public synchronized void imageComplete(int n) {
        if (n != 2 && n != 3) {
            this.status = -1;
            this.error = "Database " + this.dbFilename + " is corrupt";
        }
        if (n == 3) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pixelBuffer);
            try {
                this.loadExternal(byteArrayInputStream);
            }
            catch (Throwable throwable) {
                this.status = -1;
                this.error = "Couldn't unpack database " + this.dbFilename;
            }
            this.dbProducer.removeConsumer(this);
            this.dbProducer = null;
            this.dbImage = null;
            this.pixelBuffer = null;
            System.gc();
        }
    }

    private void loadExternal(InputStream inputStream) throws IOException {
        int n;
        int n2;
        long l;
        int n3;
        int n4;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        long l2 = dataInputStream.readLong();
        if (l2 != 7819821248086837908L) {
            throw new IOException("Not a search file");
        }
        this.docs = dataInputStream.readShort();
        this.wordDocs = dataInputStream.readShort();
        this.words = dataInputStream.readShort();
        this.titles = new String[this.docs];
        int n5 = 0;
        while (n5 < this.docs) {
            this.titles[n5] = dataInputStream.readUTF();
            ++n5;
        }
        int n6 = dataInputStream.readShort();
        if (n6 > 0) {
            this.urlPaths = new String[n6];
            n4 = 0;
            while (n4 < n6) {
                this.urlPaths[n4] = dataInputStream.readUTF();
                ++n4;
            }
        }
        ++n6;
        this.pathBits = 0;
        while (n6 > 0) {
            ++this.pathBits;
            n6 >>>= 1;
        }
        n4 = dataInputStream.readShort();
        this.urlFilenames = new String[n4];
        int n7 = 0;
        while (n7 < n4) {
            this.urlFilenames[n7] = dataInputStream.readUTF();
            ++n7;
        }
        int n8 = 0;
        while (n4 > 0) {
            ++n8;
            n4 >>>= 1;
        }
        this.urlIndices = new int[this.docs];
        int n9 = this.pathBits + n8;
        if (n9 <= 8) {
            n3 = 0;
            while (n3 < this.docs) {
                this.urlIndices[n3] = dataInputStream.readByte() & 0xFF;
                ++n3;
            }
        } else if (n9 <= 16) {
            n3 = 0;
            while (n3 < this.docs) {
                this.urlIndices[n3] = dataInputStream.readChar();
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.docs) {
                this.urlIndices[n3] = dataInputStream.readInt();
                ++n3;
            }
        }
        n3 = 0;
        int n10 = this.docs;
        while (n10 > 0) {
            ++n3;
            n10 >>>= 1;
        }
        this.rootDoc = n3 <= 8 ? dataInputStream.readByte() & 0xFF : (int)dataInputStream.readChar();
        int n11 = (this.docs + 15) / 16;
        this.framesetFlags = new char[n11];
        int n12 = 0;
        while (n12 < n11) {
            this.framesetFlags[n12] = dataInputStream.readChar();
            ++n12;
        }
        this.docLinks = new char[this.docs][];
        this.unpack(this.docLinks, this.docs, n3, dataInputStream);
        this.wordTable = new String[this.words];
        int n13 = 0;
        while (n13 < this.words) {
            this.wordTable[n13] = dataInputStream.readUTF();
            ++n13;
        }
        int n14 = dataInputStream.readShort();
        int n15 = dataInputStream.readShort();
        int n16 = dataInputStream.readShort();
        int n17 = dataInputStream.readShort();
        this.titleWordTable = new String[n14 > 0 ? n14 : 1];
        this.headingWordTable = new String[n15 > 0 ? n15 : 1];
        this.listWordTable = new String[n16 > 0 ? n16 : 1];
        this.bodyWordTable = new String[n17 > 0 ? n17 : 1];
        n14 = 0;
        n15 = 0;
        n16 = 0;
        n17 = 0;
        this.subTable = new byte[this.words];
        int n18 = this.words - this.words % 16;
        int n19 = 0;
        while (n19 < n18) {
            l = dataInputStream.readLong();
            n2 = n19;
            while (n2 < n19 + 16) {
                n = (int)l & 0xF;
                l >>>= 4;
                this.subTable[n2] = (byte)n;
                if ((n & 1) == 1) {
                    this.titleWordTable[n14++] = this.wordTable[n2];
                }
                if ((n & 2) == 2) {
                    this.headingWordTable[n15++] = this.wordTable[n2];
                }
                if ((n & 4) == 4) {
                    this.listWordTable[n16++] = this.wordTable[n2];
                }
                if ((n & 8) == 8) {
                    this.bodyWordTable[n17++] = this.wordTable[n2];
                }
                ++n2;
            }
            n19 += 16;
        }
        if (n19 < this.words) {
            l = dataInputStream.readLong();
            n2 = n19;
            while (n2 < this.words) {
                n = (int)l & 0xF;
                l >>>= 4;
                this.subTable[n2] = (byte)n;
                if ((n & 1) == 1) {
                    this.titleWordTable[n14++] = this.wordTable[n2];
                }
                if ((n & 2) == 2) {
                    this.headingWordTable[n15++] = this.wordTable[n2];
                }
                if ((n & 4) == 4) {
                    this.listWordTable[n16++] = this.wordTable[n2];
                }
                if ((n & 8) == 8) {
                    this.bodyWordTable[n17++] = this.wordTable[n2];
                }
                ++n2;
            }
        }
        if (n14 == 0) {
            this.titleWordTable = null;
        }
        if (n15 == 0) {
            this.headingWordTable = null;
        }
        if (n16 == 0) {
            this.listWordTable = null;
        }
        if (n17 == 0) {
            this.bodyWordTable = null;
        }
        if (this.loadWids) {
            int n20 = this.wordDocs;
            int n21 = 0;
            while (n20 > 0) {
                ++n21;
                n20 >>>= 1;
            }
            this.wordInDoc = new char[this.words][];
            this.unpack(this.wordInDoc, this.words, n21 += 4, dataInputStream);
        } else {
            this.widTable = new char[this.wordDocs];
        }
        this.result = new int[this.wordDocs];
        this.resultWords = new String[this.words];
        this.status = 1;
    }

    private String[] doSearch(RandomAccessFile randomAccessFile, Vector vector, int n) throws IOException {
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        boolean bl2 = false;
        block5: while (enumeration.hasMoreElements()) {
            Object e;
            block6: while ((e = enumeration.nextElement()) instanceof Integer) {
                switch ((Integer)e) {
                    case 1: {
                        bl2 = true;
                        continue block5;
                    }
                    case 0: {
                        bl2 = false;
                        continue block5;
                    }
                    case 2: {
                        bl = !bl;
                        continue block5;
                    }
                    default: {
                        if (enumeration.hasMoreElements()) continue block6;
                    }
                }
            }
            if (bl2) {
                this.doAndWord(randomAccessFile, (String)e, bl, n);
            } else {
                this.doOrWord(randomAccessFile, (String)e, bl, n);
            }
            bl2 = false;
            bl = false;
        }
        return this.doList();
    }

    private String[] doList() {
        int[] nArray = new int[this.wordDocs];
        int n = 0;
        int n2 = 0;
        while (n2 < this.wordDocs) {
            if (this.result[n2] > 0) {
                int n3 = 0;
                while (n3 < n) {
                    if (this.result[nArray[n3]] < this.result[n2]) break;
                    ++n3;
                }
                System.arraycopy(nArray, n3, nArray, n3 + 1, n - n3);
                nArray[n3] = n2;
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        n2 = 0;
        while (n2 < n) {
            this.result[n2] = nArray[n2];
            stringArray[n2] = this.titles[nArray[n2]];
            ++n2;
        }
        this.validResults = n;
        return stringArray;
    }

    private void doAndWord(RandomAccessFile randomAccessFile, String string, boolean bl, int n) throws IOException {
        int[] nArray = new int[this.wordDocs];
        this.doWord(randomAccessFile, string, nArray, n);
        if (bl) {
            this.doInverse(nArray);
        }
        int n2 = 0;
        while (n2 < this.wordDocs) {
            if (this.result[n2] != 0 && nArray[n2] != 0) {
                int n3 = n2;
                this.result[n3] = this.result[n3] + nArray[n2];
            } else {
                this.result[n2] = 0;
            }
            ++n2;
        }
    }

    private void doOrWord(RandomAccessFile randomAccessFile, String string, boolean bl, int n) throws IOException {
        int[] nArray = new int[this.wordDocs];
        this.doWord(randomAccessFile, string, nArray, n);
        if (bl) {
            this.doInverse(nArray);
        }
        int n2 = 0;
        while (n2 < this.wordDocs) {
            if (this.result[n2] != 0 || nArray[n2] != 0) {
                int n3 = n2;
                this.result[n3] = this.result[n3] + nArray[n2];
            }
            ++n2;
        }
    }

    private void doInverse(int[] nArray) {
        int n = 0;
        while (n < this.wordDocs) {
            nArray[n] = nArray[n] != 0 ? 0 : this.wordDocs - n + 1;
            ++n;
        }
    }

    private void doWord(RandomAccessFile randomAccessFile, String string, int[] nArray, int n) throws IOException {
        String string2 = string.toLowerCase();
        int n2 = 0;
        while (n2 < this.wordDocs) {
            nArray[n2] = 0;
            ++n2;
        }
        if (string.endsWith("*")) {
            int n3;
            String string3;
            if (string.length() == 1) {
                return;
            }
            int n4 = (string2 = string2.substring(0, (string = string.substring(0, string.length() - 1)).length() - 1)).compareTo(string3 = this.wordTable[n3 = this.findWord(string2)]);
            if (n4 != 0 && !string3.startsWith(string2)) {
                if (n4 < 0 && n3 > 0) {
                    string3 = this.wordTable[--n3];
                } else if (n4 > 0 && n3 < this.words - 1) {
                    string3 = this.wordTable[++n3];
                }
            }
            while (string3.startsWith(string2) && n3 > 0) {
                string3 = this.wordTable[--n3];
            }
            if (!string3.startsWith(string2)) {
                string3 = this.wordTable[++n3];
            }
            while (string3.startsWith(string2)) {
                String string4 = String.valueOf(string) + string3.substring(string.length());
                this.resultWords[this.validWords++] = string4;
                this.addWord(randomAccessFile, n3, nArray, n);
                if (++n3 >= this.words) break;
                string3 = this.wordTable[n3];
            }
            return;
        }
        int n5 = this.findWord(string2);
        String string5 = this.wordTable[n5];
        if (string5.equals(string2)) {
            this.resultWords[this.validWords++] = string;
            this.addWord(randomAccessFile, n5, nArray, n);
        }
    }

    private void addWord(RandomAccessFile randomAccessFile, int n, int[] nArray, int n2) throws IOException {
        char[] cArray;
        int n3;
        int n4;
        if (!this.loadWids) {
            randomAccessFile.seek((long)n * 4L + 8L);
            long l = (long)randomAccessFile.readInt() + (long)this.words * 4L + 8L;
            randomAccessFile.seek(l);
            n4 = randomAccessFile.readChar();
            n3 = 0;
            while (n3 < n4) {
                this.widTable[n3] = randomAccessFile.readChar();
                ++n3;
            }
            cArray = this.widTable;
        } else {
            cArray = this.wordInDoc[n];
            n4 = cArray.length;
        }
        int n5 = this.wordDocs + 1;
        int n6 = 0;
        while (n6 < n4) {
            n3 = cArray[n6] & 0xF;
            int n7 = cArray[n6] >>> 4;
            if ((n3 & n2) != 0) {
                int n8 = n7;
                nArray[n8] = nArray[n8] + n5--;
            }
            ++n6;
        }
    }

    private int findWord(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = this.words;
        int n4 = -1;
        do {
            String string2;
            if ((n = string.compareTo(string2 = this.wordTable[n2 = n3 + n4 >> 1])) == 0) {
                return n2;
            }
            if (n < 0) {
                n3 = n2;
                continue;
            }
            n4 = n2;
        } while (n4 < n3 - 1);
        return n2;
    }

    private void unpack(char[][] cArray, int n, int n2, DataInputStream dataInputStream) throws IOException {
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 <= 8 ? dataInputStream.readByte() & 0xFF : dataInputStream.readChar();
            if (n4 > 0) {
                char[] cArray2 = new char[n4];
                cArray[n3] = cArray2;
                int n5 = 0;
                while (n5 < n4) {
                    cArray2[n5] = n2 <= 8 ? (char)(dataInputStream.readByte() & 0xFF) : dataInputStream.readChar();
                    ++n5;
                }
            }
            ++n3;
        }
    }
}

