/*
 * Decompiled with CFR 0.152.
 */
package jhl.apps.search;

import java.awt.List;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import jhl.apps.html.Data;
import jhl.apps.html.DependencyCompiler;
import jhl.apps.html.NameDataTable;
import jhl.apps.html.URL;
import jhl.apps.search.AppletCompiler;
import jhl.apps.search.IndexCompiler;
import jhl.apps.search.WordLister;
import jhl.io.ResponseReader;
import jhl.util.NameTable;
import jhl.util.StringFilter;
import jhl.www.html.FilterParserObserver;
import jhl.www.html.HtmlError;
import jhl.www.html.HtmlErrorMessage;
import jhl.www.html.HtmlException;
import jhl.www.html.Parser;
import jhl.www.html.WordDocument;

public final class WordCompiler
implements Observer,
Runnable {
    String argUrl;
    String argLocal;
    String argDataPath;
    String argUrlsFile;
    NameTable argUrlExclusions;
    boolean argSilent;
    boolean argNoTitles;
    boolean argNoHeaders;
    boolean argNoLists;
    boolean argNoBody;
    String argWordsFile;
    String argIndexFile;
    String argIndexRelPath;
    int argIndexMaxLinks;
    String argWebFile;
    String argCdFile;
    NameTable argWordUrlExclusions;
    NameTable argMapUrlExclusions;
    NameTable argWordExclusions;
    boolean argExcludeNumbers;
    PrintStream appOutput;
    List appletOutput;
    FilterParserObserver parser;
    DependencyCompiler lister;
    char fsChar;
    NameDataTable filteredWordList;
    Data[] infoFiles;
    int readFiles;
    int wordFiles;
    StringFilter[] wordUrlExclude;
    StringFilter[] wordUrlPathExclude;
    StringFilter[] mapUrlExclude;
    StringFilter[] mapUrlPathExclude;
    StringFilter[] wordExclude;
    int wordFilters;
    NameTable wordExcludeTable;
    int groupMask;
    NameTable infoURLsTable;
    Vector infoURLs;
    Data TOC;

    public WordCompiler(PrintStream printStream, List list, DependencyCompiler dependencyCompiler, Parser parser) {
        this.appOutput = printStream;
        this.appletOutput = list;
        this.parser = new FilterParserObserver(new Parser());
        Parser parser2 = parser == null ? new Parser() : parser;
        this.lister = dependencyCompiler == null ? new DependencyCompiler(printStream, list, parser2) : dependencyCompiler;
        this.lister.addObserver(this);
        this.fsChar = File.separatorChar;
    }

    public static void main(String[] stringArray) {
        try {
            WordCompiler wordCompiler = new WordCompiler(System.out, null, null, null);
            wordCompiler.clear();
            if (wordCompiler.parseArgs(stringArray)) {
                if (wordCompiler.checkArgs()) {
                    wordCompiler.run();
                    return;
                }
                wordCompiler.showUsage();
                return;
            }
            wordCompiler.showUsage();
            return;
        }
        catch (Throwable throwable) {
            System.out.println("Fatal Error: " + throwable.getMessage());
            throwable.printStackTrace(System.out);
            return;
        }
    }

    public synchronized void clear() {
        this.argUrlsFile = null;
        this.argDataPath = null;
        this.argLocal = null;
        this.argUrl = null;
        this.argCdFile = null;
        this.argWebFile = null;
        this.argIndexFile = null;
        this.argWordsFile = null;
        this.argIndexRelPath = "";
        this.argUrlExclusions = new NameTable();
        this.argWordUrlExclusions = new NameTable();
        this.argMapUrlExclusions = new NameTable();
        this.argWordExclusions = new NameTable();
        this.argNoBody = false;
        this.argNoLists = false;
        this.argNoHeaders = false;
        this.argNoTitles = false;
        this.argSilent = false;
        this.argExcludeNumbers = false;
        this.argIndexMaxLinks = 10;
        this.lister.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            block49: {
                String string;
                if (!stringArray[n].startsWith("-")) {
                    this.println("Unknown argument '" + stringArray[n] + "'");
                    return false;
                }
                if (stringArray[n].equals("-f")) {
                    this.argLocal = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-gc")) {
                    this.argCdFile = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-gi")) {
                    this.argIndexFile = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-gw")) {
                    this.argWebFile = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-ir")) {
                    this.argIndexRelPath = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-im")) {
                    string = this.trimQuotes(stringArray[++n]);
                    try {
                        this.argIndexMaxLinks = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.println("Error: Bad numeric value -im '" + string + "'");
                        return false;
                    }
                    if (this.argIndexMaxLinks < 0) {
                        this.println("Error: Illegal numeric value -im '" + string + "'");
                        return false;
                    }
                } else if (stringArray[n].equals("-lu")) {
                    this.argUrlsFile = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-lw")) {
                    this.argWordsFile = this.trimQuotes(stringArray[++n]);
                } else if (stringArray[n].equals("-nb")) {
                    this.argNoBody = true;
                } else if (stringArray[n].equals("-nh")) {
                    this.argNoHeaders = true;
                } else if (stringArray[n].equals("-nl")) {
                    this.argNoLists = true;
                } else if (stringArray[n].equals("-nt")) {
                    this.argNoTitles = true;
                } else if (stringArray[n].equals("-p")) {
                    this.argDataPath = this.trimQuotes(stringArray[++n]);
                } else {
                    if (stringArray[n].equals("-r")) {
                        string = this.trimQuotes(stringArray[++n]);
                        try {
                            ResponseReader responseReader = new ResponseReader(string);
                            String[] stringArray2 = responseReader.readAll();
                            responseReader.close();
                            responseReader = null;
                            if (stringArray2 != null && !this.parseArgs(stringArray2)) {
                                return false;
                            }
                            break block49;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.println("Error: Couldn't find response file " + string);
                            return false;
                        }
                        catch (IOException iOException) {
                            this.println("Error: Couldn't read response file " + string);
                            return false;
                        }
                    }
                    if (stringArray[n].equals("-s")) {
                        this.argSilent = true;
                    } else if (stringArray[n].equals("-u")) {
                        this.argUrl = this.trimQuotes(stringArray[++n]);
                    } else if (stringArray[n].equals("-xmu")) {
                        this.argMapUrlExclusions.add(this.trimQuotes(stringArray[++n]));
                    } else if (stringArray[n].equals("-xn")) {
                        this.argExcludeNumbers = true;
                    } else if (stringArray[n].equals("-xu")) {
                        string = this.trimQuotes(stringArray[++n]);
                        this.argUrlExclusions.add(string);
                        this.argWordUrlExclusions.add(string);
                    } else if (stringArray[n].equals("-xwf")) {
                        this.argWordExclusions.add(this.trimQuotes(stringArray[++n]));
                    } else {
                        if (!stringArray[n].equals("-xwu")) {
                            this.println("Unknown argument '" + stringArray[n] + "'");
                            return false;
                        }
                        this.argWordUrlExclusions.add(this.trimQuotes(stringArray[++n]));
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public synchronized boolean checkArgs() {
        int n;
        String string;
        StringFilter stringFilter;
        Object object;
        int n2;
        int n3;
        File file;
        if (this.argLocal == null) {
            this.println("Error: Missing -f filename");
            return false;
        }
        if (this.argNoTitles && this.argNoHeaders && this.argNoLists && this.argNoBody) {
            this.println("Error: nothing to do: -nb -nh -nl -nt");
            return false;
        }
        if (this.argDataPath == null) {
            this.argDataPath = "data" + this.fsChar;
        }
        String string2 = this.argDataPath;
        if (this.fsChar != '/') {
            this.argDataPath = this.argDataPath.replace('/', this.fsChar);
        }
        if (!this.argDataPath.endsWith(File.separator)) {
            this.argDataPath = String.valueOf(this.argDataPath) + this.fsChar;
        }
        try {
            file = new File(this.argDataPath);
            this.argDataPath = file.getCanonicalPath();
            if (!this.argDataPath.endsWith(File.separator)) {
                this.argDataPath = String.valueOf(this.argDataPath) + this.fsChar;
            }
        }
        catch (IOException iOException) {
            this.println("Error: couldn't create canonical filepath for " + string2);
            return false;
        }
        file = new File(this.argDataPath);
        if (!(!file.exists() || file.isDirectory() && file.canRead())) {
            this.println("Error: filepath " + this.argDataPath + " is not a readable directory");
            return false;
        }
        file = new File(this.argLocal);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            this.println("Error: Can't read " + this.argLocal);
            return false;
        }
        boolean bl = false;
        if (this.argWebFile != null || this.argCdFile != null || this.argWordsFile != null || this.argIndexFile != null) {
            bl = true;
        }
        int n4 = 4;
        if (bl) {
            ++n4;
        }
        if (this.argIndexFile != null) {
            ++n4;
        }
        if (this.argUrl != null) {
            n4 += 2;
        }
        int n5 = this.argUrlExclusions == null ? 0 : this.argUrlExclusions.getSize();
        n4 += n5 * 2;
        if (this.argUrlsFile != null) {
            n4 += 2;
        }
        if (this.argSilent) {
            ++n4;
        }
        String[] stringArray = new String[n4];
        stringArray[0] = "-f";
        stringArray[1] = this.argLocal;
        stringArray[2] = "-p";
        stringArray[3] = string2;
        n4 = 4;
        if (bl) {
            stringArray[n4++] = "-l";
        }
        if (this.argIndexFile != null) {
            stringArray[n4++] = "-c";
        }
        if (this.argUrl != null) {
            stringArray[n4++] = "-u";
            stringArray[n4++] = this.argUrl;
        }
        int n6 = n5 = this.argUrlExclusions == null ? 0 : this.argUrlExclusions.getSize();
        if (n5 > 0) {
            n3 = 0;
            while (n3 < n5) {
                stringArray[n4++] = "-xu";
                stringArray[n4++] = this.argUrlExclusions.getName(n3);
                ++n3;
            }
        }
        if (this.argUrlsFile != null) {
            stringArray[n4++] = "-lu";
            stringArray[n4++] = this.argUrlsFile;
        }
        if (this.argSilent) {
            stringArray[n4++] = "-s";
        }
        if (this.lister.parseArgs(stringArray)) {
            if (!this.lister.checkArgs()) {
                return false;
            }
        } else {
            return false;
        }
        int n7 = n5 = this.argWordExclusions == null ? 0 : this.argWordExclusions.getSize();
        if (n5 > 0) {
            n3 = 0;
            while (n3 < n5) {
                String string3 = this.argWordExclusions.getName(n3);
                file = new File(string3);
                if (!(file.exists() && file.isFile() && file.canRead())) {
                    this.println("Error: Can't read -xwf " + string3);
                    return false;
                }
                ++n3;
            }
        }
        int n8 = n5 = this.argWordUrlExclusions == null ? 0 : this.argWordUrlExclusions.getSize();
        if (n5 > 0) {
            this.wordUrlExclude = new StringFilter[n5];
            this.wordUrlPathExclude = new StringFilter[n5];
            n3 = 0;
            int n9 = 0;
            n2 = 0;
            while (n2 < n5) {
                object = this.argWordUrlExclusions.getName(n2);
                stringFilter = new StringFilter((String)object);
                string = stringFilter.getComp();
                if (string.endsWith("//")) {
                    n = stringFilter.getMode();
                    stringFilter.setComp(string.substring(0, string.length() - 1));
                    if (n == 1) {
                        n = 0;
                    }
                    stringFilter.setMode(n | 2);
                    this.wordUrlPathExclude[n9++] = stringFilter;
                } else {
                    this.wordUrlExclude[n3++] = stringFilter;
                }
                ++n2;
            }
            if (n9 == 0) {
                this.wordUrlPathExclude = null;
            } else if (n9 < n5) {
                object = new StringFilter[n9];
                System.arraycopy(this.wordUrlPathExclude, 0, object, 0, n9);
                this.wordUrlPathExclude = object;
            }
            if (n3 == 0) {
                this.wordUrlExclude = null;
            } else if (n3 < n5) {
                object = new StringFilter[n3];
                System.arraycopy(this.wordUrlExclude, 0, object, 0, n3);
                this.wordUrlExclude = object;
            }
        }
        int n10 = n5 = this.argMapUrlExclusions == null ? 0 : this.argMapUrlExclusions.getSize();
        if (n5 > 0) {
            this.mapUrlExclude = new StringFilter[n5];
            this.mapUrlPathExclude = new StringFilter[n5];
            n3 = 0;
            int n11 = 0;
            n2 = 0;
            while (n2 < n5) {
                object = this.argMapUrlExclusions.getName(n2);
                stringFilter = new StringFilter((String)object);
                string = stringFilter.getComp();
                if (string.endsWith("//")) {
                    n = stringFilter.getMode();
                    stringFilter.setComp(string.substring(0, string.length() - 1));
                    if (n == 1) {
                        n = 0;
                    }
                    stringFilter.setMode(n | 2);
                    this.mapUrlPathExclude[n11++] = stringFilter;
                } else {
                    this.mapUrlExclude[n3++] = stringFilter;
                }
                ++n2;
            }
            if (n11 == 0) {
                this.mapUrlPathExclude = null;
            } else if (n11 < n5) {
                object = new StringFilter[n11];
                System.arraycopy(this.mapUrlPathExclude, 0, object, 0, n11);
                this.mapUrlPathExclude = object;
            }
            if (n3 == 0) {
                this.mapUrlExclude = null;
            } else if (n3 < n5) {
                object = new StringFilter[n3];
                System.arraycopy(this.mapUrlExclude, 0, object, 0, n3);
                this.mapUrlExclude = object;
            }
        }
        this.infoFiles = new Data[10];
        this.wordFiles = 0;
        this.readFiles = 0;
        return true;
    }

    public synchronized void showUsage() {
        this.println("Usage:   java jhl.apps.search.WordCompiler -f filename -p filepath [options]");
        this.println("         -f filename    the root HTML filename (required)");
        this.println("Options: -gw filename   generate Web applet files");
        this.println("         -gc filename   generate CD-ROM applet files");
        this.println("         -gi filename   generate word index file");
        this.println("         -ir relpath    word index file link relative path");
        this.println("         -im number     maximum number of links per word index");
        this.println("         -lu filename   list dependency URLs to filename");
        this.println("         -lw filename   list words to filename");
        this.println("         -nt            exclude <TITLE> tagged words from database");
        this.println("         -nh            exclude <H1..H6><CAPTION> tagged words from database");
        this.println("         -nl            exclude <DT><LI> tagged words from database");
        this.println("         -nb            exclude <BODY> tagged words from database");
        this.println("         -p filepath    intermediate data filepath");
        this.println("         -r filename    execute response file");
        this.println("         -s             suppress HTML syntax error reporting");
        this.println("         -u url         the WWW URL equivalent of the root HTML document");
        this.println("         -xmu url       exclude URL from map list");
        this.println("         -xn            exclude numbers from word list");
        this.println("         -xu url        exclude URL from dependancy list");
        this.println("         -xwf filename  word exclusion HTML filename");
        this.println("         -xwu url       exclude URL from word list");
    }

    public synchronized void run() {
        Object object;
        int n;
        this.println("Intermediate data: file://" + this.argDataPath);
        NameDataTable nameDataTable = new NameDataTable();
        int n2 = n = this.argWordExclusions == null ? 0 : this.argWordExclusions.getSize();
        if (n > 0) {
            WordDocument wordDocument;
            int n3 = 0;
            while (n3 < n) {
                Object object2;
                String string = this.argWordExclusions.getName(n3);
                File file = new File(string);
                wordDocument = new WordDocument();
                object = new HtmlError();
                try {
                    this.println("file://" + file.getCanonicalPath());
                    this.parser.parse(file, wordDocument, (HtmlError)object);
                    object2 = ((HtmlError)object).getErrors();
                    if (object2 != null) {
                        int n4 = ((Vector)object2).size();
                        int n5 = 0;
                        while (n5 < n4) {
                            HtmlErrorMessage htmlErrorMessage = (HtmlErrorMessage)((Vector)object2).elementAt(n5);
                            this.println(htmlErrorMessage.getError());
                            ++n5;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.println("Error: Can't get canonical version of -xwf " + string);
                    return;
                }
                catch (HtmlException htmlException) {
                    this.println("Error: " + string + ": " + htmlException.getMessage());
                    return;
                }
                object2 = new NameDataTable(wordDocument, false);
                nameDataTable.add((NameDataTable)object2);
                ++n3;
            }
            wordDocument = null;
            object = null;
        }
        n = nameDataTable.getSize();
        this.wordFilters = 0;
        if (n > 0) {
            this.wordExclude = new StringFilter[n];
            int n6 = 0;
            while (n6 < n) {
                object = nameDataTable.getString(n6);
                StringFilter stringFilter = new StringFilter((String)object);
                if (stringFilter.getMode() != 0) {
                    if (stringFilter.getMode() == 1) {
                        if (this.wordExcludeTable == null) {
                            this.wordExcludeTable = new NameTable(50);
                        }
                        this.wordExcludeTable.add((String)object);
                    } else {
                        this.wordExclude[this.wordFilters++] = stringFilter;
                    }
                }
                ++n6;
            }
            if (this.wordFilters == 0) {
                this.wordExclude = null;
            } else if (this.wordFilters < n) {
                object = new StringFilter[this.wordFilters];
                System.arraycopy(this.wordExclude, 0, object, 0, this.wordFilters);
                this.wordExclude = object;
            }
        }
        this.groupMask = 0;
        this.groupMask |= this.argNoTitles ? 0 : 1;
        this.groupMask |= this.argNoHeaders ? 0 : 2;
        this.groupMask |= this.argNoLists ? 0 : 4;
        this.groupMask |= this.argNoBody ? 0 : 8;
        this.parser = null;
        this.argUrlExclusions = null;
        this.argWordUrlExclusions = null;
        this.argMapUrlExclusions = null;
        this.argWordExclusions = null;
        System.gc();
        this.filteredWordList = new NameDataTable();
        this.infoURLsTable = new NameTable(10);
        this.infoURLs = null;
        this.lister.run();
        this.wordUrlExclude = null;
        this.wordUrlPathExclude = null;
        this.mapUrlExclude = null;
        this.mapUrlPathExclude = null;
        this.wordExclude = null;
        System.gc();
        int n7 = this.filteredWordList.getSize();
        if (this.argWordsFile != null && n7 > 0) {
            object = new WordLister(this.appOutput, this.appletOutput, this.filteredWordList);
            ((WordLister)object).generate(this.argWordsFile);
        }
        System.gc();
        this.orderSearchDatabase();
        if (this.argIndexFile != null && n7 > 0 && this.readFiles > 0) {
            object = new IndexCompiler(this.appOutput, this.appletOutput, this.readFiles, this.wordFiles, this.filteredWordList, this.infoFiles, this.argIndexRelPath, this.argIndexMaxLinks);
            ((IndexCompiler)object).generate(this.argIndexFile);
        }
        System.gc();
        if ((this.argWebFile != null || this.argCdFile != null) && this.readFiles > 0) {
            if (this.readFiles >= 4096) {
                this.println("Error: Too many files for the search applet database");
                return;
            }
            object = new AppletCompiler(this.appOutput, this.appletOutput, this.readFiles, this.wordFiles, this.filteredWordList, this.infoFiles, this.TOC, this.lister.siteAbsPath);
            ((AppletCompiler)object).generate(this.argWebFile, this.argCdFile);
        }
        System.gc();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Data) {
            this.addInfo((Data)object);
            return;
        }
        if (object instanceof URL) {
            this.addUrl((URL)object);
        }
    }

    protected void addInfo(Data data) {
        data.links = this.infoURLs;
        if (!data.frameset && !this.isWordExcluded(data.url.stringize())) {
            data.wordTable.removeGroup(this.groupMask);
            this.excludeWords(data.wordTable);
            this.filteredWordList.add(data.wordTable);
            data.count = data.wordTable.getSize();
            this.ensureCapacity();
            this.infoFiles[this.readFiles++] = data;
            if (data.count > 0) {
                ++this.wordFiles;
            }
            data.hrefUrls = null;
            data.nonHrefUrls = null;
        } else if (this.readFiles == 0 || !this.isMapExcluded(data.url.stringize())) {
            data.count = 0;
            this.ensureCapacity();
            this.infoFiles[this.readFiles++] = data;
            data.wordTable = null;
            data.hrefUrls = null;
            data.nonHrefUrls = null;
        }
        this.infoURLs = null;
        this.infoURLsTable.clear();
        System.gc();
    }

    protected void addUrl(URL uRL) {
        URL uRL2 = this.convertUrl(uRL);
        String string = String.valueOf(uRL2.path) + uRL2.filename;
        if (!this.infoURLsTable.inTable(string)) {
            if (this.infoURLs == null) {
                this.infoURLs = new Vector();
            }
            this.infoURLs.addElement(string);
            this.infoURLsTable.add(string);
        }
    }

    private void println(String string) {
        if (this.appletOutput != null) {
            this.appletOutput.addItem(string);
            int n = this.appletOutput.getItemCount() - 1;
            this.appletOutput.makeVisible(n);
        }
        if (this.appOutput != null) {
            this.appOutput.println(string);
        }
    }

    private void ensureCapacity() {
        if (this.readFiles >= this.infoFiles.length) {
            int n = this.infoFiles.length + 10;
            Data[] dataArray = new Data[n];
            System.arraycopy(this.infoFiles, 0, dataArray, 0, this.readFiles);
            this.infoFiles = dataArray;
        }
    }

    private boolean isWordExcluded(String string) {
        int n;
        int n2;
        if (this.wordUrlExclude != null) {
            n2 = this.wordUrlExclude.length;
            n = 0;
            while (n < n2) {
                if (this.wordUrlExclude[n].isValid(string)) {
                    return true;
                }
                ++n;
            }
        }
        if (this.wordUrlPathExclude == null) {
            return false;
        }
        n2 = this.wordUrlPathExclude.length;
        n = 0;
        while (n < n2) {
            StringFilter stringFilter = this.wordUrlPathExclude[n];
            if (stringFilter.isValid(string)) {
                String string2 = stringFilter.getComp();
                int n3 = string2.length();
                int n4 = string.indexOf(string2);
                if (string.indexOf(47, n4 + n3) < 0) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean isMapExcluded(String string) {
        int n;
        int n2;
        if (this.mapUrlExclude != null) {
            n2 = this.mapUrlExclude.length;
            n = 0;
            while (n < n2) {
                if (this.mapUrlExclude[n].isValid(string)) {
                    return true;
                }
                ++n;
            }
        }
        if (this.mapUrlPathExclude == null) {
            return false;
        }
        n2 = this.mapUrlPathExclude.length;
        n = 0;
        while (n < n2) {
            StringFilter stringFilter = this.mapUrlPathExclude[n];
            if (stringFilter.isValid(string)) {
                String string2 = stringFilter.getComp();
                int n3 = string2.length();
                int n4 = string.indexOf(string2);
                if (string.indexOf(47, n4 + n3) < 0) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private void excludeWords(NameDataTable nameDataTable) {
        if (!this.argExcludeNumbers && this.wordFilters == 0 && this.wordExcludeTable == null) {
            return;
        }
        int n = nameDataTable.getSize();
        if (n > 0 && this.argExcludeNumbers) {
            nameDataTable.removeDigits();
        }
        if ((n = nameDataTable.getSize()) > 0 && this.wordFilters > 0) {
            nameDataTable.remove(this.wordExclude);
        }
        if ((n = nameDataTable.getSize()) > 0 && this.wordExcludeTable != null) {
            nameDataTable.remove(this.wordExcludeTable);
        }
    }

    private void orderSearchDatabase() {
        if (this.readFiles <= 0) {
            return;
        }
        Data[] dataArray = new Data[this.readFiles];
        int n = 1;
        this.TOC = dataArray[0] = this.infoFiles[0];
        this.TOC.url = this.convertUrl(this.TOC.url);
        int n2 = 1;
        while (n2 < this.readFiles) {
            int n3;
            int n4;
            block6: {
                this.infoFiles[n2].url = this.convertUrl(this.infoFiles[n2].url);
                int n5 = this.infoFiles[n2].count;
                n4 = 0;
                int n6 = 0;
                int n7 = n;
                int n8 = -1;
                do {
                    n4 = n7 + n8 >> 1;
                    int n9 = dataArray[n4].count;
                    n6 = n9 - n5;
                    if (n6 == 0) break block6;
                    if (n6 < 0) {
                        n7 = n4;
                        continue;
                    }
                    n8 = n4;
                } while (n8 < n7 - 1);
                if (n6 > 0) {
                    ++n4;
                }
            }
            if ((n3 = n - n4) > 0) {
                System.arraycopy(dataArray, n4, dataArray, n4 + 1, n3);
            }
            dataArray[n4] = this.infoFiles[n2];
            ++n;
            ++n2;
        }
        this.infoFiles = dataArray;
        System.gc();
    }

    private URL convertUrl(URL uRL) {
        URL uRL2 = new URL();
        uRL2.schema = uRL.schema;
        uRL2.location = uRL.location;
        uRL2.path = uRL.path;
        uRL2.filename = uRL.filename;
        uRL2.path = uRL2.path.length() == this.lister.rootAbsPath.length() ? "" : uRL2.path.substring(this.lister.rootAbsPath.length());
        return uRL2;
    }

    private String trimQuotes(String string) {
        int n = string.length();
        if (n <= 0) {
            return string;
        }
        if (string.charAt(n - 1) == '\"') {
            string = string.substring(0, n - 1);
        }
        if (string.charAt(0) == '\"') {
            string = string.substring(1);
        }
        return string;
    }
}

