/*
 * Decompiled with CFR 0.152.
 */
package jhl.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class LZWOutputStream
extends FilterOutputStream {
    private static final int TABLESIZE = 8192;
    private static final int TABLEBITMASK = 8191;
    private static final int MINBITS = 8;
    private static final int MAXBITS = 13;
    private static final int MAXCODE = 4095;
    private static final long EMPTY = 0xFFFFFF000L;
    private static final int BUFFERSIZE = 255;
    protected long[] codeTable;
    protected int clearCode = 256;
    protected int eofCode;
    protected int currentLzwCode;
    protected int currentLzwBits = 9;
    protected int maxCode;
    protected int currentBitField = 0;
    protected int compressedBits = 0;
    protected int bitBucket = 0;
    protected byte[] lzwBuffer = new byte[256];
    protected int lzwBuffered = 0;
    protected boolean started;
    byte[] singleByte;

    public LZWOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.codeTable = new long[8192];
        this.eofCode = this.clearCode + 1;
        this.currentLzwCode = this.eofCode + 1;
        this.maxCode = 1 << this.currentLzwBits;
        this.singleByte = new byte[1];
    }

    public void write(int n) throws IOException {
        this.singleByte[0] = (byte)n;
        this.encode(this.singleByte, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.encode(byArray, n, n2);
    }

    public void flush() throws IOException {
        if (this.started) {
            this.lzwEncode(this.currentBitField);
            this.lzwEncode(this.eofCode);
            while (this.compressedBits > 0) {
                if (this.lzwBuffered >= 255) {
                    this.out.write((byte)this.lzwBuffered);
                    this.out.write(this.lzwBuffer, 0, this.lzwBuffered);
                    this.lzwBuffered = 0;
                }
                this.lzwBuffer[this.lzwBuffered++] = (byte)this.bitBucket;
                this.bitBucket >>>= 8;
                this.compressedBits -= 8;
            }
            this.compressedBits = 0;
            if (this.lzwBuffered > 0) {
                this.out.write((byte)this.lzwBuffered);
                this.out.write(this.lzwBuffer, 0, this.lzwBuffered);
            }
            this.lzwBuffered = 0;
            this.out.write(0);
            this.started = false;
        }
        this.out.flush();
    }

    private void encode(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        int n3 = n + n2;
        if (!this.started) {
            this.clearTable();
            this.currentBitField = byArray[n++] & 0xFF;
            this.started = true;
        }
        while (n < n3) {
            int n4;
            int n5;
            int n6;
            if ((n6 = this.getTableKey(n5 = (this.currentBitField << 8) + (n4 = byArray[n++] & 0xFF))) >= 0) {
                this.currentBitField = n6;
                continue;
            }
            this.lzwEncode(this.currentBitField);
            this.currentBitField = n4;
            if (this.currentLzwCode >= 4095) {
                this.clearTable();
                continue;
            }
            this.addTableKey(n5);
        }
    }

    private int makeKey(int n) {
        return (n >>> 12 ^ n) & 0x1FFF;
    }

    private void addTableKey(int n) {
        int n2 = (n >>> 12 ^ n) & 0x1FFF;
        while (this.codeTable[n2] != 0xFFFFFF000L) {
            ++n2;
            n2 &= 0x1FFF;
        }
        this.codeTable[n2] = (long)n << 12 | (long)(this.currentLzwCode & 0xFFF);
        ++this.currentLzwCode;
    }

    private int getTableKey(int n) {
        long l;
        int n2 = (n >>> 12 ^ n) & 0x1FFF;
        long l2 = (long)n << 12;
        while ((l = this.codeTable[n2]) != 0xFFFFFF000L) {
            if ((l & 0xFFFFFF000L) == l2) {
                return (int)l & 0xFFF;
            }
            ++n2;
            n2 &= 0x1FFF;
        }
        return -1;
    }

    private void lzwEncode(int n) throws IOException {
        this.bitBucket |= n << this.compressedBits;
        this.compressedBits += this.currentLzwBits;
        while (this.compressedBits >= 8) {
            if (this.lzwBuffered >= 255) {
                this.out.write((byte)this.lzwBuffered);
                this.out.write(this.lzwBuffer, 0, this.lzwBuffered);
                this.lzwBuffered = 0;
            }
            this.lzwBuffer[this.lzwBuffered++] = (byte)this.bitBucket;
            this.bitBucket >>>= 8;
            this.compressedBits -= 8;
        }
        if (this.currentLzwCode >= this.maxCode) {
            this.maxCode = 1 << ++this.currentLzwBits;
        }
    }

    private void clearTable() throws IOException {
        this.lzwEncode(this.clearCode);
        this.currentLzwCode = this.eofCode + 1;
        this.currentLzwBits = 9;
        this.maxCode = 1 << this.currentLzwBits;
        int n = 0;
        while (n < 8192) {
            this.codeTable[n] = 0xFFFFFF000L;
            ++n;
        }
    }
}

