/*
 * Decompiled with CFR 0.152.
 */
package jhl.util;

import java.util.Enumeration;
import jhl.util.CaseNameTable;
import jhl.util.NameHashtableEntry;
import jhl.util.NameHashtableEnumerator;
import jhl.util.NameTable;

public class NameHashtable {
    NameHashtableEntry[] table;
    int count;

    public NameHashtable() {
        this(101);
    }

    public NameHashtable(int n) {
        if (n <= 0) {
            n = 101;
        }
        this.table = new NameHashtableEntry[n];
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized int getSize() {
        return this.count;
    }

    public synchronized void clear() {
        NameHashtableEntry[] nameHashtableEntryArray = this.table;
        int n = 0;
        while (n < nameHashtableEntryArray.length) {
            nameHashtableEntryArray[n] = null;
            ++n;
        }
        this.count = 0;
    }

    public synchronized Enumeration elements() {
        return new NameHashtableEnumerator(this.table);
    }

    public void add(String string) {
        this.add(string, 1);
    }

    public synchronized void add(String string, int n) {
        NameHashtableEntry[] nameHashtableEntryArray = this.table;
        int n2 = string.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % nameHashtableEntryArray.length;
        NameHashtableEntry nameHashtableEntry = nameHashtableEntryArray[n3];
        while (nameHashtableEntry != null) {
            if (nameHashtableEntry.hash == n2 && nameHashtableEntry.key.equals(string)) {
                nameHashtableEntry.usage += n;
                return;
            }
            nameHashtableEntry = nameHashtableEntry.next;
        }
        if (this.count >= nameHashtableEntryArray.length) {
            this.rehash();
            this.add(string, n);
            return;
        }
        NameHashtableEntry nameHashtableEntry2 = new NameHashtableEntry();
        nameHashtableEntry2.hash = n2;
        nameHashtableEntry2.key = string;
        nameHashtableEntry2.usage = n;
        nameHashtableEntry2.next = nameHashtableEntryArray[n3];
        nameHashtableEntryArray[n3] = nameHashtableEntry2;
        ++this.count;
    }

    public synchronized void remove(String string) {
        NameHashtableEntry[] nameHashtableEntryArray = this.table;
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % nameHashtableEntryArray.length;
        NameHashtableEntry nameHashtableEntry = nameHashtableEntryArray[n2];
        NameHashtableEntry nameHashtableEntry2 = null;
        while (nameHashtableEntry != null) {
            if (nameHashtableEntry.hash == n && nameHashtableEntry.key.equals(string)) {
                if (nameHashtableEntry2 != null) {
                    nameHashtableEntry2.next = nameHashtableEntry.next;
                } else {
                    nameHashtableEntryArray[n2] = nameHashtableEntry.next;
                }
                --this.count;
                return;
            }
            nameHashtableEntry2 = nameHashtableEntry;
            nameHashtableEntry = nameHashtableEntry.next;
        }
    }

    public synchronized boolean inTable(String string) {
        NameHashtableEntry[] nameHashtableEntryArray = this.table;
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % nameHashtableEntryArray.length;
        NameHashtableEntry nameHashtableEntry = nameHashtableEntryArray[n2];
        while (nameHashtableEntry != null) {
            if (nameHashtableEntry.hash == n && nameHashtableEntry.key.equals(string)) {
                return true;
            }
            nameHashtableEntry = nameHashtableEntry.next;
        }
        return false;
    }

    public synchronized NameTable toNameTable(boolean bl) {
        return this.toNameTable(new NameTable(this.count), bl);
    }

    public synchronized NameTable toNameTable(NameTable nameTable, boolean bl) {
        int n;
        NameHashtableEntry[] nameHashtableEntryArray = this.table;
        int n2 = n = nameHashtableEntryArray.length;
        while (n2-- > 0) {
            NameHashtableEntry nameHashtableEntry = nameHashtableEntryArray[n2];
            while (nameHashtableEntry != null) {
                if (bl) {
                    nameTable.add(nameHashtableEntry.key.toLowerCase(), nameHashtableEntry.usage);
                } else {
                    nameTable.add(nameHashtableEntry.key, nameHashtableEntry.usage);
                }
                nameHashtableEntry = nameHashtableEntry.next;
            }
        }
        return nameTable;
    }

    public synchronized CaseNameTable toCaseNameTable() {
        int n;
        CaseNameTable caseNameTable = new CaseNameTable(this.count);
        NameHashtableEntry[] nameHashtableEntryArray = this.table;
        int n2 = n = nameHashtableEntryArray.length;
        while (n2-- > 0) {
            NameHashtableEntry nameHashtableEntry = nameHashtableEntryArray[n2];
            while (nameHashtableEntry != null) {
                caseNameTable.add(nameHashtableEntry.key, nameHashtableEntry.usage);
                nameHashtableEntry = nameHashtableEntry.next;
            }
        }
        return caseNameTable;
    }

    private void rehash() {
        int n = this.table.length;
        NameHashtableEntry[] nameHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        NameHashtableEntry[] nameHashtableEntryArray2 = new NameHashtableEntry[n2];
        this.table = nameHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            NameHashtableEntry nameHashtableEntry = nameHashtableEntryArray[n3];
            while (nameHashtableEntry != null) {
                NameHashtableEntry nameHashtableEntry2 = nameHashtableEntry;
                nameHashtableEntry = nameHashtableEntry.next;
                int n4 = (nameHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                nameHashtableEntry2.next = nameHashtableEntryArray2[n4];
                nameHashtableEntryArray2[n4] = nameHashtableEntry2;
            }
        }
    }
}

