/*
 * Decompiled with CFR 0.152.
 */
package jhl.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jhl.util.NameTableCompressor;
import jhl.util.StringFilter;

public final class NameTable {
    int size;
    String[] names;
    int[] usage;
    NameTableCompressor compressor;

    public NameTable() {
        this(10);
    }

    public NameTable(int n) {
        if (n <= 0) {
            n = 10;
        }
        this.size = 0;
        this.names = new String[n];
        this.usage = new int[n];
    }

    public synchronized void clear() {
        this.size = 0;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized void setCompressor(NameTableCompressor nameTableCompressor) {
        this.compressor = nameTableCompressor;
    }

    public synchronized int getMaxUsage() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            n = Math.max(n, this.usage[n2]);
            ++n2;
        }
        return n;
    }

    public synchronized void add(NameTable nameTable) {
        if (nameTable == null || nameTable.getSize() == 0) {
            return;
        }
        int n = nameTable.getSize();
        this.ensureCapacity(this.size + n);
        if (this.size == 0) {
            int n2 = 0;
            while (n2 < n) {
                this.names[n2] = nameTable.names[n2];
                this.usage[n2] = nameTable.usage[n2];
                ++this.size;
                ++n2;
            }
            return;
        }
        String string = nameTable.names[0];
        int n3 = this.find(string);
        String string2 = this.names[n3];
        int n4 = string.compareTo(string2);
        if (n4 == 0) {
            int n5 = n3;
            this.usage[n5] = this.usage[n5] + nameTable.usage[0];
        } else {
            if (n4 > 0) {
                ++n3;
            }
            this.prepareInsertion(n3);
            this.names[n3] = string;
            this.usage[n3] = nameTable.usage[0];
            ++this.size;
        }
        int n6 = 1;
        while (n6 < n) {
            block10: {
                string = nameTable.names[n6];
                while (true) {
                    if (n3 >= this.size) {
                        this.names[n3] = string;
                        this.usage[n3] = nameTable.usage[n6];
                        ++this.size;
                        break block10;
                    }
                    string2 = this.names[n3];
                    n4 = string.compareTo(string2);
                    if (n4 == 0) {
                        int n7 = n3;
                        this.usage[n7] = this.usage[n7] + nameTable.usage[n6];
                        break block10;
                    }
                    if (n4 <= 0) break;
                    ++n3;
                }
                this.prepareInsertion(n3);
                this.names[n3] = string;
                this.usage[n3] = nameTable.usage[n6];
                ++this.size;
            }
            ++n6;
        }
    }

    public synchronized void add(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.size == 0) {
            this.names[0] = string;
            this.usage[0] = 1;
            ++this.size;
            return;
        }
        int n = this.find(string);
        String string2 = this.names[n];
        int n2 = string.compareTo(string2);
        if (n2 == 0) {
            int n3 = n;
            this.usage[n3] = this.usage[n3] + 1;
            return;
        }
        if (n2 > 0) {
            ++n;
        }
        this.ensureCapacity(this.size);
        this.prepareInsertion(n);
        this.names[n] = string;
        this.usage[n] = 1;
        ++this.size;
    }

    public synchronized void remove(String string) {
        if (string == null || string.length() == 0 || this.size == 0) {
            return;
        }
        int n = this.find(string);
        String string2 = this.names[n];
        if (string2.equals(string)) {
            int n2 = n;
            this.usage[n2] = this.usage[n2] - 1;
            if (this.usage[n2] <= 0) {
                this.delete(n);
            }
        }
    }

    public synchronized void add(String string, int n) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.size == 0) {
            this.names[0] = string;
            this.usage[0] = n;
            ++this.size;
            return;
        }
        int n2 = this.find(string);
        String string2 = this.names[n2];
        int n3 = string.compareTo(string2);
        if (n3 == 0) {
            int n4 = n2;
            this.usage[n4] = this.usage[n4] + n;
            return;
        }
        if (n3 > 0) {
            ++n2;
        }
        this.ensureCapacity(this.size);
        this.prepareInsertion(n2);
        this.names[n2] = string;
        this.usage[n2] = n;
        ++this.size;
    }

    public synchronized void removeAll(String string) {
        if (string == null || string.length() == 0 || this.size == 0) {
            return;
        }
        int n = this.find(string);
        String string2 = this.names[n];
        if (string2.equals(string)) {
            this.delete(n);
        }
    }

    public synchronized void removeAll(int n) {
        if (n < 0 || n >= this.size) {
            return;
        }
        this.delete(n);
    }

    public synchronized void removeAll(StringFilter stringFilter) {
        if (this.size == 0) {
            return;
        }
        int n = 0;
        while (n < this.size) {
            if (stringFilter.isValid(this.names[n])) {
                this.delete(n);
                --n;
            }
            ++n;
        }
    }

    public synchronized void removeAll(NameTable nameTable) {
        if (this.size == 0 || nameTable == null || nameTable.getSize() == 0) {
            return;
        }
        int n = nameTable.getSize();
        String string = nameTable.names[0];
        int n2 = this.find(string);
        String string2 = this.names[n2];
        int n3 = string.compareTo(string2);
        if (n3 == 0) {
            this.delete(0);
        } else if (n3 > 0) {
            ++n2;
        }
        int n4 = 1;
        while (n4 < n) {
            string = nameTable.names[n4];
            while (true) {
                if (n2 >= this.size) {
                    return;
                }
                string2 = this.names[n2];
                n3 = string.compareTo(string2);
                if (n3 == 0) {
                    this.delete(n2);
                    break;
                }
                if (n3 <= 0) break;
                ++n2;
            }
            ++n4;
        }
    }

    public synchronized boolean inTable(String string) {
        if (string == null || string.length() == 0 || this.size == 0) {
            return false;
        }
        int n = this.find(string);
        String string2 = this.names[n];
        return string.compareTo(string2) == 0;
    }

    public synchronized int getIndex(String string) {
        if (string == null || string.length() == 0 || this.size == 0) {
            return -1;
        }
        return this.find(string);
    }

    public synchronized String getName(int n) {
        if (n < 0 || n >= this.size) {
            return "";
        }
        return this.names[n];
    }

    public synchronized int getUsage(int n) {
        if (n < 0 || n >= this.size) {
            return -1;
        }
        return this.usage[n];
    }

    private void ensureCapacity(int n) {
        if (n >= this.names.length) {
            n += 9;
            n -= n % 10;
            String[] stringArray = new String[n + 10];
            int[] nArray = new int[n + 10];
            System.arraycopy(this.names, 0, stringArray, 0, this.size);
            System.arraycopy(this.usage, 0, nArray, 0, this.size);
            this.names = stringArray;
            this.usage = nArray;
        }
    }

    private void prepareInsertion(int n) {
        int n2 = this.size - n;
        if (n2 > 0) {
            System.arraycopy(this.names, n, this.names, n + 1, n2);
            System.arraycopy(this.usage, n, this.usage, n + 1, n2);
        }
    }

    private void delete(int n) {
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.names, n + 1, this.names, n, n2);
            System.arraycopy(this.usage, n + 1, this.usage, n, n2);
        }
        --this.size;
        this.names[this.size] = null;
        this.usage[this.size] = 0;
    }

    private int find(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = this.size;
        int n4 = -1;
        do {
            String string2;
            if ((n = string.compareTo(string2 = this.names[n2 = n3 + n4 >> 1])) == 0) {
                return n2;
            }
            if (n < 0) {
                n3 = n2;
                continue;
            }
            n4 = n2;
        } while (n4 < n3 - 1);
        return n2;
    }

    public synchronized void store(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.size);
        if (this.size > 0) {
            int n;
            if (this.compressor != null) {
                this.compressor.init();
                n = 0;
                while (n < this.size) {
                    this.compressor.store(dataOutputStream, this.names[n]);
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.size) {
                    dataOutputStream.writeUTF(this.names[n]);
                    ++n;
                }
            }
            n = 0;
            int n2 = 0;
            while (n2 < this.size) {
                if (this.usage[n2] > n) {
                    n = this.usage[n2];
                }
                ++n2;
            }
            dataOutputStream.writeInt(n);
            if (n < 128) {
                int n3 = 0;
                while (n3 < this.size) {
                    dataOutputStream.writeByte((byte)this.usage[n3]);
                    ++n3;
                }
                return;
            }
            if (n < 32768) {
                int n4 = 0;
                while (n4 < this.size) {
                    dataOutputStream.writeShort((short)this.usage[n4]);
                    ++n4;
                }
                return;
            }
            int n5 = 0;
            while (n5 < this.size) {
                dataOutputStream.writeInt(this.usage[n5]);
                ++n5;
            }
        }
    }

    public synchronized void load(DataInputStream dataInputStream) throws IOException {
        this.size = dataInputStream.readInt();
        if (this.size > 0) {
            int n;
            int n2 = this.size + 9;
            n2 -= n2 % 10;
            this.names = new String[n2];
            this.usage = new int[n2];
            if (this.compressor != null) {
                this.compressor.init();
                n = 0;
                while (n < this.size) {
                    this.names[n] = this.compressor.load(dataInputStream);
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.size) {
                    this.names[n] = dataInputStream.readUTF();
                    ++n;
                }
            }
            n = dataInputStream.readInt();
            if (n < 128) {
                int n3 = 0;
                while (n3 < this.size) {
                    this.usage[n3] = dataInputStream.readByte();
                    ++n3;
                }
                return;
            }
            if (n < 32768) {
                int n4 = 0;
                while (n4 < this.size) {
                    this.usage[n4] = dataInputStream.readShort();
                    ++n4;
                }
                return;
            }
            int n5 = 0;
            while (n5 < this.size) {
                this.usage[n5] = dataInputStream.readInt();
                ++n5;
            }
        }
    }
}

