/*
 * Decompiled with CFR 0.152.
 */
package jhl.util;

public final class StringFilter {
    int mode;
    String comp;
    public static final int NONE = 0;
    public static final int STRAIGHT = 1;
    public static final int BEGINS = 2;
    public static final int ENDS = 4;
    public static final int CONTAINS = 6;

    public StringFilter(String string) {
        if (string != null && string.length() > 0) {
            this.mode = 0;
            this.comp = string;
            int n = string.length();
            if (n > 1 && this.comp.charAt(0) == '*') {
                this.mode = 4;
                this.comp = this.comp.substring(1);
                --n;
            }
            if (n > 1 && this.comp.charAt(n - 1) == '*') {
                this.mode |= 2;
                this.comp = this.comp.substring(0, --n);
            }
            if (this.mode == 0) {
                this.mode = 1;
            }
            if (n <= 0) {
                this.mode = 0;
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    public synchronized void setMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                this.mode = n;
            }
        }
    }

    public String getComp() {
        return this.comp;
    }

    public synchronized void setComp(String string) {
        if (string != null && string.length() > 0) {
            this.comp = string;
        }
    }

    public synchronized boolean isValid(String string) {
        switch (this.mode) {
            case 1: {
                return string.equals(this.comp);
            }
            case 2: {
                return string.startsWith(this.comp);
            }
            case 4: {
                return string.endsWith(this.comp);
            }
            case 6: {
                return string.indexOf(this.comp) >= 0;
            }
        }
        return false;
    }

    public synchronized String filter(String string) {
        switch (this.mode) {
            case 2: {
                return string.substring(this.comp.length());
            }
            case 4: {
                return string.substring(0, string.length() - this.comp.length());
            }
            case 6: {
                return this.comp;
            }
        }
        return "";
    }
}

