/*
 * Decompiled with CFR 0.152.
 */
package jhl.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import jhl.util.NameTableCompressor;

public final class WordTableCompressor
implements NameTableCompressor {
    Vector stack;
    int sp;
    String topOfStack;
    int tosLength;
    private static final char[] popSymbols = new char[]{'(', ')', '[', ']', '{', '}', '$', '^', '*', '|'};

    public void init() {
        this.stack = new Vector();
        this.sp = 0;
        this.tosLength = 0;
    }

    public void store(DataOutputStream dataOutputStream, String string) throws IOException {
        int n = string.length();
        if (this.tosLength >= 2 && n >= 2) {
            if (n > this.tosLength && string.startsWith(this.topOfStack)) {
                dataOutputStream.writeUTF("+" + string.substring(this.tosLength));
                this.stack.addElement(this.topOfStack);
                ++this.sp;
                this.topOfStack = string;
                this.tosLength = n;
                return;
            }
            int n2 = 0;
            while (this.sp > 0) {
                this.topOfStack = (String)this.stack.elementAt(--this.sp);
                this.tosLength = this.topOfStack.length();
                ++n2;
                if (n <= this.tosLength || !string.startsWith(this.topOfStack)) continue;
                if (n2 > 10) break;
                StringBuffer stringBuffer = new StringBuffer(16);
                stringBuffer.append(popSymbols[--n2]);
                stringBuffer.append(string.substring(this.tosLength));
                dataOutputStream.writeUTF(stringBuffer.toString());
                this.stack.setSize(this.sp);
                this.stack.addElement(this.topOfStack);
                ++this.sp;
                this.topOfStack = string;
                this.tosLength = n;
                return;
            }
        }
        this.stack.setSize(0);
        this.sp = 0;
        this.topOfStack = string;
        this.tosLength = n;
        dataOutputStream.writeUTF("-" + string);
    }

    public String load(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        String string2 = string.substring(1);
        switch (string.charAt(0)) {
            default: {
                this.stack.setSize(0);
                this.sp = 0;
                this.topOfStack = string2;
                return this.topOfStack;
            }
            case '+': {
                this.stack.addElement(this.topOfStack);
                ++this.sp;
                this.topOfStack = String.valueOf(this.topOfStack) + string2;
                return this.topOfStack;
            }
            case '|': {
                --this.sp;
            }
            case '*': {
                --this.sp;
            }
            case '^': {
                --this.sp;
            }
            case '$': {
                --this.sp;
            }
            case '}': {
                --this.sp;
            }
            case '{': {
                --this.sp;
            }
            case ']': {
                --this.sp;
            }
            case '[': {
                --this.sp;
            }
            case ')': {
                --this.sp;
            }
            case '(': 
        }
        --this.sp;
        this.topOfStack = (String)this.stack.elementAt(this.sp);
        this.stack.setSize(this.sp);
        this.stack.addElement(this.topOfStack);
        ++this.sp;
        this.topOfStack = String.valueOf(this.topOfStack) + string2;
        return this.topOfStack;
    }
}

