/*
 * Decompiled with CFR 0.152.
 */
package jhl.www.html;

import java.util.StringTokenizer;
import jhl.www.html.Attribute;
import jhl.www.html.Tag;
import jhl.www.html.TagContainer;
import jhl.www.html.URL;
import jhl.www.html.URLParser;
import jhl.www.html.Validator;

final class AttributeFilter {
    private static final String Where = "left, center, right";
    private static final String Direction = "left, right";
    private static final String Clear = "left, all, right, none";
    private static final String Vertical = "top, middle, bottom";
    private static final String UpDown = "top, bottom";
    private static final String Twod = "top, middle, bottom, left, right";
    private static final String Cellhalign = "left, right, center, justify, char";
    private static final String Cellvalign = "top, middle, bottom, baseline";
    private static final String Frame = "left, center, right, top, texttop, middle, absmiddle, baseline, bottom, absbottom";
    private static final String Iframe = "left, center, right, top, middle, bottom";
    private static final String ObjectAlign = "left, center, right, texttop, middle, textmiddle, baseline, textbottom";
    private static final String OLType = "1, a, A, i, I";
    private static final String ULType = "disc, square, circle";
    private static final String Method = "get, post";
    private static final String InputType = "text, password, checkbox, radio, submit, reset, file, hidden, image";
    private static final String Shape = "rect, rectangle, circ, circle, poly, polygon, default";
    private static final String Checked = "checked, true, false";
    private static final String Behavior = "scroll, slide, alternate";
    private static final String FrameType = "void, above, below, hsides, lhs, rhs, vsides, box, border";
    private static final String Rules = "none, groups, rows, cols, all";
    private static final String Scrolling = "yes, no, auto";
    private static final String Layout = "tiles, pages";
    private static final String ParamType = "data, ref, object";
    private static final String YesNo = "yes, no";
    private static final String ColorName = "acqua, black, blue, green, silver, lime, gray, olive, white, yellow, maroon, navy, red, purple, teal, fuchsia";
    private static final String ColorValue = "#00FFFF, #000000, #0000FF, #008000, #C0C0C0, #00FF00, #808080, #808000, #FFFFFF, #FFFF00, #800000, #000080, #FF0000, #800080, #008080, #FF00FF";
    private Validator val;
    private URLParser up;

    AttributeFilter(Validator validator) {
        this.val = validator;
        this.up = new URLParser(validator);
    }

    void checkRequired(Tag tag) {
        switch (tag.id) {
            case 71: {
                Attribute attribute;
                Attribute attribute2 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("alt");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "alt", tag.getTagName());
                }
                return;
            }
            case 33: 
            case 42: 
            case 1028: 
            case 1030: {
                Attribute attribute;
                Attribute attribute3 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("src");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "src", tag.getTagName());
                }
                return;
            }
            case 67: {
                Attribute attribute;
                Attribute attribute4 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("rows");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "rows", tag.getTagName());
                }
                Attribute attribute5 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("cols");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "cols", tag.getTagName());
                }
            }
            case 66: 
            case 75: {
                Attribute attribute;
                Attribute attribute6 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("name");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "name", tag.getTagName());
                }
                return;
            }
            case 12: {
                Attribute attribute;
                Attribute attribute7 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("href");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "href", tag.getTagName());
                }
                return;
            }
            case 73: {
                Attribute attribute;
                Attribute attribute8 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("n");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "n", tag.getTagName());
                }
                return;
            }
            case 15: {
                Attribute attribute;
                Attribute attribute9 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("content");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "content", tag.getTagName());
                }
                return;
            }
            case 43: {
                Attribute attribute;
                Attribute attribute10;
                Attribute attribute11 = tag.attributes == null ? null : (Attribute)tag.attributes.get("code");
                Attribute attribute12 = attribute10 = tag.attributes == null ? null : (Attribute)tag.attributes.get("object");
                if (!(attribute11 != null && attribute11.type != 0 || attribute10 != null && attribute10.type != 0)) {
                    this.val.addError(tag.line, tag.col, "a2", "code", "object", tag.getTagName());
                }
                Attribute attribute13 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("height");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "height", tag.getTagName());
                }
                Attribute attribute14 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("width");
                if (attribute == null || attribute.type == 0) {
                    this.val.addError(tag.line, tag.col, "a1", "width", tag.getTagName());
                }
                return;
            }
            case 65: {
                Attribute attribute;
                Attribute attribute15;
                Attribute attribute16 = attribute15 = tag.attributes == null ? null : (Attribute)tag.attributes.get("type");
                if (attribute15 == null) {
                    attribute15 = new Attribute();
                    attribute15.text = "text";
                    attribute15.name = "text";
                    attribute15.type = 5;
                    attribute15.value = new Integer(0);
                    tag.putAttr(attribute15);
                } else if (attribute15.type == 0) {
                    attribute15.text = "text";
                    attribute15.name = "text";
                    attribute15.type = 5;
                    attribute15.value = new Integer(0);
                }
                int n = (Integer)attribute15.value;
                if (n != 4 && n != 5) {
                    Attribute attribute17 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("name");
                    if (attribute == null) {
                        this.val.addError(tag.line, tag.col, "a1", "name", tag.getTagName());
                    }
                }
                if (n == 2 || n == 3) {
                    Attribute attribute18 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("value");
                    if (attribute == null) {
                        this.val.addError(tag.line, tag.col, "a1", "name", tag.getTagName());
                    }
                }
                return;
            }
        }
    }

    void checkAttribute(Tag tag, Attribute attribute, int n, int n2) {
        String string = attribute.name.toLowerCase();
        switch (tag.id) {
            case 12: 
            case 14: 
            case 15: 
            case 47: 
            case 73: 
            case 75: {
                this.checkTagAttribute(tag, attribute, n, n2, string);
                return;
            }
        }
        if (string.equals("id")) {
            this.checkSGML(tag, attribute, n, n2, string, 1);
            return;
        }
        if (string.equals("lang")) {
            this.checkSGML(tag, attribute, n, n2, string, 2);
            return;
        }
        if (string.equals("class")) {
            this.checkSGML(tag, attribute, n, n2, string, 5);
            return;
        }
        if (string.equals("style")) {
            this.checkSGML(tag, attribute, n, n2, string, 2);
            return;
        }
        this.checkTagAttribute(tag, attribute, n, n2, string);
    }

    private void checkTagAttribute(Tag tag, Attribute attribute, int n, int n2, String string) {
        switch (tag.id) {
            case 45: {
                if (string.equals("size")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("color")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("face")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 1036: {
                if (string.equals("size")) {
                    this.checkSize(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("color")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("face")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 46: {
                if (string.equals("clear")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Clear);
                }
                return;
            }
            case 9: {
                if (string.equals("background")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bgcolor")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("text")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("link")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("vlink")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("alink")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bgproperties")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("leftmargin")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("topmargin")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                }
                return;
            }
            case 35: {
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Where);
                }
                return;
            }
            case 41: {
                if (string.equals("href")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("rel")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("rev")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("title")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("target")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 16: {
                if (string.equals("href")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("rel")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("rev")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("title")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 47: {
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 71: {
                if (string.equals("shape")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Shape);
                    return;
                }
                if (string.equals("coords")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("href")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    Attribute attribute2 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("nohref");
                    if (attribute != null) {
                        this.val.addError(tag.line, tag.col, "a6", "nohref", "href", tag.getTagName());
                        return;
                    }
                } else if (string.equals("nohref")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    Attribute attribute3 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("href");
                    if (attribute != null) {
                        this.val.addError(tag.line, tag.col, "a6", "href", "nohref", tag.getTagName());
                        return;
                    }
                } else {
                    if (string.equals("alt")) {
                        this.checkSGML(tag, attribute, n, n2, string, 2);
                        return;
                    }
                    if (string.equals("target")) {
                        this.checkSGML(tag, attribute, n, n2, string, 2);
                    }
                }
                return;
            }
            case 33: {
                if (string.equals("src")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("param")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("height")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (!string.equals("width")) break;
                this.checkLength(tag, attribute, n, n2, string);
                return;
            }
            case 42: {
                if (string.equals("src")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("alt")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Twod);
                    return;
                }
                if (string.equals("height")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("width")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("border")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("hspace")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("vspace")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("usemap")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("ismap")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("dynsrc")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("start")) {
                    this.checkSGML(tag, attribute, n, n2, string, 5);
                    return;
                }
                if (string.equals("loop")) {
                    this.checkSGML(tag, attribute, n, n2, string, 4);
                    return;
                }
                if (string.equals("controls")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("vrml")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 43: {
                if (string.equals("codebase")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("code")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    Attribute attribute4 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("object");
                    if (attribute != null) {
                        this.val.addError(tag.line, tag.col, "a6", "code", "object", tag.getTagName());
                        return;
                    }
                } else if (string.equals("object")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    Attribute attribute5 = attribute = tag.attributes == null ? null : (Attribute)tag.attributes.get("code");
                    if (attribute != null) {
                        this.val.addError(tag.line, tag.col, "a6", "object", "code", tag.getTagName());
                        return;
                    }
                } else {
                    if (string.equals("alt")) {
                        this.checkSGML(tag, attribute, n, n2, string, 2);
                        return;
                    }
                    if (string.equals("name")) {
                        this.checkSGML(tag, attribute, n, n2, string, 2);
                        return;
                    }
                    if (string.equals("archive")) {
                        this.checkSGML(tag, attribute, n, n2, string, 2);
                        return;
                    }
                    if (string.equals("height")) {
                        this.checkLength(tag, attribute, n, n2, string);
                        return;
                    }
                    if (string.equals("width")) {
                        this.checkLength(tag, attribute, n, n2, string);
                        return;
                    }
                    if (string.equals("align")) {
                        this.checkLiteral(tag, attribute, n, n2, string, Twod);
                        return;
                    }
                    if (string.equals("hspace")) {
                        this.checkSGML(tag, attribute, n, n2, string, 3);
                        return;
                    }
                    if (string.equals("vspace")) {
                        this.checkSGML(tag, attribute, n, n2, string, 3);
                        return;
                    }
                    if (string.equals("border")) {
                        this.checkSGML(tag, attribute, n, n2, string, 3);
                    }
                }
                return;
            }
            case 39: {
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Where);
                    return;
                }
                if (string.equals("size")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("width")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("color")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("noshade")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                }
                return;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Where);
                }
                return;
            }
            case 1024: {
                if (string.equals("src")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("loop")) {
                    this.checkSGML(tag, attribute, n, n2, string, 4);
                    return;
                }
                if (string.equals("start")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 1031: {
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Vertical);
                    return;
                }
                if (string.equals("behavior")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Behavior);
                    return;
                }
                if (string.equals("bgcolor")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("direction")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Direction);
                    return;
                }
                if (string.equals("height")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("width")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("hspace")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("vspace")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("loop")) {
                    this.checkSGML(tag, attribute, n, n2, string, 4);
                    return;
                }
                if (string.equals("scrollamount")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("scrolldelay")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("border")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("background")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                }
                return;
            }
            case 30: {
                if (string.equals("width")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                }
                return;
            }
            case 27: 
            case 28: 
            case 29: {
                if (string.equals("compact")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                }
                return;
            }
            case 26: {
                if (string.equals("compact")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("type")) {
                    this.checkOLType(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("start")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                }
                return;
            }
            case 25: {
                if (string.equals("compact")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("type")) {
                    this.checkLiteral(tag, attribute, n, n2, string, ULType);
                }
                return;
            }
            case 68: {
                if (string.equals("type")) {
                    TagContainer tagContainer = this.val.tos();
                    Tag tag2 = tagContainer.onStackEntity(32);
                    if (tag2.id == 26) {
                        this.checkOLType(tag, attribute, n, n2, string);
                        return;
                    }
                    this.checkLiteral(tag, attribute, n, n2, string, ULType);
                    return;
                }
                if (string.equals("value")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                }
                return;
            }
            case 38: {
                if (string.equals("action")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("method")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Method);
                    return;
                }
                if (string.equals("enctype")) {
                    if (attribute.type == 0) {
                        this.val.addError(n, n2, "a3", string, tag.getTagName());
                        return;
                    }
                } else {
                    if (string.equals("name")) {
                        this.checkSGML(tag, attribute, n, n2, string, 2);
                        return;
                    }
                    if (string.equals("target")) {
                        this.checkSGML(tag, attribute, n, n2, string, 2);
                    }
                }
                return;
            }
            case 65: {
                if (string.equals("type")) {
                    this.checkLiteral(tag, attribute, n, n2, string, InputType);
                    return;
                }
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("value")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("checked")) {
                    this.checkChecked(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("size")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("maxlength")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("src")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Twod);
                }
                return;
            }
            case 66: {
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("size")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("multiple")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                }
                return;
            }
            case 74: {
                if (string.equals("selected")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("value")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 67: {
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("rows")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("cols")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                }
                return;
            }
            case 40: {
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Where);
                    return;
                }
                if (string.equals("width")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("border")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("cellspacing")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("cellpadding")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("cols")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("frame")) {
                    this.checkLiteral(tag, attribute, n, n2, string, FrameType);
                    return;
                }
                if (string.equals("rules")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Rules);
                    return;
                }
                if (string.equals("background")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bgcolor")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolor")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolorlight")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolordark")) {
                    this.checkColor(tag, attribute, n, n2, string);
                }
                return;
            }
            case 72: {
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, UpDown);
                    return;
                }
                if (string.equals("height")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("width")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 1026: 
            case 1027: {
                if (string.equals("span")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("width")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Cellhalign);
                    return;
                }
                if (string.equals("valign")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Cellvalign);
                    return;
                }
                if (string.equals("char")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("charoff")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 1038: 
            case 1039: 
            case 1040: {
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Cellhalign);
                    return;
                }
                if (string.equals("valign")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Cellvalign);
                    return;
                }
                if (string.equals("char")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("charoff")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 79: {
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Where);
                    return;
                }
                if (string.equals("valign")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Cellvalign);
                    return;
                }
                if (string.equals("char")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("charoff")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("bgcolor")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolor")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolorlight")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolordark")) {
                    this.checkColor(tag, attribute, n, n2, string);
                }
                return;
            }
            case 77: 
            case 78: {
                if (string.equals("nowrap")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("rowspan")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("colspan")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Where);
                    return;
                }
                if (string.equals("valign")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Cellvalign);
                    return;
                }
                if (string.equals("height")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("width")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("axis")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("axes")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("char")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("charoff")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("background")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bgcolor")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolor")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolorlight")) {
                    this.checkColor(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("bordercolordark")) {
                    this.checkColor(tag, attribute, n, n2, string);
                }
                return;
            }
            case 11: {
                if (string.equals("prompt")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("action")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 12: {
                if (string.equals("href")) {
                    if (this.checkUrl(tag, attribute, n, n2, string)) {
                        URL uRL = (URL)attribute.value;
                        if (uRL.location == null) {
                            if (uRL.path == null || uRL.path.charAt(0) != '/') {
                                this.val.addError(n, n2, "a7", string, tag.getTagName());
                                attribute.type = 0;
                            }
                            return;
                        }
                    }
                } else if (string.equals("target")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 73: {
                if (string.equals("n")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 15: {
                if (string.equals("http-equiv")) {
                    this.checkSGML(tag, attribute, n, n2, string, 5);
                    return;
                }
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 5);
                    return;
                }
                if (string.equals("content")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("charset")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 14: {
                if (string.equals("type")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("title")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 13: {
                if (string.equals("type")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("language")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("src")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 1029: {
                if (string.equals("layout")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Layout);
                    return;
                }
                if (string.equals("rows")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("cols")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("frameborder")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("framespacing")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                }
                return;
            }
            case 1028: {
                if (string.equals("src")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("marginwidth")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("marginheight")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("frameborder")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("framespacing")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("noresize")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Frame);
                    return;
                }
                if (string.equals("scrolling")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Scrolling);
                    return;
                }
                if (string.equals("height")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("width")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("hspace")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("vspace")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                }
                return;
            }
            case 1030: {
                if (string.equals("src")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("marginwidth")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("marginheight")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("frameborder")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("framespacing")) {
                    this.checkSGML(tag, attribute, n, n2, string, 3);
                    return;
                }
                if (string.equals("noresize")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, Iframe);
                }
                return;
            }
            case 1035: {
                if (string.equals("declare")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("classid")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("codebase")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("data")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("type")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("codetype")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("standby")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("align")) {
                    this.checkLiteral(tag, attribute, n, n2, string, ObjectAlign);
                    return;
                }
                if (string.equals("height")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("width")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("border")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("hspace")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("vspace")) {
                    this.checkLength(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("ismap")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("usemap")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("shapes")) {
                    this.checkSelf(tag, attribute, n, n2, string);
                    return;
                }
                if (string.equals("name")) {
                    this.checkUrl(tag, attribute, n, n2, string);
                }
                return;
            }
            case 75: {
                if (string.equals("name")) {
                    this.checkSGML(tag, attribute, n, n2, string, 4);
                    return;
                }
                if (string.equals("value")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                    return;
                }
                if (string.equals("valuetype")) {
                    this.checkLiteral(tag, attribute, n, n2, string, ParamType);
                    return;
                }
                if (string.equals("type")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
            case 7: {
                if (string.equals("version")) {
                    this.checkSGML(tag, attribute, n, n2, string, 2);
                }
                return;
            }
        }
    }

    private boolean checkSGML(Tag tag, Attribute attribute, int n, int n2, String string, int n3) {
        if (attribute.type == 0) {
            this.val.addError(n, n2, "a3", string, tag.getTagName());
            return false;
        }
        switch (n3) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                if (attribute.type != 3) {
                    this.val.addError(n, n2, "a4", "NUMBER", string, tag.getTagName());
                    attribute.type = 0;
                    return false;
                }
                return true;
            }
            case 4: {
                switch (attribute.type) {
                    case 3: 
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                this.val.addError(n, n2, "a4", "NMTOKEN", string, tag.getTagName());
                attribute.type = 0;
                return false;
            }
            case 5: {
                if (attribute.type != 5) {
                    this.val.addError(n, n2, "a4", "NAME", string, tag.getTagName());
                    attribute.type = 0;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean checkSelf(Tag tag, Attribute attribute, int n, int n2, String string) {
        if (attribute.type != 0) {
            if (!string.equals(attribute.text.toLowerCase())) {
                this.val.addError(n, n2, "a5", string, tag.getTagName());
            }
            attribute.type = 0;
        }
        return true;
    }

    private boolean checkSize(Tag tag, Attribute attribute, int n, int n2, String string) {
        if (attribute.type == 0) {
            this.val.addError(n, n2, "a3", string, tag.getTagName());
            return false;
        }
        switch (attribute.type) {
            case 3: {
                return true;
            }
            case 2: 
            case 4: {
                attribute.type = 2;
                char c = attribute.text.charAt(0);
                if (c != '-' && c != '+') {
                    this.val.addError(n, n2, "a4", string, tag.getTagName());
                    attribute.type = 0;
                    return false;
                }
                String string2 = attribute.text;
                int n3 = string2.length();
                int n4 = 1;
                while (n4 < n3) {
                    c = string2.charAt(n4);
                    if (c < '0' || c > '9') {
                        this.val.addError(n, n2, "a4", string, tag.getTagName());
                        attribute.type = 0;
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
        }
        this.val.addError(n, n2, "a4", string, tag.getTagName());
        attribute.type = 0;
        return false;
    }

    private boolean checkLength(Tag tag, Attribute attribute, int n, int n2, String string) {
        if (attribute.type == 0) {
            this.val.addError(n, n2, "a3", string, tag.getTagName());
            return false;
        }
        switch (attribute.type) {
            case 3: {
                return true;
            }
            case 2: {
                char c;
                String string2 = attribute.text;
                int n3 = string2.length();
                int n4 = 0;
                while (n4 < n3 - 1) {
                    c = string2.charAt(n4);
                    if (c < '0' || c > '9') {
                        this.val.addError(n, n2, "a4", string, tag.getTagName());
                        attribute.type = 0;
                        return false;
                    }
                    ++n4;
                }
                c = string2.charAt(n4);
                if (c != '%' && (c < '0' || c > '9')) {
                    this.val.addError(n, n2, "a4", string, tag.getTagName());
                    attribute.type = 0;
                    return false;
                }
                return true;
            }
        }
        this.val.addError(n, n2, "a4", string, tag.getTagName());
        attribute.type = 0;
        return false;
    }

    private boolean checkUrl(Tag tag, Attribute attribute, int n, int n2, String string) {
        if (attribute.type == 0) {
            this.val.addError(n, n2, "a3", string, tag.getTagName());
            return false;
        }
        URL uRL = this.up.parse(tag, attribute.text, n, n2);
        attribute.value = uRL;
        attribute.text = uRL.data;
        return true;
    }

    private boolean checkColor(Tag tag, Attribute attribute, int n, int n2, String string) {
        if (attribute.type == 0) {
            this.val.addError(n, n2, "a3", string, tag.getTagName());
            return false;
        }
        String string2 = attribute.text.toUpperCase();
        switch (attribute.type) {
            case 5: {
                if (this.checkColorName(attribute)) {
                    string2 = attribute.text;
                }
            }
            case 2: 
            case 3: 
            case 4: {
                int n3 = string2.length();
                if (string2.charAt(0) != '#') {
                    this.val.addError(n, n2, "a8", string, tag.getTagName());
                    string2 = "#" + string2;
                    ++n3;
                }
                attribute.text = string2;
                attribute.type = 2;
                attribute.delim = 34;
                if (n3 - 1 > 6) {
                    this.val.addError(n, n2, "a4", string, tag.getTagName());
                    attribute.type = 0;
                    return false;
                }
                int n4 = 0;
                int n5 = 1;
                while (n5 < n3) {
                    char c = string2.charAt(n5);
                    if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
                        this.val.addError(n, n2, "a4", string, tag.getTagName());
                        attribute.type = 0;
                        return false;
                    }
                    n4 <<= 4;
                    n4 = c >= 'A' ? (n4 += c - 65 + 10) : (n4 += c - 48);
                    ++n5;
                }
                attribute.value = new Integer(n4);
                return true;
            }
        }
        this.val.addError(n, n2, "a4", string, tag.getTagName());
        attribute.type = 0;
        return false;
    }

    private boolean checkColorName(Attribute attribute) {
        String string = attribute.text.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(ColorName, ", ");
        StringTokenizer stringTokenizer2 = new StringTokenizer(ColorValue, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(string)) {
                attribute.text = stringTokenizer2.nextToken();
                attribute.type = 2;
                attribute.delim = 34;
                return true;
            }
            stringTokenizer2.nextToken();
        }
        return false;
    }

    private boolean checkOLType(Tag tag, Attribute attribute, int n, int n2, String string) {
        if (attribute.type == 0) {
            this.val.addError(n, n2, "a3", string, tag.getTagName());
            return false;
        }
        int n3 = this.checkValue(attribute, OLType, true);
        if (n3 < 0) {
            this.val.addError(n, n2, "a3", string, tag.getTagName());
            return false;
        }
        attribute.value = new Integer(n3);
        return true;
    }

    private boolean checkContentType(Tag tag, Attribute attribute, int n, int n2, String string) {
        if (attribute.type == 0) {
            this.val.addError(n, n2, "a3", string, tag.getTagName());
            return false;
        }
        return true;
    }

    private boolean checkChecked(Tag tag, Attribute attribute, int n, int n2, String string) {
        if (attribute.type == 0) {
            attribute.value = new Boolean(true);
            attribute.type = 6;
            return true;
        }
        int n3 = this.checkValue(attribute, Checked, false);
        if (n3 < 0) {
            this.val.addError(n, n2, "a9", string, Checked, tag.getTagName());
            attribute.value = new Boolean(false);
            attribute.type = 0;
            return false;
        }
        if (n3 == 2) {
            attribute.value = new Boolean(false);
            attribute.type = 0;
        } else {
            attribute.value = new Boolean(true);
            attribute.type = 6;
        }
        return true;
    }

    private boolean checkLiteral(Tag tag, Attribute attribute, int n, int n2, String string, String string2) {
        if (attribute.type == 0) {
            this.val.addError(n, n2, "a9", string, string2, tag.getTagName());
            return false;
        }
        int n3 = this.checkValue(attribute, string2, false);
        if (n3 < 0) {
            this.val.addError(n, n2, "a9", string, string2, tag.getTagName());
            attribute.type = 0;
            return false;
        }
        attribute.value = new Integer(n3);
        return true;
    }

    private int checkValue(Attribute attribute, String string, boolean bl) {
        String string2 = attribute.text;
        if (string2 == null) {
            return -1;
        }
        string2 = bl ? string2 : string2.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

