/*
 * Decompiled with CFR 0.152.
 */
package jhl.www.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import jhl.www.html.Address;
import jhl.www.html.AmpChar;
import jhl.www.html.Anchor;
import jhl.www.html.Attribute;
import jhl.www.html.AttributeFilter;
import jhl.www.html.Body;
import jhl.www.html.ColGroup;
import jhl.www.html.DescList;
import jhl.www.html.DirList;
import jhl.www.html.Document;
import jhl.www.html.Embed;
import jhl.www.html.External;
import jhl.www.html.Form;
import jhl.www.html.Frameset;
import jhl.www.html.Head;
import jhl.www.html.Html;
import jhl.www.html.HtmlError;
import jhl.www.html.HtmlErrorMessage;
import jhl.www.html.HtmlException;
import jhl.www.html.List;
import jhl.www.html.Map;
import jhl.www.html.NoBody;
import jhl.www.html.Pre;
import jhl.www.html.Select;
import jhl.www.html.Sgml;
import jhl.www.html.Table;
import jhl.www.html.TableArea;
import jhl.www.html.TableRow;
import jhl.www.html.Tag;
import jhl.www.html.TagContainer;
import jhl.www.html.Text;
import jhl.www.html.Validator;

public final class Parser
extends Observable
implements Validator {
    char[] text;
    int textSize;
    int textIndex;
    Document wrapper;
    HtmlError err;
    private AttributeFilter filter = new AttributeFilter(this);
    TagContainer stack;
    private int correctorIndex;
    private int correctorSize;
    private Tag[] corrector;
    private boolean hasHtml;
    private boolean hasHead;
    private boolean hasBody;
    private boolean hasFrameset;
    private boolean hasDeprecated;
    private boolean hasExtensions;
    private boolean hasUnknown;
    private int pushedHtml;
    private int pushedHead;
    private int pushedBody;
    private int pushedPre;
    private int pushedNoframes;
    private int pushedMap;
    private int pushedTable;
    private int pushedColgroup;
    private int pushedDl;
    private int pushedForm;
    private int pushedSelect;
    private int pushedTr;
    private int pushedEmbed;
    private int pushedFrameset;
    private int pushedHeading;
    private int pushedList;
    private int pushedExternal;
    private InputStreamReader in;
    private OutputStreamWriter out;
    private char[] chars;
    private int charsSize;
    private int charBlockSize;
    private int readIndex;
    private int writeIndex;
    private long charsRead;
    private boolean superRetaining;
    private boolean retaining;
    private int retainedReadIndex;
    private int line;
    private int col;
    private int retainedLine;
    private int retainedCol;
    private int retainedIndex;
    private static Hashtable htAmpChar;
    private static AmpChar[] entity;
    private boolean wasWhite;
    private boolean textSinceLastBreak;
    private Text lastTextTag;
    private Tag lastTag;
    boolean plainText;
    private static Hashtable htTags;

    public synchronized void parse(File file, Document document) throws HtmlException {
        this.parse(file, document, null);
    }

    public synchronized void parse(File file, Document document, HtmlError htmlError) throws HtmlException {
        this.err = htmlError;
        this.wrapper = document;
        this.init();
        if (!file.exists()) {
            throw new HtmlException("p1");
        }
        if (!file.isFile()) {
            throw new HtmlException("p2");
        }
        if (!file.canRead()) {
            throw new HtmlException("p3");
        }
        long l = file.length();
        if (l <= 0L) {
            throw new HtmlException("p4");
        }
        try {
            if (htmlError != null) {
                htmlError.getErrors();
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            this.connect(fileInputStream, null);
            this.parseText();
            this.disconnect();
            this.corrector = null;
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HtmlException("p5");
        }
        catch (IOException iOException) {
            throw new HtmlException("p6");
        }
    }

    public synchronized void parse(URL uRL, Document document) throws HtmlException {
        this.parse(uRL, document, null);
    }

    public synchronized void parse(URL uRL, Document document, HtmlError htmlError) throws HtmlException {
        this.wrapper = document;
        this.err = htmlError;
        this.init();
        try {
            if (htmlError != null) {
                htmlError.getErrors();
            }
            InputStream inputStream = uRL.openStream();
            this.connect(inputStream, null);
            this.parseText();
            this.disconnect();
            this.corrector = null;
            return;
        }
        catch (IOException iOException) {
            throw new HtmlException("p6");
        }
    }

    public Document getDocument() {
        return this.wrapper;
    }

    private void init() {
        if (this.wrapper == null) {
            this.wrapper = new Document();
        }
        this.stack = this.wrapper;
        this.correctorSize = 10;
        this.correctorIndex = 0;
        this.corrector = new Tag[this.correctorSize];
        this.hasFrameset = false;
        this.hasBody = false;
        this.hasHead = false;
        this.hasHtml = false;
        this.hasUnknown = false;
        this.hasExtensions = false;
        this.hasDeprecated = false;
        this.pushedBody = 0;
        this.pushedHead = 0;
        this.pushedHtml = 0;
        this.pushedNoframes = 0;
        this.pushedFrameset = 0;
        this.pushedExternal = 0;
        this.pushedList = 0;
        this.pushedHeading = 0;
        this.pushedEmbed = 0;
        this.pushedTr = 0;
        this.pushedSelect = 0;
        this.pushedForm = 0;
        this.pushedDl = 0;
        this.pushedColgroup = 0;
        this.pushedTable = 0;
        this.pushedMap = 0;
        this.pushedPre = 0;
        this.wasWhite = false;
        this.textSinceLastBreak = false;
        this.lastTag = null;
        this.lastTextTag = null;
        this.plainText = false;
    }

    private void term() {
        this.corrector = null;
    }

    private void parseText() throws HtmlException {
        this.superRetaining = true;
        while (true) {
            Tag tag;
            if ((tag = this.getTag()) == null) {
                if (this.stack == this.wrapper) break;
                this.forceCloseStackTag(null);
                continue;
            }
            if (tag.id == 0) continue;
            if (!tag.opening) {
                if (!this.validCloseTag(tag)) continue;
                this.stack.close(tag, this);
                continue;
            }
            if (!this.checkStackTag(tag)) continue;
            if (this.stack.inExclusion(tag)) {
                this.forceCloseStackTag(tag);
                continue;
            }
            this.stack.add(tag, this);
        }
        Document document = this.wrapper;
        Parser parser = this;
        if (document.doctype == null) {
            parser.addError(1, 1, "t15");
        }
        this.wrapper.text = this.text;
        this.wrapper.plainText = this.plainText;
        if (this.hasDeprecated) {
            this.addError(1, 1, "t9");
        }
        if (this.hasExtensions) {
            this.addError(1, 1, "t10");
        }
        if (this.hasUnknown) {
            this.addError(1, 1, "t11");
        }
        this.tellObservers(this.wrapper);
    }

    private void forceCloseStackTag(Tag tag) {
        Tag tag2 = this.construct(this.stack.name, false, true);
        if (tag == null) {
            TagContainer tagContainer = this.stack;
            if (tagContainer.required && !this.stack.implied) {
                this.addError(this.line, this.col, "t14", this.stack.getTagClosingName());
            }
            tag2.line = this.line;
            tag2.col = this.col;
        } else {
            TagContainer tagContainer = this.stack;
            if (tagContainer.required && !this.stack.implied) {
                this.addError(tag.line, tag.col, "t13", this.stack.getTagClosingName(), tag.getTagName());
            }
            tag2.line = tag.line;
            tag2.col = tag.col;
        }
        this.addCorrector(tag);
        this.stack.close(tag2, this);
    }

    private boolean validCloseTag(Tag tag) throws HtmlException {
        if (this.stack.id == tag.id) {
            return true;
        }
        if (!tag.hasEndMarkup()) {
            this.addError(tag.line, tag.col, "p4", tag.getTagClosingName());
            return false;
        }
        if (tag.entity == 8) {
            if (this.pushedHeading <= 0) {
                this.addError(tag.line, tag.col, "p5", tag.getTagOpeningName());
                return false;
            }
            Tag tag2 = this.stack.onStackEntity(8);
            if (tag2.id != tag.id) {
                this.addError(tag.line, tag.col, "t4", tag.getTagClosingName(), tag2.getTagName());
                tag.id = tag2.id;
                tag.name = tag2.name;
            }
            return true;
        }
        if (!this.stack.onStackId(tag.id)) {
            this.addError(tag.line, tag.col, "p5", tag.getTagOpeningName());
            return false;
        }
        return true;
    }

    private boolean checkStackTag(Tag tag) throws HtmlException {
        if (tag.id == 6) {
            if (this.pushedBody > 0 || this.pushedNoframes > 0) {
                return true;
            }
            Text text = (Text)tag;
            int n = text.textEnd - text.textStart;
            if (n == 0 || n == 1 && this.text[text.textStart] == ' ') {
                return false;
            }
            if (this.superRetaining && this.pushedHtml <= 0 && !this.hasHtml && this.pushedHead <= 0 && !this.hasHead) {
                this.addError(1, 1, "p11");
                this.textIndex = 0;
                this.readIndex = 0;
                this.correctorIndex = 0;
                this.line = 1;
                this.col = 1;
                this.writeIndex = this.charsSize;
                this.superRetaining = false;
                this.plainText = true;
                Tag tag2 = this.construct("text/plain", true, true);
                tag2.line = 1;
                tag2.col = 1;
                this.putBack(tag2, "body", true);
                return false;
            }
            this.superRetaining = false;
            this.putBack(tag, "body", true);
            return false;
        }
        if (tag.id == 2) {
            if (this.wrapper.doctype != null) {
                this.addError(tag.line, tag.col, "p2");
                return false;
            }
            this.wrapper.doctype = tag;
            if (this.pushedHtml > 0 || this.hasHtml) {
                this.addError(tag.line, tag.col, "p3");
            }
            return false;
        }
        if (tag.id == 3) {
            Document document = this.wrapper;
            document.comments.add(tag);
            this.setChanged();
            this.notifyObservers(tag);
            return false;
        }
        if (tag.id == 7) {
            return this.checkHtmlTag(tag);
        }
        if (tag.id == 8) {
            return this.checkHeadTag(tag);
        }
        if (tag.id == 9) {
            return this.checkBodyTag(tag);
        }
        if (tag.id == 1029) {
            return this.checkFramesetTag(tag);
        }
        if (!this.checkOrphans(tag)) {
            return false;
        }
        if ((tag.group & 0xFFFFFFFE) == 12) {
            if (this.pushedBody > 0 || this.pushedNoframes > 0) {
                return true;
            }
            if (this.pushedBody <= 0 && this.pushedFrameset <= 0) {
                this.putBack(tag, "body", true);
                return false;
            }
            this.addError(tag.line, tag.col, "p6", tag.getTagName(), "noframes");
            this.putBack(tag, "noframes", true);
            return false;
        }
        if ((tag.group & 0xFFFFFFFE) == 4) {
            if (this.pushedBody > 0) {
                return true;
            }
            this.putBack(tag, "body", true);
            return false;
        }
        if ((tag.group & 0xFFFFFFFE) == 8) {
            if (this.pushedFrameset > 0) {
                return true;
            }
            this.addError(tag.line, tag.col, "p6", tag.getTagName(), "frameset");
            this.putBack(tag, "frameset", true);
            return false;
        }
        if ((tag.group & 0xFFFFFFFE) == 2) {
            if (this.pushedHead > 0) {
                return true;
            }
            this.putBack(tag, "head", true);
            return false;
        }
        if (this.pushedHead <= 0 && this.pushedBody <= 0 && this.pushedFrameset <= 0) {
            if (!this.hasHead) {
                this.putBack(tag, "head", true);
                return false;
            }
            this.putBack(tag, "body", true);
            return false;
        }
        if (this.pushedFrameset > 0 && this.pushedNoframes <= 0) {
            this.addError(tag.line, tag.col, "p6", tag.getTagName(), "noframes");
            this.putBack(tag, "noframes", true);
            return false;
        }
        return true;
    }

    private boolean checkHtmlTag(Tag tag) {
        if (this.hasHtml || this.pushedHtml > 0) {
            this.addError(tag.line, tag.col, "p9", "<html>");
            this.hasHtml = true;
        }
        return true;
    }

    private boolean checkHeadTag(Tag tag) {
        if (this.pushedHtml <= 0) {
            this.putBack(tag, "html", true);
            return false;
        }
        if (this.hasHead || this.pushedHead > 0) {
            this.addError(tag.line, tag.col, "p9", "<head>");
        } else if (this.hasBody || this.pushedBody > 0) {
            this.addError(tag.line, tag.col, "p10", "<head>", "body");
        } else if (this.hasFrameset || this.pushedFrameset > 0) {
            this.addError(tag.line, tag.col, "p10", "<head>", "frameset");
        }
        this.hasHead = true;
        return true;
    }

    private boolean checkBodyTag(Tag tag) {
        if (this.pushedHtml <= 0) {
            this.putBack(tag, "html", true);
            return false;
        }
        if (this.pushedFrameset > 0 && this.pushedNoframes <= 0) {
            this.putBack(tag, "noframes", true);
            return false;
        }
        if (this.hasBody || this.pushedBody > 0) {
            this.addError(tag.line, tag.col, "p9", "<body>");
        } else if (this.hasFrameset || this.pushedFrameset > 0) {
            this.addError(tag.line, tag.col, "p10", "<body>", "frameset");
        }
        if (this.pushedFrameset < 0) {
            this.hasBody = true;
        }
        return true;
    }

    private boolean checkFramesetTag(Tag tag) {
        if (this.pushedHtml <= 0) {
            this.putBack(tag, "html", true);
            return false;
        }
        if (this.hasFrameset) {
            this.addError(tag.line, tag.col, "p9", "<frameset>");
        } else if (this.hasBody) {
            this.addError(tag.line, tag.col, "p10", "<frameset>", "body");
        }
        return true;
    }

    private boolean checkOrphans(Tag tag) throws HtmlException {
        switch (tag.id) {
            case 71: {
                if (this.pushedMap <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "map");
                    this.putBack(tag, "map", true);
                    return false;
                }
                return true;
            }
            case 72: 
            case 79: 
            case 1026: 
            case 1038: 
            case 1039: 
            case 1040: {
                if (this.pushedTable <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "table");
                    this.putBack(tag, "table", true);
                    return false;
                }
                return true;
            }
            case 1027: {
                if (this.pushedColgroup <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "colgroup");
                    this.putBack(tag, "colgroup", true);
                    return false;
                }
                return true;
            }
            case 69: 
            case 70: {
                if (this.pushedDl <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "dl");
                    this.putBack(tag, "dl", true);
                    return false;
                }
                return true;
            }
            case 68: {
                if (this.pushedList <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "ul");
                    this.putBack(tag, "ul", true);
                    return false;
                }
                return true;
            }
            case 75: {
                if (this.pushedExternal <= 0) {
                    this.addError(tag.line, tag.col, "p7", tag.getTagName(), "applet");
                    return false;
                }
                return true;
            }
            case 65: 
            case 66: {
                if (this.pushedForm <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "form");
                    this.putBack(tag, "form", true);
                    return false;
                }
                return true;
            }
            case 67: {
                if (this.pushedForm <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "form");
                    this.putBack(tag, "form", true);
                    return false;
                }
                return true;
            }
            case 74: {
                if (this.pushedSelect <= 0) {
                    if (this.pushedForm <= 0) {
                        this.addError(tag.line, tag.col, "p6", tag.getTagName(), "form");
                        this.putBack(tag, "form", true);
                        return false;
                    }
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "select");
                    this.putBack(tag, "select", true);
                    return false;
                }
                return true;
            }
            case 77: 
            case 78: {
                if (this.pushedTr <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "tr");
                    this.putBack(tag, "tr", true);
                    return false;
                }
                return true;
            }
            case 34: {
                if (this.pushedEmbed <= 0) {
                    this.addError(tag.line, tag.col, "p6", tag.getTagName(), "embed");
                    this.putBack(tag, "embed", true);
                    return false;
                }
                return true;
            }
            case 4: 
            case 31: 
            case 32: 
            case 76: {
                if (this.pushedBody <= 0) {
                    this.putBack(tag, "body", true);
                    return false;
                }
                this.stack.add(tag, this);
                if (this.stack != (TagContainer)tag) {
                    return false;
                }
                try {
                    Tag tag2 = this.parseLiteralTag(tag.name);
                    this.stack.addTag(tag2, this);
                    Tag tag3 = this.parseTag();
                    if (tag3 != null) {
                        this.stack.close(tag3, this);
                    } else {
                        this.forceCloseStackTag(null);
                    }
                    return false;
                }
                catch (IOException iOException) {
                    throw new HtmlException("p6");
                }
            }
            case 10: {
                return this.checkTitle(tag);
            }
            case 13: 
            case 14: {
                return this.checkScriptOrStyle(tag);
            }
        }
        return true;
    }

    private boolean checkTitle(Tag tag) throws HtmlException {
        if (this.pushedHead <= 0) {
            this.putBack(tag, "head", true);
            return false;
        }
        this.stack.add(tag, this);
        if (this.stack != (TagContainer)tag) {
            return false;
        }
        while (true) {
            Tag tag2;
            if ((tag2 = this.getTitleTag()) == null) {
                this.addCorrector(tag2);
                return false;
            }
            if (tag2.id == 6) {
                this.stack.addTag(tag2, this);
                continue;
            }
            if (tag2.id == 2) {
                if (this.wrapper.doctype != null) {
                    this.addError(tag2.line, tag2.col, "p2");
                    continue;
                }
                this.wrapper.doctype = tag2;
                this.addError(tag2.line, tag2.col, "p3");
                continue;
            }
            if (tag2.id == 3) {
                Document document = this.wrapper;
                document.comments.add(tag2);
                this.setChanged();
                this.notifyObservers(tag);
                continue;
            }
            if (!tag2.opening) {
                if (this.stack.onStackId(tag2.id)) {
                    this.addCorrector(tag2);
                    return false;
                }
                if (!tag2.hasEndMarkup()) {
                    this.addError(tag2.line, tag2.col, "p4", tag2.getTagClosingName());
                    continue;
                }
                this.addError(tag2.line, tag2.col, "t2", tag2.getTagClosingName(), tag.getTagOpeningName());
                continue;
            }
            if ((tag2.entity & 4) == 4 || (tag2.entity & 0x3FF8) == 0 || this.stack.inExclusion(tag2)) {
                this.forceCloseStackTag(tag2);
                return false;
            }
            this.addError(tag2.line, tag2.col, "t2", tag2.getTagName(), tag.getTagOpeningName());
        }
    }

    private boolean checkScriptOrStyle(Tag tag) throws HtmlException {
        if (tag.id == 14) {
            if (this.pushedHead <= 0) {
                this.putBack(tag, "head", true);
                return false;
            }
        } else if (this.pushedHead <= 0 && this.pushedBody <= 0) {
            if (this.hasHead) {
                this.putBack(tag, "body", true);
            } else {
                this.putBack(tag, "head", true);
            }
            return false;
        }
        this.stack.add(tag, this);
        if (this.stack != (TagContainer)tag) {
            return false;
        }
        try {
            Tag tag2;
            while (true) {
                if ((tag2 = this.parseCDATATag()) == null) {
                    this.addCorrector(tag2);
                    return false;
                }
                if (tag2.id == 5) {
                    this.stack.addTag(tag2, this);
                    continue;
                }
                if (this.validCloseTag(tag2)) break;
            }
            this.addCorrector(tag2);
            return false;
        }
        catch (IOException iOException) {
            throw new HtmlException("p6");
        }
    }

    public final TagContainer tos() {
        return this.stack;
    }

    public final void push(TagContainer tagContainer) {
        tagContainer.parent = this.stack;
        this.stack = tagContainer;
        switch (tagContainer.id) {
            case 7: {
                ++this.pushedHtml;
                break;
            }
            case 8: {
                ++this.pushedHead;
                break;
            }
            case 9: {
                ++this.pushedBody;
                break;
            }
            case 30: {
                ++this.pushedPre;
                break;
            }
            case 1032: {
                ++this.pushedNoframes;
                break;
            }
            case 47: {
                ++this.pushedMap;
                break;
            }
            case 40: {
                ++this.pushedTable;
                break;
            }
            case 1026: {
                ++this.pushedColgroup;
                break;
            }
            case 29: {
                ++this.pushedDl;
                break;
            }
            case 38: {
                ++this.pushedForm;
                break;
            }
            case 66: {
                ++this.pushedSelect;
                break;
            }
            case 79: {
                ++this.pushedTr;
                break;
            }
            case 33: {
                ++this.pushedEmbed;
                break;
            }
            case 1029: {
                ++this.pushedFrameset;
            }
        }
        switch (tagContainer.entity) {
            case 8: {
                ++this.pushedHeading;
                return;
            }
            case 32: {
                ++this.pushedList;
                return;
            }
            case 256: {
                ++this.pushedExternal;
                return;
            }
        }
    }

    public final void pop() {
        switch (this.stack.id) {
            case 7: {
                --this.pushedHtml;
                break;
            }
            case 8: {
                --this.pushedHead;
                break;
            }
            case 9: {
                --this.pushedBody;
                break;
            }
            case 30: {
                --this.pushedPre;
                break;
            }
            case 1032: {
                --this.pushedNoframes;
                break;
            }
            case 47: {
                --this.pushedMap;
                break;
            }
            case 40: {
                --this.pushedTable;
                break;
            }
            case 1026: {
                --this.pushedColgroup;
                break;
            }
            case 29: {
                --this.pushedDl;
                break;
            }
            case 38: {
                --this.pushedForm;
                break;
            }
            case 66: {
                --this.pushedSelect;
                break;
            }
            case 79: {
                --this.pushedTr;
                break;
            }
            case 33: {
                --this.pushedEmbed;
                break;
            }
            case 1029: {
                --this.pushedFrameset;
            }
        }
        switch (this.stack.entity) {
            case 8: {
                --this.pushedHeading;
                break;
            }
            case 32: {
                --this.pushedList;
                break;
            }
            case 256: {
                --this.pushedExternal;
            }
        }
        if (this.stack.correctorIndex > 0) {
            this.putBack(this.stack.corrector, this.stack.correctorIndex);
            this.stack.corrector = null;
            this.stack.correctorSize = 0;
            this.stack.correctorIndex = 0;
        }
        if (this.stack.parent != null) {
            this.stack = this.stack.parent;
        }
    }

    public final void putBack(Tag tag) {
        this.addCorrector(tag);
    }

    public final void putBack(Tag tag, Tag tag2) {
        this.addCorrector(tag2);
        this.addCorrector(tag);
    }

    public final void putBack(Tag tag, String string) {
        this.putBack(tag, string, true);
    }

    public final void putBack(Tag tag, String string, boolean bl) {
        this.addCorrector(tag);
        Tag tag2 = this.construct(string, bl, true);
        tag2.line = tag.line;
        tag2.col = tag.col;
        this.addCorrector(tag2);
    }

    private final void putBack(Tag[] tagArray, int n) {
        if (this.correctorIndex + n >= this.correctorSize) {
            this.correctorSize += n;
            Tag[] tagArray2 = new Tag[this.correctorSize];
            System.arraycopy(this.corrector, 0, tagArray2, 0, this.correctorIndex);
            this.corrector = tagArray2;
        }
        System.arraycopy(tagArray, 0, this.corrector, this.correctorIndex, n);
        this.correctorIndex += n;
    }

    public final void tellObservers(Tag tag) {
        if (tag.id == 6 || tag.id == 5) {
            this.lastTextTag = (Text)tag;
            this.lastTag = null;
        } else if (tag.isTextBreak()) {
            this.textSinceLastBreak = false;
            if (this.lastTextTag != null) {
                int n = this.lastTextTag.textEnd;
                int n2 = this.lastTextTag.textStart;
                if (n > n2) {
                    int n3 = 10;
                    block3: while (n > n2) {
                        n3 = this.text[--n];
                        switch (n3) {
                            case 9: 
                            case 12: 
                            case 32: {
                                if (n > n2) continue block3;
                                --n;
                                continue block3;
                            }
                        }
                    }
                    ++n;
                    if (n3 != 10) {
                        this.text[n++] = 10;
                    }
                }
                this.lastTextTag.textEnd = this.textIndex = n;
                if (n <= n2) {
                    this.lastTextTag.ignore = true;
                }
            }
            this.lastTextTag = null;
            this.lastTag = tag;
        } else {
            this.lastTag = tag;
        }
        this.setChanged();
        this.notifyObservers(tag);
    }

    private final void addCorrector(Tag tag) {
        if (this.correctorIndex >= this.correctorSize) {
            this.correctorSize += 10;
            Tag[] tagArray = new Tag[this.correctorSize];
            System.arraycopy(this.corrector, 0, tagArray, 0, this.correctorIndex);
            this.corrector = tagArray;
        }
        this.corrector[this.correctorIndex++] = tag;
    }

    private final Tag getTag() throws HtmlException {
        try {
            Tag tag = this.correctorIndex == 0 ? this.parseTag() : this.corrector[--this.correctorIndex];
            if (tag == null) {
                return null;
            }
            if (tag.deprecated) {
                this.hasDeprecated = true;
            }
            if (tag.id >= 1024) {
                this.hasExtensions = true;
            } else if (tag.id == 0) {
                this.hasUnknown = true;
            }
            return tag;
        }
        catch (IOException iOException) {
            throw new HtmlException("p6");
        }
    }

    private final Tag getTitleTag() throws HtmlException {
        try {
            Tag tag = this.correctorIndex == 0 ? this.parseTag() : this.corrector[--this.correctorIndex];
            return tag;
        }
        catch (IOException iOException) {
            throw new HtmlException("p6");
        }
    }

    public void addError(int n, int n2, String string) {
        if (this.err != null) {
            String string2 = this.err.getMessage(string);
            this.err.add(new HtmlErrorMessage(n, n2, string2));
        }
    }

    public void addError(int n, int n2, String string, String string2) {
        if (this.err != null) {
            String string3 = this.err.getMessage(string);
            this.err.add(new HtmlErrorMessage(n, n2, string3, string2));
        }
    }

    public void addError(int n, int n2, String string, String string2, String string3) {
        if (this.err != null) {
            String string4 = this.err.getMessage(string);
            this.err.add(new HtmlErrorMessage(n, n2, string4, string2, string3));
        }
    }

    public void addError(int n, int n2, String string, String string2, String string3, String string4) {
        if (this.err != null) {
            String string5 = this.err.getMessage(string);
            this.err.add(new HtmlErrorMessage(n, n2, string5, string2, string3, string4));
        }
    }

    private static void lexInit() {
        htAmpChar = new Hashtable(256);
        entity = new AmpChar[256];
        new AmpChar("amp", 38, htAmpChar, entity);
        new AmpChar("lt", 60, htAmpChar, entity);
        new AmpChar("gt", 62, htAmpChar, entity);
        new AmpChar("quot", 34, htAmpChar, entity);
        new AmpChar("nbsp", 160, htAmpChar, entity);
        new AmpChar("iexcl", 161, htAmpChar, entity);
        new AmpChar("cent", 162, htAmpChar, entity);
        new AmpChar("pound", 163, htAmpChar, entity);
        new AmpChar("curren", 164, htAmpChar, entity);
        new AmpChar("yen", 165, htAmpChar, entity);
        new AmpChar("brvbar", 166, htAmpChar, entity);
        new AmpChar("brkbar", 166, htAmpChar, entity);
        new AmpChar("sect", 167, htAmpChar, entity);
        new AmpChar("die", 168, htAmpChar, entity);
        new AmpChar("uml", 168, htAmpChar, entity);
        new AmpChar("copy", 169, htAmpChar, entity);
        new AmpChar("ordf", 170, htAmpChar, entity);
        new AmpChar("laquo", 171, htAmpChar, entity);
        new AmpChar("not", 172, htAmpChar, entity);
        new AmpChar("shy", 173, htAmpChar, entity);
        new AmpChar("reg", 174, htAmpChar, entity);
        new AmpChar("hibar", 175, htAmpChar, entity);
        new AmpChar("macr", 175, htAmpChar, entity);
        new AmpChar("deg", 176, htAmpChar, entity);
        new AmpChar("plusmn", 177, htAmpChar, entity);
        new AmpChar("sup2", 178, htAmpChar, entity);
        new AmpChar("sup3", 179, htAmpChar, entity);
        new AmpChar("acute", 180, htAmpChar, entity);
        new AmpChar("micro", 181, htAmpChar, entity);
        new AmpChar("para", 182, htAmpChar, entity);
        new AmpChar("middot", 183, htAmpChar, entity);
        new AmpChar("cedil", 184, htAmpChar, entity);
        new AmpChar("sup1", 185, htAmpChar, entity);
        new AmpChar("ordm", 186, htAmpChar, entity);
        new AmpChar("raquo", 187, htAmpChar, entity);
        new AmpChar("frac14", 188, htAmpChar, entity);
        new AmpChar("frac12", 189, htAmpChar, entity);
        new AmpChar("frac34", 190, htAmpChar, entity);
        new AmpChar("iquest", 191, htAmpChar, entity);
        new AmpChar("Agrave", 192, htAmpChar, entity);
        new AmpChar("Aacute", 193, htAmpChar, entity);
        new AmpChar("Acirc", 194, htAmpChar, entity);
        new AmpChar("Atilde", 195, htAmpChar, entity);
        new AmpChar("Auml", 196, htAmpChar, entity);
        new AmpChar("Aring", 197, htAmpChar, entity);
        new AmpChar("AElig", 198, htAmpChar, entity);
        new AmpChar("Ccedil", 199, htAmpChar, entity);
        new AmpChar("Egrave", 200, htAmpChar, entity);
        new AmpChar("Eacute", 201, htAmpChar, entity);
        new AmpChar("Ecirc", 202, htAmpChar, entity);
        new AmpChar("Euml", 203, htAmpChar, entity);
        new AmpChar("Igrave", 204, htAmpChar, entity);
        new AmpChar("Iacute", 205, htAmpChar, entity);
        new AmpChar("Icirc", 206, htAmpChar, entity);
        new AmpChar("Iuml", 207, htAmpChar, entity);
        new AmpChar("ETH", 208, htAmpChar, entity);
        new AmpChar("Ntilde", 209, htAmpChar, entity);
        new AmpChar("Ograve", 210, htAmpChar, entity);
        new AmpChar("Oacute", 211, htAmpChar, entity);
        new AmpChar("Ocirc", 212, htAmpChar, entity);
        new AmpChar("Otilde", 213, htAmpChar, entity);
        new AmpChar("Ouml", 214, htAmpChar, entity);
        new AmpChar("times", 215, htAmpChar, entity);
        new AmpChar("Oslash", 216, htAmpChar, entity);
        new AmpChar("Ugrave", 217, htAmpChar, entity);
        new AmpChar("Uacute", 218, htAmpChar, entity);
        new AmpChar("Ucirc", 219, htAmpChar, entity);
        new AmpChar("Uuml", 220, htAmpChar, entity);
        new AmpChar("Yacute", 221, htAmpChar, entity);
        new AmpChar("THORN", 222, htAmpChar, entity);
        new AmpChar("szlig", 223, htAmpChar, entity);
        new AmpChar("agrave", 224, htAmpChar, entity);
        new AmpChar("aacute", 225, htAmpChar, entity);
        new AmpChar("acirc", 226, htAmpChar, entity);
        new AmpChar("atilde", 227, htAmpChar, entity);
        new AmpChar("auml", 228, htAmpChar, entity);
        new AmpChar("aring", 229, htAmpChar, entity);
        new AmpChar("aelig", 230, htAmpChar, entity);
        new AmpChar("ccedil", 231, htAmpChar, entity);
        new AmpChar("egrave", 232, htAmpChar, entity);
        new AmpChar("eacute", 233, htAmpChar, entity);
        new AmpChar("ecirc", 234, htAmpChar, entity);
        new AmpChar("euml", 235, htAmpChar, entity);
        new AmpChar("igrave", 236, htAmpChar, entity);
        new AmpChar("iacute", 237, htAmpChar, entity);
        new AmpChar("icirc", 238, htAmpChar, entity);
        new AmpChar("iuml", 239, htAmpChar, entity);
        new AmpChar("eth", 240, htAmpChar, entity);
        new AmpChar("ntilde", 241, htAmpChar, entity);
        new AmpChar("ograve", 242, htAmpChar, entity);
        new AmpChar("oacute", 243, htAmpChar, entity);
        new AmpChar("ocirc", 244, htAmpChar, entity);
        new AmpChar("otilde", 245, htAmpChar, entity);
        new AmpChar("ouml", 246, htAmpChar, entity);
        new AmpChar("divide", 247, htAmpChar, entity);
        new AmpChar("oslash", 248, htAmpChar, entity);
        new AmpChar("ugrave", 249, htAmpChar, entity);
        new AmpChar("uacute", 250, htAmpChar, entity);
        new AmpChar("ucirc", 251, htAmpChar, entity);
        new AmpChar("uuml", 252, htAmpChar, entity);
        new AmpChar("yacute", 253, htAmpChar, entity);
        new AmpChar("thorn", 254, htAmpChar, entity);
        new AmpChar("yuml", 255, htAmpChar, entity);
    }

    private void connect(InputStream inputStream) throws IOException {
        this.connect(inputStream, null);
    }

    private void connect(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (this.in != null) {
            this.disconnect();
        }
        this.in = new InputStreamReader(inputStream);
        this.out = outputStream != null ? new OutputStreamWriter(outputStream) : null;
        this.col = 1;
        this.line = 1;
        this.textIndex = 0;
        this.charsSize = 0;
        this.readIndex = 0;
        this.writeIndex = 0;
        this.textSize = 1024;
        this.charBlockSize = 1024;
        this.chars = new char[this.charBlockSize];
        this.text = new char[this.charBlockSize];
        this.superRetaining = false;
        this.retaining = false;
        this.charsRead = 0L;
    }

    private void disconnect() throws IOException {
        this.in.close();
        this.in = null;
        if (this.out != null) {
            this.out.close();
        }
        this.chars = null;
        this.writeIndex = -1;
    }

    public synchronized long getCharsRead() {
        return this.charsRead;
    }

    /*
     * Unable to fully structure code
     */
    public String parseString(int var1_1, int var2_2, String var3_3) {
        if (var3_3 == null || (var4_4 = var3_3.length()) <= 0) {
            return "";
        }
        var5_5 = new StringBuffer(var4_4);
        var6_6 = 0;
        while (var6_6 < var4_4) {
            var7_7 = var3_3.charAt(var6_6);
            switch (var7_7) {
                case 9: 
                case 12: {
                    var7_7 = 32;
                    ** GOTO lbl77
                }
                case 38: {
                    var8_8 = var6_6;
                    var9_9 = var6_6 + 1;
                    if (var9_9 < var4_4) {
                        var10_10 = var3_3.charAt(var9_9);
                        if (var10_10 == '#') {
                            if (++var9_9 >= var4_4) {
                                var5_5.append(var3_3.substring(var6_6, var9_9));
                                var6_6 = var9_9 - 1;
                                break;
                            }
                            var11_11 = 0;
                            var10_10 = var3_3.charAt(var9_9);
                            if (var10_10 >= '0' && var10_10 <= '9') {
                                while (var10_10 >= '0' && var10_10 <= '9') {
                                    var11_11 *= 10;
                                    if ((var11_11 += var10_10 - 48) > 65535) {
                                        var11_11 = 65536;
                                    }
                                    if (++var9_9 >= var4_4) {
                                        var5_5.append(var3_3.substring(var6_6, var9_9));
                                        var6_6 = var9_9 - 1;
                                        continue;
                                    }
                                    var10_10 = var3_3.charAt(var9_9);
                                }
                                if (var10_10 == ';') {
                                    ++var9_9;
                                }
                                if (var11_11 > 65535) {
                                    this.addError(var1_1, var2_2 + var8_8, "l13");
                                    var6_6 = var9_9 - 1;
                                    break;
                                }
                                if (var10_10 != ';') {
                                    this.addError(var1_1, var2_2 + var9_9, "l14");
                                }
                                var6_6 = var9_9 - 1;
                                var5_5.append((char)var11_11);
                                break;
                            }
                            var5_5.append(var3_3.substring(var6_6, var9_9));
                            var6_6 = var9_9 - 1;
                            break;
                        }
                        if (var10_10 >= 'A' && var10_10 <= 'Z' || var10_10 >= 'a' && var10_10 <= 'z') {
                            var11_12 = new StringBuffer();
                            while (var10_10 >= 'A' && var10_10 <= 'Z' || var10_10 >= 'a' && var10_10 <= 'z') {
                                var11_12.append(var10_10);
                                if (++var9_9 >= var4_4) {
                                    var5_5.append(var3_3.substring(var6_6, var9_9));
                                    var6_6 = var9_9 - 1;
                                    continue;
                                }
                                var10_10 = var3_3.charAt(var9_9);
                            }
                            var12_13 = (AmpChar)Parser.htAmpChar.get(var11_12.toString());
                            if (var10_10 == ';') {
                                ++var9_9;
                            }
                            if (var12_13 == null) {
                                this.addError(var1_1, var2_2 + var8_8, "l15", var11_12.toString());
                                var6_6 = var9_9 - 1;
                                break;
                            }
                            if (var10_10 != ';') {
                                this.addError(var1_1, var2_2 + var9_9, "l16");
                            }
                            var6_6 = var9_9 - 1;
                            var5_5.append(var12_13.value);
                            break;
                        }
                    }
                }
lbl77:
                // 6 sources

                default: {
                    var5_5.append((char)var7_7);
                }
            }
            ++var6_6;
        }
        return var5_5.toString();
    }

    private int get() throws IOException {
        if (this.writeIndex < 0) {
            return -1;
        }
        if (this.readIndex < this.writeIndex) {
            return this.chars[this.readIndex++];
        }
        if (!this.superRetaining && !this.retaining) {
            this.readIndex = 0;
            this.writeIndex = this.in.read(this.chars, 0, this.charBlockSize);
            if (this.writeIndex > 0) {
                if (this.out != null) {
                    this.out.write(this.chars, 0, this.writeIndex);
                }
                this.charsRead += (long)this.writeIndex;
                this.charsSize = this.writeIndex;
            }
        } else {
            char[] cArray = new char[this.charBlockSize];
            this.writeIndex = this.in.read(cArray, 0, this.charBlockSize);
            if (this.writeIndex > 0) {
                this.charsRead += (long)this.writeIndex;
                if (this.out != null) {
                    this.out.write(cArray, 0, this.writeIndex);
                }
                if (this.chars.length < this.charsSize + this.writeIndex) {
                    char[] cArray2 = new char[this.charsSize + this.writeIndex];
                    System.arraycopy(this.chars, 0, cArray2, 0, this.charsSize);
                    this.chars = cArray2;
                }
                System.arraycopy(cArray, 0, this.chars, this.charsSize, this.writeIndex);
                this.charsSize += this.writeIndex;
                this.writeIndex = this.charsSize;
            }
        }
        if (this.readIndex < this.writeIndex) {
            return this.chars[this.readIndex++];
        }
        return -1;
    }

    private int getChar() throws IOException {
        int n = this.get();
        if (n == 13) {
            n = this.get();
            if (n != 10 && this.writeIndex >= 0) {
                --this.readIndex;
            }
            ++this.line;
            this.col = 0;
            n = 10;
        } else if (n == 10) {
            n = this.get();
            if (n != 13 && this.writeIndex >= 0) {
                --this.readIndex;
            }
            ++this.line;
            this.col = 0;
            n = 10;
        }
        return n;
    }

    private void put() {
        if (this.writeIndex < 0) {
            return;
        }
        --this.readIndex;
    }

    private void putChar(int n) {
        if (this.textIndex >= this.textSize) {
            this.textSize += this.charBlockSize;
            char[] cArray = new char[this.textSize];
            System.arraycopy(this.text, 0, cArray, 0, this.textIndex);
            this.text = cArray;
        }
        this.text[this.textIndex++] = (char)n;
    }

    private void retain() {
        this.retainedReadIndex = this.readIndex;
        this.retainedLine = this.line;
        this.retainedCol = this.col;
        this.retainedIndex = this.textIndex;
        this.retaining = true;
    }

    private void release(boolean bl) {
        if (bl) {
            this.readIndex = this.retainedReadIndex;
            this.line = this.retainedLine;
            this.col = this.retainedCol;
            this.textIndex = this.retainedIndex;
            this.writeIndex = this.charsSize;
        }
        this.retaining = false;
    }

    private boolean isLetter(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122;
    }

    private boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    private boolean isName(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 46 || n == 45;
    }

    private Tag parseLiteralTag(String string) throws IOException {
        this.wasWhite = false;
        this.textSinceLastBreak = false;
        int n = this.line;
        int n2 = this.col;
        int n3 = this.textIndex;
        while (true) {
            int n4 = this.getChar();
            ++this.col;
            switch (n4) {
                case -1: {
                    --this.col;
                    Text text = new Text();
                    text.line = n;
                    text.col = n2;
                    text.textStart = n3;
                    text.textEnd = this.textIndex;
                    this.lastTextTag = text;
                    return this.lastTextTag;
                }
                case 60: {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    this.retain();
                    n4 = this.get();
                    if (this.get() == 47) {
                        n4 = this.get();
                        int n5 = this.textIndex;
                        while (n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122) {
                            this.putChar(n4);
                            n4 = this.get();
                        }
                        if (this.textIndex > n5 && string.equals(new String(this.text, n5, this.textIndex - n5).toLowerCase())) {
                            this.release(true);
                            Text text = new Text();
                            text.line = n;
                            text.col = n2;
                            text.textStart = n3;
                            text.textEnd = this.textIndex;
                            this.lastTextTag = text;
                            return this.lastTextTag;
                        }
                    }
                    this.release(true);
                    n4 = this.getChar();
                    ++this.col;
                }
            }
            this.putChar(n4);
        }
    }

    private Tag parseCDATATag() throws IOException {
        this.wasWhite = false;
        this.textSinceLastBreak = false;
        this.lastTextTag = null;
        int n = this.line;
        int n2 = this.col;
        int n3 = this.textIndex;
        while (true) {
            int n4 = this.getChar();
            ++this.col;
            switch (n4) {
                case -1: {
                    --this.col;
                    if (this.textIndex > n3) {
                        Text text = new Text();
                        text.id = 5;
                        text.line = n;
                        text.col = n2;
                        text.textStart = n3;
                        text.textEnd = this.textIndex;
                        return text;
                    }
                    return null;
                }
                case 60: {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    this.retain();
                    n4 = this.get();
                    n4 = this.get();
                    if (n4 == 47 && ((n4 = this.get()) >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122)) {
                        this.release(true);
                        if (this.textIndex > n3) {
                            Text text = new Text();
                            text.id = 5;
                            text.line = n;
                            text.col = n2;
                            text.textStart = n3;
                            text.textEnd = this.textIndex;
                            return text;
                        }
                        return this.parseHtmlEndMarkup();
                    }
                    this.release(true);
                    n4 = this.getChar();
                    ++this.col;
                }
            }
            this.putChar(n4);
        }
    }

    private Tag parseTag() throws IOException {
        int n = this.line;
        int n2 = this.col;
        int n3 = this.textIndex;
        block9: while (true) {
            int n4 = this.getChar();
            ++this.col;
            switch (n4) {
                case -1: {
                    --this.col;
                    if (this.textIndex > n3) {
                        Text text = new Text();
                        text.line = n;
                        text.col = n2;
                        text.textStart = n3;
                        text.textEnd = this.textIndex;
                        return text;
                    }
                    return null;
                }
                case 10: {
                    if (this.pushedPre <= 0) {
                        n4 = 32;
                        if (!this.textSinceLastBreak || this.wasWhite) continue block9;
                    }
                    this.wasWhite = true;
                    break;
                }
                case 9: {
                    this.col += (this.col + 8) % 8;
                }
                case 12: {
                    if (this.pushedPre <= 0) {
                        n4 = 32;
                    }
                }
                case 32: {
                    if (this.pushedPre <= 0 && (!this.textSinceLastBreak || this.wasWhite)) continue block9;
                    this.wasWhite = true;
                    break;
                }
                case 38: {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    this.parseAmpEntity();
                    this.wasWhite = false;
                    this.textSinceLastBreak = true;
                    continue block9;
                }
                case 60: {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    this.retain();
                    n4 = this.get();
                    n4 = this.get();
                    if (n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122) {
                        this.release(true);
                        if (this.textIndex > n3) {
                            Text text = new Text();
                            text.line = n;
                            text.col = n2;
                            text.textStart = n3;
                            text.textEnd = this.textIndex;
                            return text;
                        }
                        return this.parseHtmlMarkup();
                    }
                    if (n4 == 33) {
                        n4 = this.get();
                        this.release(true);
                        if (this.textIndex > n3) {
                            Text text = new Text();
                            text.line = n;
                            text.col = n2;
                            text.textStart = n3;
                            text.textEnd = this.textIndex;
                            return text;
                        }
                        if (!(n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122)) {
                            return this.parseSgmlComment();
                        }
                        return this.parseSgmlDeclaration();
                    }
                    if (n4 == 47 && ((n4 = this.get()) >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122)) {
                        this.release(true);
                        if (this.textIndex > n3) {
                            Text text = new Text();
                            text.line = n;
                            text.col = n2;
                            text.textStart = n3;
                            text.textEnd = this.textIndex;
                            return text;
                        }
                        return this.parseHtmlEndMarkup();
                    }
                    this.release(true);
                    n4 = this.getChar();
                    ++this.col;
                }
                default: {
                    this.wasWhite = false;
                }
            }
            this.textSinceLastBreak = true;
            this.putChar(n4);
        }
    }

    private void parseAmpEntity() throws IOException {
        int n = this.line;
        int n2 = this.col++;
        int n3 = this.textIndex;
        int n4 = this.getChar();
        this.putChar(n4);
        n4 = this.get();
        if (n4 == 35) {
            ++this.col;
            this.putChar(n4);
            n4 = this.get();
            int n5 = 0;
            if (n4 >= 48 && n4 <= 57) {
                while (n4 >= 48 && n4 <= 57) {
                    this.putChar(n4);
                    n5 *= 10;
                    if ((n5 += n4 - 48) > 65535) {
                        n5 = 65536;
                    }
                    ++this.col;
                    n4 = this.get();
                }
                if (n4 == 59) {
                    ++this.col;
                    this.putChar(n4);
                } else if (this.writeIndex >= 0) {
                    --this.readIndex;
                }
                if (n5 > 65535) {
                    this.addError(n, n2, "l13");
                    return;
                }
                this.textIndex = n3;
                this.putChar(n5);
                if (n4 != 59) {
                    this.addError(this.line, this.col, "l14");
                }
                return;
            }
            if (this.writeIndex >= 0) {
                --this.readIndex;
            }
            return;
        }
        if (n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122) {
            while (n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122) {
                this.putChar(n4);
                ++this.col;
                n4 = this.get();
            }
            AmpChar ampChar = (AmpChar)htAmpChar.get(new String(this.text, n3 + 1, this.textIndex - n3 - 1));
            if (n4 == 59) {
                ++this.col;
                this.putChar(n4);
            } else if (this.writeIndex >= 0) {
                --this.readIndex;
            }
            if (ampChar == null) {
                this.addError(n, n2, "l15", new String(this.text, n3 + 1, this.textIndex - n3 - 1));
                return;
            }
            this.textIndex = n3;
            this.putChar(ampChar.value);
            if (n4 != 59) {
                this.addError(this.line, this.col, "l16");
            }
            return;
        }
        if (this.writeIndex >= 0) {
            --this.readIndex;
        }
    }

    private Tag parseSgmlComment() throws IOException {
        int n = this.line;
        int n2 = this.col++;
        int n3 = this.textIndex;
        int n4 = this.getChar();
        this.putChar(n4);
        n4 = this.getChar();
        ++this.col;
        this.putChar(n4);
        n4 = this.getChar();
        ++this.col;
        if (n4 < 0 || n4 == 60 || n4 == 62) {
            if (n4 != 62) {
                --this.col;
                if (this.writeIndex >= 0) {
                    --this.readIndex;
                }
                this.addError(this.line, this.col, "l1");
            }
            this.putChar(62);
            Sgml sgml = new Sgml("!-- --", 3);
            sgml.line = n;
            sgml.col = n2;
            sgml.textStart = n3;
            sgml.statement = new String(this.text, n3, this.textIndex - n3);
            this.textIndex = n3;
            return sgml;
        }
        if (n4 != 45) {
            this.addError(n, n2, "l3");
            this.putChar(45);
            this.putChar(45);
            this.putChar(n4);
        } else {
            this.putChar(n4);
            n4 = this.getChar();
            ++this.col;
            if (n4 != 45) {
                this.addError(n, n2, "l3");
                this.putChar(45);
                if (n4 >= 0) {
                    this.putChar(n4);
                } else {
                    --this.col;
                }
            } else {
                n4 = 32;
            }
        }
        boolean bl = false;
        block8: while (true) {
            int n5 = n4;
            n4 = this.getChar();
            ++this.col;
            switch (n4) {
                case -1: {
                    if (this.retaining) {
                        this.release(true);
                        this.addError(this.line, this.col, "l3");
                        n4 = this.text[this.textIndex];
                        if (n4 == 62) {
                            this.getChar();
                            ++this.col;
                        }
                    } else {
                        --this.col;
                        this.addError(this.line, this.col, "l2");
                    }
                    this.putChar(32);
                    this.putChar(45);
                    this.putChar(45);
                    this.putChar(62);
                    Sgml sgml = new Sgml("!-- --", 3);
                    sgml.line = n;
                    sgml.col = n2;
                    sgml.textStart = n3;
                    sgml.statement = new String(this.text, n3, this.textIndex - n3);
                    this.textIndex = n3;
                    return sgml;
                }
                case 45: {
                    this.putChar(n4);
                    if (n5 == 45) {
                        bl = true;
                        n4 = 32;
                        continue block8;
                    }
                    bl = false;
                    continue block8;
                }
                case 9: {
                    this.col += (this.col + 8) % 8;
                }
                case 10: 
                case 12: 
                case 32: {
                    this.putChar(n4);
                    continue block8;
                }
                case 62: {
                    if (bl) {
                        this.putChar(n4);
                        if (this.retaining) {
                            this.release(false);
                        }
                        Sgml sgml = new Sgml("!-- --", 3);
                        sgml.line = n;
                        sgml.col = n2;
                        sgml.textStart = n3;
                        sgml.statement = new String(this.text, n3, this.textIndex - n3);
                        this.textIndex = n3;
                        return sgml;
                    }
                }
                case 60: {
                    if (this.retaining) break;
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    this.retain();
                    this.getChar();
                    ++this.col;
                }
            }
            this.putChar(n4);
            bl = false;
        }
    }

    private Tag parseSgmlDeclaration() throws IOException {
        int n = this.line;
        int n2 = this.col++;
        int n3 = this.textIndex;
        this.retain();
        this.getChar();
        this.getChar();
        ++this.col;
        int n4 = this.get();
        while (this.isName(n4)) {
            this.putChar(n4);
            ++this.col;
            n4 = this.get();
        }
        String string = new String(this.text, n3, this.textIndex - n3).toLowerCase();
        if (!string.equals("doctype")) {
            this.release(true);
            return this.parseSgmlComment();
        }
        this.release(false);
        if (this.writeIndex >= 0) {
            --this.readIndex;
        }
        this.textIndex = n3;
        while (true) {
            n4 = this.getChar();
            ++this.col;
            switch (n4) {
                case -1: 
                case 60: 
                case 62: {
                    if (n4 != 62) {
                        --this.col;
                        if (this.writeIndex >= 0) {
                            --this.readIndex;
                        }
                        this.addError(this.line, this.col, "l1");
                    }
                    this.putChar(62);
                    Sgml sgml = new Sgml("!doctype", 2);
                    sgml.line = n;
                    sgml.col = n2;
                    sgml.textStart = n3;
                    sgml.statement = "<!doctype" + new String(this.text, n3, this.textIndex - n3);
                    this.textIndex = n3;
                    return sgml;
                }
            }
            this.putChar(n4);
        }
    }

    private Tag parseHtmlMarkup() throws IOException {
        int n = this.line;
        int n2 = this.col++;
        int n3 = this.textIndex;
        this.getChar();
        int n4 = this.get();
        while (this.isName(n4)) {
            this.putChar(n4);
            ++this.col;
            n4 = this.get();
        }
        if (this.writeIndex >= 0) {
            --this.readIndex;
        }
        Tag tag = this.construct(new String(this.text, n3, this.textIndex - n3).toLowerCase(), true, false);
        tag.line = n;
        tag.col = n2;
        this.textIndex = n3;
        block7: while (true) {
            n4 = this.getChar();
            ++this.col;
            switch (n4) {
                case 10: 
                case 12: 
                case 32: {
                    continue block7;
                }
                case 9: {
                    this.col += (this.col + 8) % 8;
                    continue block7;
                }
                case 62: {
                    this.filter.checkRequired(tag);
                    return tag;
                }
                case -1: 
                case 60: {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    this.addError(this.line, this.col, "l4");
                    this.filter.checkRequired(tag);
                    return tag;
                }
            }
            --this.col;
            if (this.writeIndex >= 0) {
                --this.readIndex;
            }
            this.parseAttribute(tag);
        }
    }

    private void parseAttribute(Tag tag) throws IOException {
        boolean bl = false;
        Attribute attribute = new Attribute();
        block9: while (true) {
            int n = this.getChar();
            ++this.col;
            switch (n) {
                case 10: 
                case 12: 
                case 32: {
                    continue block9;
                }
                case 9: {
                    this.col += (this.col + 8) % 8;
                    continue block9;
                }
                case -1: 
                case 60: 
                case 62: {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    return;
                }
            }
            if (n == 61) {
                this.addError(this.line, this.col - 1, "l5");
                this.parseAttributeValue(tag, attribute);
                return;
            }
            if (n >= 65 && n <= 90 || n >= 97 && n <= 122) {
                int n2 = this.textIndex;
                int n3 = this.line;
                int n4 = this.col - 1;
                while (this.isName(n)) {
                    this.putChar(n);
                    n = this.get();
                    ++this.col;
                }
                --this.col;
                if (this.writeIndex >= 0) {
                    --this.readIndex;
                }
                attribute.name = new String(this.text, n2, this.textIndex - n2);
                this.textIndex = n2;
                block11: while (true) {
                    n = this.getChar();
                    ++this.col;
                    switch (n) {
                        case 10: 
                        case 12: 
                        case 32: {
                            continue block11;
                        }
                        case 9: {
                            this.col += (this.col + 8) % 8;
                            continue block11;
                        }
                    }
                    break;
                }
                if (n == 61) {
                    this.parseAttributeValue(tag, attribute);
                } else {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    attribute.type = 0;
                }
                String string = attribute.name.toLowerCase();
                String string2 = string = tag.attributes == null ? null : (Attribute)tag.attributes.get(string);
                if (string != null) {
                    this.addError(n3, n4, "l6", attribute.name);
                    return;
                }
                tag.putAttr(attribute);
                return;
            }
            if (bl) continue;
            this.addError(this.line, this.col - 1, "l7");
            bl = true;
        }
    }

    private void parseAttributeValue(Tag tag, Attribute attribute) throws IOException {
        int n;
        block4: while (true) {
            n = this.getChar();
            ++this.col;
            switch (n) {
                case 10: 
                case 12: 
                case 32: {
                    continue block4;
                }
                case 9: {
                    this.col += (this.col + 8) % 8;
                    continue block4;
                }
            }
            break;
        }
        int n2 = this.line;
        int n3 = this.col - 1;
        if (n < 0 || n == 60 || n == 62 || n == 61) {
            --this.col;
            if (this.writeIndex >= 0) {
                --this.readIndex;
            }
            this.addError(this.line, this.col, "l8");
            return;
        }
        if (n == 34 || n == 39) {
            --this.col;
            if (this.writeIndex >= 0) {
                --this.readIndex;
            }
            this.parseLiteral(tag, attribute);
            return;
        }
        boolean bl = false;
        int n4 = this.textIndex;
        int n5 = 2;
        if (n >= 65 && n <= 90 || n >= 97 && n <= 122) {
            n5 = 5;
        } else if (n >= 48 && n <= 57) {
            n5 = 3;
        } else if (this.isName(n)) {
            n5 = 4;
        }
        while (n >= 0 && "<>= \t\f\r\n".indexOf(n) < 0) {
            this.putChar(n);
            if (!this.isName(n)) {
                if (!bl) {
                    this.addError(this.line, this.col - 1, "l9");
                    bl = true;
                    n5 = 2;
                }
            } else if (n5 == 3 && (n < 48 || n > 57)) {
                n5 = 4;
            }
            n = this.get();
            ++this.col;
        }
        --this.col;
        if (this.writeIndex >= 0) {
            --this.readIndex;
        }
        attribute.text = new String(this.text, n4, this.textIndex - n4);
        attribute.type = n5;
        this.textIndex = n4;
        if (attribute.name != null) {
            this.filter.checkAttribute(tag, attribute, n2, n3);
        }
    }

    private void parseLiteral(Tag tag, Attribute attribute) throws IOException {
        int n = this.line;
        int n2 = this.col;
        int n3 = this.textIndex;
        int n4 = this.getChar();
        block6: while (true) {
            int n5 = this.getChar();
            ++this.col;
            switch (n5) {
                case -1: {
                    if (this.retaining) {
                        this.release(true);
                    } else {
                        --this.col;
                    }
                    this.addError(this.line, this.col, "l10");
                    if (n3 < this.textIndex) {
                        attribute.text = new String(this.text, n3, this.textIndex - n3);
                        attribute.delim = n4;
                        attribute.type = this.getValueType(n3);
                        this.textIndex = n3;
                        if (attribute.name != null) {
                            this.filter.checkAttribute(tag, attribute, n, n2);
                            return;
                        }
                    } else {
                        this.addError(n, n2, "l11");
                    }
                    return;
                }
                case 38: {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    this.parseAmpEntity();
                    continue block6;
                }
                case 34: 
                case 39: {
                    if (n5 != n4) break;
                    if (this.retaining) {
                        this.release(false);
                    }
                    if (n3 < this.textIndex) {
                        attribute.text = new String(this.text, n3, this.textIndex - n3);
                        attribute.delim = n4;
                        attribute.type = this.getValueType(n3);
                        this.textIndex = n3;
                        if (attribute.name != null) {
                            this.filter.checkAttribute(tag, attribute, n, n2);
                            return;
                        }
                    } else {
                        this.addError(n, n2, "l11");
                    }
                    return;
                }
                case 60: 
                case 62: {
                    if (this.retaining) break;
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    this.retain();
                }
            }
            this.putChar(n5);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getValueType(int var1_1) {
        var2_2 = this.text[var1_1++];
        var3_3 = 2;
        if (var2_2 >= 'A' && var2_2 <= 'Z' || var2_2 >= 'a' && var2_2 <= 'z') {
            var3_3 = 5;
        } else if (var2_2 >= '0' && var2_2 <= '9') {
            var3_3 = 3;
        } else if (this.isName(var2_2)) {
            var3_3 = 4;
        }
        if (var3_3 != 2) ** GOTO lbl18
        return var3_3;
lbl-1000:
        // 1 sources

        {
            if (!this.isName(var2_2)) {
                return 2;
            }
            if (var3_3 == 3 && (var2_2 < '0' || var2_2 > '9')) {
                var3_3 = 4;
            }
            var2_2 = this.text[var1_1++];
lbl18:
            // 2 sources

            ** while (var1_1 < this.textIndex)
        }
lbl19:
        // 1 sources

        return var3_3;
    }

    private Tag parseHtmlEndMarkup() throws IOException {
        int n = this.line;
        int n2 = this.col++;
        int n3 = this.textIndex;
        this.getChar();
        this.getChar();
        ++this.col;
        int n4 = this.get();
        while (this.isName(n4)) {
            this.putChar(n4);
            ++this.col;
            n4 = this.get();
        }
        if (this.writeIndex >= 0) {
            --this.readIndex;
        }
        Tag tag = this.construct(new String(this.text, n3, this.textIndex - n3).toLowerCase(), false, false);
        tag.line = n;
        tag.col = n2;
        this.textIndex = n3;
        boolean bl = false;
        block7: while (true) {
            n4 = this.getChar();
            ++this.col;
            switch (n4) {
                case 10: 
                case 12: 
                case 32: {
                    continue block7;
                }
                case 9: {
                    this.col += (this.col + 8) % 8;
                    continue block7;
                }
                case 62: {
                    return tag;
                }
                case -1: 
                case 60: {
                    --this.col;
                    if (this.writeIndex >= 0) {
                        --this.readIndex;
                    }
                    if (!bl) {
                        this.addError(this.line, this.col, "l12");
                    }
                    return tag;
                }
            }
            if (bl) continue;
            this.addError(this.line, this.col - 1, "l12");
            bl = true;
        }
    }

    private static void tagInit() {
        htTags = new Hashtable();
        Tag tag = new Anchor();
        htTags.put(tag.name, tag);
        tag = new Address();
        htTags.put(tag.name, tag);
        tag = new External("applet", 43, 3984);
        htTags.put(tag.name, tag);
        tag = new Tag("area", 71, 13, 65536);
        htTags.put(tag.name, tag);
        tag = new TagContainer("b", 50, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new Tag("base", 12, 3, 2);
        htTags.put(tag.name, tag);
        tag = new Tag("basefont", 45, 13, 512);
        htTags.put(tag.name, tag);
        tag = new Tag("bgsound", 1024, 15, 516);
        htTags.put(tag.name, tag);
        tag = new TagContainer("big", 53, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("blink", 1025, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("blockquote", 37, 13, 4096, 16376);
        htTags.put(tag.name, tag);
        tag = new Body();
        htTags.put(tag.name, tag);
        tag = new Tag("br", 46, 13, 128);
        htTags.put(tag.name, tag);
        tag = new TagContainer("caption", 72, 13, 16384, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("center", 36, 13, 4096, 16376);
        htTags.put(tag.name, tag);
        tag = new TagContainer("cite", 64, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("code", 60, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new Tag("col", 1027, 13, 16384);
        htTags.put(tag.name, tag);
        tag = new ColGroup();
        htTags.put(tag.name, tag);
        tag = new TagContainer("dd", 70, 13, 65536, 8176, true);
        htTags.put(tag.name, tag);
        tag = new TagContainer("dfn", 59, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new DirList("dir", 28);
        htTags.put(tag.name, tag);
        tag = new TagContainer("div", 35, 13, 4096, 16376);
        htTags.put(tag.name, tag);
        tag = new DescList();
        htTags.put(tag.name, tag);
        tag = new TagContainer("dt", 69, 13, 65536, 3984, true);
        htTags.put(tag.name, tag);
        tag = new TagContainer("em", 57, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new Embed();
        tag.deprecated = true;
        htTags.put(tag.name, tag);
        tag = new TagContainer("font", 44, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new Form();
        htTags.put(tag.name, tag);
        tag = new Tag("frame", 1028, 9, 32768);
        htTags.put(tag.name, tag);
        tag = new Frameset();
        htTags.put(tag.name, tag);
        tag = new TagContainer("h1", 18, 13, 8, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("h2", 19, 13, 8, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("h3", 20, 13, 8, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("h4", 21, 13, 8, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("h5", 22, 13, 8, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("h6", 23, 13, 8, 3984);
        htTags.put(tag.name, tag);
        tag = new Head();
        htTags.put(tag.name, tag);
        tag = new Tag("hr", 39, 13, 4096);
        htTags.put(tag.name, tag);
        tag = new Html();
        htTags.put(tag.name, tag);
        tag = new TagContainer("i", 49, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new Tag("iframe", 1030, 5, 4096);
        htTags.put(tag.name, tag);
        tag = new Tag("img", 42, 13, 512);
        htTags.put(tag.name, tag);
        tag = new Tag("input", 65, 13, 1024);
        htTags.put(tag.name, tag);
        tag = new Tag("isindex", 11, 15, 4098);
        htTags.put(tag.name, tag);
        tag = new External("jwssuperapplet", 43, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("kbd", 62, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("li", 68, 13, 65536, 8176, true);
        htTags.put(tag.name, tag);
        tag = new Tag("link", 16, 3, 4);
        htTags.put(tag.name, tag);
        tag = new TagContainer("listing", 32, 13, 64, 2048);
        tag.deprecated = true;
        htTags.put(tag.name, tag);
        tag = new Map();
        htTags.put(tag.name, tag);
        tag = new TagContainer("marquee", 1031, 13, 512, 3984, true);
        htTags.put(tag.name, tag);
        tag = new DirList("menu", 27);
        htTags.put(tag.name, tag);
        tag = new Tag("meta", 15, 3, 4);
        htTags.put(tag.name, tag);
        tag = new Tag("nextid", 73, 3, 2);
        tag.deprecated = true;
        htTags.put(tag.name, tag);
        tag = new Tag("nobr", 1034, 13, 128);
        htTags.put(tag.name, tag);
        tag = new Tag("noembed", 34, 13, 65536);
        tag.deprecated = true;
        htTags.put(tag.name, tag);
        tag = new NoBody("noframes", 1032, 9, 32768);
        htTags.put(tag.name, tag);
        tag = new NoBody("noscript", 1033, 13, 512);
        htTags.put(tag.name, tag);
        tag = new External("object", 1035, 16376);
        htTags.put(tag.name, tag);
        tag = new List("ol", 26);
        htTags.put(tag.name, tag);
        tag = new TagContainer("option", 74, 13, 65536, 3984, true);
        htTags.put(tag.name, tag);
        tag = new TagContainer("p", 24, 13, 4096, 3984, true);
        htTags.put(tag.name, tag);
        tag = new Tag("param", 75, 13, 65536);
        htTags.put(tag.name, tag);
        tag = new TagContainer("plaintext", 76, 13, 64, 2048, true);
        tag.deprecated = true;
        htTags.put(tag.name, tag);
        tag = new Pre();
        htTags.put(tag.name, tag);
        tag = new TagContainer("s", 1036, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("samp", 61, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("script", 13, 15, 516, 65536);
        htTags.put(tag.name, tag);
        tag = new Select();
        htTags.put(tag.name, tag);
        tag = new TagContainer("small", 54, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("span", 1037, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("strike", 52, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("strong", 58, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("style", 14, 3, 4, 65536);
        htTags.put(tag.name, tag);
        tag = new TagContainer("sub", 55, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("sup", 56, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new Table();
        htTags.put(tag.name, tag);
        tag = new TableArea("tbody", 1039);
        htTags.put(tag.name, tag);
        tag = new TagContainer("td", 77, 13, 65536, 16376, true);
        htTags.put(tag.name, tag);
        tag = new TagContainer("textarea", 67, 13, 1024, 3984);
        htTags.put(tag.name, tag);
        tag = new TableArea("tfoot", 1040);
        htTags.put(tag.name, tag);
        tag = new TagContainer("th", 78, 13, 65536, 16376, true);
        htTags.put(tag.name, tag);
        tag = new TableArea("thead", 1038);
        htTags.put(tag.name, tag);
        tag = new TableRow();
        htTags.put(tag.name, tag);
        tag = new TagContainer("tt", 48, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new TagContainer("title", 10, 3, 2, 2048);
        htTags.put(tag.name, tag);
        tag = new TagContainer("u", 51, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new List("ul", 25);
        htTags.put(tag.name, tag);
        tag = new TagContainer("var", 63, 13, 16, 3984);
        htTags.put(tag.name, tag);
        tag = new Tag("wbr", 1041, 13, 128);
        htTags.put(tag.name, tag);
        tag = new TagContainer("xmp", 31, 13, 64, 2048);
        htTags.put(tag.name, tag);
        tag = new TagContainer("text/plain", 4, 13, 64, 2048, true);
        tag.ignore = true;
        htTags.put(tag.name, tag);
    }

    private final Tag construct(String string, boolean bl, boolean bl2) {
        Tag tag = (Tag)htTags.get(string);
        tag = tag == null ? new Tag(string) : tag.duplicate();
        tag.opening = bl;
        tag.implied = bl2;
        return tag;
    }

    public static void main(String[] stringArray) throws HtmlException, IOException {
        Vector vector;
        if (stringArray.length != 1) {
            System.out.println("Usage:   java jhl.www.html.Parser html-file");
            System.exit(1);
        }
        String string = stringArray[0];
        File file = new File(string);
        Parser parser = new Parser();
        Document document = new Document();
        HtmlError htmlError = new HtmlError();
        long l = System.currentTimeMillis();
        parser.parse(file, document, htmlError);
        long l2 = System.currentTimeMillis() - l;
        if (htmlError.errors != null) {
            htmlError.errors.size();
        }
        if ((vector = htmlError.getErrors()) != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                HtmlErrorMessage htmlErrorMessage = (HtmlErrorMessage)vector.elementAt(n2);
                System.err.println(htmlErrorMessage.getError());
                ++n2;
            }
        }
        System.out.println(String.valueOf(parser.getCharsRead()) + " chars read in " + (double)l2 / 1000.0 + " s");
    }

    private static void showUsage() {
        System.out.println("Usage:   java jhl.www.html.Parser html-file");
    }

    static {
        Parser.lexInit();
        Parser.tagInit();
    }
}

