/*
 * Decompiled with CFR 0.152.
 */
package jhl.www.html;

import java.util.Enumeration;
import java.util.Hashtable;
import jhl.www.html.Attribute;

public class Tag
implements Cloneable {
    static final int G_HTML = 1;
    static final int G_HEAD = 2;
    static final int G_BODY = 4;
    static final int G_FRAME = 8;
    static final int G_FRAMEBODY = 12;
    static final int G_HEADFRAMEBODY = 14;
    static final int E_HTML_CONTENT = 1;
    static final int E_HEAD_CONTENT = 2;
    static final int E_HEAD_MISC = 4;
    static final int E_HEADING = 8;
    static final int E_FONT = 16;
    static final int E_LIST = 32;
    static final int E_PREFORMATTED = 64;
    static final int E_BREAK = 128;
    static final int E_EXTERNAL = 256;
    static final int E_SPECIAL = 512;
    static final int E_FORM = 1024;
    static final int E_PCDATA = 2048;
    static final int E_BLOCK_MISC = 4096;
    static final int E_BODY_MISC = 8192;
    static final int E_TABLE = 16384;
    static final int E_TEXT = 3984;
    static final int E_BLOCK = 4192;
    static final int E_FLOW = 8176;
    static final int E_BODY_CONTENT = 16376;
    static final int E_FRAME_CONTENT = 32768;
    static final int E_ORPHAN = 65536;
    static final int E_TEXTBREAK = 128367;
    public static final int T_UNKNOWN = 0;
    public static final int T_DOCUMENT = 1;
    public static final int T_SGML_DECL = 2;
    public static final int T_SGML_COM = 3;
    public static final int T_PLAINDATA = 4;
    public static final int T_CDATA = 5;
    static final int T_START = 6;
    public static final int T_TEXT = 6;
    public static final int T_HTML = 7;
    public static final int T_HEAD = 8;
    public static final int T_BODY = 9;
    public static final int T_TITLE = 10;
    public static final int T_ISINDEX = 11;
    public static final int T_BASE = 12;
    public static final int T_SCRIPT = 13;
    public static final int T_STYLE = 14;
    public static final int T_META = 15;
    public static final int T_LINK = 16;
    public static final int T_ADDRESS = 17;
    public static final int T_H1 = 18;
    public static final int T_H2 = 19;
    public static final int T_H3 = 20;
    public static final int T_H4 = 21;
    public static final int T_H5 = 22;
    public static final int T_H6 = 23;
    public static final int T_P = 24;
    public static final int T_UL = 25;
    public static final int T_OL = 26;
    public static final int T_MENU = 27;
    public static final int T_DIR = 28;
    public static final int T_DL = 29;
    public static final int T_PRE = 30;
    public static final int T_XMP = 31;
    public static final int T_LISTING = 32;
    public static final int T_EMBED = 33;
    public static final int T_NOEMBED = 34;
    public static final int T_DIV = 35;
    public static final int T_CENTER = 36;
    public static final int T_BLOCKQUOTE = 37;
    public static final int T_FORM = 38;
    public static final int T_HR = 39;
    public static final int T_TABLE = 40;
    public static final int T_A = 41;
    public static final int T_IMG = 42;
    public static final int T_APPLET = 43;
    public static final int T_FONT = 44;
    public static final int T_BASEFONT = 45;
    public static final int T_BR = 46;
    public static final int T_MAP = 47;
    public static final int T_TT = 48;
    public static final int T_I = 49;
    public static final int T_B = 50;
    public static final int T_U = 51;
    public static final int T_STRIKE = 52;
    public static final int T_BIG = 53;
    public static final int T_SMALL = 54;
    public static final int T_SUB = 55;
    public static final int T_SUP = 56;
    public static final int T_EM = 57;
    public static final int T_STRONG = 58;
    public static final int T_DFN = 59;
    public static final int T_CODE = 60;
    public static final int T_SAMP = 61;
    public static final int T_KBD = 62;
    public static final int T_VAR = 63;
    public static final int T_CITE = 64;
    public static final int T_INPUT = 65;
    public static final int T_SELECT = 66;
    public static final int T_TEXTAREA = 67;
    public static final int T_LI = 68;
    public static final int T_DT = 69;
    public static final int T_DD = 70;
    public static final int T_AREA = 71;
    public static final int T_CAPTION = 72;
    public static final int T_NEXTID = 73;
    public static final int T_OPTION = 74;
    public static final int T_PARAM = 75;
    public static final int T_PLAINTEXT = 76;
    public static final int T_TD = 77;
    public static final int T_TH = 78;
    public static final int T_TR = 79;
    static final int T_EXTENSIONS = 1024;
    public static final int T_BGSOUND = 1024;
    public static final int T_BLINK = 1025;
    public static final int T_COLGROUP = 1026;
    public static final int T_COL = 1027;
    public static final int T_FRAME = 1028;
    public static final int T_FRAMESET = 1029;
    public static final int T_IFRAME = 1030;
    public static final int T_MARQUEE = 1031;
    public static final int T_NOFRAMES = 1032;
    public static final int T_NOSCRIPT = 1033;
    public static final int T_NOBR = 1034;
    public static final int T_OBJECT = 1035;
    public static final int T_S = 1036;
    public static final int T_SPAN = 1037;
    public static final int T_THEAD = 1038;
    public static final int T_TBODY = 1039;
    public static final int T_TFOOT = 1040;
    public static final int T_WBR = 1041;
    int line;
    int col;
    String name;
    boolean opening;
    int id;
    int group;
    int entity;
    Hashtable attributes;
    boolean implied;
    boolean ignore;
    boolean deprecated;

    Tag(String string) {
        this.name = string;
        this.opening = true;
        this.id = 0;
    }

    Tag(String string, int n, int n2, int n3) {
        this(string);
        this.id = n;
        this.group = n2;
        this.entity = n3;
    }

    final Tag duplicate() {
        try {
            return (Tag)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Tag duplicate(Tag tag, boolean bl) {
        try {
            Tag tag2 = (Tag)this.clone();
            tag2.opening = bl;
            tag2.implied = true;
            tag2.ignore = false;
            tag2.line = tag.line;
            tag2.col = tag.col;
            if (!bl) {
                tag2.attributes = null;
            }
            return tag2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getFullTagName() {
        if (!this.opening) {
            return this.getTagClosingName();
        }
        if (this.attributes == null) {
            return this.getTagOpeningName();
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append('<');
        stringBuffer.append(this.name);
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            String string = attribute.getAttribute();
            if (string == null) continue;
            stringBuffer.append(' ');
            stringBuffer.append(attribute.getAttribute());
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.col;
    }

    public int getId() {
        return this.id;
    }

    public int getEntity() {
        return this.entity;
    }

    public String getTagName() {
        if (this.opening) {
            return this.getTagOpeningName();
        }
        return this.getTagClosingName();
    }

    public String getTagOpeningName() {
        return "<" + this.name + ">";
    }

    public String getTagClosingName() {
        return "</" + this.name + ">";
    }

    public boolean isContainer() {
        return false;
    }

    public final boolean isOpening() {
        return this.opening;
    }

    public final boolean isTextBreak() {
        if (this.id <= 6) {
            return false;
        }
        if ((this.entity & 0x1F56F) != 0) {
            return true;
        }
        return this.id == 39 || this.id == 46 || this.id == 13 || this.id == 1033;
    }

    public final boolean isImplied() {
        return this.implied;
    }

    public final boolean isIgnorable() {
        return this.ignore;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public final boolean isExtension() {
        return this.id == 0 || this.id >= 1024;
    }

    boolean isComplete() {
        return true;
    }

    public boolean hasEndMarkup() {
        return false;
    }

    public boolean requiresEndMarkup() {
        return false;
    }

    public final Attribute getAttr(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (Attribute)this.attributes.get(string);
    }

    final void putAttr(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new Hashtable(5);
        }
        this.attributes.put(attribute.name.toLowerCase(), attribute);
    }
}

