/*
 * Decompiled with CFR 0.152.
 */
package jhl.www.html;

import jhl.www.html.Tag;
import jhl.www.html.Validator;

public class TagContainer
extends Tag {
    TagContainer parent;
    Tag[] contents;
    int length;
    int size;
    int contains;
    boolean required;
    int correctorIndex;
    int correctorSize;
    Tag[] corrector;

    TagContainer(String string) {
        super(string);
    }

    TagContainer(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, n3, false);
    }

    TagContainer(String string, int n, int n2, int n3, boolean bl) {
        this(string, n, n2, n3, n3, bl);
    }

    TagContainer(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, false);
    }

    TagContainer(String string, int n, int n2, int n3, int n4, boolean bl) {
        super(string, n, n2, n3);
        this.contains = n4;
        this.required = !bl;
    }

    final Tag duplicate(Tag tag, boolean bl) {
        TagContainer tagContainer = (TagContainer)super.duplicate(tag, bl);
        tagContainer.parent = null;
        tagContainer.contents = null;
        tagContainer.length = 0;
        tagContainer.size = 0;
        tagContainer.correctorIndex = 0;
        tagContainer.correctorSize = 0;
        tagContainer.corrector = null;
        return tagContainer;
    }

    public TagContainer getParent() {
        return this.parent;
    }

    public int getSize() {
        return this.size;
    }

    public Tag[] getContents() {
        return this.contents;
    }

    public Tag getContentAt(int n) {
        if (n < 0 || n >= this.size) {
            return null;
        }
        return this.contents[n];
    }

    public final boolean isContainer() {
        return true;
    }

    public final boolean hasEndMarkup() {
        return true;
    }

    public final boolean requiresEndMarkup() {
        return this.required;
    }

    public final boolean hasContents() {
        if (this.size <= 1) {
            return false;
        }
        int n = 0;
        while (n < this.size - 1) {
            TagContainer tagContainer;
            Tag tag = this.contents[n];
            if (tag.isContainer() ? (tagContainer = (TagContainer)tag).hasContents() : !tag.ignore) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean inExclusion(Tag tag) {
        if (this.parent != null) {
            return this.parent.inExclusion(tag);
        }
        return false;
    }

    boolean needsParent(Tag tag, Validator validator) {
        return false;
    }

    boolean canContain(Tag tag) {
        return (tag.group & this.group) != 0 && (tag.entity & this.contains) != 0;
    }

    void add(Tag tag, Validator validator) {
        if (this.canContain(tag)) {
            if (this.needsParent(tag, validator)) {
                return;
            }
            this.addTag(tag, validator);
            if (tag.isContainer()) {
                validator.push((TagContainer)tag);
            }
            return;
        }
        this.addTag(this.duplicate(tag, false), validator);
        if (this.required) {
            validator.addError(tag.line, tag.col, "t13", this.getTagClosingName(), tag.getTagName());
            if (tag.isContainer()) {
                TagContainer tagContainer = (TagContainer)tag;
                if ((tag.group & this.group) != 0 && (!tagContainer.canContain(this) || tagContainer.inExclusion(this))) {
                    if (this.id == 43 || this.id == 1035 || this.id == 33 || this.entity == 1024) {
                        validator.putBack(tagContainer);
                        validator.pop();
                        return;
                    }
                    tagContainer.putForward(this.duplicate(tag, true));
                    validator.putBack(tagContainer);
                    validator.pop();
                    return;
                }
            }
            if (this.id == 43 || this.id == 1035 || this.id == 33 || this.entity == 1024) {
                validator.putBack(tag);
                validator.pop();
                return;
            }
            if ((tag.group & this.group) != 0 && !this.inExclusion(tag)) {
                validator.putBack(tag, this.duplicate(tag, true));
            } else {
                validator.putBack(tag);
            }
            validator.pop();
            return;
        }
        validator.putBack(tag);
        validator.pop();
    }

    void close(Tag tag, Validator validator) {
        if (tag.id == this.id && !tag.opening) {
            this.addTag(tag, validator);
        } else {
            this.addTag(this.duplicate(tag, false), validator);
            if (this.required) {
                validator.addError(tag.line, tag.col, "t13", this.getTagClosingName(), tag.getTagName());
            }
            validator.putBack(tag);
        }
        validator.pop();
    }

    void clean(Validator validator) {
        if (this.isTextBreak()) {
            return;
        }
        if (!this.hasContents()) {
            this.ignore = true;
        }
    }

    final boolean onStackId(int n) {
        TagContainer tagContainer = this;
        while (tagContainer != null) {
            if (tagContainer.id == n) {
                return true;
            }
            tagContainer = tagContainer.parent;
        }
        return false;
    }

    final Tag onStackEntity(int n) {
        TagContainer tagContainer = this;
        while (tagContainer != null) {
            if ((tagContainer.entity & n) == n) {
                return tagContainer;
            }
            tagContainer = tagContainer.parent;
        }
        return null;
    }

    final boolean inContents(int n) {
        if (this.size == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.size) {
            Tag tag = this.contents[n2];
            if (tag.id == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    final void addTag(Tag tag, Validator validator) {
        if (this.length <= this.size) {
            this.length += 5;
            Tag[] tagArray = new Tag[this.length];
            if (this.size > 0) {
                System.arraycopy(this.contents, 0, tagArray, 0, this.size);
            }
            this.contents = tagArray;
        }
        this.contents[this.size++] = tag;
        if (tag.id == this.id && !tag.opening) {
            this.clean(validator);
        }
        validator.tellObservers(tag);
    }

    final void putForward(Tag tag) {
        if (this.correctorIndex <= this.correctorSize) {
            this.correctorSize += 5;
            Tag[] tagArray = new Tag[this.correctorSize];
            if (this.correctorIndex > 0) {
                System.arraycopy(this.corrector, 0, tagArray, 0, this.correctorIndex);
            }
            this.corrector = tagArray;
        }
        this.corrector[this.correctorIndex++] = tag;
    }

    final void merge(TagContainer tagContainer, TagContainer tagContainer2, Validator validator) {
        Tag tag = tagContainer.removeClose();
        int n = tagContainer2.size;
        int n2 = 0;
        while (n2 < n) {
            Tag tag2 = tagContainer2.contents[n2];
            tagContainer.addTag(tag2, validator);
            ++n2;
        }
        tagContainer2.length = 0;
        tagContainer2.size = 0;
        tagContainer2.contents = null;
        tagContainer.addTag(tag, validator);
    }

    final Tag removeClose() {
        if (this.size == 0) {
            return null;
        }
        Tag tag = this.contents[this.size - 1];
        if (tag.id == this.id) {
            --this.size;
            return tag;
        }
        return null;
    }
}

