/*
 * Decompiled with CFR 0.152.
 */
package jhl.www.html;

import java.io.File;
import java.net.URL;
import java.util.Stack;
import jhl.util.NameHashtable;
import jhl.www.html.Document;
import jhl.www.html.HtmlError;
import jhl.www.html.HtmlException;
import jhl.www.html.Parser;
import jhl.www.html.ParserObserver;
import jhl.www.html.Tag;
import jhl.www.html.WordDocument;

public class WordParserObserver
extends ParserObserver {
    WordDocument wd;
    boolean hasFrameset;
    boolean start;
    int startText;
    Stack tableStack;
    NameHashtable current;

    public WordParserObserver(Parser parser) {
        super(parser);
    }

    public synchronized void parse(File file, WordDocument wordDocument) throws HtmlException {
        this.parse(file, wordDocument, null);
    }

    public synchronized void parse(File file, WordDocument wordDocument, HtmlError htmlError) throws HtmlException {
        this.wd = wordDocument == null ? new WordDocument() : wordDocument;
        this.init();
        super.parse(file, (Document)wordDocument, htmlError);
    }

    public synchronized void parse(URL uRL, WordDocument wordDocument) throws HtmlException {
        this.parse(uRL, wordDocument, null);
    }

    public synchronized void parse(URL uRL, WordDocument wordDocument, HtmlError htmlError) throws HtmlException {
        this.wd = wordDocument == null ? new WordDocument() : wordDocument;
        this.init();
        super.parse(uRL, (Document)wordDocument, htmlError);
    }

    protected void tagParsed(Tag tag) {
        if (this.hasFrameset) {
            return;
        }
        if (tag.id == 1029) {
            this.wd.titleWords.clear();
            this.wd.headingWords.clear();
            this.wd.listWords.clear();
            this.wd.htmlWords.clear();
            this.hasFrameset = true;
            return;
        }
        if (tag.id == 10) {
            if (tag.opening) {
                this.startText = this.parser.textIndex;
                this.current = this.wd.titleWords;
                return;
            }
            if (this.parser.textIndex > this.startText + 1) {
                int n = this.parser.textIndex - 1;
                this.breakWords(this.startText, n);
            }
            return;
        }
        if (tag.id == 9) {
            if (tag.opening) {
                this.startText = this.parser.textIndex;
                this.current = this.wd.htmlWords;
                this.start = true;
                return;
            }
            int n = this.parser.textIndex;
            if (n > this.startText) {
                this.breakWords(this.startText, n);
            }
            this.current = null;
            this.start = false;
            return;
        }
        if (this.start) {
            switch (tag.id) {
                case 13: 
                case 14: 
                case 43: 
                case 1031: 
                case 1033: 
                case 1035: {
                    if (tag.opening) {
                        int n = this.parser.textIndex;
                        if (n > this.startText) {
                            this.breakWords(this.startText, n);
                        }
                        this.startText = n;
                        this.tableStack.push(this.current);
                        this.current = null;
                        return;
                    }
                    this.startText = this.parser.textIndex;
                    this.current = (NameHashtable)this.tableStack.pop();
                    return;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 72: {
                    if (this.current != null) {
                        if (tag.opening) {
                            int n = this.parser.textIndex;
                            if (n > this.startText) {
                                this.breakWords(this.startText, n);
                            }
                            this.startText = n;
                            this.tableStack.push(this.current);
                            this.current = this.wd.headingWords;
                            return;
                        }
                        int n = this.parser.textIndex;
                        if (n > this.startText) {
                            this.breakWords(this.startText, n);
                        }
                        this.startText = n;
                        this.current = (NameHashtable)this.tableStack.pop();
                    }
                    return;
                }
                case 68: 
                case 69: {
                    if (this.current != null) {
                        if (tag.opening) {
                            int n = this.parser.textIndex;
                            if (n > this.startText) {
                                this.breakWords(this.startText, n);
                            }
                            this.startText = n;
                            this.tableStack.push(this.current);
                            this.current = this.wd.listWords;
                            return;
                        }
                        int n = this.parser.textIndex;
                        if (n > this.startText) {
                            this.breakWords(this.startText, n);
                        }
                        this.startText = n;
                        this.current = (NameHashtable)this.tableStack.pop();
                    }
                    return;
                }
            }
        }
    }

    private void init() {
        this.start = false;
        this.hasFrameset = false;
        this.startText = -1;
        this.tableStack = new Stack();
    }

    private void breakWords(int n, int n2) {
        if (this.current == null) {
            return;
        }
        int n3 = n;
        char[] cArray = this.parser.text;
        while (n3 < n2) {
            char c;
            int n4;
            if (!Character.isLetterOrDigit(cArray[n3++])) continue;
            n = n3 - 1;
            while (n3 < n2) {
                n4 = cArray[n3];
                if (Character.isLetterOrDigit((char)n4) || n4 == 46 || n4 == 95) {
                    ++n3;
                    continue;
                }
                if (n3 + 1 >= n2) break;
                c = cArray[n3 + 1];
                if (n4 != 44 || !Character.isDigit(c)) break;
                ++n3;
            }
            n4 = n3 - 1;
            while (n4 > n) {
                c = cArray[n4];
                if (c != '.' && c != '_') break;
                --n4;
            }
            this.current.add(new String(cArray, n, ++n4 - n));
        }
    }
}

