
<HTML>

<TITLE>Darren's Store</TITLE>

<%

	' Connect to the store
	Set Darren = Server.CreateObject("DarrenStore.Store")

	' Do we have a cart already?
	if isempty(session("cart")) then
		set session("cart") = Darren.NewCart
	end if
	session("cart").add request.querystring("add")

%>

	<body>

        <!--header, and a link back to the catalog -->
	<font size=5>Your Cart</font>
	<br>
	<a href="default.asp">Back to catalog</a>
	<br><br>

	<!-- table for cart items -->
	<table border=1>
        <!-- Table heading -->
	<tr><td>Name</td><td>Quantity</td><td>Each</td><td>Total</td></tr>

	<%

                ' Hold the total somewhere...
		total = 0

		' loop all of the items in the cart
		for each item in session("cart").items

			' Each cart item only holds the ID of the product.
                        ' We have to use the DarrenStore.Store object to get the 
                        ' item details back from the database
			set objRecProduct = Darren.GetProductInfo(item.productid)
			if not objRecProduct.eof then

                                'Draw in the name of the item
				response.write "<tr><td>"
				response.write objRecProduct("mfrname") & " " & objRecProduct("productname")

                                'Draw in the quantity that we've chosen
				response.write "</td><td>"
				response.write item.quantity

                                'Draw in the line price
				response.write "</td><td align=right>"
				response.write formatcurrency(objRecProduct("price"), 2)

                                'Draw in the total for the line and increase the total
				response.write "</td><td align=right>"
				response.write formatcurrency(objRecProduct("price") * item.quantity, 2)
				total = total + (objRecProduct("price") * item.quantity)
				response.write "</td></tr>"

			end if
			objRecProduct.close
			set objRecProduct = nothing

		next

		' Draw the total
		response.write "<tr><td colspan=4 align=right><b>Total: "
		response.write formatcurrency(total, 2)
		response.write "</b></td></tr>"

	%>

	</table>
	<br>



<%
	' Close the store
	Set Darren = Nothing
%>

</html>