VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Transactions"
   ClientHeight    =   930
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4140
   LinkTopic       =   "Form1"
   ScaleHeight     =   930
   ScaleWidth      =   4140
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdCommit 
      Caption         =   "C&ommit"
      Height          =   495
      Left            =   2760
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "&Connect"
      Height          =   495
      Left            =   120
      TabIndex        =   1
      Top             =   240
      Width           =   1215
   End
   Begin VB.CommandButton cmdUpdate 
      Caption         =   "&Update"
      Height          =   495
      Left            =   1440
      TabIndex        =   0
      Top             =   240
      Width           =   1215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim objConn As ADODB.Connection
Dim objRec As ADODB.Recordset

Private Sub cmdConnect_Click()

   On Error GoTo Connection_Error

   Set objConn = New ADODB.Connection
   objConn.ConnectionString = "Provider=SQLOLEDB.1;" & _
                              "Persist Security Info=False;" & _
                              "User ID=sa;Initial Catalog=pubs"
   objConn.Open
   MsgBox "Connection successful!", , "Connect"

   Exit Sub

Connection_Error:
   MsgBox "Unable to connect:" & vbCrLf & Err.Description, , "Connect"

End Sub


Private Sub cmdUpdate_Click()

   Dim strSQL As String

   objConn.CommandTimeout = 15

   ' DROP the table if it exists. We'll ignore any errors
   ' that might occur if the table doesn't exist
   On Error Resume Next
   strSQL = "DROP TABLE Employee_BK"
   objConn.Execute strSQL

   ' Create a backup table to work with
   strSQL = "CREATE TABLE Employee_BK " & _
            "(emp_id    empid           NOT NULL ," & _
            "fname      varchar (20)    NOT NULL , " & _
            "minit      char (1)        NULL ," & _
            "lname      varchar (30)    NOT NULL ," & _
            "job_id     smallint        NOT NULL ," & _
            "job_lvl    tinyint         NOT NULL ," & _
            "pub_id     char (4)        NOT NULL ," & _
            "hire_date  DateTime        NOT NULL)"
   objConn.Execute strSQL

   objConn.BeginTrans
   On Error GoTo Update_Error

   ' Populate it with backup data
   strSQL = "INSERT INTO Employee_BK " & _
            "SELECT * FROM Employee"
   objConn.Execute strSQL

   ' Update the new salary information
   strSQL = "UPDATE Employee_BK " & _
            "SET job_lvl = job_lvl + 3 " & _
            "WHERE job_id = 5"
   objConn.Execute strSQL

   MsgBox "Completed Successfully!" & vbCrLf & _
          "Committing Changes.", , "Update"

   objConn.CommitTrans

   Exit Sub

Update_Error:

   MsgBox "Error occured - " & Err.Description & vbCrLf & _
           "Rolling Back the last transactions.", , "Update"

   objConn.RollbackTrans

End Sub


Private Sub cmdCommit_Click()
   Dim strSQL As String
   Dim intRetval As Integer
   Set objRec = New ADODB.Recordset
   Dim intCounter As Integer

   objRec.LockType = adLockOptimistic

   objConn.CommandTimeout = 15
   objConn.BeginTrans

   On Error GoTo Update_Error

   ' Navigate through all Employees and count affected records

   objRec.Open "Employee_BK", objConn, , , adCmdTable
   objRec.MoveFirst

   Do Until objRec.EOF
      ' Get the Job code & update
      If objRec("job_id") = "5" Then
         objRec("job_id") = "3"
         intCounter = intCounter + 1
      End If
      'Move to the next record
      objRec.MoveNext
   Loop

   ' Ask the user if the information is correct
   intRetval = MsgBox(intCounter & " records are about to be modified." & _
               " Commit Changes? ", vbQuestion + vbYesNo, "Commit Changes?")

   If intRetval = vbYes Then
      ' If so, commit the changes
      objConn.CommitTrans
   Else
      ' Otherwise, rollback the changes
      objConn.RollbackTrans
   End If
    
   Exit Sub

Update_Error:

   MsgBox "Error occured - " & Err.Description & vbCrLf & _
          "Rolling back the last transactions."

   objConn.RollbackTrans

End Sub


