VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 2  'RequiresTransaction
END
Attribute VB_Name = "clsServer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Implements ObjectControl
Dim objContext As ObjectContext
Dim strSQL As String
Dim cnNorthwind As ADODB.Connection       ' Connection object to Northwind
Dim rsGeneric As New ADODB.Recordset      ' Generic recordset for looking up IDs

Dim rsOrder As New ADODB.Recordset        ' Recordset for Orders
Dim rsOrderDetails As New ADODB.Recordset ' Recordset for Order Details

Dim rsStock As New ADODB.Recordset        ' For updating inventory stock levels



Public Function Get_Table_Recordset(strTable As String) As ADODB.Recordset
   Set objContext = GetObjectContext()
    
   On Error GoTo errHandle
    

   cnNorthwind.Open
   cnNorthwind.CursorLocation = adUseClient

   strSQL = "SELECT * FROM " & strTable

   Set Get_Table_Recordset = cnNorthwind.Execute(strSQL)

   Get_Table_Recordset.ActiveConnection = Nothing
   cnNorthwind.Close
   If Not objContext Is Nothing Then
     objContext.SetComplete
     Set objContext = Nothing
   End If

Exit Function
    
errHandle:
   If Not objContext Is Nothing Then
     objContext.SetAbort
     Set objContext = Nothing
   End If
   Err.Clear


End Function

Public Function Get_Products() As ADODB.Recordset
   Set objContext = GetObjectContext()
    
   On Error GoTo errHandle

   cnNorthwind.Open
   cnNorthwind.CursorLocation = adUseClient

   strSQL = "SELECT Categories.CategoryName, Products.ProductID, " & _
            "Products.ProductName,Products.QuantityPerUnit," & _
            "Products.UnitPrice,Products.UnitsInStock, " & _
            "Products.UnitsOnOrder FROM Categories " & _
            "INNER JOIN Products ON Categories.CategoryID " & _
            "= Products.CategoryID " & _
            "ORDER BY Categories.CategoryName"

   Set Get_Products = cnNorthwind.Execute(strSQL)

   Get_Products.ActiveConnection = Nothing
   cnNorthwind.Close
   If Not objContext Is Nothing Then
     objContext.SetComplete
     Set objContext = Nothing
   End If

Exit Function
    
errHandle:

   If Not objContext Is Nothing Then
     objContext.SetAbort
     Set objContext = Nothing
   End If
   Err.Clear

End Function


Public Function Get_Customer_Details(CompanyName As String) As ADODB.Recordset
   Set objContext = GetObjectContext()
    
   On Error GoTo errHandle

   cnNorthwind.Open
   cnNorthwind.CursorLocation = adUseClient

   CompanyName = Replace(CompanyName, "'", "''")

   strSQL = "SELECT * FROM Customers WHERE CompanyName = '" & CompanyName & "'"

   Set Get_Customer_Details = cnNorthwind.Execute(strSQL)

   Get_Customer_Details.ActiveConnection = Nothing
   cnNorthwind.Close
   If Not objContext Is Nothing Then
     objContext.SetComplete
     Set objContext = Nothing
   End If

Exit Function
    
errHandle:

   If Not objContext Is Nothing Then
     objContext.SetAbort
     Set objContext = Nothing
   End If
   Err.Clear

End Function

Public Function Get_ID(strTable As String, strValue) As String
   Set objContext = GetObjectContext()
    
   On Error GoTo errHandle

   cnNorthwind.Open
   cnNorthwind.CursorLocation = adUseClient

   Select Case strTable

     Case "Customers"
       strSQL = "SELECT * FROM Customers WHERE CompanyName = '" & strValue & "'"
       Set rsGeneric = cnNorthwind.Execute(strSQL)
       Get_ID = rsGeneric("CustomerID")

     Case "Employees"
       strSQL = "SELECT * FROM Employees WHERE " _
              & "LastName = '" & Left(strValue, InStr(strValue, ",") - 1) _
              & "' AND FirstName = '" & _
              Right(strValue, Len(strValue) - InStr(strValue, ",") - 1) & "'"
       Set rsGeneric = cnNorthwind.Execute(strSQL)
       Get_ID = rsGeneric("EmployeeID")

     Case "Shippers"
       strSQL = "SELECT * FROM Shippers WHERE CompanyName = '" & strValue & "'"
       Set rsGeneric = cnNorthwind.Execute(strSQL)
       Get_ID = rsGeneric("ShipperID")

   End Select

   rsGeneric.ActiveConnection = Nothing
   cnNorthwind.Close
   If Not objContext Is Nothing Then
     objContext.SetComplete
     Set objContext = Nothing
   End If

Exit Function
    
errHandle:

   If Not objContext Is Nothing Then
     objContext.SetAbort
     Set objContext = Nothing
   End If
   Err.Clear

End Function


Public Function Send_Order(rsNewOrder As ADODB.Recordset, rsNewOrderDetail As _
                           ADODB.Recordset) As String

On Error GoTo BadSend
   Set objContext = GetObjectContext()
   cnNorthwind.Open
   cnNorthwind.CursorLocation = adUseServer

   strSQL = "SELECT * FROM Orders WHERE 1=2"
   rsOrder.LockType = adLockOptimistic
   rsOrder.CursorType = adOpenKeyset
   rsOrder.Open strSQL, cnNorthwind, , , adCmdText

   strSQL = "SELECT * FROM [Order Details] WHERE 1 =2"
   rsOrderDetails.LockType = adLockOptimistic
   rsOrderDetails.CursorType = adOpenKeyset
   rsOrderDetails.Open strSQL, cnNorthwind, , , adCmdText

   rsStock.LockType = adLockOptimistic
   rsStock.CursorType = adOpenKeyset

   With rsOrder
     .AddNew
     !CustomerID = rsNewOrder!CustomerID
     !EmployeeID = rsNewOrder!EmployeeID
     !OrderDate = rsNewOrder!OrderDate
     !RequiredDate = rsNewOrder!RequiredDate
     !ShipVia = rsNewOrder!ShipVia
     !Freight = rsNewOrder!Freight
     !ShipName = rsNewOrder!ShipName
     !ShipAddress = rsNewOrder!ShipAddress
     !ShipCity = rsNewOrder!ShipCity
     If Trim(rsNewOrder!ShipRegion) <> "" Then
       !ShipRegion = rsNewOrder!ShipRegion
     End If
     !ShipCountry = rsNewOrder!ShipCountry
     !ShipPostalCode = rsNewOrder!ShipPostalCode
     .Update
     Send_Order = !OrderID
   End With

   If rsNewOrderDetail.RecordCount > 0 Then
     rsNewOrderDetail.MoveFirst
     Do Until rsNewOrderDetail.EOF
       With rsOrderDetails
         .AddNew
         !OrderID = rsOrder!OrderID
         !ProductID = rsNewOrderDetail!ProductID
         !UnitPrice = rsNewOrderDetail!UnitPrice
         !Quantity = rsNewOrderDetail!Quantity
         !Discount = rsNewOrderDetail!Discount
         .Update

         rsNewOrderDetail.MoveNext

         strSQL = "SELECT * FROM Products WHERE ProductID = " & !ProductID
         rsStock.Open strSQL, cnNorthwind, , , adCmdText
         rsStock!UnitsInStock = rsStock!UnitsInStock - !Quantity
         rsStock.Update
         rsStock.Close
       End With
     Loop
   End If

   cnNorthwind.Close
   If Not objContext Is Nothing Then
     objContext.SetComplete
     Set objContext = Nothing
   End If

Exit Function

BadSend:

   Debug.Print Err.Number & Err.Description
   Err.Clear
   cnNorthwind.Close
   Send_Order = "Error Entering Order"
   If Not objContext Is Nothing Then
     objContext.SetAbort
     Set objContext = Nothing
   End If

End Function


Private Sub ObjectControl_Activate()

   Set cnNorthwind = New ADODB.Connection
   cnNorthwind.ConnectionString = "DSN=NorthWind;uid=sa;pwd="

End Sub

Private Sub ObjectControl_Deactivate()

End Sub

Private Function ObjectControl_CanBePooled() As Boolean

End Function

