VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Object = "{0ECD9B60-23AA-11D0-B351-00A0C9055D8E}#6.0#0"; "MSHFLXGD.OCX"
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCT2.OCX"
Begin VB.Form frmClientApp 
   Caption         =   "Client Order Application"
   ClientHeight    =   8385
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8865
   LinkTopic       =   "Form1"
   ScaleHeight     =   8385
   ScaleWidth      =   8865
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtOrderID 
      Height          =   285
      Left            =   6840
      TabIndex        =   35
      Top             =   7800
      Width           =   1575
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "Send Order"
      Height          =   375
      Left            =   1440
      TabIndex        =   34
      Top             =   7800
      Width           =   3015
   End
   Begin VB.TextBox txtTotal 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   6960
      TabIndex        =   32
      Text            =   "$ 0.00"
      Top             =   7200
      Width           =   1455
   End
   Begin VB.TextBox txtFreight 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   6960
      TabIndex        =   30
      Text            =   "$ 8.00"
      Top             =   6720
      Width           =   1455
   End
   Begin VB.TextBox txtSubTotal 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   6960
      TabIndex        =   28
      Text            =   "$ 0.00"
      Top             =   6360
      Width           =   1455
   End
   Begin VB.CommandButton cmdNew 
      Caption         =   "New Order"
      Height          =   375
      Left            =   3960
      TabIndex        =   27
      Top             =   6360
      Width           =   1815
   End
   Begin VB.ComboBox cboEmployee 
      Height          =   315
      Left            =   3120
      TabIndex        =   25
      Top             =   7200
      Width           =   1695
   End
   Begin MSComCtl2.DTPicker dtpRequired 
      Height          =   315
      Left            =   1560
      TabIndex        =   23
      Top             =   7200
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   556
      _Version        =   393216
      Format          =   24510465
      CurrentDate     =   36343
   End
   Begin MSComCtl2.DTPicker dtpOrder 
      Height          =   315
      Left            =   120
      TabIndex        =   21
      Top             =   7200
      Width           =   1215
      _ExtentX        =   2143
      _ExtentY        =   556
      _Version        =   393216
      Format          =   24510465
      CurrentDate     =   36343
   End
   Begin VB.ComboBox cboShipVia 
      Height          =   315
      Left            =   1080
      TabIndex        =   19
      Top             =   6360
      Width           =   2535
   End
   Begin MSDataGridLib.DataGrid dgrOrderDetails 
      Height          =   1335
      Left            =   120
      TabIndex        =   17
      Top             =   4560
      Width           =   8535
      _ExtentX        =   15055
      _ExtentY        =   2355
      _Version        =   393216
      AllowUpdate     =   -1  'True
      HeadLines       =   1
      RowHeight       =   15
      AllowDelete     =   -1  'True
      BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ColumnCount     =   2
      BeginProperty Column00 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   2057
            SubFormatType   =   0
         EndProperty
      EndProperty
      BeginProperty Column01 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   2057
            SubFormatType   =   0
         EndProperty
      EndProperty
      SplitCount      =   1
      BeginProperty Split0 
         BeginProperty Column00 
         EndProperty
         BeginProperty Column01 
         EndProperty
      EndProperty
   End
   Begin MSHierarchicalFlexGridLib.MSHFlexGrid hfgProducts 
      Height          =   1455
      Left            =   120
      TabIndex        =   16
      Top             =   2760
      Width           =   8535
      _ExtentX        =   15055
      _ExtentY        =   2566
      _Version        =   393216
      FixedCols       =   0
      FillStyle       =   1
      SelectionMode   =   1
      _NumberOfBands  =   1
      _Band(0).Cols   =   2
   End
   Begin VB.Frame fraCustomer 
      Caption         =   "Customer Detail"
      Height          =   2295
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   8535
      Begin VB.TextBox txtPhone 
         Height          =   285
         Left            =   3960
         TabIndex        =   13
         Top             =   1800
         Width           =   1575
      End
      Begin VB.TextBox txtPostal 
         Height          =   285
         Left            =   2280
         TabIndex        =   11
         Top             =   1800
         Width           =   1455
      End
      Begin VB.TextBox txtCountry 
         Height          =   285
         Left            =   120
         TabIndex        =   9
         Top             =   1800
         Width           =   1935
      End
      Begin VB.TextBox txtRegion 
         Height          =   285
         Left            =   4560
         TabIndex        =   7
         Top             =   1080
         Width           =   855
      End
      Begin VB.TextBox txtCity 
         Height          =   285
         Left            =   2640
         TabIndex        =   5
         Top             =   1080
         Width           =   1695
      End
      Begin VB.TextBox txtAddress 
         Height          =   285
         Left            =   120
         TabIndex        =   3
         Top             =   1080
         Width           =   2295
      End
      Begin VB.ComboBox cboCompany 
         Height          =   315
         Left            =   1320
         TabIndex        =   1
         Top             =   360
         Width           =   3015
      End
      Begin VB.Label Phone 
         Caption         =   "Phone"
         Height          =   255
         Left            =   3960
         TabIndex        =   14
         Top             =   1560
         Width           =   975
      End
      Begin VB.Label Label6 
         Caption         =   "Postal Code"
         Height          =   255
         Left            =   2280
         TabIndex        =   12
         Top             =   1560
         Width           =   1335
      End
      Begin VB.Label Label5 
         Caption         =   "Country"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   1560
         Width           =   2295
      End
      Begin VB.Label Label4 
         Caption         =   "Region"
         Height          =   255
         Left            =   4560
         TabIndex        =   8
         Top             =   840
         Width           =   855
      End
      Begin VB.Label Label3 
         Caption         =   "City"
         Height          =   255
         Left            =   2640
         TabIndex        =   6
         Top             =   840
         Width           =   1455
      End
      Begin VB.Label Label2 
         Caption         =   "Address"
         Height          =   255
         Left            =   120
         TabIndex        =   4
         Top             =   840
         Width           =   2295
      End
      Begin VB.Label Label1 
         Caption         =   "Company Name"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   400
         Width           =   1695
      End
   End
   Begin VB.Label Label16 
      Caption         =   "Confimation/Order Number"
      Height          =   255
      Left            =   4800
      TabIndex        =   36
      Top             =   7850
      Width           =   1935
   End
   Begin VB.Line Line3 
      X1              =   120
      X2              =   8640
      Y1              =   7680
      Y2              =   7680
   End
   Begin VB.Label Label15 
      Caption         =   "Total"
      Height          =   255
      Left            =   6120
      TabIndex        =   33
      Top             =   7200
      Width           =   855
   End
   Begin VB.Line Line2 
      X1              =   8520
      X2              =   5880
      Y1              =   7080
      Y2              =   7080
   End
   Begin VB.Label Label14 
      Caption         =   "Freight"
      Height          =   255
      Left            =   6120
      TabIndex        =   31
      Top             =   6720
      Width           =   855
   End
   Begin VB.Label Label13 
      Caption         =   "Sub Total"
      Height          =   255
      Left            =   6120
      TabIndex        =   29
      Top             =   6360
      Width           =   855
   End
   Begin VB.Label Label12 
      Caption         =   "Employee"
      Height          =   255
      Left            =   3120
      TabIndex        =   26
      Top             =   6960
      Width           =   1455
   End
   Begin VB.Label Label11 
      Caption         =   "Required Date"
      Height          =   255
      Left            =   1560
      TabIndex        =   24
      Top             =   6960
      Width           =   1215
   End
   Begin VB.Label Label10 
      Caption         =   "Order Date"
      Height          =   255
      Left            =   120
      TabIndex        =   22
      Top             =   6960
      Width           =   1215
   End
   Begin VB.Label Label9 
      Caption         =   "Ship Method"
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   6420
      Width           =   1095
   End
   Begin VB.Line Line1 
      X1              =   120
      X2              =   8640
      Y1              =   6120
      Y2              =   6120
   End
   Begin VB.Label Label8 
      Caption         =   "Order Items:"
      Height          =   255
      Left            =   120
      TabIndex        =   18
      Top             =   4320
      Width           =   1695
   End
   Begin VB.Label Label7 
      Caption         =   "Available Products:"
      Height          =   255
      Left            =   120
      TabIndex        =   15
      Top             =   2520
      Width           =   1935
   End
End
Attribute VB_Name = "frmClientApp"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim objServer As clsServer

Dim rsGeneric As New ADODB.Recordset          ' Generic Recordset
Dim rsOrder As ADODB.Recordset                ' Order Recordset
Dim rsOrderDetails As ADODB.Recordset         ' Order Details

Dim Drag_ProductID As String
Dim Drag_ProductName As String
Dim Drag_UnitPrice As String

Private Sub Form_Load()

   Set objServer = New clsServer

   Set rsGeneric = objServer.Get_Table_Recordset("Customers")
   Do Until rsGeneric.EOF
     cboCompany.AddItem rsGeneric("CompanyName")
     rsGeneric.MoveNext
   Loop

   Set rsGeneric = objServer.Get_Table_Recordset("Shippers")
   cboShipVia = rsGeneric("CompanyName")
   Do Until rsGeneric.EOF
     cboShipVia.AddItem rsGeneric("CompanyName")
     rsGeneric.MoveNext
   Loop

   Set rsGeneric = objServer.Get_Table_Recordset("Employees")
   cboEmployee = rsGeneric("LastName") & ", " & rsGeneric("FirstName")
   Do Until rsGeneric.EOF
     cboEmployee.AddItem rsGeneric("LastName") & ", " & rsGeneric("FirstName")
     rsGeneric.MoveNext
   Loop

   Set rsGeneric = objServer.Get_Products()

   hfgProducts.MergeCol(0) = True
   hfgProducts.MergeCells = flexMergeRestrictColumns

   Set hfgProducts.Recordset = rsGeneric

   ' Format Grid Width's
   hfgProducts.ColWidth(0) = 1200
   hfgProducts.ColWidth(1) = 800
   hfgProducts.ColWidth(2) = 2000
   hfgProducts.ColWidth(3) = 1500
   hfgProducts.ColWidth(4) = 800

   Create_New_Order
   Create_New_Order_Detail

   Set rsGeneric = Nothing

   dtpOrder = Date
   dtpRequired = Date + 7

End Sub

Private Sub cboCompany_Click()

   Set rsGeneric = objServer.Get_Customer_Details(cboCompany)

   txtAddress = rsGeneric("Address")
   txtCity = rsGeneric("City")
   txtPhone = rsGeneric("Phone")
   txtCountry = rsGeneric("Country")
   txtPostal = rsGeneric("PostalCode")
   txtRegion = "" & rsGeneric("Region")


   cmdNew.Value = True

   Set rsGeneric = Nothing

End Sub

Public Sub Create_New_Order()

   ' Create the Order recordset
   Set rsOrder = New ADODB.Recordset
   With rsOrder.Fields
     .Append "CustomerID", adVarChar, 8
     .Append "EmployeeID", adBigInt
     .Append "OrderDate", adDate
     .Append "RequiredDate", adDate
     .Append "ShipVia", adBigInt
     .Append "Freight", adCurrency
     .Append "ShipName", adVarChar, 40
     .Append "ShipAddress", adVarChar, 60
     .Append "ShipCity", adVarChar, 15
     .Append "ShipRegion", adVarChar, 15
     .Append "ShipCountry", adVarChar, 15
     .Append "ShipPostalCode", adVarChar, 10
   End With
    
   With rsOrder
     .Open
     .AddNew
   End With

End Sub

Public Sub Create_New_Order_Detail()

   ' Create the recordset for the OrderDetails grid.
   Set rsOrderDetails = New Recordset

   With rsOrderDetails.Fields
     .Append "ProductID", adInteger
     .Append "ProductName", adVarChar, 255
     .Append "UnitPrice", adCurrency
     .Append "Quantity", adDouble
     .Append "Discount", adDouble
     .Append "ExtendedPrice", adCurrency
   End With
   rsOrderDetails.Open

End Sub

Private Sub hfgProducts_MouseDown(Button As Integer, Shift As Integer, _
                                  X As Single, Y As Single)

   hfgProducts.Col = 1
   Drag_ProductID = hfgProducts.Text
   hfgProducts.Col = 2
   Drag_ProductName = hfgProducts.Text
   hfgProducts.Col = 4
   Drag_UnitPrice = hfgProducts.Text
    
   hfgProducts.Drag vbBeginDrag
   hfgProducts.DragIcon = LoadPicture(App.Path & "\drag.ico")

End Sub


Private Sub dgrOrderDetails_DragOver(Source As Control, X As Single, _
                                      Y As Single, State As Integer)
   Select Case State
     Case 0
       hfgProducts.DragIcon = LoadPicture(App.Path & "\drop.ico")
     Case 1
       hfgProducts.DragIcon = LoadPicture(App.Path & "\drag.ico")
   End Select

End Sub

Private Sub dgrOrderDetails_DragDrop(Source As Control, X As Single, _
                                     Y As Single)

   ' Look for dups
   If rsOrderDetails.RecordCount > 0 Then
     rsOrderDetails.MoveFirst
     Do Until rsOrderDetails.EOF
       If rsOrderDetails("ProductID") = Drag_ProductID Then
         Beep
         MsgBox "Item already exists!"
         Exit Sub
       End If
       rsOrderDetails.MoveNext
     Loop
   End If
    
   rsOrderDetails.AddNew
        
   With rsOrderDetails
     !ProductID = Drag_ProductID
     !Quantity = 1
     !Discount = 0
     !ProductName = Drag_ProductName
     !UnitPrice = Drag_UnitPrice
   End With
   Set dgrOrderDetails.DataSource = rsOrderDetails
    
   dgrOrderDetails.Columns(1).Width = 2200
   dgrOrderDetails.Columns(2).Width = 1000
   dgrOrderDetails.Columns(3).Width = 1000
   dgrOrderDetails.Columns(4).Width = 1000
    
   Total_All

End Sub

Public Sub Total_All()

   Dim curAmount As Currency

   
   If rsOrderDetails.RecordCount > 0 Then

     dgrOrderDetails.Columns(5) = dgrOrderDetails.Columns(2) * _
                                  dgrOrderDetails.Columns(3) * _
                                  (1 - dgrOrderDetails.Columns(4))

     rsOrderDetails.MoveFirst

     Do While Not rsOrderDetails.EOF
       curAmount = curAmount + rsOrderDetails!ExtendedPrice
       rsOrderDetails.MoveNext
     Loop
     txtSubTotal = Format(curAmount, "$ ##0.00")
     

 
     txtTotal = Format(Right$(txtFreight, Len(txtFreight) - 2) + _
                       curAmount, "$ ##0.00")
   Else
     txtSubTotal = "$ 0.00"
     txtTotal = "$ 0.00"
   End If

End Sub

Private Sub dgrOrderDetails_AfterColUpdate(ByVal ColIndex As Integer)

   Total_All

End Sub

Private Sub cmdNew_Click()

   cmdSend.Enabled = True
   dgrOrderDetails.Enabled = True
   hfgProducts.Enabled = True

   txtOrderID = ""
    
   Create_New_Order_Detail
    
   Set dgrOrderDetails.DataSource = rsOrderDetails
    
   Total_All

End Sub

Private Sub cmdSend_Click()

   Dim strOrderConfirm As String
    
   ' Validate some business Rules

   If cboCompany = "" Then
     MsgBox "Company Name must be valid!"
     Exit Sub
   End If
    
   If rsOrderDetails.RecordCount < 1 Then
     MsgBox "No items listed in the order detail section!"
     Exit Sub
   End If
    
   Me.MousePointer = vbHourglass

   With rsOrder
     !CustomerID = objServer.Get_ID("Customers", cboCompany)
     !EmployeeID = objServer.Get_ID("Employees", cboEmployee)
     !OrderDate = dtpOrder
     !RequiredDate = dtpRequired
     !Freight = Val(txtFreight)
     !ShipVia = objServer.Get_ID("Shippers", cboShipVia)
     !ShipName = cboCompany
     !ShipAddress = txtAddress
     !ShipCity = txtCity
     !ShipRegion = txtRegion
     !ShipCountry = txtCountry
     !ShipPostalCode = txtPostal

   End With

   'Send order to Server
   strOrderConfirm = objServer.Send_Order(rsOrder, rsOrderDetails)
    
   Me.MousePointer = vbArrow

   If IsNumeric(strOrderConfirm) Then
     txtOrderID = strOrderConfirm
        
     MsgBox "Your Order has been placed.  The " _
            & vbCrLf & "confirmation number is: " & strOrderConfirm

     cmdSend.Enabled = False
     dgrOrderDetails.Enabled = False
     hfgProducts.Enabled = False
     
   Else
     MsgBox strOrderConfirm
   End If
    
   Set rsGeneric = objServer.Get_Products()
   Set hfgProducts.Recordset = rsGeneric

End Sub


