VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsCustomerSrvr"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'Internal Customers collection
Private m_colCustomers As colCustomers

Private Const SPS = "sps_Customer"
Private Const SPI = "spi_Customer"
Private Const SPD = "spd_Customer"
Private Const SPU = "spu_Customer"
'Const to make sure all New objects have the same spelling of New
Private Const CNEW = "New"

Public Enum Types
    All = 0
    Customer = 1
End Enum

' Delete the Item from the database and the collection
Public Sub Delete(varKey As Variant)
    On Error GoTo ErrorHandler
    
    m_colCustomers.Item(varKey).IsDeleted = True
    
    Exit Sub
ErrorHandler:

    ' Raise an Error back to the calling Application/Object that something
    ' went wrong when trying to mark the item to be deleted when saved
    Err.Raise 1002, , "Unable to mark customer as deleted!"
End Sub


Public Function IsDirty() As Boolean

   On Error GoTo ErrorHandler
    
   Dim objCustomer As clsCustomer
    
   IsDirty = False
   For Each objCustomer In m_colCustomers
      If objCustomer.IsDirty Then
         IsDirty = True
         Exit For
      End If
   Next
   Set objCustomer = Nothing
Exit Function

ErrorHandler:
   If Not objCustomer Is Nothing Then
      Set objCustomer = Nothing
   End If
    
    ' Raise the error back to the call applicaiton/object
    Err.Raise 1004, , _
       "Unable to check to see if the customer objects have changed!"
End Function

'The Load method will allow us to load the Customer objects
'in a few different ways. For example we will be able to load
'a single Customer object or Load all of the Customer objects
'in the system
Public Sub Load(LoadType As Types, Optional Key As Long)
    On Error GoTo ErrorHandler
    Dim objConnect As ADODB.Connection
    Dim objRecordset As ADODB.Recordset
    Dim objCustomer As clsCustomer
    Dim strSQL As String
    
    Set objConnect = New ADODB.Connection
    Set objRecordset = New ADODB.Recordset
'Set the ConnectionString
    objConnect.ConnectionString = "driver={SQL Server};" & _
        "server=(local);uid=sa;pwd=;database=Northwind"
'Open a Connection ot the Database
    objConnect.Open
    
    strSQL = SPS
    
'Set the Type Parameter
    strSQL = strSQL & " " & LoadType
    
'Set the CustomerID, if LoadType is 0 then Set CustomerID = Null.
'Otherwise set the CustomerID parameter = to the Key value.
    If LoadType = All Then
       strSQL = strSQL & ", " & "Null"
    Else
        strSQL = strSQL & ", '" & Key & "'"
    End If
    
'Open the Recordset
    objRecordset.Open strSQL, objConnect, adOpenForwardOnly
    
    
'Now load the Customers returned by the Database into their objects.
    Do While Not objRecordset.EOF
        Set objCustomer = m_colCustomers.Add(objRecordset("CustomerID"))
        With objCustomer
            .IsLoading = True
            .CustomerID = objRecordset("CustomerID")
            .CompanyName = objRecordset("CompanyName")
'All of the following Properties can be Null, to handle this
'we do a check to see before updating the Property
            If Not IsNull(objRecordset("Address")) Then
                .Address = objRecordset("Address")
            End If
            If Not IsNull(objRecordset("City")) Then
                .City = objRecordset("City")
            End If
            If Not IsNull(objRecordset("ContactName")) Then
                .ContactName = objRecordset("ContactName")
            End If
            If Not IsNull(objRecordset("ContactTitle")) Then
                .ContactTitle = objRecordset("ContactTitle")
            End If
            If Not IsNull(objRecordset("Country")) Then
                .Country = objRecordset("Country")
            End If
            If Not IsNull(objRecordset("Fax")) Then
                .Fax = objRecordset("Fax")
            End If
            If Not IsNull(objRecordset("Phone")) Then
                .Phone = objRecordset("Phone")
            End If
            If Not IsNull(objRecordset("Postalcode")) Then
                .PostalCode = objRecordset("PostalCode")
            End If
            If Not IsNull(objRecordset("Region")) Then
                .Region = objRecordset("Region")
            End If
            .IsLoading = False
        End With
        objRecordset.MoveNext
    Loop
        
    Set objCustomer = Nothing
    Set objRecordset = Nothing
    Set objConnect = Nothing
    
    Exit Sub

ErrorHandler:
    Err.Raise 1003, "Load Customer Object Failure"
End Sub

Private Sub Class_Initialize()
    Set m_colCustomers = New colCustomers
End Sub

'Returns the internal Customers Collection.
Public Property Get Customers() As colCustomers
    Set Customers = m_colCustomers
End Property

Public Function NewCustomer() As String
    Dim strKey As String
    Static intNewCount As Integer
    
    strKey = CNEW & " - " & intNewCount
    
    Call m_colCustomers.Add(strKey)
    
    m_colCustomers.Item(strKey).IsDirty = True
    
    intNewCount = intNewCount + 1
    NewCustomer = strKey
    
    Exit Function

ErrorHandler:
    Err.Raise 2004, , "New Customer Failure"
End Function

Public Sub Save()

   On Error GoTo ErrorHandler

   Dim objConnect As ADODB.Connection
   Dim objCommand As ADODB.Command
   Dim objParam As ADODB.Parameter
   Dim objCustomer As clsCustomer
   Dim objHoldCustomer As clsCustomer
   Dim strSQL As String
   Dim intFor As Integer

   Set objConnect = New ADODB.Connection

   'Set the ConnectionString
   objConnect.ConnectionString = "driver={SQL Server};" & _
              "server=(local);uid=sa;pwd=;database=Northwind"

   'Open a connection to the database
    objConnect.Open

   For intFor = m_colCustomers.Count To 1 Step -1
      Set objCustomer = m_colCustomers.Item(intFor)

      If objCustomer.IsDirty Then
         With objCustomer
            Set objCommand = New ADODB.Command
            Set objCommand.ActiveConnection = objConnect

            'If the customer is a new customer and is also deleted then
            'just remove it from the collection as we have not added the
            'customer to the database yet
            If InStr(.Key, "New") And .IsDeleted Then
               m_colCustomers.Remove objCustomer.Key

            'Otherwise, add the customer to the database
            ElseIf InStr(.Key, "New") > 0 Then
               'Load the parameters for the Customer object
               LoadParameters objCommand, objCustomer
               'Set which stored procedure to use
               objCommand.CommandText = SPI
               objCommand.CommandType = adCmdStoredProc
               'Execute the stored procedure
               objCommand.Execute
               'Update the new customer to use the CustomerID instead
               'of the New indicator
               UpdateCustomer objCustomer
               'Remove the old customer from the Customers collection
               m_colCustomers.Remove .Key
               Set objHoldCustomer = Nothing

            'Remove the object from the database and the Customers
            'collection
            ElseIf .IsDeleted = True Then
               'Load the parameters for the Customer object
               Set objParam = objCommand.CreateParameter _
                     ("CustomerID", adVarChar, adParamInput, 5, .CustomerID)
               objCommand.Parameters.Append objParam
               'Set the stored procedure to be used
               objCommand.CommandText = SPD
               objCommand.CommandType = adCmdStoredProc
               'Execute the stored procedure
               objCommand.Execute
               'Remove the object from the collection
               m_colCustomers.Remove objCustomer.Key

            'Default for a Save is an Update
            Else
               'Load the parameters for the Customer object
               LoadParameters objCommand, objCustomer
               'Set the stored procedure to use
               objCommand.CommandText = SPU
               objCommand.CommandType = adCmdStoredProc
               'Execute the Stored Procedured
               objCommand.Execute
               .IsDirty = False
            End If
         End With
      End If
      Set objParam = Nothing
      Set objCommand = Nothing
   Next intFor

   Set objCustomer = Nothing
   Set objConnect = Nothing

Exit Sub

ErrorHandler:

   Err.Raise 2001, , "Customer Save Failure"

End Sub

Private Sub LoadParameters(objCommand As ADODB.Command, objCustomer As clsCustomer)

   Dim objParam As ADODB.Parameter

   With objCustomer
      'Load the parameters for the Customer object
      Set objParam = objCommand.CreateParameter _
          ("CustomerID", adVarChar, adParamInput, 5, .CustomerID)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("CompanyName", adVarChar, adParamInput, 40, .CompanyName)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("ContactName", adVarChar, adParamInput, 30, .ContactName)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("ContactTitle", adVarChar, adParamInput, 30, .ContactTitle)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("Address", adVarChar, adParamInput, 60, .Address)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("City", adVarChar, adParamInput, 15, .City)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("Region", adVarChar, adParamInput, 15, .Region)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("PostalCode", adVarChar, adParamInput, 10, .PostalCode)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("Country", adVarChar, adParamInput, 15, .Country)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("Phone", adVarChar, adParamInput, 24, .Phone)
      objCommand.Parameters.Append objParam
      Set objParam = objCommand.CreateParameter _
          ("Fax", adVarChar, adParamInput, 24, .Fax)
      objCommand.Parameters.Append objParam
   End With

End Sub

'Add a new Customer using the CustoemrID as the Key
Private Sub UpdateCustomer(objCustomer As clsCustomer)

   Dim objHoldCustomer As clsCustomer

   With objCustomer
      Set objHoldCustomer = m_colCustomers.Add(.CustomerID)
      objHoldCustomer.Key = .CustomerID
      objHoldCustomer.CustomerID = .CustomerID
      objHoldCustomer.Address = .Address
      objHoldCustomer.City = .City
      objHoldCustomer.CompanyName = .CompanyName
      objHoldCustomer.ContactName = .ContactName
      objHoldCustomer.ContactTitle = .ContactTitle
      objHoldCustomer.Country = .Country
      objHoldCustomer.Fax = .Fax
      objHoldCustomer.Phone = .Phone
      objHoldCustomer.PostalCode = .PostalCode
      objHoldCustomer.Region = .Region
      objHoldCustomer.IsDirty = False
   End With

End Sub

