if exists (select * from sysobjects where id = object_id(N'[dbo].[spd_Customer]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spd_Customer]
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[spi_Customer]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spi_Customer]
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sps_Customer]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sps_Customer]
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[spu_Customer]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[spu_Customer]
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE spd_Customer 
	@CustomerID	nvarchar(5)
AS

	Begin Transaction

	Delete Customers
	Where CustomerID = @CustomerID

	IF @@Error = 0
	BEGIN
	     Commit Transaction
	     Return 0
	END
	Else
	BEGIN
	     Rollback Transaction
	     Return -1
	End

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE spi_Customer
	@CustomerID	nchar(5),
	@CompanyName	nvarchar(40),
	@ContactName	nvarchar(30),
	@ContactTitle	nvarchar(30),
	@Address	nvarchar(60),
	@City		nvarchar(15),
	@Region		nvarchar(15),
	@PostalCode	nvarchar(10),
	@Country	nvarchar(15),
	@Phone		nvarchar(24),
	@Fax		nvarchar(24)
 AS

	Begin Transaction

	Insert into Customers (CustomerID, CompanyName, ContactName, ContactTitle, Address, City, Region, PostalCode, Country, Phone, Fax)
	Values (@CustomerID, @CompanyName, @ContactName, @ContactTitle, @Address, @City, @Region, @PostalCode, @Country, @Phone, @Fax)

	IF @@Error <> 0
	     Begin
		Rollback Transaction
		Return -1
	     End
	Else
	     Begin
		Commit Transaction
		Return 0
	     End

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE sps_Customer 
	@Type	Int,
	@CustomerID	nChar(5) = Null
AS

Set NOCOUNT ON
Declare @errNo          Int,
	@ErrMsg       varchar(255)

/* Validate that we have the correct information being supplied by the calling Routine */	
	IF  @Type = 1 And @CustomerID Is Null
	Begin
		Select	@ErrNo = 15000,
			@ErrMsg = "When requesting a single customer you must supply a CustomerID."
		Goto Err
	End

/* If Type is a 0 then return all Customers */
	If @Type = 0
		Select	CustomerID,
			CompanyName,
			ContactName,
			ContactTitle,
			Address,
			City,
			Region,
			PostalCode,
			Country,
			Phone,
			Fax                      
		From	Customers
	Else IF @Type = 1
		Select	CustomerID,
			CompanyName,
			ContactName,
			ContactTitle,
			Address,
			City,
			Region,
			PostalCode,
			Country,
			Phone,
			Fax                      
		From	Customers
		Where	CustomerID	= @CustomerID

	Return 0
Err:
	Raiserror @ErrNo @ErrMsg
	Return -1

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO

CREATE PROCEDURE spu_Customer
	@CustomerID	nchar(5),
	@CompanyName	nvarchar(40),
	@ContactName	nvarchar(30),
	@ContactTitle	nvarchar(30),
	@Address	nvarchar(60),
	@City		nvarchar(15),
	@Region		nvarchar(15),
	@PostalCode	nvarchar(10),
	@Country	nvarchar(15),
	@Phone		nvarchar(24),
	@Fax		nvarchar(24)
 AS

	Begin Transaction

	Update Customers 
	Set	CompanyName	= @CompanyName, 
		ContactName	= @ContactName,	 
		ContactTitle	= @ContactTitle,
		Address		= @Address,
		City		= @City,
		Region		= @Region,
		PostalCode	= @PostalCode,
		Country		= @Country,
		Phone		= @Phone,
		Fax		= @Fax
	where	CustomerID	= @CustomerID

	IF @@Error <> 0
	     Begin
		Rollback Transaction
		Return -1
	     End
	Else
	     Begin
		Commit Transaction
		Return 0
	     End

GO
SET QUOTED_IDENTIFIER  OFF    SET ANSI_NULLS  ON 
GO


