VERSION 5.00
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Begin VB.UserControl Sales 
   ClientHeight    =   5130
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   6540
   ScaleHeight     =   5130
   ScaleWidth      =   6540
   Begin VB.CommandButton cmdExtract 
      Caption         =   "&Run Extract"
      Height          =   315
      Left            =   4800
      TabIndex        =   3
      Top             =   4680
      Width           =   1095
   End
   Begin VB.ComboBox cboCustomers 
      Height          =   315
      Left            =   840
      TabIndex        =   2
      Top             =   4680
      Width           =   3855
   End
   Begin MSChart20Lib.MSChart MSChart1 
      Height          =   4095
      Left            =   120
      OleObjectBlob   =   "Sales.ctx":0000
      TabIndex        =   1
      Top             =   480
      Width           =   6255
   End
   Begin VB.Label lblTitle 
      Alignment       =   2  'Center
      Caption         =   "Orders by Sales Amount ($)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   6255
   End
End
Attribute VB_Name = "Sales"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'Property Variables:
Dim m_ExtractFile As String
Dim m_ChartType As ChartFormat

Private vSales() As Variant
Private vCustomers() As Variant
Private vBookmarks() As Variant

'Enumerations
Public Enum Status
    FileOK
    FileEmpty
    FileNotFound
End Enum

Public Enum ChartFormat
    VtChChartType2dBar
    VtChChartType3dBar
End Enum

'Event Declarations:
Event FileStatus(ByVal StatusCode As Status) 'MappingInfo=cmdExtract,cmdExtract,-1,Click
Event PointSelected(evtCompanyName As Variant, evtOrderID As Variant, evtSalesAmount As Variant, evtShippedDate As Variant)

Private Sub UserControl_Initialize()
    'This event fires first at design-time and runtime
    With MSChart1
        .ColumnCount = 1
        .RowCount = 1
        .RowLabel = ""
        .Data = 0
    End With
    lblTitle.Visible = False
End Sub

'Initialize Properties for User Control
Private Sub UserControl_InitProperties()
    m_ExtractFile = ""
    m_ChartType = VtChChartType2dBar
End Sub

'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    m_ExtractFile = PropBag.ReadProperty("ExtractFile", "")
    m_ChartType = PropBag.ReadProperty("ChartType", "")
End Sub

'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    Call PropBag.WriteProperty("ExtractFile", m_ExtractFile, "")
    Call PropBag.WriteProperty("ChartType", m_ChartType, "")
End Sub

'Properties:
Public Property Get ChartType() As ChartFormat
    If Ambient.UserMode Then Err.Raise 393
    ChartType = m_ChartType
End Property

Public Property Let ChartType(ByVal New_ChartType As ChartFormat)
    If Ambient.UserMode Then Err.Raise 382
    m_ChartType = New_ChartType
    PropertyChanged "ChartType"
End Property

Public Property Get ExtractFile() As String
    ExtractFile = m_ExtractFile
End Property

Public Property Let ExtractFile(ByVal New_ExtractFile As String)
    If Ambient.UserMode Then Err.Raise 382
    m_ExtractFile = New_ExtractFile
    PropertyChanged "ExtractFile"
End Property

'Events:
Private Sub cmdExtract_Click()
    'Purpose: Load the extract file
    
    Dim nI As Integer
    
    'Test the extract file
    If m_ExtractFile = "" Then
        RaiseEvent FileStatus(Status.FileEmpty) 'ExtractFile property is empty
        Exit Sub
    ElseIf Dir(m_ExtractFile) = "" Then
        RaiseEvent FileStatus(Status.FileNotFound) 'ExtractFile was not found
        Exit Sub
    Else
        RaiseEvent FileStatus(Status.FileOK) 'ExtractFile OK
    End If
    
    Call GetData
    
    'Populate Combobox
    For nI = 1 To UBound(vCustomers)
        Call cboCustomers.AddItem(vCustomers(nI))
    Next nI
    
    cboCustomers.ListIndex = 0
    Call cboCustomers_Click
End Sub

Private Sub MSChart1_PointSelected(Series As Integer, DataPoint As Integer, MouseFlags As Integer, Cancel As Integer)
    Dim nK As Integer
    'Raise an event with summary information on the selected data point
    nK = vBookmarks(DataPoint) 'Get current position in vSales()
    RaiseEvent PointSelected(vSales(2, nK), vSales(1, nK), vSales(0, nK), vSales(3, nK))
End Sub

Private Sub cboCustomers_Click()
    'Chart selected customer
    'Note: vSales() must have (column, row) order to work with MSChart control
    
    Dim nI As Integer
    Dim nJ As Integer
    
    Erase vBookmarks
    
    With MSChart1
        nJ = 1
        .ColumnCount = nJ 'Update
        .Column = 1
        
        For nI = 1 To UBound(vSales, 2)
            If vSales(2, nI) = cboCustomers.Text Then
                'Store position in vBookmarks
                ReDim Preserve vBookmarks(nJ) As Variant
                vBookmarks(nJ) = nI
                'Add to chart
                .RowCount = nJ
                .Row = nJ
                .RowLabel = vSales(1, nI)
                nJ = nJ + 1
            End If
        Next nI
    End With
    
    lblTitle.Visible = True
End Sub

Private Sub GetData()
    'Purpose:
    '1. Read Contents of 'Sales.txt' into vSales()
    '2. Add the customers to vCustomers()
    'Note: Header row is assigned index of zero
    
    Dim nI As Integer
    Dim nJ As Integer
    Dim bInFound As Boolean
    Dim nCustomers As Integer
    
    'Read the Extract File into vSales()
    nI = 0
    Open m_ExtractFile For Input As #1
        Do While Not EOF(1)
            ReDim Preserve vSales(4, nI) As Variant
            Input #1, vSales(0, nI), vSales(1, nI), _
                        vSales(2, nI), vSales(3, nI)
            nI = nI + 1
        Loop
    Close #1
    
    'Initialize
    nCustomers = 1
    ReDim vCustomers(nCustomers) As Variant
    vCustomers(nCustomers) = vSales(2, 1)
    
    'Assemble Array of customers
    For nI = 1 To UBound(vSales, 2)
        For nJ = 1 To UBound(vCustomers)
            If vCustomers(nJ) = vSales(2, nI) Then
                bInFound = True
                Exit For
            End If
        Next nJ
        If Not bInFound Then
            nCustomers = nCustomers + 1
            ReDim Preserve vCustomers(nCustomers)
            vCustomers(UBound(vCustomers)) = vSales(2, nI)
        Else
            bInFound = False
        End If
    Next nI
End Sub
