Imports System.Xml
Imports System.IO


Public Class InsultProcessor
    Inherits System.ComponentModel.Component


    Public Function ProcessInsultsXmlDoc(ByVal InsultDocument As String, ByVal NumberToProcess As Integer) As Integer
        Dim InsultsXml As New XmlDocument()
        Dim InsultsRoot As XmlNode
        Dim InsultsNode As XmlNode
        Dim RecordsProcessed As Integer

        ' load the insults into the XmlDocument
        Call InsultsXml.Load(InsultDocument)

        ' set the root node
        InsultsRoot = InsultsXml.ChildNodes(1)

        ' based on the NumberToProcess, loop through each 
        ' Insult node and increase the RecordsProcessed by 1
        For Each InsultsNode In InsultsRoot
            RecordsProcessed += 1
            If NumberToProcess <> 0 And NumberToProcess <= RecordsProcessed Then
                Exit For
            End If
        Next

        ProcessInsultsXmlDoc = RecordsProcessed

    End Function

    Public Function ProcessInsultsXmlReader(ByVal InsultDocument As String, ByVal NumberToProcess As Integer) As Integer
        ' create a new instance of an XmlTextReader, with the 
        ' InsultDocument as the FileName
        Dim InsultsReader As New XmlTextReader(InsultDocument)
        Dim RecordsProcessed As Integer
        Dim Insult As String
        Dim Gender As String
        Dim Offensive As String


        ' read each Insult node and increase the RecordsProcessed by 1
        ' based on the NumberToProcess
        While InsultsReader.Read()
            If InsultsReader.Name = "Insult" Then
                'Get attribute values
                Gender = InsultsReader.GetAttribute("Gender")
                Offensive = InsultsReader.GetAttribute("Offensive")
                'Get the element value
                Insult = InsultsReader.ReadElementString()

                'Increment the counter
                RecordsProcessed += 1
                'Check to see if we have processed the requeted number of elements
                If NumberToProcess <> 0 And NumberToProcess <= RecordsProcessed Then
                    Exit While
                End If
            End If
        End While

        ProcessInsultsXmlReader = RecordsProcessed

    End Function



#Region " Component Designer generated code "

    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyClass.New()

        'Required for Windows.Forms Class Composition Designer support
        Container.Add(Me)
    End Sub

    Public Sub New()
        MyBase.New()

        'This call is required by the Component Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Required by the Component Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container()
    End Sub

#End Region

End Class
