using System;
using System.Xml;
using System.Xml.Serialization;

namespace Errors
{
	[Serializable()]
	public class Error
	{
		// Property holders
		private string m_application;
		private string m_machine;
		private int m_number;
		private string m_description;
		private int m_severity;
		private int m_id;
		private System.DateTime m_createdDate;
		
		//Property accessors
		[SoapAttribute()]
		[XmlAttribute()]
		public int ID
		{
			get {return m_id;}
			set {m_id = value;}
		}		
		
		[SoapElement()]
		[XmlElement()]
		public int Number
		{
			get {return m_number;}
			set {m_number = value;}
		}
		
		[SoapElement()]
		[XmlElement()]
		public string Description
		{
			get {return m_description;}
			set {m_description = value;}
		}

		[SoapAttribute()]
		[XmlAttribute()]
		public string Application
		{
			get {return m_application;}
			set {m_application = value;}
		}

		[SoapAttribute()]
		[XmlAttribute()]
		public string Machine
		{
			get {return m_machine;}
			set {m_machine = value;}
		}

		[SoapElement()]
		[XmlElement()]
		public int Severity
		{
			get {return m_severity;}
			set {m_severity = value;}
		}
		
		[SoapElement()]
		[XmlElement()]
		public System.DateTime CreatedDate
		{
			get {return m_createdDate;}
			set {m_createdDate = value;}
		}
	}

	public class ErrorsCollection : System.Collections.CollectionBase
	{
		// Indexer - Strongly typed
		public Error this [int index]
		{
			get
			{
				return (Error)this.List[index];
			}
		}

		// Add method - Strongly typed
		public void Add (Error newError)
		{
			this.List.Add(newError);
		}
	}
}
