using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;

namespace Errors
{
	/// <summary>
	/// The ErrorProcessor class contains the Insert and Browse methods for handling Error objects
	/// </summary>
	public class ErrorProcessor 
	{
		//
		private SqlConnection sqlConn;
		private SqlDataAdapter errorDataAdapter;
		private SqlCommand browseCommand;
		private SqlCommand insertCommand;
		
		public ErrorProcessor()
		{
			InitializeComponent();
		}

		//Insert new error
		public void Insert(Error newError)
		{
			sqlConn.Open();
			// insert newError into the Error table
			errorDataAdapter.InsertCommand.Parameters["@Number"].Value = newError.Number;
			errorDataAdapter.InsertCommand.Parameters["@Description"].Value = newError.Description;
			errorDataAdapter.InsertCommand.Parameters["@Application"].Value = newError.Application;
			errorDataAdapter.InsertCommand.Parameters["@Machine"].Value = newError.Machine;
			errorDataAdapter.InsertCommand.Parameters["@Severity"].Value = newError.Severity;
			errorDataAdapter.InsertCommand.ExecuteNonQuery();
			sqlConn.Close();

		}
		
		//Retrieve existing errors
		public ErrorsCollection Browse(string application, int severity, DateTime startDate, DateTime endDate)
		{
			// browse for errors satisfying the passed in criteria
			sqlConn.Open();
			
			errorDataAdapter.SelectCommand.Parameters["@Application"].Value = application; 
			errorDataAdapter.SelectCommand.Parameters["@Severity"].Value = severity;
			errorDataAdapter.SelectCommand.Parameters["@StartDate"].Value = startDate;	
			errorDataAdapter.SelectCommand.Parameters["@EndDate"].Value = endDate;
			
			SqlDataReader errorsReader = errorDataAdapter.SelectCommand.ExecuteReader();

			ErrorsCollection errorList = new ErrorsCollection();

			while(errorsReader.Read()) 
			{
				// add to the ErrorsCollection all of the returned rows
				Error newError = new Error();
				
				newError.ID = errorsReader.GetInt32(0);
				newError.Number = errorsReader.GetInt32(1);
				newError.Description = errorsReader.GetString(2);
				newError.Application = errorsReader.GetString(3);
				newError.Machine = errorsReader.GetString(4);
				newError.Severity = errorsReader.GetInt16(5);
				newError.CreatedDate = errorsReader.GetDateTime(6);

				errorList.Add(newError);
			}

			sqlConn.Close();
			
			return errorList;
		}
	
		private void InitializeComponent()
		{
			this.sqlConn = new System.Data.SqlClient.SqlConnection();
			this.errorDataAdapter = new System.Data.SqlClient.SqlDataAdapter();
			this.browseCommand = new System.Data.SqlClient.SqlCommand();
			this.insertCommand = new System.Data.SqlClient.SqlCommand();
			// 
			// sqlConn
			// 

			// TODO:  change the connection string for the DEMO
			this.sqlConn.ConnectionString = "data source=(local);initial catalog=ErrorLog;persist security info=False;user " +
				"id=sa;password=otto;workstation id=OTTO;packet size=4096";
			// 
			// errorDataAdapter
			// 
			this.errorDataAdapter.InsertCommand = this.insertCommand;
			this.errorDataAdapter.SelectCommand = this.browseCommand;
			this.errorDataAdapter.TableMappings.AddRange(new System.Data.Common.DataTableMapping[] {
																									   new System.Data.Common.DataTableMapping("Table", "Errors", new System.Data.Common.DataColumnMapping[] {
																																																				 new System.Data.Common.DataColumnMapping("ID", "ID"),
																																																				 new System.Data.Common.DataColumnMapping("Number", "Number"),
																																																				 new System.Data.Common.DataColumnMapping("Description", "Description"),
																																																				 new System.Data.Common.DataColumnMapping("Application", "Application"),
																																																				 new System.Data.Common.DataColumnMapping("Machine", "Machine"),
																																																				 new System.Data.Common.DataColumnMapping("Severity", "Severity"),
																																																				 new System.Data.Common.DataColumnMapping("CreatedDate", "CreatedDate")})});
			// 
			// browseCommand
			// 
			this.browseCommand.CommandText = "[BrowseErrors]";
			this.browseCommand.CommandType = System.Data.CommandType.StoredProcedure;
			this.browseCommand.Connection = this.sqlConn;
			this.browseCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@RETURN_VALUE", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.ReturnValue, false, ((System.Byte)(0)), ((System.Byte)(0)), "", System.Data.DataRowVersion.Current, null));

			this.browseCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Application", System.Data.SqlDbType.VarChar, 200, "Application"));
			this.browseCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Severity", System.Data.SqlDbType.SmallInt, 2, "Severity"));
			this.browseCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@StartDate", System.Data.SqlDbType.DateTime));
			this.browseCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@EndDate", System.Data.SqlDbType.DateTime));
			
			// 
			// insertCommand
			// 
			this.insertCommand.CommandText = "[InsertError]";
			this.insertCommand.CommandType = System.Data.CommandType.StoredProcedure;
			this.insertCommand.Connection = this.sqlConn;
			this.insertCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@RETURN_VALUE", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.ReturnValue, false, ((System.Byte)(0)), ((System.Byte)(0)), "", System.Data.DataRowVersion.Current, null));
			this.insertCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Number", System.Data.SqlDbType.Int, 4, "Number"));
			this.insertCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Description", System.Data.SqlDbType.VarChar, 200, "Description"));
			this.insertCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Application", System.Data.SqlDbType.VarChar, 200, "Application"));
			this.insertCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Machine", System.Data.SqlDbType.VarChar, 200, "Machine"));
			this.insertCommand.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Severity", System.Data.SqlDbType.SmallInt, 2, "Severity"));
		}
	}

}
