Imports System.Messaging
Imports System.Xml
Imports System.IO
Imports System.Windows.Forms.Application
Imports System.Text

Public Class Form1
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents errorList As System.Windows.Forms.ListBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents demoQueue As System.Messaging.MessageQueue
    Friend WithEvents Button4 As System.Windows.Forms.Button
    Friend WithEvents Button5 As System.Windows.Forms.Button

    Private rslt As System.IAsyncResult
    Friend WithEvents cmdPutOnQueue As System.Windows.Forms.Button
    Friend WithEvents cmdStartListening As System.Windows.Forms.Button
    Friend WithEvents cmdStopListening As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.cmdStartListening = New System.Windows.Forms.Button()
        Me.cmdStopListening = New System.Windows.Forms.Button()
        Me.errorList = New System.Windows.Forms.ListBox()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.demoQueue = New System.Messaging.MessageQueue()
        Me.cmdPutOnQueue = New System.Windows.Forms.Button()
        Me.Button4 = New System.Windows.Forms.Button()
        Me.Button5 = New System.Windows.Forms.Button()
        Me.SuspendLayout()
        '
        'cmdStartListening
        '
        Me.cmdStartListening.Location = New System.Drawing.Point(113, 59)
        Me.cmdStartListening.Name = "cmdStartListening"
        Me.cmdStartListening.Size = New System.Drawing.Size(112, 29)
        Me.cmdStartListening.TabIndex = 0
        Me.cmdStartListening.Text = "START"
        '
        'cmdStopListening
        '
        Me.cmdStopListening.Location = New System.Drawing.Point(113, 99)
        Me.cmdStopListening.Name = "cmdStopListening"
        Me.cmdStopListening.Size = New System.Drawing.Size(112, 28)
        Me.cmdStopListening.TabIndex = 1
        Me.cmdStopListening.Text = "STOP"
        '
        'errorList
        '
        Me.errorList.ItemHeight = 16
        Me.errorList.Location = New System.Drawing.Point(31, 168)
        Me.errorList.Name = "errorList"
        Me.errorList.Size = New System.Drawing.Size(286, 100)
        Me.errorList.TabIndex = 2
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(92, 138)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(174, 30)
        Me.Label1.TabIndex = 3
        Me.Label1.Text = "ERRORS LOGGED:"
        Me.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'demoQueue
        '
        Me.demoQueue.Path = "lauryn\Private$\DemoQueue"
        Me.demoQueue.SynchronizingObject = Me
        '
        'cmdPutOnQueue
        '
        Me.cmdPutOnQueue.Location = New System.Drawing.Point(113, 10)
        Me.cmdPutOnQueue.Name = "cmdPutOnQueue"
        Me.cmdPutOnQueue.Size = New System.Drawing.Size(112, 39)
        Me.cmdPutOnQueue.TabIndex = 4
        Me.cmdPutOnQueue.Text = "PUT ERRORS ON QUEUE"
        '
        'Button4
        '
        Me.Button4.Location = New System.Drawing.Point(31, 296)
        Me.Button4.Name = "Button4"
        Me.Button4.Size = New System.Drawing.Size(123, 29)
        Me.Button4.TabIndex = 5
        Me.Button4.Text = "PURGE QUEUE"
        '
        'Button5
        '
        Me.Button5.Location = New System.Drawing.Point(174, 296)
        Me.Button5.Name = "Button5"
        Me.Button5.Size = New System.Drawing.Size(133, 29)
        Me.Button5.TabIndex = 6
        Me.Button5.Text = "CLEAR LISTBOX"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
        Me.ClientSize = New System.Drawing.Size(348, 328)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Button5, Me.Button4, Me.cmdPutOnQueue, Me.Label1, Me.errorList, Me.cmdStopListening, Me.cmdStartListening})
        Me.Name = "Form1"
        Me.Text = "MSMQ Client"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private processingMessages As Boolean = False



    Private Sub ProcessSoapMsg(ByVal soapMsg As XmlTextReader)

        Dim newError As New Errors.Error()
        Dim errorProcessor As New Errors.ErrorProcessor()
        Dim parser As System.Xml.XmlParserContext

        Dim currentMsgReader As New XmlTextReader(soapMsg.Value, System.Xml.XmlNodeType.Element, parser)

        While currentMsgReader.Read()
            Select Case currentMsgReader.NodeType
                Case XmlNodeType.XmlDeclaration

                    ' if an <xml tag then check to see if next element is a LogError tag
                    currentMsgReader.ReadStartElement()
                    If currentMsgReader.NodeType = XmlNodeType.Element And currentMsgReader.Name = "soap:Body" Then
                        ' move to the next node
                        currentMsgReader.ReadStartElement()
                        If currentMsgReader.NodeType = XmlNodeType.Element And currentMsgReader.Name = "LogError" Then
                            currentMsgReader.ReadStartElement()
                            With newError
                                ' grab the attributes
                                .Application = currentMsgReader.Item("Application")
                                .Machine = currentMsgReader.Item("Machine")

                                ' grab the element properties
                                currentMsgReader.ReadStartElement()
                                currentMsgReader.Read()
                                .Number = Convert.ToInt32(currentMsgReader.Value())
                                currentMsgReader.Read()

                                currentMsgReader.Read()
                                currentMsgReader.Read()
                                .Description = currentMsgReader.Value()
                                currentMsgReader.Read()

                                currentMsgReader.Read()
                                currentMsgReader.Read()
                                .Severity = Convert.ToInt32(currentMsgReader.Value())

                            End With
                            errorProcessor.Insert(newError)
                            errorList.Items.Add(newError.Description)
                        Else
                            MessageBox.Show("Message is not a valid SOAP message.")
                        End If
                    Else
                        MessageBox.Show("Message is not a valid SOAP message.")
                    End If
            End Select

        End While

    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        errorList.Items.Clear()
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        demoQueue.Purge()
    End Sub

    Private Sub cmdPutOnQueue_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPutOnQueue.Click
        Dim errCounter As Int16
        Dim sXML As String


        'Write 40 SOAP Requests to the queue
        For errCounter = 1 To 40
            sXML = "<?xml version=""1.0"" standalone=""no""?>"
            sXML = sXML & "<soap:Envelope xmlns:soap=""http://schemas.xmlsoap.org/soap/envelope/"">"
            sXML = sXML & "<soap:Body><LogError xmlns=""http://demos.claritycon.com"">"
            sXML = sXML & "<newError Application=""" & "MSMQClient" & """ Machine=""" & "localhost" & """>"
            sXML = sXML & "<Number>" & errCounter & "</Number>"
            sXML = sXML & "<Description>" & "error #" & errCounter & "</Description>"
            sXML = sXML & "<Severity>" & "2" & "</Severity>"
            sXML = sXML & "</newError>"
            sXML = sXML & "</LogError></soap:Body></soap:Envelope>"

            demoQueue.Send(sXML, "DemoError @ " & Now.ToString())

        Next
        MessageBox.Show("Errors were put on the queue.")

    End Sub

    Private Sub cmdStartListening_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdStartListening.Click

        Dim msg As Message
        Dim errorProcessor As New Errors.ErrorProcessor()
        Dim timeOut As New System.TimeSpan(0, 0, 2)

        'Start reading from queue
        Try
            processingMessages = True
            Do While processingMessages
                DoEvents()
                msg = demoQueue.Receive(timeOut)
                msg = demoQueue.Receive()
                msg.BodyStream.Position = 0

                Dim xmlReader As New XmlTextReader(msg.BodyStream)
                Do While (xmlReader.Read())

                    If xmlReader.NodeType = XmlNodeType.Element Then
                        Select Case xmlReader.Name

                            Case "string"
                                xmlReader.Read()
                                Dim parser As System.Xml.XmlParserContext
                                Dim MessageReader As New XmlTextReader(xmlReader.Value, XmlNodeType.Element, parser)

                                Do While MessageReader.Read
                                    If MessageReader.NodeType = XmlNodeType.Element Then
                                        Select Case MessageReader.Name
                                            Case "soap:Body"
                                                MessageReader.Read()
                                                'This Element will tell us the method that was called
                                                Select Case MessageReader.Name
                                                    Case "LogError"
                                                        'Create a new Error object
                                                        Dim currentError As New Errors.Error()

                                                        'Parse the body of the request and set the properties
                                                        MessageReader.Read()
                                                        'Grab the attributes
                                                        currentError.Application = MessageReader.Item("Application")
                                                        currentError.Machine = MessageReader.Item("Machine")

                                                        'Read the element properties
                                                        MessageReader.ReadStartElement()
                                                        MessageReader.Read()
                                                        currentError.Number = Convert.ToInt32(MessageReader.Value())
                                                        MessageReader.Read()

                                                        MessageReader.Read()
                                                        MessageReader.Read()
                                                        currentError.Description = MessageReader.Value()
                                                        MessageReader.Read()

                                                        MessageReader.Read()
                                                        MessageReader.Read()
                                                        currentError.Severity = Convert.ToInt32(MessageReader.Value())

                                                        'Create an ErrorProcessor and inser the error
                                                        Dim currentErrorProcessor As New Errors.ErrorProcessor()
                                                        currentErrorProcessor.Insert(currentError)

                                                        Me.errorList.Items.Add("Error Processed")
                                                End Select
                                        End Select
                                    End If
                                Loop
                        End Select
                    End If
                Loop
            Loop
            demoQueue.Close()

        Catch mqEx As MessageQueueException
            ' Handle no message arriving in the queue.
            If mqEx.MessageQueueErrorCode = _
                MessageQueueErrorCode.IOTimeout Then
                MessageBox.Show("Receive timed out:  No messages in queue.")
            End If
        End Try

    End Sub

    Private Sub cmdStopListening_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdStopListening.Click
        MessageBox.Show("Stop Reading From Queue")
        processingMessages = False
    End Sub
End Class

