Imports System.Web.Services
Imports Errors
Imports System.IO
Imports System
Imports System.Web.Services.Protocols
Imports System.Xml.Serialization
Imports System.Web.Services.Description

<WebService(Namespace:="http://demos.claritycon.com")> _
Public Class WSErrorProcessor
    Inherits System.Web.Services.WebService

#Region " Web Services Designer Generated Code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Web Services Designer.
        InitializeComponent()

        'Add your own initialization code after the InitializeComponent() call

    End Sub

    'Required by the Web Services Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Web Services Designer
    'It can be modified using the Web Services Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container()
    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        'CODEGEN: This procedure is required by the Web Services Designer
        'Do not modify it using the code editor.
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

#End Region

    <WebMethod(Description:="Document/Literal method to retrieve existing errors")> _
    Public Function GetErrors(ByVal application As String, ByVal severity As String, ByVal startDate As String, ByVal endDate As String) As ErrorsCollection

        'Create the ErrorProcessor object
        Dim err As New ErrorProcessor()

        'Try the call and throw an exception if it fails
        Try
            Return err.Browse(application, Convert.ToInt16(severity), Convert.ToDateTime(startDate), Convert.ToDateTime(endDate))
        Catch ex As Exception
            Throw New SoapException("A SoapException has occurred: " & ex.Message, System.Web.Services.Protocols.SoapException.ClientFaultCode)
        End Try

    End Function

    <WebMethod(Description:="Document/Literal method to add a new error")> _
    Public Sub LogError(ByVal newError As Errors.Error)

        'Create the ErrorProcessor object
        Dim err As New ErrorProcessor()

        'Try the call and throw an exception if it fails
        Try
            Call err.Insert(newError)
        Catch ex As Exception
            Throw New SoapException("A SoapException has occurred: " & ex.Message, System.Web.Services.Protocols.SoapException.ClientFaultCode)
        End Try
    End Sub

    <SoapRpcMethod(Action:="http://demos.claritycon.com/GetErrorsRPC"), _
    WebMethod(Description:="RPC/Encoded method to retrieve existing errors")> _
    Public Function GetErrorsRPC(ByVal application As String, ByVal severity As String, ByVal startDate As String, ByVal endDate As String) As ErrorsCollection

        'Create the ErrorProcessor object
        Dim err As New ErrorProcessor()

        'Try the call and throw an exception if it fails
        Try
            Return err.Browse(application, Convert.ToInt16(severity), Convert.ToDateTime(startDate), Convert.ToDateTime(endDate))
        Catch ex As Exception
            Throw New SoapException("A SoapException has occurred: " & ex.Message, System.Web.Services.Protocols.SoapException.ClientFaultCode)
        End Try

    End Function

    <SoapRpcMethod(Action:="http://demos.claritycon.com/LogErrorRPC"), _
    WebMethod(Description:="RPC/Encoded method to add a new error")> _
    Public Sub LogErrorRPC(ByVal newError As Errors.Error)

        'Create the ErrorProcessor object
        Dim err As New ErrorProcessor()

        'Try the call and throw an exception if it fails
        Try
            Call err.Insert(newError)
        Catch ex As Exception
            Throw New SoapException("A SoapException has occurred: " & ex.Message, System.Web.Services.Protocols.SoapException.ClientFaultCode)
        End Try
    End Sub
End Class
