Imports Errors

Public Class RemoteErrorService
    Inherits MarshalByRefObject

    Public Function GetErrors(ByVal application As String, ByVal severity As String, ByVal startDate As String, ByVal endDate As String) As ErrorsCollection

        'Create the Error processor
        Dim err As New ErrorProcessor()

        'Try getting the errors
        Try
            Return err.Browse(application, Convert.ToInt16(severity), Convert.ToDateTime(startDate), Convert.ToDateTime(endDate))
        Catch ex As Exception
            Throw New Exception("A Exception has occurred: " & ex.Message)
        End Try

    End Function

    Public Sub LogError(ByVal newError As Errors.Error)

        'Create the ErrorProcessor
        Dim err As New ErrorProcessor()

        'Try inserting the new error
        Try
            Call err.Insert(newError)
        Catch ex As Exception
            Throw New Exception("A Exception has occurred: " & ex.Message)
        End Try
    End Sub
End Class