//: c12:FileLocking.java
// From 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. See copyright notice in CopyRight.txt.
import java.io.FileOutputStream;
import java.nio.channels.*;
import com.bruceeckel.simpletest.*;

public class FileLocking {
  private static Test monitor = new Test();
  public static void main(String[] args) throws Exception {
    FileOutputStream fos= new FileOutputStream("file.txt");
    FileLock fl = (fos.getChannel()).tryLock();
    if(fl != null) {
      System.out.println("Locked File");
      Thread.sleep(100);
      fl.release();
      System.out.println("Released Lock");
    }
    fos.close();
    monitor.expect(new String[]{
      "Locked File",
      "Released Lock"
    });
  }
} ///:~