//: c12:UsingBuffers.java
// From 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. See copyright notice in CopyRight.txt.
import java.nio.*;
import com.bruceeckel.simpletest.*;

public class UsingBuffers {
  private static Test monitor = new Test();
  private static CharBuffer
  symmScramble(CharBuffer buffer) {
    while(buffer.position() < buffer.limit()) {
      buffer.mark();
      char c1 = buffer.get();
      char c2 = buffer.get();
      ((CharBuffer)buffer.reset()).put(c2).put(c1);
    }
    System.out.println(buffer.rewind());
    return buffer;
  }
  public static void main(String[] args) {
    CharBuffer cb =
      CharBuffer.wrap("UsingBuffers".toCharArray());
    symmScramble(cb);
    symmScramble(cb);
    monitor.expect(new String[] {
      "sUniBgfuefsr",
      "UsingBuffers"
    });
  }
} ///:~