Option Explicit On 

Public MustInherit Class BaseItem

    Private miItemNumber As Integer
    Private msName As String
    Private msDesc As String
    Private miQtyOnHand As Integer

    Public ReadOnly Property ItemNumber() As Integer
        Get
            Return miItemNumber
        End Get
    End Property

    Public Property Name() As String
        Get
            Return msName
        End Get
        Set(ByVal Value As String)
            msName = Value
        End Set
    End Property

    Public Property Description() As String
        Get
            Return msDesc
        End Get
        Set(ByVal Value As String)
            msDesc = Value
        End Set
    End Property

    Protected Property Quantity() As Integer
        Get
            Return miQtyOnHand
        End Get
        Set(ByVal Value As Integer)
            miQtyOnHand = Value
        End Set
    End Property

    Public Sub New(ByVal ItemNumber As Integer)
        miItemNumber = ItemNumber
        'Load other properties from database
    End Sub

    Public Sub New(ByVal ItemNumber As Integer, ByVal Name As String, ByVal Description As String)
        miItemNumber = ItemNumber
        msName = Name
        msDesc = Description
    End Sub

    Protected Sub Receive(ByVal Quantity As Integer)
        miQtyOnHand += Quantity
    End Sub

    Protected Sub Remove(ByVal Quantity As Integer)
        miQtyOnHand -= Quantity
    End Sub

End Class

Public Class StockItem
    Inherits BaseItem

    Public Sub New(ByVal ItemNumber As Integer)
        MyBase.New(ItemNumber)
    End Sub

    Public Sub New(ByVal ItemNumber As Integer, ByVal Name As String, ByVal Description As String, ByVal Quantity As Integer)
        MyBase.New(ItemNumber, Name, Description)
        MyBase.Receive(Quantity)
    End Sub

    Public Sub ReceiveItems(ByVal Quantity As Integer)
        MyBase.Receive(Quantity)
    End Sub

    Public Sub RemoveItems(ByVal Quantity As Integer)
        MyBase.Remove(Quantity)
    End Sub

End Class


Public Class SerializedItem
    Inherits BaseItem

    Private mSerialNumbers As New Hashtable()

    Public ReadOnly Property SerialNumbers() As Hashtable
        Get
            SerialNumbers = mSerialNumbers
        End Get
    End Property

    Public Sub New(ByVal ItemNumber As Integer)
        MyBase.New(ItemNumber)
        'Load serial numbers from Database
    End Sub

    Public Sub New(ByVal Name As String, ByVal ItemNumber As Integer, ByVal Description As String)
        MyBase.New(Name, ItemNumber, Description)
    End Sub

    Public Sub ReceiveSerializedItem(ByVal SerialNumber As String)
        MyBase.Receive(1)
        mSerialNumbers.Add(SerialNumber, SerialNumber)
    End Sub

    Public Sub RemoveSerializedItem(ByVal SerialNumber As String)
        If mSerialNumbers.ContainsKey(SerialNumber) Then
            MyBase.Remove(1)
            mSerialNumbers.Remove(SerialNumber)
        Else
            'Raise Error for Serial Number Not Found
        End If
    End Sub

End Class
