using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Security.Permissions;
using System.Security;
using System.IO;
using System.Diagnostics;

namespace DevT145_CS
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button cmdDeny;
		private System.Windows.Forms.Button cmdPermit;
		private System.Windows.Forms.Button cmdDemand;
		private System.Windows.Forms.Button cmdstack;
		private System.Windows.Forms.Button cmdPermissionSet;
		private System.Windows.Forms.Button cmdDeclaritive;
		private System.Windows.Forms.Button cmdCleanUp;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.TextBox textBox3;
		private System.Windows.Forms.Button button1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdDeny = new System.Windows.Forms.Button();
			this.cmdPermit = new System.Windows.Forms.Button();
			this.cmdDemand = new System.Windows.Forms.Button();
			this.cmdstack = new System.Windows.Forms.Button();
			this.cmdPermissionSet = new System.Windows.Forms.Button();
			this.cmdDeclaritive = new System.Windows.Forms.Button();
			this.cmdCleanUp = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.textBox2 = new System.Windows.Forms.TextBox();
			this.textBox3 = new System.Windows.Forms.TextBox();
			this.button1 = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// cmdDeny
			// 
			this.cmdDeny.Name = "cmdDeny";
			this.cmdDeny.Size = new System.Drawing.Size(88, 23);
			this.cmdDeny.TabIndex = 0;
			this.cmdDeny.Text = "Deny";
			this.cmdDeny.Click += new System.EventHandler(this.cmdDeny_Click);
			// 
			// cmdPermit
			// 
			this.cmdPermit.Location = new System.Drawing.Point(0, 24);
			this.cmdPermit.Name = "cmdPermit";
			this.cmdPermit.Size = new System.Drawing.Size(88, 23);
			this.cmdPermit.TabIndex = 1;
			this.cmdPermit.Text = "Permit";
			this.cmdPermit.Click += new System.EventHandler(this.cmdPermit_Click);
			// 
			// cmdDemand
			// 
			this.cmdDemand.Location = new System.Drawing.Point(0, 48);
			this.cmdDemand.Name = "cmdDemand";
			this.cmdDemand.Size = new System.Drawing.Size(88, 23);
			this.cmdDemand.TabIndex = 2;
			this.cmdDemand.Text = "Demand";
			this.cmdDemand.Click += new System.EventHandler(this.cmdDemand_Click);
			// 
			// cmdstack
			// 
			this.cmdstack.Location = new System.Drawing.Point(0, 72);
			this.cmdstack.Name = "cmdstack";
			this.cmdstack.Size = new System.Drawing.Size(88, 23);
			this.cmdstack.TabIndex = 3;
			this.cmdstack.Text = "Stack";
			this.cmdstack.Click += new System.EventHandler(this.cmdstack_Click);
			// 
			// cmdPermissionSet
			// 
			this.cmdPermissionSet.Location = new System.Drawing.Point(0, 96);
			this.cmdPermissionSet.Name = "cmdPermissionSet";
			this.cmdPermissionSet.Size = new System.Drawing.Size(88, 23);
			this.cmdPermissionSet.TabIndex = 4;
			this.cmdPermissionSet.Text = "Permission Set";
			this.cmdPermissionSet.Click += new System.EventHandler(this.cmdPermissionSet_Click);
			// 
			// cmdDeclaritive
			// 
			this.cmdDeclaritive.Location = new System.Drawing.Point(0, 120);
			this.cmdDeclaritive.Name = "cmdDeclaritive";
			this.cmdDeclaritive.Size = new System.Drawing.Size(88, 23);
			this.cmdDeclaritive.TabIndex = 5;
			this.cmdDeclaritive.Text = "Declarative";
			this.cmdDeclaritive.Click += new System.EventHandler(this.cmdDeclaritive_Click);
			// 
			// cmdCleanUp
			// 
			this.cmdCleanUp.Location = new System.Drawing.Point(0, 144);
			this.cmdCleanUp.Name = "cmdCleanUp";
			this.cmdCleanUp.Size = new System.Drawing.Size(88, 23);
			this.cmdCleanUp.TabIndex = 6;
			this.cmdCleanUp.Text = "Clean Up";
			this.cmdCleanUp.Click += new System.EventHandler(this.cmdCleanUp_Click);
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(112, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(160, 16);
			this.label1.TabIndex = 7;
			this.label1.Text = "Operation 1";
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(112, 96);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(160, 16);
			this.label2.TabIndex = 8;
			this.label2.Text = "Operation 2";
			// 
			// label3
			// 
			this.label3.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label3.Location = new System.Drawing.Point(112, 192);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(160, 16);
			this.label3.TabIndex = 9;
			this.label3.Text = "Operation 3";
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(96, 32);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox1.Size = new System.Drawing.Size(416, 56);
			this.textBox1.TabIndex = 10;
			this.textBox1.Text = "";
			// 
			// textBox2
			// 
			this.textBox2.Location = new System.Drawing.Point(96, 120);
			this.textBox2.Multiline = true;
			this.textBox2.Name = "textBox2";
			this.textBox2.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox2.Size = new System.Drawing.Size(416, 56);
			this.textBox2.TabIndex = 11;
			this.textBox2.Text = "";
			// 
			// textBox3
			// 
			this.textBox3.Location = new System.Drawing.Point(96, 208);
			this.textBox3.Multiline = true;
			this.textBox3.Name = "textBox3";
			this.textBox3.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox3.Size = new System.Drawing.Size(416, 56);
			this.textBox3.TabIndex = 12;
			this.textBox3.Text = "";
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(424, 280);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(88, 23);
			this.button1.TabIndex = 13;
			this.button1.Text = "Exit";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(528, 318);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.button1,
																		  this.textBox3,
																		  this.textBox2,
																		  this.textBox1,
																		  this.label3,
																		  this.label2,
																		  this.label1,
																		  this.cmdCleanUp,
																		  this.cmdDeclaritive,
																		  this.cmdPermissionSet,
																		  this.cmdstack,
																		  this.cmdDemand,
																		  this.cmdPermit,
																		  this.cmdDeny});
			this.Name = "Form1";
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
		
		}

		private void cmdDeny_Click(object sender, System.EventArgs e)
		{
			clsEnvironment oEnvironment = new clsEnvironment();

			//'Read the Path environment variable
			this.textBox1.Text = oEnvironment.Retrieve("path");

			//'Create permission class from System.Security.Permissions
			EnvironmentPermission perEnvironment = new EnvironmentPermission(EnvironmentPermissionAccess.Read, "path");

			//'Deny access to environment variables
			perEnvironment.Deny();

			//'Try to read the Path variable again
			try
			{
				this.textBox2.Text = oEnvironment.Retrieve("path");
			}
			catch(SecurityException se)
			{
				this.textBox2.Text = se.Message;
			}
	        

			//'Revert the Deny (restore permission to the environemnt variables)
			//perEnvironment.RevertDeny();
			EnvironmentPermission.RevertDeny();

			//'Read the Path again
			this.textBox3.Text = oEnvironment.Retrieve("path");
		}

		private void cmdPermit_Click(object sender, System.EventArgs e)
		{
			
			//'clear the prior textbox contents
			this.textBox1.Text="";
			this.textBox2.Text="";
			this.textBox3.Text="";

			//'Create the local FileIO class
			clsFileIO oFile = new clsFileIO();

			//'Write a line to the file
			oFile.Write("Message from DevT145");

			//'Create FileIO Permission class from System.Security.Permissions.
			FileIOPermission perFile = new FileIOPermission(FileIOPermissionAccess.Read, "c:/DEVT145.txt");

			//'Permit ONLY read access to the file
			perFile.PermitOnly();

			//'Try reading from and writing to the file
			try
			{
				textBox1.Text = oFile.Read();
				oFile.Write("Another message from DevT145 ");
			}
			catch (SecurityException se)
			{
				this.textBox2.Text = se.Message;
			}

			//'Revert the limited permission grant (will restore read/write access)
			//perFile.RevertPermitOnly;
			FileIOPermission.RevertPermitOnly();

			//'Write to the file
			oFile.Write("Last message from DevT145");

		}

		private void cmdDemand_Click(object sender, System.EventArgs e)
		{
			// 'clear the prior textbox contents
			this.textBox1.Text="";
			this.textBox2.Text="";
			this.textBox3.Text="";

			//'Deny access to the clipboard
			UIPermission perClipboard = new UIPermission(PermissionState.Unrestricted);
			perClipboard.Deny();

			//'Attempt to read from the clipboard
			clsClipboard oClipBoard = new clsClipboard();
			try
			{
				this.textBox1.Text= oClipBoard.Retrieve();
			}
			catch (SecurityException se)
			{
				this.textBox2.Text = se.Message;
			}
			finally
			{
				//'Restore permission to the clipboard
				//perClipboard.RevertDeny();
				UIPermission.RevertDeny();
			}
		}

		private void cmdstack_Click(object sender, System.EventArgs e)
		{
			//Deny access to the event log
			EventLogPermission perLog = new EventLogPermission(PermissionState.Unrestricted);
			perLog.Deny();

			//'Attempt to read a env var and log it to the event log
			clsEnvironment oEnvironment = new clsEnvironment();
			try
			{
				this.textBox1.Text=oEnvironment.RetrieveAndLog("path");
			}
			catch(SecurityException se){
				this.textBox1.Text = se.StackTrace;
			}
			
			//'Use the RetrieveAndLogAssert method to perform the same action
			try
			{
				this.textBox2.Text = oEnvironment.RetrieveAndLogAssert("path");
			}
			catch (SecurityException se)
			{
				this.textBox2.Text = se.StackTrace;
			}
			

			//'Restore permission to write the the event log
		    //perLog.RevertDeny;
			EventLogPermission.RevertDeny();
		}

		private void cmdPermissionSet_Click(object sender, System.EventArgs e)
		{
			//'Create Permission objects for EnvVars and Clipboard
			EnvironmentPermission perEnvironment = new EnvironmentPermission(PermissionState.Unrestricted);
			UIPermission perClipboard = new UIPermission(PermissionState.Unrestricted);

			//'Attempt to deny permission to both
			try
			{
				perEnvironment.Deny();
				perClipboard.Deny();
			}
			catch (SecurityException se)
			{
				this.textBox1.Text = se.Message;
			}
			finally
			{
				//'Revert the deny on the Environment object
				//perEnvironment.RevertAll();
				EnvironmentPermission.RevertAll();
			}

			//'Create a PermissionSet object and add both permission objects
			PermissionSet ps = new PermissionSet(PermissionState.None);
			ps.AddPermission(perEnvironment);
			ps.AddPermission(perClipboard);

			//'Deny permission to all
			ps.Deny();

			//Attempt to access both EnvVar and Clipboard
			clsEnvironment oEnvironment = new clsEnvironment();
			try
			{
				oEnvironment.Retrieve("path");
			}
			catch(SystemException se)
			{
				textBox2.Text = se.Message;
			}

			clsClipboard oClipBoard = new clsClipboard();
			try
			{
				oClipBoard.Retrieve();
			}
			catch(SystemException se )
			{
				textBox3.Text = se.Message;
			}

			//CodeAccessPermission perCa = new CodeAccessPermission();
			//perCa.RevertAll();
			CodeAccessPermission.RevertAll();
		}

		[FileIOPermissionAttribute(SecurityAction.Deny, Unrestricted=true)]
		private void cmdDeclaritive_Click(object sender, System.EventArgs e)
		{
		    //'Attempt to write to the file
			clsFileIO ofile = new clsFileIO();
			try
			{
				ofile.Write("Declarative security message");
			}
			catch(SecurityException se)
			{
				this.textBox1.Text = se.Message;
			}

			//'Attempt to read EnvVars
			clsDclEnvironment oEnvironment = new clsDclEnvironment();
			try
			{
				textBox2.Text = oEnvironment.Retrieve("windir");
				textBox3.Text = oEnvironment.Retrieve("path");
			}
			catch(SecurityException se)
			{
				textBox3.Text = se.Message;
			}
		}

		private void cmdCleanUp_Click(object sender, System.EventArgs e)
		{
			File.Delete("C:/DEVT145.txt");
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}
	}
}
